<?php
namespace App;

/**
 * Core: Application Manager - Admin class
 * 
 * Core - Application Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_ApplicationManager_Admin extends \SCHLIX\cmsAdmin_PluginsManager {

    protected $default_apps_that_cannot_be_uninstalled = array('admin', 'blog', 'html', 'settings', 'users', 'applications', 'blocks', 'macros', 'main', 'menus', 'help', 'httperror', 'themes', 'wysiwygeditors');
    
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */    

    //_________________________________________________________________________//
    public function __construct() {
        // Data: Item
        $dont_list_this_apps = array('admin', 'blog', 'html', 'main', 'help', 'users', 'httperror', 'applications', 'blocks', 'macros', 'cronscheduler', 'emailtemplates', 'logviewer', 'mediamanager', 'menus', 'sitemanager', 'themes', 'bannedip', 'wysiwygeditors', 'emailqueue', 'versioning','sitemap','schlixupdater','simplesitemap','tag', 'core');
        parent::__construct('apps', $dont_list_this_apps);
       
    }

    /**
     * Returns true if a class exists
     * @param string $name
     */
    public function extensionExists($name)
    {
        $class = '\\App\\'.$name;
        return (class_exists($class));
    }

    //_________________________________________________________________________//
    public function installItem($app) {
        global $SystemDB;

        $forbidden_listing = (is_array($this->forbidden_names)) ? $this->forbidden_names : [];

        $name = $app['title'];

        $adminapp_tobe_installed = '\\App\\' . $name . '_Admin';
        $the_app = new $adminapp_tobe_installed;
        $app_description = $the_app->getApplicationDescription();
        $datavalues['title'] = $datavalues['app_alias'] = $app['title'];
        $datavalues['app_description'] = $app_description;
        $datavalues['has_backend'] = $app['is_backend'];
        $datavalues['has_frontend'] = $app['is_frontend'];
        $datavalues['show_in_app_menu'] = (!in_array($app['title'], $forbidden_listing));

        $SystemDB->simpleInsertInto($this->table_items, $datavalues);
        $install_sample_data = false;
        $sess_install_sample_data = fsession_bool('__app_admin_install_sample_data');
        if ($sess_install_sample_data)
        {
            $install_sample_data = true;
            unset($_SESSION['__app_admin_install_sample_data']);
        }
        $install_result = $the_app->RunInstallScript($install_sample_data);
        $str_sample_data = $install_sample_data ? ___('with sample data') : '';
        $this->recordLog("Installed application : {$name} {$str_sample_data}");
        display_schlix_alert(___('Installed') . ' ' . ___('Application ') . ' ' . $name.' '.$str_sample_data);
        return $install_result;
    }
    
    public function Install() {
        if (fpost_string('install_sample_data'))
            $_SESSION['__app_admin_install_sample_data'] = true;
        return parent::Install();
    }
    //_________________________________________________________________________//
    /**
     * 
     * @global \App\Users $CurrentUser
     * @return array
     */
    public function ajxp_ConfirmUninstall()
    {
        global $CurrentUser;
        
        $error_list = [];
        check_csrf_halt_on_error();
        $uninstall_db_tables = fpost_int('database');
        $name = fpost_alphanumeric('name', 63);
        
        // 1. validate app exists
        $adminapp_tobe_uninstalled = '\\App\\'.$name.'_Admin';
        if (!class_exists($adminapp_tobe_uninstalled))
            $error_list[] = ___('Invalid application name');
        elseif ($this->isSystem($name))
            $error_list[] = ___('System application cannot be removed');
        elseif ($this->isInstalledFromExtensionGallery($name))
            $error_list[] = ___('Please remove this application from Extension Gallery Manager');
        // 2. validate password
        if (empty($error_list))
        {
            $password = fpost_string('password');
            if (empty($password))
                $error_list[] = ___('Please type your password to authenticate');
            else 
            {
                $password_ok = $CurrentUser->verifyUserNamePassword($CurrentUser->getCurrentUserName(), $password);
                if (!$password_ok)
                    $error_list[] = ___('Invalid password');
            }
        }
        $reply['messages'] = $error_list;
        $status = empty($error_list);
        if ($status)
        {
            $item_path = CURRENT_SUBSITE_PATH . '/apps/' . $name;
            
            $adminapp_tobe_uninstalled = '\\App\\'.$name.'_Admin';
            $the_app = new $adminapp_tobe_uninstalled;
            $the_app->RunUninstallScript($uninstall_db_tables, true);            
            __del_tree($item_path);
            $reply['messages'] = [___('Uninstall completed')];
            $reply['hide_form'] = true;
        }
        return ajax_reply($status, $reply);
    }

    //_________________________________________________________________________//

    public function ajaxGetAllItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        global $SystemDB;

        if ((int) $start > (int) $end)
            return ajax_reply(400, 'Invalid Request');
        $sortby = $SystemDB->escapeString($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $total_item_count = $this->app->getTotalItemCount('show_in_app_menu = 1');
        $result_array_files = $this->app->getAllItems($fields, 'show_in_app_menu = 1', $start, $end, $sortby, $sortdirection, false);
        return ajax_datasource_reply(200, $result_array_files, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }
/*
    //_________________________________________________________________________//
    private function isValidAppElement($dir, $app_name, $app_name_prefix = '') {
        $forbidden_listing = []; // (is_array($this->forbidden_names)) ? $this->forbidden_names : [];
        $item_path = SCHLIX_SITE_PATH . $dir;
        $dir = removeMultipleSlashes($item_path . "/{$app_name}/");
        $file = removeMultipleSlashes($item_path . "/{$app_name}/{$app_name}{$app_name_prefix}.class.php");
        return (!in_array($app_name, $forbidden_listing)) && (strpos($app_name, 'uninstalled_') === false ) &&
                is_dir($dir) && is_file($file);
    }

    //_________________________________________________________________________//
    public function isValidFrontendApplication($app_name) {
        return $this->isValidAppElement('/apps/', $app_name);
    }

    //_________________________________________________________________________//
    public function isValidBackendApplication($app_name) {
        return $this->isValidAppElement('/system/apps/', $app_name, '.admin');
    }
    */
    private function hasAppFile($app_name, $app_name_prefix = '') {
        $forbidden_listing = []; // (is_array($this->forbidden_names)) ? $this->forbidden_names : [];
                
        $sys_file = remove_multiple_slashes(SCHLIX_SYSTEM_PATH."/apps/" . "/{$app_name}/{$app_name}{$app_name_prefix}.class.php");
        $user_file = remove_multiple_slashes(SCHLIX_SITE_PATH."/apps/" . "/{$app_name}/{$app_name}{$app_name_prefix}.class.php");
        return (!in_array($app_name, $forbidden_listing)) && (strpos($app_name, 'uninstalled_') === false ) &&
                (is_file($sys_file) || is_file($user_file));
    }
    
    private function __listApps($backend_app_items)
    {
        $item_array = null;
        if ($backend_app_items)
        {
            foreach ($backend_app_items as $item) {
                $file = $item->getFileName();
                $valid_as_backend = $this->hasAppFile($file);
                $valid_as_frontend = $this->hasAppFile($file,'.admin');
                if ($valid_as_backend || $valid_as_frontend)
                    $item_array[] = array('title' => $file, 'is_backend' => $valid_as_backend, 'is_frontend' => $valid_as_frontend);
            }
        }
        return $item_array;
    }
    
    public function viewMainPage()
    {
        $this->checkForUnregisteredItems(); // Experimental
        parent::viewMainPage();
        

    }
    //_________________________________________________________________________//
    /**
     * Returns the list of Apps - whether it has a frontend app as well
     * @param string $frontend
     * @return array
     */
    protected function getListOfApps() {
        $item_array = [];
        

        $forbidden_listing = (is_array($this->forbidden_names)) ? $this->forbidden_names : [];
        
        $sys_app_items = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator(remove_multiple_slashes(SCHLIX_SYSTEM_PATH . "/apps/"), \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
        $user_app_items = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator(remove_multiple_slashes(SCHLIX_SITE_PATH . "/apps/"), \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
                
        $items = $this->__listApps($sys_app_items);        
        $user_items = $this->__listApps($user_app_items);        
        if ($user_items)
        {
            $items = array_merge($items, $user_items);
        }
        return $items;
    }

    //_________________________________________________________________________//
    protected function cleanUpAppsThatDontNeedToBeListed() {
        global $SystemDB;

        $forbidden_listing = (is_array($this->forbidden_names)) ? $this->forbidden_names : [];

        $total_count = ___c($forbidden_listing);
        for ($i = 0; $i < $total_count; $i++)
            $forbidden_listing[$i] = sanitize_string($forbidden_listing[$i]);
        $existing_apps = implode(',', $forbidden_listing);
        $sql = "UPDATE `{$this->table_items}` SET show_in_app_menu=0 WHERE (show_in_app_menu=1) AND title IN ({$existing_apps})";
        $SystemDB->query($sql);
        $sql = "UPDATE `{$this->table_items}` SET show_in_app_menu=1 WHERE (show_in_app_menu=0) AND title NOT IN ({$existing_apps})";
        $SystemDB->query($sql);
    }

    //_________________________________________________________________________//
    public function deleteNullApps() {
        global $SystemDB;

        $sql = "DELETE FROM `{$this->table_items}` WHERE app_alias IS NULL AND app_description IS NULL";
        $SystemDB->query($sql);
    }

    //_________________________________________________________________________//
    public function checkForUnregisteredItems() {
        $all_backend_apps = $this->getListOfApps();
        //$all_frontend_apps = $this->getListOfApps (true);
        $all_apps_name_only = [];
        foreach ($all_backend_apps as $app) {
            $all_apps_name_only[] = $app['title'];
        }
        if (is_array($all_backend_apps) && (___c($all_backend_apps) > 0)) {
            // 1. Delete  non-existant apps from db
            $this->cleanUpOrphanedItems($all_apps_name_only);
            $this->cleanUpAppsThatDontNeedToBeListed();
            // 2. Find app to be installed
            foreach ($all_backend_apps as $backend_app) {
                
                $already_installed_app = $this->findInstalledItem($backend_app['title']);
                if (___c($already_installed_app) == 0)
                    $this->installItem($backend_app);
            }
        }
        // Fix for pre-v1.2.6
        $this->deleteNullApps();
    }
    
}
