<?php
/**
 * Core: BannedIP - Main admin view template
 * 
 * Core - BannedIP
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();

$default_ban_hours = $this->app->getConfig('int_ban_hours');
if ($default_ban_hours <= 0)
    $default_ban_hours = 24;
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_BannedIPAdminController" data-enable-preview-link="true" >
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="ban"   fonticon="far fa-file-text" label="<?= ___('Ban an IP address') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    <!-- breadcrumb -->
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="date_created" data-default-sort-direction="desc">
                    <x-ui:schlix-data-table-columns>
                        <schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                        <schlix-data-table-column key="ip_address" label='IP Address' sortable="true" formatter="text" editor="new SCHLIX.UI.TextboxCellEditor({disableBtns:false})" />
                        <schlix-data-table-column key="reason" label='Reason' sortable="true" formatter="text" editor="new SCHLIX.UI.TextboxCellEditor({disableBtns:false})" />
                        <schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_DateTime"  />
                        <schlix-data-table-column key="date_expiry" label="<?= ___('Date Expiry') ?>" sortable="true" formatter="this.formatDataTableCell_DateTime"  />
                                       </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-list>



<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Ban IP Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-banip-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_BannedIPAdminController" header-label="<?= ___('Ban an IP Address') ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=ban" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:textbox name="ip_address" id="dlg-ip_address" required="required" maxlength="63" label="<?= ___('IP Address to ban') ?>" placeholder="<?= ___('IP Address (IPv4/IPv6)') ?>" />
    <x-ui:textbox name="reason" id="dlg-reason" required="required" maxlength="63" label="<?= ___('Reason') ?>" placeholder="<?= ___('e.g. Spam/nuissance/troll)') ?>" />
    <x-ui:textbox type="number" name="hours" id="dlg-howlong" value="<?= $default_ban_hours ?>" required="required" min="1" max="1000000" label="<?= ___('Ban will expire in (hours)') ?>" />

    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>