/**
 * Core: Block Manager - Javascript admin controller class
 * 
 * Core - Block Manager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_BlockManagerAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.blockmanager");
    };
    /**
     * Datatable row format: item title
     * @static
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];

        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
        if (oRecord.getData("cid") > 0)
        {
            var the_id = oRecord.getData("cid");
            var odata_cid = 'c' + the_id;
            var icon =  ___$HTML.I('', {'class' : 'fas fa-folder fa-2x'}); 
            if (itemTitle === '' || itemTitle === null)
                itemTitle = '(Untitled)';
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);

            var editIcon = ___$HTML.I('', {'class' : 'fas fa-pencil-alt'}); 

            var ahref = ___$HTML.A(icon + " " + itemTitle, 'javascript:void(0)',
            {
                'class' : 'datatable-folder dragdrop',
                'title' : 'Click here to go into this category',
                'data-category-id' :the_id,
                'data-dragdrop-id' : 'c' + odata_cid,
                'id': app_name + "-lnk-c" + odata_cid
            });

            var attrs = SCHLIX.CMS.BaseController.__generateDataAttributeFromOData(oRecord);
            attrs['class'] = 'dlg-edit-category';
            attrs['id'] = app_name + "-edit-c" + odata_cid;
            attrs['data-cid'] = 'c' + odata_cid;
            attrs['data-title'] = oRecord.getData(field_title);

            var editor_href = ___$HTML.A(editIcon, 'javascript:void(0)', attrs);

            elCell.innerHTML =
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-title'}) + ahref + ___$HTML.DIV_end() +
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + editor_href + ___$HTML.DIV_end();
            
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            var icon = "<i class =\"fa fa-cube fa-2x\"></i>";
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            elCell.innerHTML = '<a class="dragdrop" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>';
        }
    }; 
    
    /**
     * Automatically called when DOM is ready
     * @param {type} event
     * @returns {undefined}
     */
    onDOMReady (event)
    {
        SCHLIX.Event.delegate('schlix-core-blockmanager-admin', 'click', this.onShowEditCategoryDialog, 'a.dlg-edit-category', this, true);
        this.setMenuSelectionEventListener();
    }; // end func
    

    ////////////////////////////////////////////////////////////

    
    setMenuSelectionEventListener ()
    {
        if (SCHLIX.Dom.get('menu_select_everywhere'))
        {            
            var display_in_menu = document.forms.block_item_editor.display_in_menu_workaround.value;
            if (display_in_menu < 2)
                this.hideMenuSelection();
            SCHLIX.Event.on('menu_select_everywhere', "click", this.hideMenuSelection, this, true);
            SCHLIX.Event.on('menu_select_some', "click", this.showMenuSelection, this, true);
        }
    }; // end func
    
    hideMenuSelection ()
    {
            var menu = document.getElementById('schlix_multiple_categories_checkboxes');
            menu.style.display = 'none';
    }; // end func
    ///////////////////////////////////////////////////////////
    showMenuSelection ()
    {
            var menu = document.getElementById('schlix_multiple_categories_checkboxes');
            menu.style.display = 'block';
    }; // end func
    
    /**
     * Show New Category Dialog
     * @returns {undefined}
     */
    onShowNewCategoryDialog ()
    {

        var obj = SCHLIX.CMS.getObject('schlix-cms-category-dialog');
        var tgt_cid = SCHLIX.Dom.get('dlg-category-id');
        var tgt_title = SCHLIX.Dom.get('dlg-category-title');
//        SCHLIX.Dom.get('text-dlg-category-new').style.display = 'inline';
//        SCHLIX.Dom.get('text-dlg-category-edit').style.display = 'none';
        var label_new = SCHLIX.Dom.get('label-new-category-title');
        var label_edit = SCHLIX.Dom.get('label-edit-category-title');

        label_new.style.display = '';
        label_edit.style.display = 'none';

        tgt_cid.value = 'new';
        tgt_title.value = '';
        obj.show();
    }; // end func
    /**
     * Show Edit Category Dialog
     * @param {type} event
     * @returns {undefined}
     */
    showInstallerWindow ()
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
        obj.show();
    }; // end func
    
    
    /**
     * Show Edit Category Dialog
     * @param {type} event
     * @returns {undefined}
     */
    onShowEditCategoryDialog (event)
    {   
        
        //var el = SCHLIX.Dom.get(event.target.parentElement.id);
        var el = SCHLIX.Event.getTarget(event).closest('.dlg-edit-category');//(event.target.parentElement.id);
        var category_id = el.getAttribute('data-cid'); //  $(target).attr("data-category-id");
        var title = el.getAttribute('data-title'); //  $(target).attr("data-category-id");
        var obj = SCHLIX.CMS.getObject('schlix-cms-category-dialog');
        var tgt_cid = SCHLIX.Dom.get('dlg-category-id');
        var label_new = SCHLIX.Dom.get('label-new-category-title');
        var label_edit = SCHLIX.Dom.get('label-edit-category-title');
        var span_cid = SCHLIX.Dom.get('label-edit-category-id');
        
        var tgt_title = SCHLIX.Dom.get('dlg-category-title');

        //SCHLIX.Dom.get('text-dlg-category-new').style.display = 'none';
        //SCHLIX.Dom.get('text-dlg-category-edit').style.display = 'inline';
        label_new.style.display = 'none';
        label_edit.style.display = '';
        span_cid.innerHTML = '#' + category_id;

        tgt_cid.value = category_id;
        tgt_title.value = title;
        obj.show();
    }; // end func
    /**
     * Run command
     * @param {type} command
     * @returns {unresolved}
     */
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-block-item':
                var block_type = evt.target.getAttribute('data-block-type');
                this.redirectToCMSCommand("newitem&blocktype=" + block_type);
                break;
            /*case 'new-item':
                this.redirectToCMSCommand("newitem");
                break;*/
            case 'install':
                this.showInstallerWindow();
                break;
                
            case 'new-category':
                this.onShowNewCategoryDialog();
                break; //  this.redirectToCMSCommand("newcategory");break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                break;
            case 'form-submit-ok':
                this.cms_control.refreshControls();
                break;

            default:
                return super.runCommand(command, evt);
                break;

        }
    }

};

///////////////////////////////////////////////////////////
/**
 * Element Class
 */
SCHLIX.CMS.BlockVisibilityEditor = class extends SCHLIX.CMS.DataExplorerCategorizedList  {  
    /**
     * Constructor
     */
    constructor (el, options)
    {
        super(el, options);
        this.field_parent_id = "parent_id";
    
// --------------------------------- VARIABLES ------------------------------- //

        this.field_parent_id= '';
        this._rendered_nodes = [];
        this.control_treeview = null;
        this.categoryNodes= [];
        this.category_array = [];
        this.checkboxNodeIDPrefix = 'chk_app';
        this.rootTreeNodeID = 'treeleaf_0';
    }
// --------------------------------- PROCEDURES -------------------------- //

///////////////////////////////////////////////////////////
        Run ()
        {
            super.Run();
        }; // end func
        initDataSourceForTreeView ()
        {
            this.ajaxRequestGET("action=getmenus", this.receiveMenu);
        }; // end func
        initTreeView ()
        {

        }; // end func
        receiveMenu (o)
        {
            this.category_array = ajax_parse(o.responseText);

            this.buildTree();

        }; // end func
        getBlockMenuAssociation ()
        {
            var id = document.getElementById('id').value;
            this.ajaxRequestGET("action=getvisibility&id=" + id, this.receiveBlockMenuAssociation);

            return false;
        }; // end func
        receiveBlockMenuAssociation (o)
        {
            this.block_app_assoc_array = ajax_parse(o.responseText);
            for (var i = 0; i < this.block_app_assoc_array.length; i++)
            {
                var chk_xid = 'treeleaf_' + this.block_app_assoc_array[i].menu_id;
                var checkbox = document.getElementById(chk_xid);
                if (checkbox)
                    checkbox.checked = true; // null or not?
            }
        }; // end func
        buildTree ()
        {
            var tree_id = this.getChildElementNameByDynamicDomId("datanav-tree");
            this.control_treeview = new SCHLIX.UI.TreeView(tree_id);

            /** Copy & Paste **/
            this.control_treeview.removeNode(this.control_treeview.getRoot(), false);
            this.control_treeview.removeChildren(this.control_treeview.getRoot());
            this.control_treeview.destroy();
            // Build Root Node
            var category_name = 'Menus';
            var node_name = this.rootTreeNodeID;
            var myobj = {label: category_name, id: 0, html: this.drawTreeIcon(node_name, category_name)};
            var new_node = new SCHLIX.UI.HTMLNode(myobj, this.control_treeview.getRoot(), true, false);
            this.categoryNodes[0] = new_node;
            // Build the Rest
            for (var i = 0; i < this.category_array.length; i++)
            {
                var category_name = this.category_array[i]['title'];
                var category_id = this.category_array[i]['id'];
                var the_virtual_filename = '';
                if (this.category_array[i]['virtual_filename'])
                    the_virtual_filename = this.category_array[i]['virtual_filename'];
                if (category_name == "")
                    category_name = "(Untitled)";
                var parent_id = this.category_array[i]['parent_id'];
                var cid = this.category_array[i]['cid'];
                var menu_id = 0;
                //var menu_id = this.category_array[i]['id'];
                if (cid == 0)
                    menu_id = this.category_array[i]['id'];
                if (!parent_id)
                    parent_id = 0;
                var node_name = 'treeleaf_' + category_id;
                /********** Fix this one - April 29, 2010 **********/
                var myobj = {virtual_filename: the_virtual_filename, label: category_name, cid: cid, id: category_id, html: this.drawTreeIcon(node_name, category_name)};


                if (cid != null)
                    //if (parent_id == 0)
                    {
                        //		alert(cid);
                        new_node = new SCHLIX.UI.HTMLNode(myobj, this.control_treeview.getRoot(), true, true);
                    } else
                {
                    //	alert(this.category_array[i]['parent_id']);
                    if (parent_id == 0)
                        new_node = new SCHLIX.UI.HTMLNode(myobj, this.getNodeByCID(this.category_array[i]['category_id']), true, true);
                    else
                        new_node = new SCHLIX.UI.HTMLNode(myobj, this.getNodeByDataID(this.category_array[i]['parent_id']), true, true);
                }
                this.categoryNodes[i] = new_node;

            }
            this.control_treeview.subscribe("clickEvent", this.onTreeClick, this, true);  // scope correction with this, true - Feb  21, 2009
            this.control_treeview.draw();
            this.tree_built = true;
            this.getBlockMenuAssociation();

        }; // end func
        getNodeByCID (id) {
            for (var i = 0; i < this.categoryNodes.length; i++)
            {
                if (this.categoryNodes[i].data.cid === id)
                {
                    return this.categoryNodes[i];
                }
            }
            return null;
        }; // end func
        getNodeByDataID (id)
        {
            for (var i = 0; i < this.categoryNodes.length; i++)
            {
                if (typeof this.categoryNodes[i] == "undefined")
                {
                    //alert('getNodeByDataID(' + i + ') is undefined');
                } else
                if (this.categoryNodes[i].data.id == id)
                {
                    return this.categoryNodes[i];
                }
            }
            return null;
        }; // end func
        drawTreeIcon (id, category_name)
        {
            if (id != this.rootTreeNodeID)
                return "<div id='tree_" + id + "' >" +
                    "<input type='checkbox' name='categories[]' class='schlix_items_categoryeditor_checkbox' id='" + id + "' /> " +
                    '<i class="fas fa-bars"></i> ' + category_name + " </div>\n\n";
            else
                return  "<div id='tree_" + id + "' style='padding-left:1.5em'>" + '<i class="fas fa-folder text-orange" ></i>' + ' ' + category_name + "</div>\n\n";

        }; // end func
        onTreeClick (htmlobject)
        {
            var menu_id = htmlobject.node.data.id;
            var leaf_id = 'treeleaf_' + menu_id;
            var state = document.getElementById(leaf_id).checked;
            console.log(document.getElementById(leaf_id));
            var id = parseInt(document.getElementById('id').value);
            if (menu_id > 0)
            {
                var postData = "_csrftoken=" + _csrftoken + "&menu_id=" + menu_id + "&id=" + id + "&state=" + state;
                this.ajaxRequestPOST('action=setvisibility', this.reportVisibilityAssociation, postData);
            }

            return false;
        }; // end func
        getItemsListing ()
        {
            // disable this
            return false;
        }; // end func
        initAllControls ()
        {
            this.initDynamicDOM();
            // 4. Init Controller
            this.initController();

            this.initDataSourceForTreeView();
            this.initTreeView();

            this.setBusy(false);
        }; // end func
///////////////////////////////////////////////////////////
        reportCategoryAssociation (o)
        {
            var response = ajax_parse(o.responseText);
            if (response != true)
                SCHLIX.Alert.error('Cannot set the associated category');
            else
                this.getItemCategoriesAssociation();
        }; // end func
        /**
         * Initialize controller
         */
        initController ()
        {
            var controllerName = this.getControllerName();
            var controller = SCHLIX.CMS.initializedController[controllerName];
            if (!SCHLIX.Util.isUndefined(controller))
            {
                controller.control_data_editor = this;
            } else
            {
                SCHLIX.Alert.error('Editor Controller init failed: ' + controllerName + ' cannot be found');
                console.log(SCHLIX.CMS.initializedController);
            }
        }; // end func
///////////////////////////////////////////////////////////
        getItemCategoriesAssociation ()
        {
            var id = document.getElementById('id').value;
            var app_name = this.app_name;

            this.ajaxRequestGET("action=getitemcategories&id=" + id, this.onReceiveItemCategoriesAssociation);
        }; // end func
        /**
         * Receive the associated cid and id
         * @param {type} o
         * @returns {undefined}
         */
        onReceiveItemCategoriesAssociation (o)
        {
            // this.control_treeview.expandAll(); // must be visible at all times

            this.block_app_assoc_array = ajax_parse(o.responseText);
            var non_existent_ids = "";

            // Unhighlight
            for (var x in this.control_treeview._nodes) {
                this.control_treeview._nodes[x].unhighlight();
            }
            // Now set
            for (var i = 0; i < this.block_app_assoc_array.length; i++)
            {
                //console.log(this.block_app_assoc_array[i]);
                var tree_nodes = this.control_treeview.getNodesByProperty('cid', this.block_app_assoc_array[i].cid);
                if (tree_nodes.length == 1)
                    tree_nodes[0].highlight();
            }
            if (non_existent_ids != "")
                alert(non_existent_ids + " default prefix = " + this.checkboxNodeIDPrefix);
            this.setBusy(false);
        }; // end func
        /**
         * Event: called after treeview datasource is parsed
         * @returns {undefined}
         */
        onTreeBuilt ()
        {
            super.onTreeBuilt();
            this.getItemCategoriesAssociation();
        }; // end func
    };

SCHLIX.CMS.registerComponent("schlix-block-visibility-editor", SCHLIX.CMS.BlockVisibilityEditor);


    