/**
 * Core: Composer - Javascript admin controller class
 * 
 * Core - Composer 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_ComposerAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.composer");
    };
    
    ///////////////////////////////////////////////////////////
    
    static formatDataTableCell_DefaultTitleColumn (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var odata_ext = oRecord.getData("extension");
        var file_exists = oRecord.getData("file_exists");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
            var icon =   '<i class="fas fa-box"></i> ';

            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            

            itemLink += ''
            var item_class =  'dragdrop';
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            
            elCell.innerHTML =  icon + " " + itemTitle  ;

    };

    ///////////////////////////////////////////////////////////

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {

                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                theID = app_name + '-select-id' + oRecord.getData("id");
                theValue = 'i' + oRecord.getData("id");
                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';

    }; 
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};

 