<?php 
namespace App;

/**
 * Core: Composer - Main Class
 * 
 * Core - Composer
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/
/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/
/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/

class Core_Composer extends \SCHLIX\cmsApplication_List {

    
    private $lock_key = 'str_date_install_lock';
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public function __construct() {
        global $SystemDB;
        
        parent::__construct("Core: Composer", 'gk_composer_lib');
        /* You can modify this  */
        $this->has_versioning = true; // set to false if you don't need versioning capability if this app wants versioning enabled
        $this->disable_frontend_runtime = false; //  set this to true if this is a backend only app         
        
        
        ini_set('memory_limit', '-1');
        
        $this->data_directories = [
            'home' =>  '/data/composer',
            'cache' =>  '/cache/composer',
            'vendor' => '/libs'
        ]; 

        // Fix for PHP8.4 and Composer 2.2
        $errorlevel = error_reporting();
        error_reporting($errorlevel & ~E_DEPRECATED);
        // end fix
        
        foreach ($this->data_directories as $k => $dir)
        {                        
            $fp = $this->getDataDirectoryFullPath($k);
            create_directory_if_not_exists ($fp);
            if (!file_exists($this->getDataFileFullPath($k, '.htaccess')))
            {
                create_htaccess_restrict_view($fp);                
            }
        }
                
        
    }

    public function resetComposer()
    {
        foreach ($this->data_directories as $k => $dir)
        {                        
            __del_tree ($this->getDataDirectoryFullPath($k));
        }
        
        
    }
    
    /**
     * Mark composer package install
     * @param string|array $packages
     */
    public function installComposerPackage($packages) 
    {
        if (is_string($packages))
            $pkg = [$packages];
        else if (___c($packages) > 0) 
            $pkg = $packages;
        else return;
        foreach ($pkg as $p)
        {
            $this->addPendingInstallPackage($p);
        }
    }
    
    public function countOfPendingInstall()
    {
        $row = $this->table_items->q()->select('COUNT(*) AS total_item_count')->where('status = 0')->getQueryResultSingleRow();
        return $row['total_item_count'];
        
    }
    
    private function lockSetDateNow()
    {
        $this->setConfig($this->lock_key, get_current_datetime());
    }
    
    public function lockGetDate()
    {
        return $this->getConfig($this->lock_key);
    }
    
    public function lockExists()
    {
        $current_date = get_current_datetime();
        $date_install_lock = $this->lockGetDate();
        
        $active_lock_exists = (!empty($date_install_lock) && is_date($date_install_lock) && time_difference($date_install_lock, $current_date) < 7200);
        return $active_lock_exists;
    }
    
    public function lockGetExpiryDate()
    {
        $date_install_lock = $this->getConfig($this->lock_key);        
        if ($this->lockExists())
        {
            $t = strtotime($date_install_lock);
            $end = $t + 3600;
            return date(DEFAULT_DATE_FORMAT, $end);            
        }
        return null;
    }
    
    public function lockGetExpiryPeriod()
    {
        $date_install_lock = $this->lockGetExpiryDate();
        if ($date_install_lock)
        {
            $current_date = get_current_datetime();
            $diff = time_difference( $current_date, $date_install_lock);
            $diff_hour = floor($diff/3600.0);
            $diff_minute = floor (($diff - (3600*$diff_hour))/60.0);
            $diff_second = $diff - ($diff_hour*3600) - ($diff_minute*60);
            return sprintf( ___("%d hour(s) %d minute(s) %d second(s) "), $diff_hour, $diff_minute, $diff_second);

        }
        return null;
    }
    
    
    public function lockClear()
    {
        $this->setConfig($this->lock_key, '');
    }
    /**
     * Execute Pending Install
     */
    public function executePendingPackageInstall()
    {
        set_time_limit(7200);
        // watch out for race condition
        
        if (!$this->lockExists())
        {
            $tobe_installed = $this->getPackagesPendingInstall();
            if ($tobe_installed)
            {
                $this->lockSetDateNow();
                
                foreach ($tobe_installed as $t)
                {
                    echo \__HTML::P('**********************************************************************');
                    echo \__HTML::H3(sprintf(___('Installing %s...'), $t['title']));
                    echo \__HTML::P('**********************************************************************');
                    
                    $package = str_replace(['*','\\','<','>','&'], '', $t['title']);
                    $this->realInstallComposerPackage($package);
                    $this->markPackageInstallComplete($t['id']);
                    echo '<hr />';
                }
                
                echo \__HTML::P('*********************************************************************');
                echo \__HTML::H3(___('COMPLETED'));
                echo \__HTML::P('*********************************************************************');
                $this->lockClear();
            }
        }
        
    }
    
    private function markPackageInstallComplete($id)
    {
        $this->table_items->q()->update()->set(['status' => 1])->where('id = :id')->execute(['id' => $id]);
    }
    
    private function addPendingInstallPackage($name)
    {
        $existing = $this->getInstalledPackageByName($name);
        if (!$existing)
        {
            $data = ['title' => $name, 'status' => 0, 'date_created' => get_current_datetime()];
            $this->table_items->quickInsert($data);
        }        
    }
    
    protected function realInstallComposerPackage($packages) 
    {
            
        $this->syncComposerData();
        try {
            if (!class_exists("\Phar"))
                die ('PHP Phar extension must be installed');
            \Phar::loadPhar(__DIR__.'/composer.phar');
            require_once 'phar://composer.phar/vendor/autoload.php';
            require_once __DIR__.'/composerhelper.class.php';
            $pkgmgr = new \SCHLIX\ComposerHelper($this->getDataDirectoryFullPath('home'),
                    $this->getDataDirectoryFullPath('cache'),
                    $this->getDataDirectoryFullPath('vendor'),
                    $this->getDataFileFullPath('home', 'composer.json'),
                    $this->getDataFileFullPath('home', 'composer.lock'));
            if (is_string($packages))
                
                $pkg = [$packages => '*'];
            else if (___c($packages) > 0) 
            {
                $pkg = $packages;
            } else return;
            $pkgmgr->InstallPackage($pkg);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Validates save item. If there's an error, it will return an array
     * with one or more error string, otherwise it will return a boolean true
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return bool|array String array
     */
    public function getValidationErrorListBeforeSaveItem($datavalues)
    {
        $parent_error_list = parent::getValidationErrorListBeforeSaveItem($datavalues);
        $error_list = array();
        // You can put custom item save validation here
        // e.g. 
        // if (str_contains($datavalues['title'],'a'))
        // $error_list[] = ___('Title may not contain letter a');
        return array_merge($parent_error_list, $error_list);
    }

    /**
     * Before save item
     * @param array $datavalues
     * @return array
     */
    protected function modifyDataValuesBeforeSaveItem($datavalues) {
        return;
    }
    
    /**
     * Do something after save item
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    protected function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval)
    {
        return;
    }


    /**
     * Get installed packages
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return array
     */
    private function getPackagesPendingInstall()
    {
        global $SystemDB;
        
        $rows = $this->table_items->q()->select('*')->where('status = 0')->getQueryResultArray();
        //$SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_items} WHERE title = :title", ['title' => $name]);
        return $rows;
    }
    

    /**
     * Get installed packages
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $name
     * @return array
     */
    private function getInstalledPackageByName($name)
    {
        global $SystemDB;
        
        $row = $this->table_items->q()->select('*')->where('title = :title')->getQueryResultSingleRow(['title' => $name]);
        //$SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_items} WHERE title = :title", ['title' => $name]);
        return $row;
    }
    
    
    public function syncComposerData()
    {
        $cjs = $this->getDataFileFullPath('home', 'composer.json');
        $packages = $this->getAllItems();
        $arr_pkg = [];
        foreach ($packages as $p)
        {
            $arr_pkg[$p['title']] = "*" ;
        }
        $arr = ['require' => $arr_pkg];
        $str_p = json_encode($arr, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        file_put_contents($cjs, $str_p);
    }

    /**
     * Run Command
     * @param array $command
     * @return boolean
     */
    public function Run($command) {
    }



}
