<?php
/**
 * Core - CronScheduler - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.Core_CronSchedulerAdmin" type="config">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>">     
                    <schlix-config:checkbox config-key="bool_use_manual_scheduler" label="<?=  ___('Use manual scheduler') ?>" />
                    
                    <br />
                    <p><?= ___('If you choose this option, the CMS does not run its scheduler automatically, but the automation must be done by a call to the following URL') ?></p>
                    <x-ui:textbox  readonly="readonly" value="<?= SCHLIX_SITE_URL.$this->app->createFriendlyURL('') ?>" />
                    <br />
                    <schlix-config:textbox config-key="str_manual_scheduler_restrict_ip_address" pattern="((^|\.)((25[0-5])|(2[0-4]\d)|(1\d\d)|([1-9]?\d))){4}$" label="<?=  ___('Restrict running of manual scheduler to this IP Address') ?>"   />
                    
                    
                </x-ui:schlix-tab>                
                
                <!-- tab -->
               <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>      
