<?php
namespace App;

/**
 * Core: CronScheduler - Admin class
 * 
 * Core - CronScheduler
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_CronScheduler_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     *
     * @var Core_CronScheduler 
     */
    protected $app;
    
    private $common_cron_settings;

//_________________________________________________________________________//    
    public function __construct() {
        parent::__construct(null);
        $this->setItemFieldNamesForAjaxListing('id', 'title', 'cron', 'status', 'date_available', 'date_expiry', 'date_created', 'date_expected_next_run', 'date_modified', 'date_lastrun_start', 'date_lastrun_end', 'send_email_to', 'command_internal', 'command_type', 'command_external_url');
        $this->setDefaultOptions();
        
    }

    //_________________________________________________________________________//    
    protected function setDefaultOptions() {
        $this->common_cron_settings = array(
          array('value' => "", 'label' => ' -- '.___('Please select or click the string and type').' -- '),
          array('value' => "* * * * *", 'label' => ___('Every minute').' (* * * * *)'),
          //// BUG for */15 or */10 - fixed
          array('value' => "*/5 * * * *", 'label' => ___('Every 5 minutes').' (*/5 * * * *)'),
          array('value' => "*/10 * * * *", 'label' => ___('Every 10 minutes').' (*/10 * * * *)'),
          array('value' => "*/15 * * * *", 'label' => ___('Every 15 minutes').' (*/15 * * * *)'),
          array('value' => "0,30 * * * *", 'label' => ___('Every 30 minutes').' (0,30 * * * *)'),
          array('value' => "0 * * * *", 'label' => ___('Once an hour').' (0 * * * *)'),
          array('value' => "0 0,12 * * *", 'label' => ___('Twice a day').' (0 0,12 * * *)'),
          array('value' => "0 0 * * *", 'label' => ___('Once a day').' (0 0 * * *)'),
          array('value' => "0 6 * * *", 'label' => ___('Everyday at 06:00').' (0 6 * * *)'),
          array('value' => "0 0 * * 0", 'label' => ___('Once a week').' (0 0 * * 0)'),
          array('value' => "30 23 * * 0", 'label' => ___('Every Sunday at 23:30').' (30 23 * * 0)'),
          array('value' => "0 0 1,15 * *", 'label' => ___('Twice a month (1<sup>st</sup> and 15<sup>th</sup>)').' (0 0 1,15 * *)'),
          array('value' => "0 0 1 * *", 'label' => ___('Once a month').' (0 0 1 * *)'),
          array('value' => "0 0 1 1 *", 'label' => ___('Once a year').' (0 0 1 1 *)')
        );
    }

    //_________________________________________________________________________//
    protected function validateUpdateItemField($id, $field, $value) {
        $retval = true;
        switch ($field) {
            case 'cron': $testvalue = $this->app->getNearestUNIXTimeFromCronString($value);
                $retval = ($testvalue === false) ? ___('Invalid CRON String - please use the dropdown box if you do not know the syntax') . $value : true;
                break;
            case 'command_external_url':
                $retval = (filter_var($value, FILTER_VALIDATE_URL)) ? true : ___('Invalid URL') . $value;
                break;
            default: return true;
        }
        if (($retval === true) && ($id != "new"))
            $this->updateNextExpectedRunDate($id);
        return $retval;
    }

    //_________________________________________________________________________//    
    protected function ajxg_GetCronLog() {
        global $SystemDB;

        $id = fget_int('id');
        $sql = "SELECT cron, date_start, date_end, date_expected_next_run, command, log FROM gk_cronscheduler_log WHERE cron_id = :id ORDER BY id DESC";
        $result = $SystemDB->getQueryResultArray($sql, ['id' => $id]);
        return ajax_reply(200, $result);
    }

    //_________________________________________________________________________//    
    private function updateNextExpectedRunDate($id) {
        global $SystemDB;

        $id = (int) $id;
        if ($id > 0) {
            $item = $this->app->getItemByID($id);
            if ($item['cron']) {
                $next_expected_run = $this->app->getNearestUNIXTimeFromCronString($item['cron']);
                if ($next_expected_run) {
                    $date_next_expected_run = date('Y-m-d H:i:s', $next_expected_run);
                    $sql = "UPDATE gk_cronscheduler_items SET date_expected_next_run = :date_run WHERE {$this->field_id} = :id";
                    $SystemDB->query($sql, ['date_run' => $date_next_expected_run, 'id' => $id]);
                    return true;
                }
            }
        }
        return false;
    }
            

    //_________________________________________________________________________//	
    public function setPageTitle($title = '') {
        global $HTMLHeader;
        $script = 'var status_array = [{value:0, label: "Inactive"}, {value:1, label: "Active"} ];' . "\n";
        $script.= 'var command_type_array = [{value:0, label: "Internal"}, {value:1, label: "URL"} ];' . "\n";
        $script.= "var _internal_class_method_choices = " . json_encode($this->getApplicationStaticMethods()) . ";\n";
        $script.= "var _common_cron_settings = " . json_encode($this->common_cron_settings) . ';';
        $HTMLHeader->JAVASCRIPT_TEXT($script);
        parent::setPageTitle($title);
    }

    //_________________________________________________________________________//    
    public function getApplicationStaticMethods() {
        return $this->app->getApplicationStaticMethods();
    }

    
}