<?php
/**
 * Core - Custom Field - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php
global $CurrentUser;
$table_name = fget_string_notags('table');

$item['category_id'] = $this->app->getCategoryIDByTableName($table_name);
if ($item['category_id'] == 0)
    $err = ___('Table does not exist');
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = sprintf(___('New custom field in [%s]'), $table_name);
    
} else {

    $header_title = ___('Edit Item') . ' #' . $id;
}
$field_type_cats = $this->app->getFieldTypeCategories();
$field_control_types = [ 
    ['label' => ___('Text Box'), 'value' => 'textbox' ],
    ['label' => ___('Number Box'), 'value' => 'numberbox' ],
    ['label' => ___('Text Area'), 'value' => 'textarea' ],
    ['label' => ___('Wysiwyg'), 'value' => 'wysiwyg' ],
    ['label' => ___('Drop Down'), 'value' => 'select' ],
    ['label' => ___('Radio Group'), 'value' => 'radio-group'],
    ['label' => ___('Check Box'), 'value' => 'checkbox'],
];



?>
<x-ui:schlix-item-editor  data-main-app-description="<?= $header_title ?>" data-schlix-controller="SCHLIX.CMS.Core_CustomFieldAdminController">    
<?php if (empty($err)): ?>
    <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden id="id" name="id" data-field="id" />
        <x-ui:hidden id="category_id" name="category_id" value="<?= $item['category_id'] ?>" />
        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <x-ui:row>
                    <x-ui:column sm="8">
                        <x-ui:textbox id="field_label" name="field_label" required="required" data-field="field_label"  fonticon="fa fa-file-text" label="<?= ___('Field label') ?>" placeholder="<?= ___('Field label') ?>" />
                        <x-ui:textbox id="field_name"  name="field_name" required="required"  data-field="field_name" pattern="^[a-zA-Z][a-zA-Z0-9_]{1,60}$" label="<?= ___('Field name') ?>" placeholder="custom_field_name" prefix="xcf_"  />

                        
                        <x-ui:row>
                            <x-ui:column xs="6">

                                <x-ui:form-group>
                                    <label for="field_type"><?= ___('Data type') ?></label>
                                    <x-ui:input-group>
                                        
                                        <x-ui:select id="field_type" name="field_type" data-field="field_type" required="required">
                                            <x-ui:option value="" label="<?= ___('Select') ?>..." />
                                            <?php foreach ($field_type_cats as $cat => $label): ?>
                                                <x-ui:optgroup label="<?= ___($cat) ?>">
                                                    <?php $field_subtypes = $this->app->getFieldTypeItems($cat); ?>
                                                    <?php foreach ($field_subtypes as $t): ?>
                                                        <x-ui:option label="<?= ___($t) ?>" value="<?= ___($t) ?>" /> 
                                                    <?php endforeach ?>
                                                </x-ui:optgroup>
                                            <?php endforeach ?>

                                        </x-ui:select>
                                        <x-ui:input-addon id="field_unsigned_wrapper">
                                            <label><x-ui:checkbox no-wrapper="1" id="field_unsigned" name="field_unsigned" data-field="field_unsigned" value="1" /><?= ___('Unsigned') ?></label>
                                        </x-ui:input-addon>
                                    </x-ui:input-group>
                                    
                                </x-ui:form-group>


                            </x-ui:column>
                            <x-ui:column xs="3" id="field_length_wrapper">
                                <x-ui:textbox type="number"  id="field_length" name="field_length" min="0" data-field="field_length" label="<?= ___('Length') ?>" placeholder="<?= ___('Length') ?>" />
                            </x-ui:column>
                            <x-ui:column xs="3" id="field_precision_wrapper">
                                <x-ui:textbox type="number" id="field_precision" name="field_precision" min="0" max="30" data-field="field_precision" label="<?= ___('Decimal') ?>" placeholder="<?= ___('Decimal Precision') ?>" />
                            </x-ui:column>
                            
                        </x-ui:row>
                        <!-- field -->
                        <x-ui:form-group id="field_default_wrapper">
                            <label for="field_type"><?= ___('Default value') ?></label>
                            <x-ui:input-group>
                                <x-ui:input-addon id="field_null_wrapper">
                                    <label><x-ui:checkbox no-wrapper="1" id="field_null" name="field_null" data-field="field_null" value="1"  /> <?= ___('NULL') ?></label>
                                </x-ui:input-addon>
                                <x-ui:input-addon id="field_default_hint" class="wrp-field-default">
                                    <?= ___('Specify non-null default value'); ?>
                                </x-ui:input-addon>
                                <x-ui:textbox type="text" id="field_default" name="field_default" data-field="field_default" class="wrp-field-default" placeholder="<?= ___('Default value') ?>" />
                            </x-ui:input-group>

                        </x-ui:form-group>

                        <!-- end -->
                    </x-ui:column>
                        <x-ui:column sm="4">
                                <x-ui:select id="field_box_ui" name="field_box_ui"  data-field="field_box_ui" label="<?= ___('UI type') ?>" fonticon="fa fa-edit">
                                    <?php foreach ($field_control_types as $c): ?>
                                        <x-ui:option label="<?= ___($c['label']) ?>" value="<?= ___($c['value']) ?>" /> 
                                    <?php endforeach ?>
                                </x-ui:select>
                            <?php /*
                            <x-ui:textbox type="text" id="field_regex_validation" name="field_regex_validation" data-field="field_regex_validation" label="<?= ___('UI value regex pattern'); ?>" placeholder="e.g. [A-Za-z]+" />
                            */ ?>
                            <x-ui:checkbox  id="field_required" name="field_required" data-field="field_required" label=' <?= ___('Required (must not be empty)') ?>' value="1" />
                
                            <div id="field_placeholder_wrapper">
                                <x-ui:textbox id="field_placeholder" name="field_placeholder" data-field="field_placeholder"  fonticon="fas fa-file" label="<?= ___('Placeholder') ?>" placeholder="<?= ___('Input placeholder...') ?>" />
                            </div>
                            <?php /*<x-ui:wysiwyg id="field_hint" name="field_hint" data-field="field_hint"  label="<?= ___('Hint') ?>" placeholder="<?= ___('Hint') ?>" />*/ ?>
                            <div id="field_all_choices_wrapper">
                                <x-ui:checkbox  id="field_choices_use_sql" name="field_choices_use_sql" data-field="field_null" label=' <?= ___('Use SQL') ?>' value="1" />
                                <div id="field_choices_wrapper">
                                <x-ui:textarea name="field_choices" data-field="field_choices" id="field_choices" rows="10" label="<?= ___('Choices (array)') ?>" placeholder="value;label" /><p><?= sprintf(___('Type each option value using the following format: %s (separated by semicolon), one item per line'), '<strong>value;label</strong>') ?></p>
                                </div>
                                <div id="field_choices_sql_wrapper">
                                     <x-ui:textarea name="field_choices_sql" data-field="field_choices_sql" id="field_choices_sql" rows="10" label="<?= ___('Choices (SQL Query)') ?>" placeholder="SELECT field_sample_1 as `value`, field_sample_2 AS `label` FROM table_name WHERE ...." />
                                     <p><?= ___('e.g.') ?> SELECT field_sample_1 as <strong>`value`</strong>, field_sample_2 AS <strong>`label`</strong> FROM table_name WHERE ....</p>
                                </div>

                            </div>

                        </x-ui:column>                        
                </x-ui:row>

            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons data-force-ajax="true" data-close-button-back="true" />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->



        <!-- end tabs -->
    </x-ui:schlix-editor-form>
    <?php else: ?>
    <?= ___h($err) ?>
    <?php endif ?>
</x-ui:schlix-item-editor>

