<?php
/**
 * Core: EmailQueue - Main admin view template
 * 
 * Core - EmailQueue
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();

$this->app->CSS('emailqueue.css');
$test_email_to = fsession_string('test_email_to');
?>
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_EmailQueueAdminController" data-enable-preview-link="true" >

        <!-- Toolbar -->
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="test-send"  fonticon="fas fa-envelope" label="<?= ___('Test outgoing email') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" >

                    <x-ui:schlix-data-table-columns>

                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />

                        <x-ui:schlix-data-table-column key="id" hidden="false" label="<?= ___('ID') ?>" sortable="true" formatter="number" />
                        <x-ui:schlix-data-table-column key="guid" hidden="false" label="<?= ___('GUID') ?>" sortable="false" formatter="text" />
                        <x-ui:schlix-data-table-column key="field_subject" sortable="true" label="<?= ___('Subject') ?>" role="title" formatter="SCHLIX.CMS.Core_EmailQueueAdminController.formatDataTableCell_ViewMail" />
                        <x-ui:schlix-data-table-column key="field_to_email" label="<?= ___('To') ?>" formatter="text" />

                        <x-ui:schlix-data-table-column key="date_queued" label="<?= ___('Date Queued') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                        <x-ui:schlix-data-table-column key="date_sent" label="<?= ___('Date Sent') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                        <x-ui:schlix-data-table-column key="retry_count" label="<?= ___('Retry Count') ?>" sortable="true" formatter="number" />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->

    </x-ui:schlix-data-explorer-list>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~ Email View Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

<x-ui:schlix-cms-common-dialog id="schlix-cms-emailqueueviewer-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_EmailQueueAdminController" data-button-cancel-id="btn-dialog-cancel" header-label="<?= ___("View Email"); ?>">

    <x-ui:row>
        <!-- column -->
        <x-ui:column md="4">
            <x-ui:textbox id="email_from" fonticon="fa fa-envelope" readonly="readonly" label="<?= ___('From') ?>" />
            <x-ui:textbox id="email_to" fonticon="fa fa-envelope" readonly="readonly" label="<?= ___('To') ?>" />
            <x-ui:textbox id="email_datequeued" fonticon="fa fa-clock" readonly="readonly" label="<?= ___('Date Queued') ?>" />
            <x-ui:textbox id="email_datesent" fonticon="fa fa-clock" readonly="readonly" label="<?= ___('Date Sent') ?>" />
            <x-ui:textbox id="email_subject" fonticon="fa fa-edit" readonly="readonly" label="<?= ___('Subject') ?>" />
        </x-ui:column>
        
        <!-- column -->
        <x-ui:column md="8">
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_view_mail_html" label="<?= ___('HTML') ?>"> 
                    <div id="email_bodyhtml" class="email-html"></div>
                </x-ui:schlix-tab>
                <x-ui:schlix-tab id="tab_view_mail_text" label="<?= ___('Text') ?>"> 
                <div id="email_bodytext" class="email-text"></div>
                    
                </x-ui:schlix-tab>
            
            </x-ui:schlix-tab-container>
             
             
        </x-ui:column>        
        
    </x-ui:row>
    <hr />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Close') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog> 


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ Test Email Message Dialog ~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-emailtest-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_EmailQueueAdminController" data-button-submit-id="btn-test-dialog-ok" data-action="action=testemail" form-method="post"  data-button-cancel-id="btn-test-dialog-cancel" header-label="<?= ___("Send test email"); ?>">
    
    <x-ui:csrf />
    
    <x-ui:row>
        <!-- col -->
        <x-ui:column md="6">
            
            <!-- field -->
            <x-ui:textbox id="test_email_from" label="<?= ___('From') ?>" fonticon="fas fa-envelope-o" value="<?= ___h(SCHLIX_MAIL_DEFAULT_EMAIL) ?>" readonly="readonly" />

            <!-- field -->
            <x-ui:textbox id="test_email_to" name="msg_to" type="email" fonticon="fa fa-envelope" label="<?= ___('To') ?>" required="required" value="<?= ___h($test_email_to) ?>" />

            <!-- field -->

            <x-ui:textbox name="msg_subject" maxlength="191" id="msg_subject" label="<?= ___('Subject') ?>" fonticon="fas fa-comment" placeholder="<?= ___('Subject') ?>" value="TEST <?= mt_rand(1000, 65535) ?>" />
            <!-- field -->
            <x-ui:textarea name="msg_message" rows="3" id="msg_comment" label="<?= ___('Comment') ?>" 
                           fonticon="fas fa-comment" placeholder="<?= ___('Type your message') ?>">TEST EMAIL</x-ui:textarea>
            
            
        </x-ui:column>
        <!-- col -->
        <x-ui:column md="6">
            <div id="testemail_send_result" class="mail-debug"></div>
        </x-ui:column>
    </x-ui:row>
    <!-- form -->
    
    <x-ui:clearboth />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-test-dialog-ok" fonticon="fa fa-envelope" label="<?= ___('Send') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-test-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Close') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>