<?php
/**
 * Core - Help
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$this->app->CSS('emailsetup.css');

?> 
<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_EmailSetupAdminController" >
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    


            <x-ui:schlix-explorer-menu-command data-schlix-command="main" data-schlix-app-action="main"  fonticon="fas fa-server" label="<?= ___('Basic Email Setup') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="authxo2" data-schlix-app-action="authxo2"  fonticon="fas fa-server" label="<?= ___('Authorize OAUTH2 connection') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="test-send"  fonticon="fas fa-envelope" label="<?= ___('Test outgoing email') ?>" />               
        </x-ui:schlix-explorer-toolbar-menu>


    </x-ui:schlix-explorer-toolbar>
    <?php if ($are_deps_installed): ?>
    <x-ui:row>
        <!-- column -->
        <x-ui:column md="6">
             <!-- form -->

            <x-ui:form-simple-ajax data-action="<?= $this->createFriendlyAdminURL('action=authorizexoauth2') ?>" id="schlix-mailsetup-form" class="contact_form" enctype="multipart/form-data">        
                <x-ui:csrf />
                <x-ui:schlix-info-box class="box-danger" fonticon="fa fa-envelope" label="<?= ___('Authorize XOAUTH 2 connection') ?>" >

                    <x-ui:select name="mail_oauth2_provider" id="mail_oauth2_provider" fonticon="fas fa-server" required="required"  label="<?= ___('Provider') ?>" data-var="mail_oauth2_provider">
                        <x-ui:option value="" label="-- <?= ___('Please select') ?> --" />
                        <x-ui:option value="google" label="Google Workspace/GSuite" />
                        <x-ui:option value="yahoo" label="Yahoo" />
                        <x-ui:option value="microsoft" label="Microsoft" />
                    </x-ui:select> 
                    <x-ui:textbox name="mail_oauth2_client_id" autocomplete="off" id="mail_oauth2_client_id" fonticon="fa fa-user-circle" label="<?= ___('Client ID') ?>" required="required" data-var="mail_oauth2_client_id" placeholder="1234567890-abcdef.apps.googleusercontent.com" />
                    <x-ui:textbox name="mail_oauth2_secret" id="mail_oauth2_secret"  fonticon="fas fa-key" label="<?= ___('Client Secret') ?>" required="required" placeholder="1234567890abcdef" data-var="mail_oauth2_secret" />

                    <x-ui:textbox id="mail_oauth2_url_redirect"  fonticon="fas fa-external-link" label="<?= ___('URL Redirect') ?>" data-var="url_redirect" />

                    <hr />
                    <x-ui:row>
                        <x-ui:column sm="6">
                            <div class="schlix-ajax-output"></div>
                            <x-ui:button button-type="ok" type="submit" data-form-submit="1" name="sendmail" id="schlixcontact-submit-button" value="Submit" label="<?= ___('Request authorization') ?>" fonticon="fa fa-paper-plane" />
                        </x-ui:column>
                    </x-ui:row>
                </x-ui:schlix-info-box>
            </x-ui:form-simple-ajax>    
            
        </x-ui:column>
        <!-- column -->
        <x-ui:column md="6">
                <x-ui:schlix-info-box class="box-info" fonticon="fa fa-envelope" label="<?= ___('Access token') ?>" >
            <p><?= ___('Get your client ID and secret as well as set up the redirect URL from the following page') ?></p>
            <ul>
                <li><i class="fab fa-google"></i> Google - <a target="_blank" rel="noopener" href="https://console.developers.google.com/project">https://console.developers.google.com/project</a>.<br />
                <?= ___('Note: you may need to perform an additional action') ?>: <a target="_blank" rel="noopener"  href="https://accounts.google.com/DisplayUnlockCaptcha">https://accounts.google.com/DisplayUnlockCaptcha</a></li>                
                <li><i class="fab fa-microsoft"></i> Microsoft - <a target="_blank" rel="noopener" href="https://account.live.com/developers/applications/create">https://account.live.com/developers/applications/create</a></li>
                <li><i class="fab fa-yahoo"></i> Yahoo - <a target="_blank" rel="noopener" href="https://developer.yahoo.com/apps/">https://developer.yahoo.com/apps/</a></li>
            </ul>
                </x-ui:schlix-info-box>
        </x-ui:column>
        
    </x-ui:row>

    <?php else: ?>
        <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>

    <x-ui:alert type="warning">
        <p><?= ___('Please wait until all package dependencies installation is completed, then refresh this page') ?></p>
    </x-ui:alert>
    <?php endif ?>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>


<?php require('view.testmail.admin.template.php'); ?>