<?php
namespace App;

/**
 * Core: Emailtemplate - Admin class
 * 
 * Core - Emailtemplate
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Emailtemplate_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     */

//_________________________________________________________________________//    
    public function __construct() {
        // Data: Item
        parent::__construct(true, []);
        $this->setItemFieldNamesForAjaxListing('id', 'virtual_filename', 'title', 'purpose', 'date_created', 'date_modified', 'is_system_message');
    }
    
    public function editItem($id) {
        global $WYSIWYGEditor;
        
        $wid = $this->app->getConfig('int_wysiwyg_profile_id');
        
        $use_master_wysiwyg = (fget_string('type') == 'master' && fget_string('action') == 'newitem');
        
        if ($wid)
            $WYSIWYGEditor->overRideFullPrivilegeWysiwygEditor($wid);
        if ($id > 0)
        {
            $item =  $this->app->getItemByID($id);
            
            $use_master_wysiwyg = isset($item['virtual_filename']) && (str_contains($item['virtual_filename'],'master'));
        }
        if ($use_master_wysiwyg)
        {
                $wmaster_id = $this->app->getConfig('int_master_wysiwyg_profile_id');
                if ($wmaster_id > 0)
                    $WYSIWYGEditor->overRideFullPrivilegeWysiwygEditor($wmaster_id);
                
        }
        
        return parent::editItem($id);
    }
    
    public function modifyAjaxGetAllItemsResult($result) {
        $result = parent::modifyAjaxGetAllItemsResult($result);
        for ($i = 0, $c = ___c($result); $i < $c; $i++)
        {
            $is_master = str_starts_with($result[$i]['virtual_filename'],'master');
            $result[$i]['template_type'] = $is_master ? 
                    \__HTML::I('', ['class' => 'fas fa-crown text-chocolate']).' '.___('Master') :
                    \__HTML::I('', ['class' => 'fas fa-envelope-open-text text-blue']).' '.___('Regular');
        }
        return $result;
    }

    /**
     * Before save item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTable('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_id]);
        $datavalues['body_html'] = convert_pasted_png_images_from_html_text($datavalues['body_html'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['body_html'] = move_static_external_images_from_html_text($datavalues['body_html'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        // tinymce workaround bug
        // TODO fix with regex
        $datavalues['body_html'] = str_replace('href="/{$', 'href="{$', $datavalues['body_html']);
        $datavalues['body_html'] = str_replace('href="'.SCHLIX_SITE_HTTPBASE.'/{$', 'href="{$', $datavalues['body_html']);
        $datavalues['body_html'] = str_replace('src="'.SCHLIX_SITE_HTTPBASE.'/{$', 'src="{$', $datavalues['body_html']);        
        
        if (str_starts_with($datavalues['virtual_filename'], 'master'))
            $datavalues['master_template_id'] = 0;
        else 
        {
            if ($datavalues['master_template_id'] > 0)
            {
                $existing_template = $this->app->getMasterTemplateByID($datavalues['master_template_id']);
                if (!$existing_template)
                    $datavalues['master_template_id'] = 0;
                
            }
        }
        // end tinymce workaround bug
        $datavalues['body_text'] = trim($datavalues['body_text']);
        if (empty($datavalues['body_text']))
            $datavalues['body_text'] = \App\Core_Emailtemplate::convertHTMLToText ($datavalues['body_html']);
        
        return $datavalues;
    }

    
} 