<?php
namespace App;
/**
 * Core: Emailtemplate - Main Class
 * 
 * Core - Emailtemplate
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Emailtemplate extends \SCHLIX\cmsApplication_List {

    /**
     * Constructor
     */
    public function __construct() {
            parent::__construct('Email template', 'gk_email_template_items');
            $this->disable_frontend_runtime = true;
            $this->has_versioning = false; //TODO: enable for next release
    }
 

    //_______________________________________________________________________________________________________________//
    public function getByVirtualFileName($virtual_filename) {        
        $item = $this->getItemsByVirtualFilename($virtual_filename);
        if ($item)
            return $item[0];
        else
            return false;
    }
    
    public function getPreProcessedEmailTemplateByVirtualFileName($vfn)
    {
        $item = $this->getByVirtualFileName($vfn);
        
        if ($item && $item['master_template_id'] > 0)
        {
            $master = $this->getMasterTemplateByID($item['master_template_id']);
            if ($master)
            {
                
                $item['body_html'] = str_replace('{$html_email_content}', $item['body_html'], $master['body_html']);
                $item['body_text'] = str_replace('{$text_email_content}', $item['body_text'], $master['body_text']);
            }
            
        }
        return $item;
    }
    
    public function getMasterTemplateByID($id) {        
        
        return $this->table_items->q()->select('*')->where("virtual_filename LIKE 'master%' AND id = :id")->getQueryResultSingleRow(['id' => $id]);
    }
    
    public function getMasterTemplates() {        
        
        return $this->table_items->q()->select('*')->where("virtual_filename LIKE 'master%'")->getQueryResultArray();
    }
    
    public function ensureTemplateExists($virtual_filename, $purpose, $subject, $body_html, $body_text)
    {
        $template = $this->getByVirtualFileName($virtual_filename);
        if (!$template)
        {
            $data['purpose'] = $purpose;
            $data['subject'] = $subject;
            $data['body_html'] = $body_html;
            $data['body_text'] = $body_text;
            
            $this->table_items->q()->insertInto()->values($data);
        }
    }
    
    
    private static function filterInvalidLine($s)
    {
        $s = trim($s, " \n");
        return (!str_starts_with($s, '?')) && !empty($s) && ($s != "\n")  && ($s != "\r\n") && ($s != "�") && strlen($s) > 1;
    }
    //_________________________________________________________________________//		
    public static function convertHTMLToText($html) {
        global $SystemMail;

        $txt = $SystemMail->html2text($html);
        //$txt = preg_replace('/\r\n+/', "\n", $txt);
        //$txt = preg_replace('/\n\n+/', "\n", $txt);
        $arr = explode("\r\n", $txt);
        $data = array_filter( $arr, 'static::filterInvalidLine' );
        $txt = implode ("\r\n", $data);
        return $txt;
    }
    
    public function installTemplate($purpose, $virtual_filename, $subject, $body_html, $body_text, $is_system)
    {
        $existing_item  = $this->getByVirtualFileName($virtual_filename);
        if (!$existing_item)
        {
            $data = ['purpose' => $purpose,
                    'virtual_filename' => $virtual_filename,
                    'date_created' => get_current_datetime(),
                    'guid' => new_uuid_v4(),
                    'subject' => $subject,
                    'body_html' => $body_html,
                    'body_text' => $body_text,
                    'is_system_message' => $is_system];
            $this->table_items->q()->insertInto()->values($data);
            
        }
    }


}