<?php
/**
 * Core - Emailtemplate - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

global $CurrentUser;
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = ___('New Item');
    $item['virtual_filename'] = null;
    $item['title'] = null;
    $item['purpose'] = null;
    $item['is_system_message'] = null;
    
} else {
    $preview_link = $this->app->createFriendlyURL("action=viewitem&id={$id}");
    $header_title = ___('Edit Item').' #'.$id;
}
$new_master_template = (fget_string('type') == 'master' && fget_string('action') == 'newitem');
$is_master = str_starts_with($item['virtual_filename'], 'master') || $new_master_template;

if ($new_master_template)
{
    $item['virtual_filename'] = 'master-';
    $item['title'] = 'Master Template';
    $item['purpose'] = 'Master Template - ';
}

$master_templates = $this->app->getMasterTemplates();
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-item-editor  data-schlix-controller="SCHLIX.CMS.Core_EmailtemplateAdminController">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
            
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <x-ui:textbox name="purpose" maxlength="254" required="required"   value="<?= ___h($item['purpose']) ?>" label="<?= ___("Purpose") ?>" fonticon="<?= $is_master ? 'fas fa-envelope' : '' ?>" prefix="<?= $is_master ? ___('Master template') : ___('Regular template') ?> " />
                    
                    <x-ui:schlix-document-virtual-filename label="<?= ___('Shortcut name'); ?> <?= ($item['is_system_message']) ? ' ~ '.___('System Default (cannot be modified)') : '' ?>" id="virtual_filename" data-field="virtual_filename"  <?= ($item['is_system_message'] == 1) ? 'readonly="readonly"' : ''; ?> />
                  
                    <?php if ($item['is_system_message'] != 1): ?>
                    <p class="text-info"> <?= ___('Note: A master template must start with the word master. To change the email template type from master to regular or vice versa, simply add/remove the word master at the beginning of the shortcut name.') ?> </p>
                    <?php endif ?>
                  
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="fas fa-envelope-open-text" label="<?= ___('Content') ?>"> 
                    
                    <?php if ($is_master): ?>
                    <x-ui:alert type="info">
                        <p><?= ___('This is a master template. A master template must contain 3 variables') ?>:</p>
                        <ul>
                            <li>{$text_email_header_preview}</li>

                            <li>{$text_email_content}</li>

                            <li>{$text_email_footer}</li>
                            
                        </ul>
                        
                    </x-ui:alert>
                    <?php else: ?>
                        <?php if ($master_templates): ?>
                        <x-ui:select id="master_template_id" data-field="master_template_id" name="master_template_id" label="<?= ___('User master template') ?>" fonticon="fas fa-crown">
                            <x-ui:option value="" label="-- <?= ___('None') ?> --" />
                            <?php foreach ($master_templates as $m): ?>
                                <x-ui:option value="<?= ___h($m['id']) ?>" label="<?= ___h($m['purpose']) ?>" />
                            <?php endforeach ?>
                        </x-ui:select>
                        <?php else: ?>
                    <p><?= ___('Note: no master template detected') ?></p>
                        <?php endif ?>
                    
                    <x-ui:textbox id="title" name="title" data-field="title" maxlength="254" required="required" label="<?= ___('Subject'); ?>" />
                    
                    <?php endif ?>
                    <x-ui:wysiwyg id="body_html" name="body_html" data-field="body_html" label="<?= ___('HTML Body') ?>" />
                    <x-ui:clearboth />
                    <x-ui:textarea rows="20" id="body_text" name="body_text" data-field="body_text" label="<?= ___('Text Body') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 