<?php
/**
 * Core: Error 404 - Main admin view template
 * 
 * Core - Error 404
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_Error404AdminController" data-enable-preview-link="true" >
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />            
            <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="sub-application" sub-application="redirection" fonticon="fas fa-undo" label="<?= ___('View Redirection Rules') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.Core_Error404AdminController.formatDataTableCell_CheckBox" sortable="false" />
                    <x-ui:schlix-data-table-column key="path" sortable="true" label="<?= ___('URL Path') ?>" formatter="SCHLIX.CMS.Core_Error404AdminController.formatDataTableCell_404URL" />                    
                    <x-ui:schlix-data-table-column key="hits" sortable="true" label="<?= ___('Hits') ?>" formatter="number" />
                    <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                    <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Last Hit') ?>" sortable="true" formatter="this.formatDataTableCell_DateTime" />
                    <x-ui:schlix-data-table-column key="redirect_rule" label="<?= ___('Redirect Rule') ?>" sortable="false" formatter="SCHLIX.CMS.Core_Error404AdminController.formatDataTableCell_RedirectButton"  />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-list>