<?php
/**
 * Core: Extension Gallery - Main admin view template
 * 
 * Core - Extension Gallery
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
$this->app->CSS('extgallery.css');
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" data-enable-preview-link="true" data-default-view-mode="gallery">
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            
            <x-ui:schlix-explorer-menu-command data-schlix-command="main" data-schlix-app-action="main"  fonticon="fab fa-schlix text-schlix-logo" label="<?= ___('Extension Gallery') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="installedexts" data-schlix-app-action="installedexts" fonticon="fas fa-archive text-maroon" label="<?= ___('Installed Extensions') ?>" />
            
            
            
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/extensions/" target="_blank"  fonticon="fas fa-chalkboard-teacher" open-new-window="1" label="<?= ___('Publish your extensions') ?>" />            
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
        <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>

    <!-- breadcrumb -->
    <table class="table table-striped table-responsive installed-extensions">
        <tr>
            <td><?= ___('Extension Name') ?></td>
            <td><?= ___('Installed Version') ?></td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
        </tr>
    <?php foreach ($installed_exts as $ext): ?>
        <?php
            $link = $this->createFriendlyAdminURL("action=viewitem&id={$ext['item_id']}");
            $icon_url  = $ext['url_icon'];
            $next_compatible_version = $this->app->getNextCompatibleVersion($ext['guid']);
            $upg_title =  ___('Upgrade to') . ' v'.___h($next_compatible_version['ext_version']);
            
            $full_uninstall_title =  sprintf(___('Uninstall %s %s ?'), ___h($ext['title']), 'v'.___h($ext['ext_version']));
        ?>
        <tr>
            <td><a href="<?= $link ?>"><img class="icon" src="<?= $icon_url ?>" alt="<?= ___h($ext['title']) ?>" /><?= ___h($ext['title']) ?></a></td>
            <td><?= ___h($ext['ext_version']) ?></td>
            <td>
                 <x-ui:button button-type="cancel" name="uninstall" class="schlix-uninstall-ext-button" id="btn-request-uninstall-<?= $ext['id'] ?>"  label="<?= ___('Uninstall ') ?>" value="<?= ___h($ext['guid']) ?>" fonticon="fas fa-times" data-title="<?= ___h($full_uninstall_title) ?>" />       
            </td>
            
            <td>
                <?php if ($next_compatible_version): ?>
                <?php 
                    $upg_title =  ___('Upgrade to') . ' v'.___h($next_compatible_version['ext_version']);
                    $full_upg_title =  sprintf(___('Upgrade %s to %s ?'), ___h($ext['title']), ' v'.___h($next_compatible_version['ext_version']));
                
                ?>
                 <x-ui:button button-type="ok" name="upgrade" class="schlix-upgrade-ext-button" id="btn-request-upgrade-<?= $ext['id'] ?>"  label="<?= ___h($upg_title) ?>" data-title="<?= ___h($full_upg_title) ?>" value="<?= ___h($next_compatible_version['guid']) ?>" fonticon="fas fa-download" />       
                 <?php endif ?>
            </td>
        </tr>
    <?php endforeach; ?>
    </table>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ Upgrade Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-upgrade-ext-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" header-label="<?= ___('Upgrade confirmation') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=extupgrade" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="guid" id="upgrade-guid" />
    
    <div id="upgrade-title"></div>
    <hr />
    <x-ui:textbox type="password" name="password" id="password" required="required" label="<?= ___('Please enter your password to confirm') ?>" fonticon="fas fa-lock" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Uninstall Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-uninstall-ext-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" header-label="<?= ___('Uninstall confirmation') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=extuninstall" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="guid" id="uninstall-guid" />
    
    <div id="uninstall-title"></div>
    <hr />
    <x-ui:textbox type="password" name="password" id="password" required="required" label="<?= ___('Please enter your password to confirm') ?>" fonticon="fas fa-lock" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>

