<?php
/**
 * Core: HttpError - Main page template. Lists all items. 
 * 
 * Core - HttpError
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

 $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
$str_mainpage_text =  $this->getConfig('str_mainpage_text');
 // OPTIONAL - feel free to uncomment
 // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');

?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <h1 class="main title"><?= ___h($str_mainpage_title) ?></h1>
    <?php if ($pg < 2) : ?>
    <?= $str_mainpage_text ?>
    <?php endif ?>
    
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item">    
                    <?php 
                        $child_item_id = $child_item_id = $child_item[$this->field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                    ?>
                    <h2 class="item title" itemprop="headline"><?= $child_item_title_text; ?></h2>

                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <div class="text">
                        <?= $child_item['summary'] ?>
                    </div>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                </section>
                <?php endif ?>
            <?php endforeach ?>       

    
    
    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=main"); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div>