/**
 * Core: Macro Manager - Javascript admin controller class
 * 
 * Core - Macro Manager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_MacroManagerAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.macromanager");
    };

    onDOMReady ()
    {
        this.initMacroEditor();
        //SCHLIX.Event.on('zipfileupload', 'change', this.previewFile, this, true);        
    }; // end func
    ////////////////////////////////////////////////////////////
    
    
    initMacroEditor ()
    {
        if (SCHLIX.Dom.get('blocks_select_all') && SCHLIX.Dom.get('apps_select_all'))
        {
            var display_in_apps = document.forms.macro_item_editor.display_in_apps_workaround.value;
            var display_in_blocks = document.forms.macro_item_editor.display_in_blocks_workaround.value;
            SCHLIX.Event.on('apps_select_all', "click", this.hideAppSelections, this, true);
            SCHLIX.Event.on('apps_select_some', "click", this.showAppSelections, this, true);
            SCHLIX.Event.on('blocks_select_all', "click", this.hideBlockSelections, this, true);
            SCHLIX.Event.on('blocks_select_some', "click", this.showBlockSelections, this, true);

            if (display_in_apps == 1)
                this.hideAppSelections();
            if (display_in_blocks == 1)
                this.hideBlockSelections();
            console.log('display_in_apps ' + display_in_apps);
            console.log('display_in_blocks ' + display_in_blocks);
        }
    }; // end func
///////////////////////////////////////////////////////////
    hideAppSelections ()
    {
        var div = document.getElementById('app_selections');
        div.style.display = 'none';
    }; // end func
///////////////////////////////////////////////////////////
    showAppSelections (str)
    {
        var div = document.getElementById('app_selections');
        div.style.display = 'block';
    }; // end func
///////////////////////////////////////////////////////////
    hideBlockSelections ()
    {
        var div = document.getElementById('block_selections');
        div.style.display = 'none';
    }; // end func
///////////////////////////////////////////////////////////
    showBlockSelections (str)
    {
        var div = document.getElementById('block_selections');
        div.style.display = 'block';
    }; // end func
    showInstallerWindow ()
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
        obj.show();
    }; // end func
    submitForm ()
    {
        /* var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
         var form = obj.__getFirstFoundForm();
         console.log(form);*/
        return RESOLVE_TO_PARENT;
    }; // end func
    /**
     * Run command
     * @param {type} command
     * @returns {unresolved}
     */
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'install':
                this.showInstallerWindow();
                break;
            case 'dialog-submit':
                return this.submitForm();
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'form-submit-ok':
                this.cms_control.refreshControls();
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    };
};