<?php
/**
 * Core - Media Header - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<x-ui:schlix-explorer-sub-application-header />
<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.Core_MediaHeaderAdminController" type="config">

        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:column md="6">
                                     <fieldset  class="form-inline"><legend><?= ___('Image Dimension (pixels)') ?></legend>
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon><?= ___('Width') ?></x-ui:input-group-addon>                                        
                                        <schlix-config:integerbox min="320" max="2560"  config-key="int_width" config-default-value="1920" required="required" placeholder="<?= ___('Width') ?>"/>                            
                                    </x-ui:input-group>
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon><?= ___('Height') ?></x-ui:input-group-addon>
                                        <schlix-config:integerbox min="50" max="1080"  config-key="int_height" config-default-value="800" required="required" placeholder="<?= ___('Height') ?>" />
                                    </x-ui:input-group>
                                    <?= ___('pixels') ?>.   
                                     </fieldset>
                                
                                <schlix-config:integerbox min="10" max="100" label="<?= ___('Quality') ?>"  config-key="int_quality" required="required"  config-default-value="70" />                      
            </x-ui:column>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>      
