<?php
/**
 * Core: Menu - Main admin view template
 * 
 * Core - Menu
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php $app = alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias()); ?>
<div class="schlix-explorer">
    <x-ui:schlix-data-explorer-doubletree id="schlix-<?= $app ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.MenusAdmin" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $app ?>" data-model="<?= $this->getDataModelURL() ?>">

        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-item" data-schlix-app-action="newitem"   fonticon="fa fa-th-list text-blue" label="<?= ___('New Menu Item') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-category" data-schlix-app-action="newcategory" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Category') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="cut" require-selected-items="1" fonticon="fa fa-cut" label="<?= ___('Cut') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Left Column -->
            <x-ui:schlix-explorer-left-column>
                <!-- treeview -->
                <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
                <!-- end column -->
            </x-ui:schlix-explorer-left-column>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <div schlix-id="datanav-menu-items">
                </div>

                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                    <x-ui:schlix-data-table-columns>

                        <schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <schlix-data-table-column key="title" sortable="true" label="<?= ___('Title') ?>" formatter="this.formatDataTableCell_DefaultTitleColumn" />

                        <schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                        <schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                        <schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />

                        <schlix-data-table-column key="sort_order" label="<?= ___('Sort Order') ?>" sortable="true" formatter="number" editor="new SCHLIX.UI.TextboxCellEditor({validator:SCHLIX.UI.DataTable.validateNumber,disableBtns:false})" />

                        <schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date"  />
                        <schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date"  />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->

    </x-ui:schlix-data-explorer-doubletree>
</div>
 
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ New/Edit Category Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-category-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.MenusAdmin" header-label="<?= ___('Block Category') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=ajaxsavecategory" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="cid" id="dlg-category-id" />
    <x-ui:hidden name="status" value="1" />
    <x-ui:label for="dlg-category-title" id="label-new-category-title"><?= ___("Create a New Menu Category"); ?></x-ui:label>
    <x-ui:label for="dlg-category-title" id="label-edit-category-title"><?= ___("Edit Menu Category"); ?> <span id="label-edit-category-id"></span></x-ui:label>
    <x-ui:textbox name="title" id="dlg-category-title" required="required" maxlength="63" 
                    placeholder="<?= ___('Category Name') ?>" pattern="^[A-Za-z0-9_\-]{1,63}$" title="<?= ___('Alphanumeric with dash and space only') ?>" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>
