<?php
namespace App;

/**
 * Core: ThemeManager - Admin class
 * 
 * Core - ThemeManager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_ThemeManager_Admin extends \SCHLIX\cmsAdmin_PluginsManager {
    /**
     *
     * @var Core_ThemeManager 
     */
    protected $app;
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */    
    public function __construct() {
        // Data: Item
        parent::__construct('themes');
        $this->checkForUnregisteredItems("themes"); 
        $this->setItemFieldNamesForAjaxListing('id', 'title', 'description', 'status','sort_order','is_admin','date_modified','is_default');
    }


    public function ajaxGetThemeItems($is_admin, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;

        if ((int) $start > (int) $end)
            return ajax_reply(400, 'Invalid Request');
        $sortby = $SystemDB->escapeString($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $is_admin_criteria = $is_admin ? 'is_admin = 1' : 'is_admin = 0';
        $fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $total_item_count = $this->app->getTotalItemCount($is_admin_criteria);
        $result_array_files = $this->app->getAllItems($fields, $is_admin_criteria, $start, $end, $sortby, $sortdirection, false);
        return ajax_datasource_reply(200, $result_array_files, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }
    

    public function ajaxGetAllFrontendItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        // do it only once in here
        $this->checkForUnregisteredItems("themes"); 
        return $this->ajaxGetThemeItems(false, $start, $end, $sortby, $sortdirection);
    }

    public function ajaxGetAllBackendItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        return $this->ajaxGetThemeItems(true, $start, $end, $sortby, $sortdirection);
    }    
    //_________________________________________________________________________//	
    public function checkForUnregisteredItems() {
        $item_array = [];

        
        // USER
        $items = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH . '/' . $this->managed_class_name . '/', \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
        if ($items) {
            
            foreach ($items as $item) {
                $file = $item->getFileName();
                if ((strpos($file, 'uninstalled_') === false ) && file_exists($item->getPathName() . "/index.php"))
                    $item_array[] = $file;
            }
        }
        if ($item_array) {
            $this->cleanUpOrphanedItems($item_array);
            foreach ($item_array as $item) {
                $dups = $this->findInstalledItem($item);
                if (___c($dups) == 0)
                    $this->installItem($item);
            }
        }
    }
            
    //_________________________________________________________________________//
    /**
     * Set default website theme. $mode is either frontend or backend (string)
     * @param string $mode
     * @param int $id
     * @return string
     */
    public function ajaxSetDefaultWebsiteTheme($mode, $id) {
        check_csrf_halt_on_error(true);
        $int_mode = $mode == 'backend' ? 1 : 0; //is_admin ?
        $retval = $this->app->setDefaultTheme($int_mode, $id);
        return ajax_reply(200, $retval);
    }

    /*
     * Reset default backend theme
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return array
     */
    public function ajaxResetDefaultBackendTheme() {
        global $SystemDB;        
        
        check_csrf_halt_on_error(true);
        if (fpost_int('set') == 1)
        {
            $sql = "UPDATE {$this->table_items} SET is_default = 0 WHERE is_admin = 1";
            $SystemDB->query($sql);
            return ajax_reply(200, 'OK');
        } else
        {
            return ajax_reply(300, 'Invalid Command');
        }
    }


    /**
     * Install item
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $filename
     */
    public function installItem($filename) {
        global $SystemDB;

        $datavalues['title'] = $filename;
        $datavalues['status'] = 1; // as of v2.0.3, automatically set status to 1
        
        $datavalues['is_admin'] = (str_starts_with(strtolower($filename), 'admin')) ? 1 : 0;
        $SystemDB->simpleInsertInto($this->table_items, $datavalues);                            
        return true;
    }
    
    //_______________________________________________________________________________________________________________//
    /**
     * Returns the list of default templates in current theme
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @global type $SystemLog
     * @return type
     */
    public function getListOfSubtemplatesInCurrentDefaultTheme() {
        global $SystemDB, $SystemLog;

        $sql = "SELECT id FROM {$this->table_items} WHERE is_default = 1";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        if ($result) {
            $template_id = $result['id'];
            return $this->getListOfSubtemplatesByThemeID($template_id);
        } else {
            $this->app->logError('Cannot get the default template');
        }
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Updates the list of subtemplates
     * @param int $template_id
     * @return boolean
     */
    protected function updateListOfSubtemplateByTemplateID($template_id) {
        global $SystemDB;

        $template_id = (int) $template_id;
        $template = $this->app->getItemByID($template_id);
        $list_of_available_subtemplates = [];
        if ($template) {
            $template_name = $template['title'];

            $items = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH . '/themes/' . $template_name . '/', \SCHLIX\cmsDirectoryFilter::FILTER_FILE_ONLY);
            if ($items)
                foreach ($items as $item) {
                    $filename = $item->getBaseName('.php');
                    $ext = $item->getExtension();
                    if (($ext === 'php') && (($filename === 'index') || (strpos($filename, 'template') !== FALSE))) {
                        $list_of_available_subtemplates[] = $filename;
                    }
                }
            if (is_array($list_of_available_subtemplates)) {
                $str_list_of_available_subtemplates = sanitize_string(implode(';', $list_of_available_subtemplates));

                $sql = "UPDATE {$this->table_items} SET subtemplates = {$str_list_of_available_subtemplates} WHERE {$this->field_id} = {$template_id}";
                $SystemDB->query($sql);
                return true;
            } else
                return false;
        } else
            return false;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Returns the list of subtemplates, given a template ID
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $template_id
     * @return array
     */
    public function getListOfSubtemplatesByThemeID($template_id) {
        global $SystemDB;


        $template_id = (int) $template_id;
        $this->updateListOfSubtemplateByTemplateID($template_id);
        $sql = "SELECT subtemplates FROM {$this->table_items} WHERE {$this->field_id} = {$template_id}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        $str_subtemplates = $result['subtemplates'];
        $subtemplates = explode(';', $str_subtemplates);

        return $subtemplates;
    }

    //_________________________________________________________________________//
    public function ajaxGetDefaultTheme($type = 'frontend') {
        $response = [];
        $response['default'] = ($type == 'frontend' ? $this->app->getDefaultFrontendThemeID(): $this->app->getDefaultBackendThemeID() );
        return ajax_reply(200, $response);
    }
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getfrontendthemes': 
                return ajax_echo($this->ajaxGetAllFrontendItems(fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'getbackendthemes': 
                return ajax_echo($this->ajaxGetAllBackendItems(fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'resetdefaultbackend': 
                return ajax_echo($this->ajaxResetDefaultBackendTheme());
                break;
            
            case 'setdefault': 
                return ajax_echo($this->ajaxSetDefaultWebsiteTheme(fpost_alphanumeric('mode'), fpost_int('id')));
                break;
            
            case 'getdefaultfrontendtheme':
                return ajax_echo($this->ajaxGetDefaultTheme('frontend'));
                break;
            case 'getdefaultbackendtheme':
                return ajax_echo($this->ajaxGetDefaultTheme('backend'));
                break;            
            default: return parent::Run();
        }
    }

}
