<?php
namespace App;
/**
 * Core: ThemeManager - Main Class
 * 
 * Core - ThemeManager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_ThemeManager extends \SCHLIX\cmsApplication_List {

    protected $sub_template = 'index';

    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public function __construct()
    {
        parent::__construct('Theme Manager', 'gk_theme_items');
        $this->disable_frontend_runtime = true;

    }

    //_______________________________________________________________________________________________________________//
    public function viewMainPage()
    {
        return false;
    }
 
//_______________________________________________________________________________________________________________//
    public function findDuplicateItems($data)
    {
        global $SystemDB;

        $current_id = (int) $data[$this->field_id];
        $the_title = sanitize_string($data['title']);
        $sql = "SELECT * from {$this->table_items} WHERE (title = {$the_title})";

        if (intval($current_id) != 0)
            $sql.= " AND (id != '{$current_id}')";

        $result = $SystemDB->getQueryResultArray($sql);

        return $result;
    }

//_______________________________________________________________________________________________________________//
    /**
     * Sets the default theme
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param bool $is_admin
     * @param int $template_id
     * @return boolean
     */
    public function setDefaultTheme($is_admin, $template_id)
    {
        global $SystemDB;

        $template_id = (int) $template_id;
        if ($this->getItemByID($template_id)) {
            $int_is_admin = sanitize_string($is_admin ? '1' : '0');
            $sql = "UPDATE {$this->table_items} SET is_default = 0 WHERE {$this->field_id} <> {$template_id} AND is_admin = {$int_is_admin}";
            $SystemDB->query($sql);
            $sql = "UPDATE {$this->table_items} SET is_default = 1 WHERE {$this->field_id} = {$template_id} AND is_admin = {$int_is_admin}";
            $SystemDB->query($sql);
            return true;
        }
        else
            return false;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Return the ID (int) of frontend theme
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return int
     */
    public function getDefaultFrontendThemeID()
    {
        global $SystemDB;

        $sql = "SELECT {$this->field_id} FROM {$this->table_items} WHERE is_default = 1 AND is_admin = 0";
        $data = $SystemDB->getQueryResultSingleRow($sql);
        return ($data != NULL) ? $data[$this->field_id] : 0;
    }
    
    /**
     * Return the ID (int) of backend theme
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return int
     */
    public function getDefaultBackendThemeID()
    {
        global $SystemDB;

        $sql = "SELECT {$this->field_id} FROM {$this->table_items} WHERE is_default = 1 AND is_admin = 1";
        $data = $SystemDB->getQueryResultSingleRow($sql);
        return ($data != NULL) ? $data[$this->field_id] : 0;
    }
    

    //_______________________________________________________________________________________________________________//
    public function getDefaultWebsiteThemeName()
    {
        return self::getCurrentFrontendWebsiteTemplateName(); 
    }

    
    //_________________________________________________________________________//	
    /**
     * Return the current website template name for frontend
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return type
     */
    public static function getCurrentFrontendWebsiteTemplateName()
    {
        global $SystemDB;

        $template_name = \SCHLIX\cmsContextCache::get('core_theme', 'current_template_name');
        if (!$template_name)
        {
            $sql = "SELECT title FROM gk_theme_items WHERE is_default = 1 AND is_admin = 0";
            $template = $SystemDB->getQueryResultSingleRow($sql);
            $template_name = empty($template['title']) ? 'companyprofile' : $template['title'];
            \SCHLIX\cmsContextCache::set('core_theme', 'current_template_name', $template_name);
        } 

        return $template_name; 
    }

    /**
     * Return the current website template name for frontend
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return type
     */
    public static function getCurrentBackendWebsiteTemplateName()
    {
        global $SystemDB;

        $sql = "SELECT title FROM gk_theme_items WHERE is_default = 1 AND is_admin = 1";
        $template = $SystemDB->getQueryResultSingleRow($sql);

        return empty($template['title']) ? 'admindefault' : $template['title']; 
    }
    //_______________________________________________________________________________________________________________//
    public function isMobile()
    {
        if (!isset($_SESSION['template_type']))
            $this->determineWhetherToUseDesktopOrMobileTemplate();
        return ($_SESSION['template_type'] == 'mobile');
    }

    //_______________________________________________________________________________________________________________//
    public function setSubTemplate($subtemplate)
    {
        $this->sub_template = $subtemplate;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Loads a subtemplate and run it. The subtemplate can be
     * any file in the template directory, and the default is index
     * @param string $subtemplate_file
     * @param string $alternative_subtemplate_file
     */
    public function loadSubTemplateByName($subtemplate_file = 'index', $alternative_subtemplate_file = '')
    {
        global $CurrentWebSiteThemeName;
        $not_found = false;
        global $__application_to_load;
        
        if ($__application_to_load == "admin") {
            $template_name = self::getCurrentBackendWebsiteTemplateName(); //  "admindefault";
            
            $backend_prefix_path = ($template_name == 'admindefault') ? SCHLIX_SYSTEM_PATH : SCHLIX_SITE_PATH;
            if (file_exists($backend_prefix_path . '/themes/' . $template_name . '/' . $subtemplate_file . '.php'))
                include ($backend_prefix_path . '/themes/' . $template_name . '/' . $subtemplate_file . '.php');
            else
                $not_found = true;
        }
        else {
            $template_name = $CurrentWebSiteThemeName;
            if (file_exists(SCHLIX_SITE_PATH . '/themes/' . $template_name . '/' . $subtemplate_file . '.php'))
                include (SCHLIX_SITE_PATH . '/themes/' . $template_name . '/' . $subtemplate_file . '.php');
            else
            {
                if (file_exists(SCHLIX_SITE_PATH . '/themes/' . $template_name . '/' . $alternative_subtemplate_file . '.php'))
                    include (SCHLIX_SITE_PATH . '/themes/' . $template_name . '/' . $alternative_subtemplate_file . '.php');
                else
                    $not_found = true;
            }
        }
        if ($not_found)
            printf(___("Template file [%s] with subtemplate [%s] cannot be found. Please check your settings and try again."), $template_name, $subtemplate_file);
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Load subtemplate by current menu ID
     */
    public function loadSubTemplateByCurrentMenuID()
    {
        global $__forceOverrideSubTemplate;

        $menu = \App\Core_Menu::getCurrentMenuInformation();
        $subtemplate = array_key_exists('subtemplate', $menu) ? trim($menu['subtemplate']) : '';
        $subtemplate_mobile = array_key_exists('subtemplate_mobile', $menu) ? trim( (string) $menu['subtemplate_mobile']) : '';
        $subtemplate_inner_pages = array_key_exists('subtemplate_inner_pages', $menu) ?  trim((string) $menu['subtemplate_inner_pages']) : '';
        $alternative_subtemplate = '';
        if ($menu['inside_page'])
        {
            if (!empty($subtemplate_inner_pages))
            {
                $alternative_subtemplate =  $subtemplate;
                $subtemplate = $subtemplate_inner_pages;
                
            }
        }
        if ($__forceOverrideSubTemplate)
            $subtemplate = $subtemplate_mobile = $__forceOverrideSubTemplate;

        if (empty($subtemplate))
            $subtemplate = 'index';
        if (empty($subtemplate_mobile))
            $subtemplate_mobile = $subtemplate;
        
        $specific_subtemplate = $this->isMobile() ? $subtemplate_mobile : $subtemplate;
        $this->loadSubTemplateByName($specific_subtemplate,$alternative_subtemplate);
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Check current visitor's user agent and determine whether we should use the mobile or desktop template
     */
    public function determineWhetherToUseDesktopOrMobileTemplate()
    {
        $mobile_regex = "/(nokia|android|motorola|^mot\-|softbank|foma|docomo|kddi|up\.browser|up\.link|" .
                "htc|dopod|blazer|netfront|helio|hosin|huawei|novarra|CoolPad|webos|techfaith|palmsource|" .
                "blackberry|alcatel|amoi|ktouch|nexian|samsung|^sam\-|s[cg]h|^lge|ericsson|philips|sagem|wellcom|bunjalloo|maui|" .
                "symbian|smartphone|midp|wap|phone|windows ce|mobile|nexus|iemobile|^spice|^bird|^zte\-|longcos|pantech|gionee|^sie\-|portalmmm|" .
                "jig\s browser|hiptop|^ucweb|^benq|iphone|haier|^lct|opera\s*mobi|opera\*mini|320x320|240x320|176x220" .
                ")/i";
        // default/iphone/mobile
        if (!isset($_SESSION['template_type'])) {
            $is_mobile = isset($_SERVER['HTTP_X_WAP_PROFILE']) || isset($_SERVER['HTTP_PROFILE']) || preg_match($mobile_regex, strtolower($_SERVER['HTTP_USER_AGENT'])) &&
                    (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'ipad') === false);
            $_SESSION['template_type'] = ($is_mobile) ? 'mobile' : 'default';
        }
    }

    //_______________________________________________________________________________________________________________//
    public function Run($command)
    {
        $this->loadSubTemplateByCurrentMenuID();
    }

}
