<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php $filtered_app_name = fget_string_noquotes_notags('name'); ?>
<!-- end sidebar -->

<schlix-data-editor id="schlix-<?= $this->app_name ?>-admin" class="schlix-data-editor" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-main-app-description="<?= ___('Uninstall Theme').': '.$filtered_app_name ?>"  data-schlix-controller="SCHLIX.CMS.ThemesAdmin" data-model="<?= $this->getDataModelURL() ?>" data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">
    <!-- end sidebar -->
    <div class="content">
        <?php if (!isset($_POST['sure'])): ?>
            <form method="post" action="<?= $this->createFriendlyAdminURL("action=uninstall&name={$filtered_app_name}") ?>" autocomplete="off" >

                <label><input type="checkbox" name="sure" onclick="javascript:document.getElementById('ok_uninstall_button').disabled = !this.checked;" />
                    <?= ___('Are you sure you want to uninstall this theme?') ?></label><br/>
                <label><input type="checkbox" name="everything" /><?= ___('Delete everything in the directory?') ?></label><br/>
                <br/>
                <button id="ok_uninstall_button" disabled="true" type="submit" class="btn btn-success schlix-command-button" data-schlix-command="save-item" name="btn_save"><i class="fa fa-check"></i> <?= ___('OK'); ?></button>
                <button type="submit" class="btn btn-danger schlix-command-button" data-schlix-command="cancel-item" name="cancel_uninstall" value="1"><i class="fa fa-times"></i> <?= ___('Cancel'); ?></button>
            </form>
        <?php else: ?>
            <?php if ($uninstall_result === true): ?>
                <?php $main_link = $this->createFriendlyAdminURL('') ?>
                <p><?= ___('This theme has been uninstalled. Please <a href="'.$main_link.'">click here</a> to continue') ?></p>
            <?php else: ?>
                <p><?= ___('Uninstall failed') ?></p>
            <?php endif; ?>
        <?php endif; ?>

    </div>
</schlix-data-editor>
