<?php
/**
 * Core: ThemeManager - Main admin view template
 * 
 * Core - ThemeManager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php $app = $this->app_name; ?>
<div class="schlix-explorer">
    <schlix-data-explorer-list id="schlix-<?= alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias()) ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.ThemesAdmin" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>"  data-default-item-icon="fas fa-tv fa-2x">
        <schlix-datasource>
            <custom-command data-default="action=getallitems"  data-replace-with="action=getfrontendthemes" />
        </schlix-datasource>
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
                <x-ui:schlix-explorer-menu-command data-schlix-command="install" fonticon="fa fa-upload" label="<?= ___('Install a package') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>        

         
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                    <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="this.field_id" label="<?= ___('Default') ?>" hidden="false" sortable="false" formatter="SCHLIX.CMS.ThemesAdmin.formatDataTableCell_OptionBoxDesktopTemplate" />
                        <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="this.formatDataTableCell_DefaultTitleColumn" />



                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->

    </schlix-data-explorer-list>
    
    <!-- Backend -->
    <schlix-data-explorer-list id="schlix-backend<?= alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias()) ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.BackendThemesAdmin" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>"  data-default-item-icon="fas fa-tv fa-2x">

        <schlix-datasource>
            <custom-command data-default="action=getallitems"  data-replace-with="action=getbackendthemes" />
        </schlix-datasource>
        
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-heading-only="1" label="<?= ___('Admin Themes') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="reset-backend-theme"  fonticon="fa fa-undo" label="<?= ___('Reset to Default') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>
            
        </x-ui:schlix-explorer-toolbar>        
        
         
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                    <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="this.field_id" label="<?= ___('Default') ?>" hidden="false" sortable="false" formatter="SCHLIX.CMS.BackendThemesAdmin.formatDataTableCell_OptionBoxDesktopTemplate" />
                        <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="this.formatDataTableCell_DefaultTitleColumn" />



                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                                       </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->

    </schlix-data-explorer-list>    
</div>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Install Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-package-installer" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.ThemesAdmin" header-label="<?= ___('Install a package') ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=install" form-method="post">
    <!-- form -->
    <x-ui:csrf />
    <x-ui:alert type="warning">
        <p><?= ___('Please ensure that the application you are about to upload is from a trusted source') ?>.</p>
        <p><?= ___('SCHLIX is not responsible for any damage/security vulnerability/errors caused by 3rd party plugins') ?>.</p>
        <p><?= ___('Maximum file size') . ': ' . ' ' . round(get_real_max_upload_size() / (1024.0 * 1024.0), 2) . ' ' . ___('Mb') ?></p>
    </x-ui:alert>

    <x-ui:schlix-file-upload id="zipfileupload"  name="zipfileupload" accept=".zip" required="required" fonticon="far fa-folder-open" label="<?= ___('Select a ZIP file') ?>" />

    <x-ui:clearboth />
    <hr />
    <x-ui:textbox type="password" name="password" id="password" label="<?= ___('Please enter your password to authenticate this request') ?>" fonticon="fas fa-lock" />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog> 