<?php
namespace App;
/**
 * Core: Versioning - Main Class
 * 
 * Core - Versioning
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Versioning extends \SCHLIX\cmsApplication_List {

    private $header;
    private $guid;

    public function __construct() {
        parent::__construct('Versioning', 'gk_global_version_items');
        $this->hook_priority = 9900;
        $this->disable_frontend_runtime = true;
        $this->has_versioning = false;
    }

    //_______________________________________________________________________________________________________________//
    public function getItemArchiveByVersion($app_name, $guid, $version) {

        $version = sanitize_string(floatval($version));
        $app_name = sanitize_string($app_name);
        $guid = sanitize_string($guid);
        $itemdata = $this->table_items->selectOne('*', "(app_name = {$app_name}) AND (guid = {$guid}) AND (version = {$version})");
        if ($itemdata) {
            $unserialized_data = @unserialize($itemdata['content']);
            return $unserialized_data;
        } else
            return NULL;
    }

    //_______________________________________________________________________________________________________________//
    public function getItemArchiveMaxVersion($app_name, $guid) {
        $app_name = sanitize_string($app_name);
        $guid = sanitize_string($guid);
        $itemdata = $this->table_items->selectOne('MAX(version) as max_version', "(app_name = {$app_name}) AND (guid = {$guid})");
        return $itemdata['max_version'];
    }

    //_______________________________________________________________________________________________________________//

    public function getItemsByApplicationName($app_name) {
        $app_name = sanitize_string($app_name);
        return $this->table_items->selectAll('*', "(app_name = {$app_name})");
    }

/*
      //_______________________________________________________________________________________________________________//
      public function getAllItems($fields, $extra_criteria, $start, $end, $sortby, $sortdirection, $from_cache)
      {
      } */

    //_______________________________________________________________________________________________________________//
    /**
     * Saves data to versioning table
     * @param cmsApplication_List $data
     * @param array $data
     * @global Database $SystemDB
     * @global Users $CurrentUser
     *
     */
    public function save($app, array $data) {
        global $CurrentUser, $CurrentUser, $SystemDB;

        $WhichUser = ($CurrentUser == null) ? $CurrentUser : $CurrentUser;

        if ($app->hasVersioning()) {
            // only if it has guid and version
            if (array_key_exists('guid', $data) && array_key_exists('version', $data)) {
                $guid = sanitize_string($data['guid']);
                $created_by_id = sanitize_string($WhichUser->getCurrentUserID());
                $version = sanitize_string($data['version']);
                $app_name = sanitize_string($app->getApplicationName());
                $serialized_obj = @serialize($data);
                $current = sanitize_string(get_current_datetime());
                if ($serialized_obj) {
                    $sanitized_serialized_obj = sanitize_string($serialized_obj);
                    $sqltxt = "INSERT INTO {$this->table_items} (guid, version, app_name, date_created, created_by_id, content) VALUES ({$guid}, {$version}, {$app_name}, {$current}, {$created_by_id}, {$sanitized_serialized_obj})";
                    $SystemDB->query($sqltxt);
                    return true;
                }
            }
        }
        return false;
    }
    
    /**
     * Hook -after save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    public function hook_onAfterSaveItem($obj, $datavalues, $original_datavalues, $previous_item, $retval)
    {
        if ($obj->hasVersioning() && $obj->itemColumnExists('version') && !empty($previous_item['guid'])) {
            $archiving_result = $this->save($obj, $previous_item);
        }
    }

    /**
     * Hook - before save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     */
    
    public function hook_modifyDataValuesBeforeSaveItem($obj, $datavalues)
    {

        $field_id = $obj->getFieldID();
        $id = $datavalues[$field_id];
        
        if ($obj->hasVersioning())
        {
            if ($id == 'new')
            {          
                if ($obj->itemColumnExists('version'))
                    $datavalues['version'] = 1.0;
            } elseif ((int) $id > 0)
            {
                $existing_item_id = (int) $datavalues[$field_id];
                $previous_item = $obj->getItemByID($existing_item_id);
                
                if ($obj->itemColumnExists('version')) {
                    $datavalues['version'] = $previous_item['version'] + 0.1;
                }
            }
            
        }
        return $datavalues;
    }

    
    /**
     * Hook -after save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_category
     * @param array $retval
     */
    public function hook_onAfterSaveCategory($obj, $datavalues, $original_datavalues, $previous_category, $retval)
    {
        if ($obj->hasVersioning() && $obj->itemColumnExists('version') && !empty($previous_category['guid'])) {
            $archiving_result = $this->save($obj, $previous_category);
        }
    }

    /**
     * Hook - before save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     */
    
    public function hook_modifyDataValuesBeforeSaveCategory($obj, $datavalues)
    {
        $field_cid = $obj->getFieldCategoryID();

        $cid = $datavalues[$field_cid];
        
        if ($obj->hasVersioning())
        {
            if ($cid == 'new')
            {          
                if ($obj->hasVersioning() && $obj->categoryColumnExists('version'))
                $datavalues['version'] = 1.0;
            } elseif ((int) $cid > 0)
            {
                $existing_category_id = (int) $datavalues[$field_cid];
                $previous_category = $obj->getCategoryByID($existing_category_id);
                
                if ($obj->hasVersioning() && $obj->categoryColumnExists('version') && !empty($previous_category['guid'])) {
                    $datavalues['version'] = $previous_category['version'] + 0.1;
                }
            }
            
        }
        return $datavalues;
    }

}
