<?php 
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
$app_name =___h(trim($app_name));
$guid = ___h($guid);
?>
<?php $app = 'core.versioning'; ?>
<div class="schlix-explorer" id="versioning-section">
    <schlix-data-explorer-list id="schlix-versioning-admin" class="schlix-data-explorer-list" data-app="<?= $app ?>" data-schlix-controller="SCHLIX.CMS.VersioningAdmin" 
                               data-model="/admin/app/<?= $app ?>">
        <schlix-datasource>
            <custom-command data-default="action=getallitems"  data-replace-with="action=getitemversions&amp;appname=<?= $app_name ?>&amp;guid=<?= $guid ?>"></custom-command>
        </schlix-datasource>
        
        
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>
        </x-ui:schlix-explorer-toolbar>
        <!-- Begin Data Viewer -->
        <!-- Begin Data Viewer -->
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>

                <schlix-data-table schlix-id="datanav-datatable" schlix-field-item-tile="description" >
                    <schlix-data-table-columns>
                        <schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false"></schlix-data-table-column>
                        <schlix-data-table-column key="version" label="Version" formatter="text" sortable="true"></schlix-data-table-column>
                        <schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor( {disableBtns:false})"></schlix-data-table-column>
                        <schlix-data-table-column key="guid" label="GUID" formatter="text"></schlix-data-table-column>
                        <schlix-data-table-column key="id" label="Action" hidden="false" sortable="false" formatter="SCHLIX.CMS.VersioningAdmin.formatAction"></schlix-data-table-column>

                    </schlix-data-table-columns>
                </schlix-data-table>                
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination /> 
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->
    </schlix-data-explorer-list>
</div> 