<?php
namespace App;

/**
 * Gallery - Admin class
 * 
 * Gallery
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package gallery
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Gallery_Admin extends \SCHLIX\cmsAdmin_HierarchicalTree_List {

    /**
     *
     * @var Gallery
     */
    protected $app;
    
    /*
     * Array of default options for newly created item
     * @var array 
     */
    protected $default_item_options = array('display_pagetitle', 'display_item_summary_noread', 'display_item_created_by', 'display_item_date_created', 'display_item_date_modified');

    
    protected $valid_extensions = array('jpg','jpeg','png','gif');

    //_________________________________________________________________________//
    /**
     * Constructor
     */    
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'
        );
        parent::__construct($datatype, $methods);
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'pageview', 'status', 'featured', 'url_media_file','non_public');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'parent_id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'status');
    }


    /**
     * Returns relative dir to parent path
     * @param string $root_dir
     * @param string $original_path
     * @return string
     */
    private function getFileNameParentPath($root_dir, $original_path)
    {
        $root_len = strlen($root_dir);
        $relative_file_path = substr($original_path, $root_len, strlen($original_path) - $root_len);
        return $relative_file_path;
    }
    /**
     * Return category ID by full directory
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $full_dir
     * @return int
     */
    private function getCategoryIDByFullDirectory($full_dir)
    {
        global $SystemDB;
        
        $sanitized_parent_path = sanitize_string($full_dir);
        $sql = "SELECT {$this->field_category_id} FROM  {$this->table_categories} WHERE full_dir = {$sanitized_parent_path}";
        $parent = $SystemDB->getQueryResultSingleRow($sql);
        $parent_id = (int) $parent[$this->field_category_id];
        return $parent_id;
        
    }
    
    /**
     * Override search result
     * @param string $keyword
     * @param array $result
     * @return array
     */
    public function modifyAjaxSearchObjectsResult($keyword, $result)
    {
        $totalcount = count($result);
        for ($i = 0; $i < $totalcount; $i++) {
            $filename = isset($result[$i]['url_media_file']) ? $result[$i]['url_media_file'] : '';
            $category_id = isset($result[$i]['category_id']) ? $result[$i]['category_id'] : 0;
            if (str_starts_with($filename, 'https://') || str_starts_with($filename, 'http://')  )
            {
                $result[$i]['file_exists'] = true;                
            } else 
            {
                $result[$i]['file_exists'] = is_file( $this->app->getDataFileFullPath('image_small', $filename));
            }
            $result[$i]['url_image_small'] =  $this->app->getGalleryImage('image_small', $filename, $category_id, true);
            $result[$i]['url_image_medium'] = $this->app->getGalleryImage('image_medium', $filename, $category_id, true);
            $result[$i]['url_image_large'] =  $this->app->getGalleryImage('image_large', $filename, $category_id, true);
        }
        return $result;

    }

    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema) {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);

        $response_schema[] = array('key' => 'file_exists', 'parser' => 'string');
        $response_schema[] = array('key' => 'url_image_small', 'parser' => 'string');
        $response_schema[] = array('key' => 'url_image_medium', 'parser' => 'string');
        $response_schema[] = array('key' => 'url_image_large', 'parser' => 'string');

        return $response_schema;
    }
    
//_________________________________________________________________________//    	
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $parent_output = parent::ajaxGetItemsByCategoryID($id, $start, $end, $sortby, $sortdirection);
        $reply = json_decode($parent_output, true);
        $totalcount = count($reply['data']);
        for ($i = 0; $i < $totalcount; $i++) {
            $filename = isset($reply['data'][$i]['url_media_file']) ? $reply['data'][$i]['url_media_file'] : '';
            $category_id = isset($reply['data'][$i]['category_id']) ? $reply['data'][$i]['category_id'] : 0;
            if (str_starts_with($filename, 'https://') || str_starts_with($filename, 'http://')  )
            {
                $reply['data'][$i]['file_exists'] = true;                
            } else 
            {
                $reply['data'][$i]['file_exists'] = is_file( $this->app->getDataFileFullPath('image_small', $filename));
            }
            $reply['data'][$i]['url_image_small'] =  $this->app->getGalleryImage('image_small', $filename, $category_id, true);
            $reply['data'][$i]['url_image_medium'] = $this->app->getGalleryImage('image_medium', $filename, $category_id, true);
            $reply['data'][$i]['url_image_large'] =  $this->app->getGalleryImage('image_large', $filename, $category_id, true);
        }
        return json_encode($reply);
    }    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        //$datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_id], $datavalues['category_id']);
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTable ('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_id]);
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = isset($datavalues['features']) ? (int) $datavalues['featured'] : 0;
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }

        
        return $datavalues;
    }

     /**
     * Sync directory and files
     */
    public function ajxp_RefreshDB() {
        
        check_csrf_halt_on_error(true);

        $this->RecordLog('Refreshing database');
        $refresh_value = fpost_string('refresh');
        if ($refresh_value === 'normal' || $refresh_value === 'force')
        {
            $array_files = array();
            // 1 Check if there is anything added manually in the directory (E.g. FTP upload, etc)
            $data_folder_fullpath = $this->app->getDataDirectoryFullPath('image_original');
            $data_folder_abs_urlpath = $this->app->getDataDirectoryURLPath('image_original');
            $items = \SCHLIX\cmsDirectoryFilter::getRecursiveDirectoryIterator($data_folder_fullpath, \SCHLIX\cmsDirectoryFilter::FILTER_NONE, array('Thumbs.db', 'desktop.ini', 'README.txt'));
            if ($items) {


                foreach ($items as $item) {
                    $filename = $item->getFileName();
                    $original_path = $item->getPathName();
                    $relative_file_path = $this->getFileNameParentPath(SCHLIX_ROOT_PATH, $original_path);
                    $parent_dir = $this->getFileNameParentPath(remove_multiple_slashes($data_folder_fullpath), $item->getPath());
                    $int_parent_dir = (int) str_replace('/','', $parent_dir);
                    $existing_cat = $this->app->getCategoryByID($int_parent_dir);
                    // only process existing category
                    if ($int_parent_dir > 0 && $existing_cat)
                    {
                        
                        if (!$item->isLink() && $item->isFile() && $item->isReadable() && !str_starts_with($filename, '.'))
                        {
                            $the_file_url_media_file_to_original_dir = $this->getFileNameParentPath($data_folder_abs_urlpath, SCHLIX_SITE_HTTPBASE.$relative_file_path);
                            $array_files[] = 
                                array
                                (
                                  //'parent_dir' => $parent_dir,
                                  'filename' => $filename,
                                  'url_media_file' => $the_file_url_media_file_to_original_dir,
                                  //'original_path' => $original_path,
                                  'category_id' => $int_parent_dir,
                                  'size' => $item->getSize(),
                                  'date_modified' => date('Y-m-d H:i:s', $item->getMTime()),
                                );
                            
                        }
                    }
                }
            }

            // 2. Insert dirs if not exists to the database
            //$this->processOriginalDirListing($array_dirs);

            $regenerate = $this->processOriginalFileListing($array_files, $refresh_value);
            
            return ajax_reply(200, array('status' => 'OK', 'data' => $regenerate));
        } else
        {
            return ajax_reply(300,'Invalid command');
        }
    }

    
    /**
     * Process files not in the database
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $array_files
     */
    private  function processOriginalFileListing($array_files, $refresh_value)
    {
        global $SystemDB;
        //$files_recreate_thumbnails = array();
        $file_ids_recreate_thumbnails = array();
        foreach ($array_files as $file)
        {
            
            $url_media_file = sanitize_string($file['url_media_file']);
            $sql = "SELECT {$this->field_id}, category_id, filename, url_media_file, size, date_modified FROM {$this->table_items} WHERE url_media_file = {$url_media_file}";            
            $existing_row = $SystemDB->getQueryResultSingleRow($sql);
            if (in_array(strtolower(pathinfo($file['filename'], PATHINFO_EXTENSION)), $this->valid_extensions))
            {
                if ( !$existing_row )
                {
                    $file['guid'] = new_uuid_v4();
                    $file['date_created'] = $file['date_modified'];
                    
                    //$int_parent_dir = (int) str_replace('/','', $file['parent_dir']);
                    //$file['category_id'] = $int_parent_dir; // existing category, already created
                    $file['title'] = pathinfo($file['filename'], PATHINFO_FILENAME);
                    $file['options'] = @serialize($this->app->getDefaultItemMetaOptionKeys());
                    $file['permission_read'] = @serialize('everyone');
                    $file['virtual_filename'] = convert_into_sef_friendly_title($file['title']);
                    $file['filename'] = $file['filename'];
                    $file['status'] = 1;
                    $SystemDB->simpleInsertInto($this->table_items, $file);
                    $file_ids_recreate_thumbnails[] = array('id' => $SystemDB->getLastInsertID(), 'path' => $file['url_media_file']);
                    //$files_recreate_thumbnails[] = $file;
                } else
                {
                    if (!str_starts_with($file['url_media_file'], 'https://') && !str_starts_with($file['url_media_file'], 'http://'))
                    {
                        // recreate thumbnail if necessary
                        $small_image_exists  = file_exists($this->app->getDataFileFullPath('image_small', $file['url_media_file']));
                        $medium_image_exists = file_exists($this->app->getDataFileFullPath('image_medium', $file['url_media_file']));
                        $large_image_exists  = file_exists($this->app->getDataFileFullPath('image_large', $file['url_media_file']));
                        $all_images_exists = $small_image_exists && $medium_image_exists && $large_image_exists;

                        if  ( ($file['size'] != $existing_row['size'] || $file['date_modified'] != $existing_row['date_modified']) || !$all_images_exists || $refresh_value === 'force')
                        {
                           /* echo $existing_file['id'].' == '.$file['url_media_file'].' ';
                            echo "{$small_image_exists} {$medium_image_exists} {$large_image_exists}<br />";
                            echo  "({$file['size']} != {$existing_file['size']} || {$file['date_modified']} != {$existing_file['date_modified']}) || !{$all_images_exists})<br />";
                            echo "<hr />";*/

                            $file_ids_recreate_thumbnails[] = array('id' => $existing_row[$this->field_id], 'path' => $file['url_media_file']);
                            $sanitized_size = sanitize_string($file['size']);
                            $sanitized_date_modified = sanitize_string($file['date_modified']);
                            $file['filename'] = $file['filename'];
                            $sql = "UPDATE {$this->table_items} SET size = {$sanitized_size}, date_modified = {$sanitized_date_modified} WHERE {$this->field_id} = {$existing_row[$this->field_id]} ";
                            $SystemDB->query($sql);

                        }
                    }
                }
            }
            
        }
        $this->app->ensureDataDirectoryExists();
        return $file_ids_recreate_thumbnails;
    }        
    
    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {

        global $CurrentUser;

        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id], $datavalues[$this->field_category_parent_id]);
        if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = isset($datavalues['permission_read']) ? serialize($datavalues['permission_read']) : null;
        $datavalues['permission_write'] = isset($datavalues['permission_write']) ? serialize($datavalues['permission_write']) : null;
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        $this->app->ensureDataDirectoryExists();
        return $datavalues;
    }


    //_________________________________________________________________________//
    public function ajaxMoveObjects($mixed_items_to_move, $destination)
    { // mixed item = categories + items
        //case 1: move file, case 2: move folder, case 3: move mixed files and folders
        //http://schlixcms/admin/index.php?page=html&ajax=1&action=ajax_move&item=c3&destination=c5
        global $SystemDB;

        check_csrf_halt_on_error(true);
        // Find parents of the destinations first to avoid relaps
        $pos = strrpos($destination, "_");
        $destination_catnumber = substr($destination, $pos + 1, strlen($destination) - $pos);
        $parent_id_array = $this->getParentIDs($destination_catnumber);
        $source_catnumbers = null;
        // Now process the source

        if ($destination[0] == 'i') {
            return ajax_reply(400, ___('Incorrect user operation - an item cannot be set as a destination for move operation'));
        }
        elseif (strpos($mixed_items_to_move, 'folder') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_catnumber = substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            if ($source_catnumber == $destination_catnumber) {
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to the same folder'));
            }
            else

            if (array_search($source_catnumber, $parent_id_array, TRUE) !== false) // April 1, 2010
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
            else
                //$sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where cid = '{$source_catnumber}'";
            {
                $SystemDB->query("UPDATE {$this->table_categories} SET parent_id = :destination_cid where cid = :source_cid", ['destination_cid' => $destination_catnumber, 'source_cid' => $source_catnumber]);
                if (method_exists($this, 'forceRefreshMenuLinks'))
                    $this->forceRefreshMenuLinks();
                
                return ajax_reply(200, 'OK');
            }
        }
        else if (strpos($mixed_items_to_move, 'article') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_itemnumber = substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            //$sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}' where id = '{$source_itemnumber}'";
            $SystemDB->query("UPDATE  {$this->table_items} SET category_id = :destination_cid where id = :source_id",  ['destination_cid' => $destination_catnumber, 'source_id' => $source_catnumber]);
        }
        else {
            // mixed stuff
            $mixed_items_array = explode(',', $mixed_items_to_move);
            foreach ($mixed_items_array as $mixed_item)
            {
                $current_id = substr($mixed_item, 1); // 11 is the next string after
                if (strpos($mixed_item, 'c') > -1) {
                    $source_catnumbers[] = (int) $current_id;
                }
                else { // else if it's an item instead
                    $source_itemnumbers[] = (int) $current_id;
                }
            } // end foreach
            // verify if there's a conflict
            $error = false;
            if ($source_catnumbers)
                foreach ($source_catnumbers as $source_catnumber)
                    if (in_array($source_catnumber, $parent_id_array) || $source_catnumber == $destination_catnumber)
                        $error = true;
            // now update parent_id
            $dest_cat_info = $this->app->getCategoryByID($destination_catnumber);
            if (!$error) {
                if ( is_array($dest_cat_info) || $destination_catnumber == 0)
                {
                    $dest_cat_full_dir = $destination_catnumber == 0 ? '0' : $dest_cat_info[$this->app->getFieldCategoryID()];
                    $sanitized_dest_cat_full_dir = sanitize_string($dest_cat_info[$this->app->getFieldCategoryID()]);
                    if ($source_catnumbers) {
                        $source_catstrs = implode(",", $source_catnumbers);
                        $sql = "SELECT * FROM {$this->table_categories} WHERE {$this->field_category_id} IN ({$source_catstrs})"; 
                        $SystemDB->query( "UPDATE {$this->table_categories} SET parent_id = :destination_cid where {$this->field_category_id} in  ({$source_catstrs})", ['destination_cid' => $destination_catnumber, 'dest_cat_full_dir' => $dest_cat_info['full_dir']]);
                    }
                    // Fix - Dec 6, 2011 - forgot to add if
                    if ($source_itemnumbers) {
                        $source_itemstrs = implode(",", $source_itemnumbers);
                        $sql = "SELECT * FROM {$this->table_items} WHERE {$this->field_id} IN ({$source_itemstrs})";
                        $items_to_move = $SystemDB->getQueryResultArray($sql);
                        if ($items_to_move)
                        {
                            foreach ($items_to_move as $item)
                            {
                                // move it to dest
                                if (!str_starts_with($item['url_media_file'], 'https://') && !str_starts_with($item['url_media_file'], 'http://'))
                                {
                                    rename ($this->app->getDataFileFullPath('image_original', $item['url_media_file']),  $this->app->getDataFileFullPath('image_original', $destination_catnumber.'/'.$item['filename']));
                                    rename ($this->app->getDataFileFullPath('image_large', $item['url_media_file']),  $this->app->getDataFileFullPath('image_large', $destination_catnumber.'/'.$item['filename']));
                                    rename ($this->app->getDataFileFullPath('image_medium', $item['url_media_file']),  $this->app->getDataFileFullPath('image_medium', $destination_catnumber.'/'.$item['filename']));
                                    rename ($this->app->getDataFileFullPath('image_small', $item['url_media_file']),  $this->app->getDataFileFullPath('image_small', $destination_catnumber.'/'.$item['filename']));
                                }
                                
                            }
                        }
                        
                        
                       //$sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}', parent_dir = {$sanitized_dest_cat_full_dir}, url_media_file = CONCAT( {$sanitized_dest_cat_full_dir},'/',filename) where id in  ({$source_itemstrs})";
                        $SystemDB->query("UPDATE  {$this->table_items} SET category_id = :destination_cid, url_media_file = CONCAT('/', :dest_cat_full_dir,'/',filename) where id in  ({$source_itemstrs}) AND (url_media_file NOT LIKE 'https://%') AND (url_media_file NOT LIKE 'http://%')", ['destination_cid' => $destination_catnumber, 'dest_cat_full_dir' => $destination_catnumber]);
                        $SystemDB->query("UPDATE  {$this->table_items} SET category_id = :destination_cid where id in  ({$source_itemstrs}) AND ((url_media_file LIKE 'https://%') OR (url_media_file LIKE 'http://%'))", ['destination_cid' => $destination_catnumber, 'dest_cat_full_dir' => $destination_catnumber]);
                    }
                    if (method_exists($this, 'forceRefreshMenuLinks'))
                        $this->forceRefreshMenuLinks();

                    return ajax_reply(200, 'OK');
                } else
                    return ajax_reply(400, ___('Cannot find destination folder'));
            }
            else
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
        } // end mixed stuff
    }    
    /**
     * Create thumbnail by ID
     * @param int $id
     * @return array
     */
    public function ajxp_RecreateThumbnail()
    {
        global $SystemDB;
                        
        $id = fpost_int('id');
        check_csrf_halt_on_error(true);
        $item = $this->app->getItemByID($id);
        if ($item)
        {
            $this->app->createMultipleImageSizesForOriginalImage($item['url_media_file'], $item['category_id']);
            $img_original = $this->app->getDataFileFullPath('image_original', $item['url_media_file']);
            $ext = strtolower(pathinfo($img_original, PATHINFO_EXTENSION));
            if (function_exists('exif_read_data'))
            {
                if (($ext == 'jpg' || $ext == 'jpeg'))
                {
                    $exif_arr_data = @exif_read_data($img_original);
                    //suppress error, e.g.  Process tag(x2001=PreviewImag): Illegal components(0)
                    $datavalues['exif_data'] = $exif_arr_data ? @serialize($exif_arr_data) : '';
                    $SystemDB->simpleUpdate($this->table_items, $datavalues, $this->field_id, $id);
                } else
                {
                    $datavalues['exif_data'] = '';
                    $SystemDB->simpleUpdate($this->table_items, $datavalues, $this->field_id, $id);
                }
            }
            return ajax_reply(200,"OK");
        } else
            ajax_reply(404,'Item not found');
    }
    

    //_________________________________________________________________________//
    public function ajxp_Upload()
    {
        check_csrf_halt_on_error();
        $this->app->ensureDataDirectoryExists();        
        $cid = $this->getCurrentCategoryIDFromCookie();
        $category=  $this->app->getCategoryByID($cid);
        $cid_prefix = $category ? $cid : '0';
        $placeholder =  $this->app->getDataFileFullPath('image_original', strval($cid_prefix)) ;        
        if (!is_dir($placeholder))
        {
            return ajax_reply(300, "Folder does not exist ".$placeholder);
        } else 
        {
            $multiplefile_names = $_FILES['filedata']['name'];
            $tmp_files = $_FILES['filedata']['tmp_name'];
            $total_number_of_files = ___c($multiplefile_names);
            for ($i = 0; $i < $total_number_of_files; $i++)
            {
                
                $new_filename = convert_to_safe_filename($multiplefile_names[$i]);
                $valid_image = is_valid_uploaded_image_file($tmp_files[$i], $new_filename);
                if ($valid_image)
                    move_uploaded_file($tmp_files[$i], $placeholder .'/'.$new_filename);
                
            }
            return ajax_reply(200, 'Upload OK');
            
        } 
    }
    
        
    //_________________________________________________________________________//
    public function Uninstall() {
        return false;
    }

}
