<?php
namespace App;
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class Html_Admin extends \SCHLIX\cmsAdmin_HierarchicalTree_List {

    /**
     *
     * @var Html 
     */
    protected $app;

    //_________________________________________________________________________//
    /**
     * Constructor
     */
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'
        );
        parent::__construct($datatype, $methods);
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'pageview', 'status', 'featured');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'parent_id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'status');
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename',  $datavalues['virtual_filename'],$datavalues[$this->field_id], $datavalues[$this->field_item_category_id] );
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = isset($datavalues['featured']) ? (int) $datavalues['featured'] : 0;
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
/* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])        
        if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); 
*/
        
        return $datavalues;
    }

    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        global $CurrentUser;
        

        $external_images_save_path = '/media/images/clippings/';        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id], $datavalues[$this->field_category_parent_id]);
        //if ($datavalues['permission_read_everyone'])
            //$datavalues['permission_read'] = 'everyone';
        //$datavalues['permission_read'] = serialize($datavalues['permission_read']);
        //$datavalues['permission_write'] = serialize($datavalues['permission_write']);
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        return $datavalues;        
    } 
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        // adda preview link
        $response_schema[] = array ('key' => 'preview_link', 'parser' =>'string');
        return $response_schema;
    }

    //_________________________________________________________________________//
    /**
     * Deprecated. Display item options. options is a serialized array
     * Replaced with: \INPUT::CMSObjectOptions('options', $this->app->getItemMetaOptionKeys(), $item['options'], $this->app->getDefaultItemMetaOptionKeys(), 1, 3);
     * @deprecated since version 2.0.3
     * @param string $options
     */
    public function displayItemOptions($options) 
    {
        $display_options = empty($options) ? $this->default_item_options : unserialize($options);
        echo \INPUT::CHECKBOX_GROUP('options', $this->app->getItemMetaOptions(), $display_options, ___('Display Options'));
    }

    //_________________________________________________________________________//
    /**
     * Deprecated. Display category options
     * Replaced with: \INPUT::CMSObjectOptions('options', $this->app->getCategoryMetaOptionKeys(), $category['options'], $this->app->getDefaultCategoryMetaOptionKeys(), 1, 3);
     * in your edit.category.template.php
     * @deprecated since version 2.0.3
     * @param string $options
     */
    public function displayCategoryOptions($options) {
        $display_options = empty($options) ? $this->default_category_options : unserialize($options);
        $category_meta_options = $this->app->getCategoryMetaOptions();
        foreach ($category_meta_options as $option)
            if (!array_key_exists('options', $option))
                $checkbox_options[] = $option;
            else
                $drop_down_options[] = $option;
        echo \INPUT::CHECKBOX_GROUP('options', $checkbox_options, $display_options, 'Display Options');
        echo \__HTML::BR();
        echo \__HTML::FIELDSET_start();
        echo \__HTML::LEGEND('Default Sort Options');
        foreach ($drop_down_options as $drop_down_option) {
    
        $dropdown = \INPUT::SELECT("options[{$drop_down_option['value']}]", $drop_down_option['options'], $display_options[$drop_down_option['value']], array('class' => ''));
        echo \__HTML::LABEL($drop_down_option['label'], $dropdown).\__HTML::BR();

            
            
         //   echo LABEL($drop_down_option['label'], INPUT_DROPDOWN("options[{$drop_down_option['value']}]", $drop_down_option['options'], $display_options[$drop_down_option['value']]));
//            echo BR();
        }
        echo \__HTML::FIELDSET_end();
    }
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getitemsresponseschema' :
                return $this->getItemsResponseSchema();
                break; 
            
            default:return parent::Run();
        }
    }

    
    //_________________________________________________________________________//
    public function Uninstall() {
        return false;
    }

}
