<?php
namespace App;

/**
 * Brochure Pages - Admin class
 * 
 * 
 *
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0

 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Landing_Admin extends \SCHLIX\cmsAdmin_CategorizedList {

    //_________________________________________________________________________//
    public function __construct() {
        $datatype = 'basicsimplecategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'
        );
        parent::__construct($datatype, $methods);
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'pageview', 'status', 'featured');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'parent_id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'status');
    }

    /**
     * Generate parent URL's path
     * @param array $item
     * @return string
     */
    public function getItemParentURLPathPreviewLink($item)
    {
        $field_category_id = $this->app->getFieldCategoryID();

        $parent_category_text = ($item['category_id'] > 0) ? $this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$item['category_id']}") : SCHLIX_SITE_HTTPBASE.'/'.  get_application_alias($this->app_name).'/';
        return $parent_category_text.'#';
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_id], $datavalues['category_id']);
        
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = isset($datavalues['featured']) ? intval($datavalues['featured']) : 0;
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }

        
        return $datavalues;
    }

    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        global $CurrentUser;

        $external_images_save_path = '/media/images/clippings/';        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id]);
        
        /*if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']);*/
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        return $datavalues;        
    } 
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        // adda preview link
        $response_schema[] = array ('key' => 'preview_link', 'parser' =>'string');
        return $response_schema;
    }
            
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getitemsresponseschema' :
                return $this->getItemsResponseSchema();
                break; 
            default:return parent::Run();
        }
    }

    //_________________________________________________________________________//
    public function Uninstall() {
        return false;
    }

}

?>