<?php
namespace App;

/**
 * Personal Data Request - Admin class
 * 
 * Plugin for compliance with GDPR
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package personaldatarequest
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class PersonalDataRequest_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */    
    public function __construct() {
        global $SystemDB;
        
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here        
        $this->setItemFieldNamesForAjaxListing('id', 'email_address','user_id','guid','request_ip_address','request_user_agent','confirmed_ip_address','date_created','date_modified','date_expiry','status','request_type', 'reason');
        $this->search_field = 'email_address';
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = intval($datavalues['featured']);

        
        return $datavalues;
    }
    
}