/**
 * Personal Data Request - Javascript admin controller class
 * 
 * Plugin for compliance with GDPR 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.GDPRAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("personaldatarequest");
    };


    ///////////////////////////////////////////////////////////

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {

                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                theID = app_name + '-select-id' + oRecord.getData("id");
                theValue = 'i' + oRecord.getData("id");
                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';

    };
    
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_Status (elCell, oRecord, oColumn, oData) {

         var txt = "";
         switch (oData)
         {             
             case -2: txt = "No Data";break;
             case 0: txt = "Pending user confirmation";break;
             case 1: txt = "Confirmed";break;              
         }
         elCell.innerHTML = txt;
         
    };
    
    static formatDataTableCell_RequestType (elCell, oRecord, oColumn, oData) {

         var txt = "";
         switch (oData)
         {             
             case 1: txt = "Data Request";break;
             case 2: txt = "Removal";break;
         }
         elCell.innerHTML = txt;
    };    
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};

