<?php
/**
 * Search
 *
 * @copyright SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * 
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    https://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$enabled_apps_array = $this->app->getConfig('array_enabled_apps');
?>
<?php $app = $this->app_name; ?>

<x-ui:schlix-data-explorer-blank id="schlix-<?= $this->app->getApplicationNameOnly() ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.SearchAdmin" data-main-app-description="<?= $this->app->getApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>">

    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

    </x-ui:schlix-explorer-toolbar>
    <div class="content">

        <p><?= ___('Global search is enabled for the following applications') ?>:</p>
        <ul>
            <?php foreach ($enabled_apps_array as $enabled_app): ?>
                <li><?= ___h($enabled_app) ?></li>
            <?php endforeach ?>
        </ul>
        <p><?= ___('You can change which applications are accessible by clicking the Configuration toolbar button') ?>.</p>
    </div>

    <!-- End Data Viewer -->

</x-ui:schlix-data-explorer-blank>

