<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;

class simpleSitemap extends \SCHLIX\cmsApplication_Basic {

    public function __construct()
    {
        parent::__construct('Sitemap');

        $system_cron = new cronScheduler();
        $system_cron->createDefaultSchedulerForMyApplicationStaticMethod('Regenerate schema.org sitemap', '\\App\\simpleSitemap::processRunRegenerateSitemap', "0 0 * * *");
        $this->disable_frontend_runtime = true;
    }

    //_______________________________________________________________________________________________________________//
    public function getURLs()
    {
        global $SystemConfig;
        global $CurrentFrontendApplication;

        $default_permission_read_everyone = serialize('everyone');
        $default_app_array = array('html', 'blog');
        $enabled_apps_array = $SystemConfig->get($this->app_name, 'array_enabled_apps');
        if (___c($enabled_apps_array) == 0 || !is_array($enabled_apps_array))
            $enabled_apps_array = $default_app_array;
        $forbidden_listing = array('.', '..', '.svn', '.cvs', '.git', '__MACOSX');

        $item_array = get_list_of_all_apps(true, 5);
        $urls = [];
        $url_list = [];
        if (is_array($item_array) && (count($item_array) > 0))
        {
            foreach ($item_array as $appname)
            {
                if (in_array($appname, $enabled_apps_array) && $appname != SCHLIX_DEFAULT_USER_CLASS)
                {
                    $alias = get_application_alias($appname);
                    $latest_date_modified = NULL;
                    $fullclassname = '\\App\\' . $appname;
                    $temp_app = new $fullclassname;
                    if (!$temp_app->isFrontendRuntimeDisabled())
                    {
                        if (method_exists($temp_app, 'getAllItems'))
                        {
                            $field_i = (method_exists($temp_app, 'getCategoryFieldName')) ? $temp_app->getItemFieldID() : $field_c = 'id';
                            $all_items = $temp_app->getAllItems('*', 'status > 0', 0, 0, $field_i, 'ASC');
                            foreach ($all_items as $the_item)
                            {
                                $lastmod = $the_item['date_modified'];
                                $created = $the_item['date_created'];
                                if ($lastmod == NULL || $lastmod == NULL_DATE)
                                    $lastmod = $created;
                                $stime = strtotime($lastmod);
                                if ($stime > $latest_date_modified)
                                    $latest_date_modified = $stime;
                                $date_last_modified = ($lastmod != '' && $stime !== false) ? date("Y-m-d", strtotime($lastmod)) : date("Y-m-d");
                                $can_read = (array_key_exists('permission_read', $the_item)) ? ($the_item['permission_read'] === $default_permission_read_everyone || empty($the_item['permission_read'])) : true;

                                $exclude_from_sitemap = false;
                                if (array_key_exists('options', $the_item))
                                {
                                    $options = $this->translateMetaOptions($the_item['options']);
                                    $exclude_from_sitemap = isset($options['exclude_from_sitemap']);
                                }
                                if ($can_read && !$exclude_from_sitemap)
                                {
                                    /* workaround */
                                    if (!($appname == 'html' && ( (int) $the_item['id'] == 1)))
                                    /* end workaround */
                                    $url_list[] = array('url' => $temp_app->createFriendlyURL("action=viewitem&id={$the_item['id']}"),
                                        'date_modified' => $date_last_modified, 'type' => 'item');
                                }
                            }
                        }
                        if (method_exists($temp_app, 'getAllCategories'))
                        {

                            $field_c = (method_exists($temp_app, 'getCategoryFieldName')) ? $temp_app->getCategoryFieldName() : $field_c = 'cid';

                            $all_cats = $temp_app->getAllCategories('*', 'status > 0', 0, 0, 'cid', $field_c, 'ASC');
                            foreach ($all_cats as $the_cat)
                            {
                                $cid = $the_cat["cid"];
                                $lastmod =  isset($the_cat['date_modified']) ? $the_cat['date_modified'] : null;
                                $stime = strtotime($lastmod);
                                if ($stime > $latest_date_modified)
                                    $latest_date_modified = $stime;
                                $date_last_modified = ($lastmod != '' && $stime !== false) ? date("Y-m-d", $stime) : $date_last_modified = date("Y-m-d");
                                $can_read = (array_key_exists('permission_read', $the_cat)) ? ($the_cat['permission_read'] === $default_permission_read_everyone || empty($the_cat['permission_read'])) : true;
                                $latest_items = $temp_app->getItemsByCategoryID($cid, 'date_created', 'status > 0', 0, 1, 'date_created', 'DESC');
                                if ($latest_items)
                                {
                                    $date_last_modified = date('Y-m-d', strtotime($latest_items[0]['date_created']));
                                }
                                if ($can_read)
                                {
                                    $url_list[] = array('url' => $temp_app->createFriendlyURL("action=viewcategory&cid={$cid}"),
                                        'date_modified' => $date_last_modified, 'type' => 'category');
                                }
                            }
                        }
                        if ($appname != $CurrentFrontendApplication)
                            $url_list[] = array('url' => $temp_app->createFriendlyURL(""), 'date_modified' => date("Y-m-d", $latest_date_modified), 'type' => 'main');
                    }
                }
            }
            return $url_list;
        } else
            return null;
    }

    private function getAllMenuInfo()
    {
        $menus = new \App\Core_Menu();
        $all_menu_items = $menus->getAllItems('*', 'status > 0');
        return array_column($all_menu_items, 'sefurl');
    }

    protected function getFrequency($lastmod)
    {
        if ($lastmod == '-0001-11-30')
            return 'yearly';
        $date_difference = days_difference($lastmod, get_current_datetime());
        $freq = 'archive';
        if ($date_difference <= 7)
        {
            $freq = 'daily';
        }
        if ($date_difference > 7)
        {
            $freq = "monthly";
        }
        if ($date_difference > 30)
        {
            $freq = "monthly";
        }/*
          if ($date_difference > 365)
          {
          $freq = "yearly";
          } */
        return $freq;
    }

    /**
     * Get the sitemap XML
     * @return string
     */
    public function getSitemapXML()
    {
        $menu_array = $this->getAllMenuInfo();
        $urls = $this->getURLs();
        $output = '<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        $output .= "\n";
        $url = "";
        $lastmod = date('Y-m-d');
        $freq = "daily";
        $priority = "0.5";
        $i = 0;
        // add first url
        /*$url = SCHLIX_SITE_URL.SCHLIX_SITE_HTTPBASE;
        $freq = 'daily';
        $priority = '1.0';
        $output.= "<url>\n <loc>{$url}</loc>\n <lastmod>{$lastmod}</lastmod>\n <changefreq>{$freq}</changefreq>\n <priority>{$priority}</priority>\n</url>\n";
        */

        foreach ($urls as $urlinfo)
        {
            if ($urlinfo['type'] == 'category')
            {
                $priority = (in_array($urlinfo['url'], $menu_array)) ? "0.9" : "0.6";
                $freq = $this->getFrequency($urlinfo['date_modified']);
            } else if ($urlinfo['type'] == 'item')
            {
                $priority = (in_array($urlinfo['url'], $menu_array)) ? "0.8" : "0.5";
                $freq = $this->getFrequency($urlinfo['date_modified']);
            } else // if main
            {
                $priority = (in_array($urlinfo['url'], $menu_array)) ? "1.0" : "0.5";
                $freq = "daily";
            }

            $url = SCHLIX_SITE_URL . $urlinfo['url'];
            $lastmod = $urlinfo['date_modified'];
            if ($lastmod == '-0001-11-30')
                $lastmod = date('Y-m-d');
            $link = "<url>\n <loc>{$url}</loc>\n <lastmod>{$lastmod}</lastmod>\n <changefreq>{$freq}</changefreq>\n <priority>{$priority}</priority>\n</url>\n";
            $output .= $link;
            $i++;
        }
        $output .= '</urlset>';

        return $output;
    }

    public function getCachedSitemapXMLURL()
    {
        return SCHLIX_SITE_HTTP_URL . CURRENT_SUBSITE_URL_PATH . '/cache/sitemap.xml';
    }

    public function saveSitemapXMLToCache()
    {
        $filename = SCHLIX_SITE_PATH . '/cache/sitemap.xml';
        $output = $this->getSitemapXML();
        if (is_writable(SCHLIX_SITE_PATH . '/cache/'))
        {
            return file_put_contents($filename, $output);
        }
        return false;
    }

    //_______________________________________________________________________________________________________________//
    public static function processRunRegenerateSitemap()
    {
        $sitemapgen = new simpleSitemap();
        $sitemap_file = SCHLIX_SITE_URL . SCHLIX_SITE_HTTPBASE . '/cache/sitemap.xml';
        if ($sitemapgen->saveSitemapXMLToCache())
        {
            echo "Sitemap: {$sitemap_file} generated";
        } else
        {
            echo "Sitemap: failed to save {$sitemap_file}";
        }
    }

    public function createSitemapIfNotExist()
    {
        if (!file_exists(SCHLIX_SITE_PATH . '/cache/sitemap.xml'))
            $this->saveSitemapXMLToCache();
    }

//_______________________________________________________________________________________________________________//
    public function viewMainPage()
    {
        $urls = $this->getURLs();
        $current_method = __FUNCTION__;
        $this->loadTemplateFile('view.main', array('urls' => $urls, 'current_method' => $current_method));
        $this->processRunRegenerateSitemap();
    }

//_______________________________________________________________________________________________________________//

    public function Run($command)
    {
        return false;
    }

}
