<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php

global $HTMLHeader;
$can_login_with_email = $this->getConfig('bool_allow_login_by_email');

$invalid_retries_before_captcha = $this->getConfig('int_number_of_login_retry_before_captcha', 20);
$enable_captcha_for_user_login = $this->getConfig('bool_enable_captcha_user_login');
$show_captcha = $enable_captcha_for_user_login || rate_limit_exceeded('invalid_password_retry', $invalid_retries_before_captcha, 3600);
?>


    <h1 class="title"><i class="fa fa-user"></i> <?= ___('My Account') ?></h1>
    <hr />
    <x-ui:row>
        <!-- col -->
        <x-ui:column sm="6" md="4">
            <x-ui:panel type="panel-default">
                <x-ui:panel-body>
                    <div id="schlix-users-login-form">
                    <x-ui:row>
                        <x-ui:column sm="12">
                        <x-ui:form-simple-ajax name="loginform"  method="post" data-action="<?= $this->createFriendlyURL("action=userlogin"); ?>" enctype="multipart/form-data" >
                            <x-ui:hidden name="login" id="login" value="login" />
                            <x-ui:csrf />
                            
                            <x-ui:form-group>
                                <x-ui:textbox name="username" id="username" autofocus="autofocus" required="required" fonticon="fa fa-user" placeholder="<?= ___('Username') ?> <?=  $can_login_with_email ? '/' . ___('E-mail') : '' ?>" />
                            </x-ui:form-group>
                            <x-ui:form-group>
                                <x-ui:password name="password" id="password" required="required" fonticon="fa fa-lock" placeholder="<?= ___('Password') ?>" />
                            </x-ui:form-group>
                            
                            
                            <x-ui:checkbox id="chkremember" name="remember" value="1" label="<?= ___('Remember Me'); ?>" />
                            
                            
                            <?php if ($show_captcha): ?>
                            <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" value="" />
                            <?php endif; ?>
                    
                            <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-sign-in" value="Submit" label="<?= ___('Sign in') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />
                        </x-ui:form-simple-ajax>
                        </x-ui:column>
                    </x-ui:row>
                    </div>

                </x-ui:panel-body>
                <x-ui:panel-footer>
                    <a href="<?= $this->createFriendlyURL("action=forgotpassword"); ?>"><i class="fa fa-unlock-alt"></i> <?= ___('Forgot password?'); ?></a>
                    <?php if ($this->getConfig('bool_enable_registration')): ?>                        
                    <br />
                    <a href="<?= $this->createFriendlyURL("action=register"); ?>"><i class="fa fa-user-plus"></i> <?= ___('Sign up'); ?></a>
                    <?php endif; ?>

                </x-ui:panel-footer>
            </x-ui:panel>
        </x-ui:column>
        <!-- col -->
        
        <x-ui:column sm="6" md="8">
        <div class="schlix-ajax-output"></div>
        <?php if (isset($error_list) && ___c($error_list) > 0 ): ?>
            <x-ui:alert type="error" var="error_list" fonticon="fa fa-times" />
        <?php endif; ?>            
        <?php if (isset($success_list) && ___c($success_list) > 0 ): ?>
            <x-ui:alert type="info" var="success_list" fonticon="fa fa-check" />
        <?php endif; ?>            
                
            <x-ui:echo-safe-config-value key="str_login_welcome_text" />
            
        </x-ui:column>
    </x-ui:row>


