<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Block;

class LoginBox extends \SCHLIX\cmsBlock {

    public function Run() {
        global $SystemConfig, $CurrentUser;

        $force_ssl = $SystemConfig->get(SCHLIX_DEFAULT_USER_CLASS, 'bool_force_ssl_authentication');
        $login_url = $CurrentUser->createFriendlyURL("action=login");
        if ($force_ssl)
            $login_url = force_https_url() . $login_url;

        if ($CurrentUser->authenticated() == false) {
            $redirect_to_url = filter_var($_SERVER['REQUEST_URI'], FILTER_SANITIZE_URL);
            $CurrentUser->setLoginRedirectURL($redirect_to_url);
        }
        
        $CurrentUser->loadDefaultStaticAssetFiles();

        $create_account_link = ($CurrentUser->getConfig("bool_enable_registration") > 0) ? $CurrentUser->createFriendlyURL("action=register") : "";
        $this->loadTemplateFile('loginbox', compact(array_keys(get_defined_vars())));
    }

}

?>