<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Block;

class Menus_Default_CSS_Classes
{
    public $ul_1_class;
    public $ul_2_class;
    
    public $li_1_regular_class;
    public $li_1_dropdown_class; 
    
    public $li_2_regular_class;
    public $li_2_dropdown_class; 
    
    public $a_1_regular_class;
    public $a_1_dropdown_class;
    
    public $a_2_regular_class;
    public $a_2_dropdown_class;

    public $dropdown_toggle_class;
    
    public $divider_class;
    
    /**
     * 
     * @param string $ul_1_class
     * @param string $ul_2_class
     * @param string $li_1_regular_class
     * @param string $li_1_dropdown_class
     * @param string $li_2_regular_class
     * @param string $li_2_dropdown_class
     * @param string $a_1_regular_class
     * @param string $a_1_dropdown_class
     * @param string $a_2_regular_class
     * @param string $a_2_dropdown_class
     * @param string $dropdown_toggle_class
     * @param string $divider_class
     */
    public function __construct($ul_1_class, $ul_2_class, $li_1_regular_class, $li_1_dropdown_class, $li_2_regular_class, $li_2_dropdown_class, $a_1_regular_class, $a_1_dropdown_class,     $a_2_regular_class, $a_2_dropdown_class, $dropdown_toggle_class, $divider_class) 
    {
        $this->ul_1_class = $ul_1_class;
        $this->ul_2_class = $ul_2_class;

        $this->li_1_regular_class = $li_1_regular_class;
        $this->li_1_dropdown_class = $li_1_dropdown_class;

        $this->li_2_regular_class = $li_2_regular_class;
        $this->li_2_dropdown_class =  $li_2_dropdown_class;

        $this->a_1_regular_class = $a_1_regular_class;
        $this->a_1_dropdown_class = $a_1_dropdown_class;

        $this->a_2_regular_class = $a_2_regular_class;
        $this->a_2_dropdown_class = $a_2_dropdown_class;

        $this->dropdown_toggle_class = $dropdown_toggle_class; 
        $this->divider_class = $divider_class;
    }
}

class Menus extends \SCHLIX\cmsBlock {

    protected $element_li = 'li';
    protected $element_ul = 'ul';
    
    protected $element_divider = 'li';
    protected $li_submenu_icon = '';
    
    protected $ul_1_class = '';
    protected $ul_2_class = '';    

    /**
     * CSS class for LI (list item) with no parent (root menu) without submenu
     * @var string
     */
    protected $li_1_regular_class = '';
    /**
     * CSS class for LI (list item) with no parent (root menu) with dropdown (child) item
     * @var string
     */
    protected $li_1_dropdown_class = ''; 
    
    /**
     * CSS class for LI (list item) with parent (child item) without submenu
     * @var string
     */
    protected $li_2_regular_class = '';
    /**
     * CSS class for LI (list item) with no parent (root menu) with dropdown (child) item
     * @var string
     */    
    protected $li_2_dropdown_class = ''; 
    
    protected $a_1_regular_class = '';
    protected $a_1_dropdown_class = '';
    
    protected $a_2_regular_class = '';
    protected $a_2_dropdown_class = '';
    
    //protected $li_class = 'nav-item';
    //protected $li_first_level_dropdown_class = 'dropdown'; // bootstrap 3     
    protected $divider_class = 'dropdown-divider'; //'submenu_divider';
    protected $dropdown_toggle_class = '';
    
    protected $skin_name;
    /**
     *
     * @var \App\Core_Menu 
     */
    protected $app_menu;
    
    private $is_current_user_admin;
    
    protected $list_of_css_frameworks = ['bootstrap3','bootstrap4','bootstrap5'];
    /**
     * 
     * @var array
     */
    protected $default_menu_css = [];

    public function __construct($block_name, $config) {
        
        parent::__construct($block_name, $config);
        
        $this->default_menu_css = [
            'bootstrap3' => new Menus_Default_CSS_Classes( 'nav navbar-nav', 'dropdown-menu', 'menu-item', 'menu-item dropdown',  '', 'dropdown-submenu',  'nav-link', 'nav-link dropdown-toggle', 'nav-submenu', 'dropdown-toggle', 'dropdown', 'submenu_divider'),
            'bootstrap4' => new Menus_Default_CSS_Classes(  'navbar-nav', 'dropdown-menu', 'nav-item', 'nav-item dropdown',  'dropdown-item', 'dropdown dropdown-item',  'nav-link', 'nav-link dropdown-toggle', 'nav-submenu', 'dropdown-toggle', 'dropdown', 'dropdown-divider'),
            'bootstrap5' => new Menus_Default_CSS_Classes(  'navbar-nav', 'dropdown-menu', 'nav-item', 'nav-item dropdown',  'dropdown-item2', 'dropdown dropdown-item',  'nav-link', 'nav-link dropdown-toggle', 'nav-submenu dropdown-item', 'dropdown-toggle', 'dropdown', 'dropdown-divider')
            
        ];
    }
    public function Run()
    {

        global $CurrentUser;
        $this->app_menu = new \App\Core_Menu();
        $this->is_current_user_admin = $CurrentUser->isCurrentUserMemberOfGroupName('Administrators');        
        $menu_id = (int) $this->getConfig('int_menu_id');
        
        $this->li_submenu_icon = $this->getConfig('str_submenu_icon');
        $skin_name = defined('SCHLIX_THEME_SKIN') ? SCHLIX_THEME_SKIN : 'bootstrap3';
        $this->skin_name = $skin_name;
        
        if (in_array($skin_name, $this->list_of_css_frameworks))
        {
            $default_skin_css = $this->default_menu_css[$skin_name];
            $this->ul_1_class = $this->getConfig('str_custom_css_class', $default_skin_css->ul_1_class);
            $this->ul_2_class = $this->getConfig('str_ul_2_class', $default_skin_css->ul_2_class);

            $this->li_1_regular_class = $this->getConfig('str_li_1_regular_class', $default_skin_css->li_1_regular_class);
            $this->li_2_regular_class = $this->getConfig('str_li_2_regular_class', $default_skin_css->li_2_regular_class);

            $this->a_1_regular_class = $this->getConfig('str_a_1_regular_class', $default_skin_css->a_1_regular_class);
            $this->a_2_regular_class = $this->getConfig('str_a_2_regular_class', $default_skin_css->a_2_regular_class);

            $this->li_1_dropdown_class = $this->getConfig('str_li_1_dropdown_class', $default_skin_css->li_1_dropdown_class);
            $this->li_2_dropdown_class = $this->getConfig('str_li_2_dropdown_class', $default_skin_css->li_2_dropdown_class);

            $this->a_1_dropdown_class = $this->getConfig('str_a_1_dropdown_class', $default_skin_css->a_1_dropdown_class);
            $this->a_2_dropdown_class = $this->getConfig('str_a_2_dropdown_class', $default_skin_css->a_2_dropdown_class);

            $this->dropdown_toggle_class = $this->getConfig('str_dropdown_toggle_class', $default_skin_css->dropdown_toggle_class);
            $this->divider_class = $default_skin_css->divider_class;
        }
        /*if ($skin_name === 'bootstrap3')
        {
            // get data from config
            $this->ul_1_class = $this->getConfig('str_custom_css_class', $this->default_bs3_ul_1_class);
            $this->ul_2_class = $this->getConfig('str_ul_2_class', $this->default_bs3_ul_2_class);

            $this->li_1_regular_class = $this->getConfig('str_li_1_regular_class', $this->default_bs3_li_1_regular_class);
            $this->li_2_regular_class = $this->getConfig('str_li_2_regular_class', $this->default_bs3_li_2_regular_class);

            $this->a_1_regular_class = $this->getConfig('str_a_1_regular_class', $this->default_bs3_a_1_regular_class);
            $this->a_2_regular_class = $this->getConfig('str_a_2_regular_class', $this->default_bs3_a_2_regular_class);

            $this->li_1_dropdown_class = $this->getConfig('str_li_1_dropdown_class', $this->default_bs3_li_1_dropdown_class);
            $this->li_2_dropdown_class = $this->getConfig('str_li_2_dropdown_class', $this->default_bs3_li_2_dropdown_class);

            $this->a_1_dropdown_class = $this->getConfig('str_a_1_dropdown_class', $this->default_bs3_a_1_dropdown_class);
            $this->a_2_dropdown_class = $this->getConfig('str_a_2_dropdown_class', $this->default_bs3_a_2_dropdown_class);

            $this->dropdown_toggle_class = $this->getConfig('str_dropdown_toggle_class', $this->default_bs3_dropdown_toggle_class);
            $this->divider_class = 'submenu_divider';
            
        } else if ($skin_name === 'bootstrap4' || $skin_name === 'bootstrap5')
        {
            // get data from config
            $this->ul_1_class = $this->getConfig('str_custom_css_class', $this->default_bs4_ul_1_class);
            $this->ul_2_class = $this->getConfig('str_ul_2_class',$this->default_bs4_ul_2_class);

            $this->li_1_regular_class = $this->getConfig('str_li_1_regular_class', $this->default_bs4_li_1_regular_class);
            $this->li_2_regular_class = $this->getConfig('str_li_2_regular_class', $this->default_bs4_li_2_regular_class);

            $this->a_1_regular_class = $this->getConfig('str_a_1_regular_class', $this->default_bs4_a_1_regular_class);
            $this->a_2_regular_class = $this->getConfig('str_a_2_regular_class', $this->default_bs4_a_2_regular_class);

            $this->li_1_dropdown_class = $this->getConfig('str_li_1_dropdown_class', $this->default_bs4_li_1_dropdown_class);
            $this->li_2_dropdown_class = $this->getConfig('str_li_2_dropdown_class', $this->default_bs4_li_2_dropdown_class);

            $this->a_1_dropdown_class = $this->getConfig('str_a_1_dropdown_class', $this->default_bs4_a_1_dropdown_class);
            $this->a_2_dropdown_class = $this->getConfig('str_a_2_dropdown_class', $this->default_bs4_a_2_dropdown_class);

            $this->dropdown_toggle_class = $this->getConfig('str_dropdown_toggle_class', $this->default_bs4_dropdown_toggle_class);
        } else if ($skin_name === 'bootstrap5')
        {
            
        }*/
        echo $this->viewMenuByCategoryID($menu_id);
    }

    /**
     * Display UL - you can override this function
     * @param int $parent_id
     * @param int $depth
     * @return string
     */
    protected function menu_UL($parent_id, $depth)
    {
        if ($depth == 0)
        {
            return "<ul class=\"{$this->ul_1_class}\" id=\"{$this->block_name}\">[menu_items]</ul>\n";
        } else
            return "\n<ul class=\"{$this->ul_2_class}\">[menu_items]</ul>\n";
    }

    /**
     * Display LI - you can override this function
     * @param array $item
     * @param string $menu_child_nodes
     * @return string
     */
    protected function menu_LI($item, $menu_child_nodes)
    {
        $output = '';
        /* Bootstrap 4
          <ul class="navbar-nav mr-auto">
          <li class="nav-item">
          <a class="nav-link" href="/test" target="_blank">test</a>
          </li>
          <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" id="dropdown2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Dropdown2</a>
          <ul class="dropdown-menu" aria-labelledby="dropdown2">
          <li class="dropdown-item" href="#"><a>Action 2 A</a></li>
          ....
          </ul>
         */
        //$li_class = $this->li_first_level_class;// 'nav-item';
        $has_submenu = !empty($menu_child_nodes);
        if (!$has_submenu)
        {
            if ($item['parent_id'] > 0)
                $li_class = $this->li_2_regular_class;
            else 
                $li_class = $this->li_1_regular_class;
        } else
        {
            if ($item['parent_id'] > 0)
                $li_class =  $this->li_2_dropdown_class;  //$this->li_1_dropdown_class.' '.$this->li_2_dropdown_class;
            else
                $li_class  = $this->li_1_dropdown_class; // $this->li_1_regular_class . ' ' . $this->li_1_dropdown_class;
        }

        $str_li_class = $li_class ? ' class="' . $li_class . '" ' : ''; // empty($child_output) ? "" : " class=\"dropdown\" ";
        $li_id = " id=\"block_{$this->block_name}_li_{$item['id']}\"";
        $item['_block_name'] = $this->block_name;

        ///////////////////////////////////////////////////////////////
        if (SCHLIX_SEF_ENABLED)
            $menu_link = $item['sefurl'];
        else
        {
            switch ($item['application'])
            {
                case 'home':$menu_link = SCHLIX_SITE_HTTPBASE . $item['internalurl'];
                    break;
                case 'menu_divider': return '<hr class="submenu_divider" />';
                case 'external_link': $menu_link = $item['internalurl'];
                    break;
                default: $menu_link = "index.php?{$item['internalurl']}";
            }
        }
        if ($item['application'] === 'menu_divider')
            return "<{$this->element_divider} class=\"{$this->divider_class}\"></li>";
        $font_icon = strip_tags(trim((string) $item['font_icon']));
        $menu_title = $original_menu_title = ___h($item['title']);
        if ($font_icon)
        {
            $font_icon_tag = \__HTML::I('', ['class' => $font_icon]);
            $menu_title = $item['use_font_icon_only_no_text'] ? $font_icon_tag : $font_icon_tag . ' ' . $menu_title;
        }

        $the_target = '';
        if ($item['open_in_new_window'] == 1)
            $the_target = '_blank';
        if (SCHLIX_SITE_SSL_ENABLED && $item['ssl_state'] == 2)
            $menu_link = SCHLIX_SITE_HTTPS_URL . $menu_link;
        else
        if ($item['ssl_state'] == 1)
            $menu_link = SCHLIX_SITE_HTTP_URL . $menu_link;
        $a_attr = array();

        $has_submenu = !empty($menu_child_nodes);
        if (!$has_submenu)
        {            
            if ($item['parent_id'] > 0)
                $a_attr['class'] = $this->a_2_regular_class;
            else 
                $a_attr['class'] = $this->a_1_regular_class;            
        } else
        {
            if ($item['parent_id'] > 0)
                $a_attr['class'] = $this->a_2_dropdown_class;
            else 
            {
                $a_attr['class'] = $this->a_1_dropdown_class;
                $a_attr['data-submenu'] = 1;
            }
            
            $a_attr['data-toggle'] = $this->dropdown_toggle_class;
            $a_attr['data-bs-toggle'] = $this->dropdown_toggle_class;
            $a_attr['data-hassubmenu'] = 1;
        }
        //$a_attr['id'] = 'block_' . alpha_numeric_only($item['_block_name']) . "_id-{$item['id']}";
        $a_attr['target'] = $the_target;
        $a_attr['title'] = $original_menu_title;

        $icon = $this->li_submenu_icon;
        $font_css = $icon ? " <i class=\"{$icon}\"></i>" : '';
        // bootstrap 3: $submenu_icon = $has_submenu ? $font_css : "";
        // boottrap 4: 
         $submenu_icon = '';
        $elem_a = \__HTML::A($menu_title . $submenu_icon, $menu_link, $a_attr);

        if ($menu_child_nodes)
            $menu_child_nodes .= "\n";
        $output .= "\t<{$this->element_li}{$li_id}{$str_li_class}>{$elem_a}{$menu_child_nodes}</{$this->element_li}>\n";
        return $output;
    }

    /**
     * View Menu by category ID
     * @param int $menu_id
     */
    protected function viewMenuByCategoryID($menu_id)
    {

        $menu_items = $this->app_menu->getMenuArrayByCategoryID($menu_id, true);
        $str_menu_items = $this->traverseMenuItems($menu_items, 'menu_UL', 'menu_LI');
        echo $str_menu_items;
    }

    /**
     * 
     * @global \App\Users $CurrentUser
     * @param array $menu_items
     * @param string $method_folder
     * @param string $method_item
     * @param int $parent_id
     * @param int $depth
     * @return string
     */
    protected function traverseMenuItems($menu_items, $method_folder, $method_item, $parent_id = 0, $depth = 0)
    {

        global $CurrentUser;

        $ul = call_user_func([$this, $method_folder], $parent_id, $depth);
        $menu_count = ___c($menu_items);
        $ul_content = '';
        for ($i = 0; $i < $menu_count; $i++)
        {
            if ($menu_items[$i]['parent_id'] == $parent_id)
            {
                $item = $menu_items[$i];                
                $can_read = $this->is_current_user_admin || $CurrentUser->hasReadPermission($item['permission_read']);
                if ($can_read)
                {

                    $childnodes = $this->traverseMenuItems($menu_items, $method_folder, $method_item, $item['id'], $depth + 1, 'id');
                    $c = call_user_func([$this, $method_item], $item, $childnodes);
                    $ul_content .= $c;
                }
            }
        }
        if ($ul_content)
        {
            $ul = str_replace('[menu_items]', $ul_content, $ul);
            return $ul;
        }
        return '';
        //return $ul ;
    }

}
