<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

/*
  interface_cmsApplication --> interface_cmsApplication_List --> interface_cmsApplication_CategorizedList --> interface_cmsApplication_HierarchicalTree_List --> interface_cmsApplication_ManyToMany
 */
/**
* Project: SCHLIX CMS: a lightweight, extensible content management system<br />
* File: app_interface.php<br />
*
*
* @copyright 2011 - 2023 SCHLIX Web Inc
* @author SCHLIX Web Inc
* @version 2.1.x (April 2017)
* @license GPLv3
*/
namespace SCHLIX;

interface interface_cmsEditor {
    /**
     * Ensure default profiles exists
     * @global \App\Core_EditorManager $WYSIWYGEditor
     */
    public function ensureDefaultProfilesExist();
    /**
     * Returns an array of default config key/value array. Profile name can be simple, full, etc...
     * @param string $reset_profile_name
     * @return array
     */
    public function getDefaultProfileResetSettings($reset_profile_name);

    
    /**
     * Returns a list of extensions, where $from is either 'system' or 'user'
     * and $type can be any subdirectory within it, e.g. plugins, themes, languages
     * @param string $from
     * @param string $type
     * @return type
     */
    public function getListOfExtensions($from, $type);

     /**
     * Returns extension path, where $from is either system or user,
     * $type is the subdirectory, and $item is the specific extension
     * @param string $from
     * @param string $type
     * @param string $item
     * @return string
     */    
    public function getExtensionFullPath($from, $type, $item= '');
    /**
     * Returns extension URL path, where $from is either system or user,
     * $type is the subdirectory, and $item is the specific extension
     * @param string $from
     * @param string $type
     * @param string $item
     * @return string
     */
    public function getExtensionURLPath($from, $type, $item= '');
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveConfig($datavalues);
    /**
     * Returns the configuration script, uncached
     * @return string
     */
    public function getUncachedConfigurationScript();
    
    /**
     * Generate config
     * @return boolean
     */
    public function viewInitScript();
    
    
}


interface interface_cmsMacro {

    /**
     * Loads macro configuration
     */
    public function getConfiguration();

    /**
     * Run the macro
     * @param string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = false);
}

interface interface_cmsBlock {

    /**
     * Loads block configuration
     */
    public function getConfiguration();

    /**
     * Run the block
     */
    public function Run();
}

interface interface_cmsApplication_Basic {
    
    /**
     * Returns true if this app is not meant to be run in the frontend
     * @return bool
     */
    public function isFrontendRuntimeDisabled();
    /**
     * Returns true if versioning is enabled
     * @return bool
     */
    public function hasVersioning();
    /**
     * Redirects to internal action, e.g. /action/myaction. Protocol can be 
     * OPT_REDIRECT_DEFAULT or OPT_REDIRECT_HTTPS or OPT_REDIRECT_HTTP 
     * @param string $action
     * @param string $protocol
     */
    public function redirectToOtherAction($action, $protocol = OPT_REDIRECT_DEFAULT);
    /**
     * Returns an array of HTML link of breadcrumbs
     * @return array
     */
    public function getBreadCrumbsArray();
    /**
     * Displays the breadcrumb
     * @param string $separator
     * @return string
     */
    public function displayBreadCrumbs($separator = ' &raquo; ');
    
    /**
     * Returns a config value from key for this app
     * @global \SCHLIX\cmsRegistryConfig $SystemConfig
     * @global \SCHLIX\cmsUser $CurrentUser
     * @param string $key
     * @param string $default_value
     * @return mixed
     */
    public function getConfig($key, $default_value = FALSE);
    /**
     * Set a config value for this app
     * @global \SCHLIX\cmsRegistryConfig $SystemConfig
     * @param string $key
     * @param string $value
     * @return mixed
     */
    public function setConfig($key, $value);
    
    /**
     * Returns the application name
     * @return string
     */
    public function getApplicationName();
    /**
     * Returns the application description from database. If it's empty, then the
     * default application description set in the class will be used instead
     * @return string
     */
    public function getApplicationDescription();
    /**
     * Returns the application description not from the database
     * @return string
     */
    
    public function getOriginalApplicationDescription();

    /**
     * Process text output with macro. Runs all macros
     * @global \App\Core_MacroManager $Macros
     * @param array $data
     * @param string $function_name
     * @param array $extra_info
     * @return string
     */

    public function processDataOutputWithMacro(&$data, $function_name, $extra_info = false);

    /**
     * Outputs the page title
     */
    public function displayPageTitle();
    /**
     * Outputs the page meta description
     */
    public function displayPageMetaDescription();
    /**
     * Outputs the page metta keywords
     */
    public function displayPageMetaKeywords();
    /**
     * Returns the page meta description
     * @return string
     */
    public function getPageMetaDescription();
    /**
     * Returns the page meta keywords
     * @return string
     */
    public function getPageMetaKeywords();
    /**
     * Set the page meta description
     * @param string $meta_description
     */
    public function setPageMetaDescription($meta_description);
    /**
     * Set the page meta keywords
     * @param string $meta_keywords
     */
    public function setPageMetaKeywords($meta_keywords);
    /**
     * Frontend: view the main page. Usually loads view.main.template.php
     */
    public function viewMainPage();
    /**
     * Returns an array of command, given $urlpath.
     * @param string $urlpath
     * @return array
     */
    public function interpretFriendlyURL($urlpath);

    /**
     * create SEO friendly URL. Format is action={...}&param1={....}&param2={...}
     * @param string $str
     * @return string
     */
    public function createFriendlyURL($str);

    /**
     * Runs command. If return value is true, then it will be displayed as a full page
     * If return value is false, AJAX method is assumed
     * @param string $command
     * @return boolean
     */
    public function Run($command);
    
}

interface interface_cmsApplication_List extends interface_cmsApplication_Basic {

    /**
     * Returns total item count with specified critiera (e.g. status > 0)
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $criteria
     * @param bool $cache
     * @return int
     */
    public function getTotalItemCount($criteria = '', $cache = false);

    /**
     * Returns item table name
     */
    public function getItemTableName();

    /**
     * Returns the field names
     */
    public function getItemFieldNames();
    
    /**
     * Returns the title field name from $this->table_items (usually just title)
     * @return string
     */
    public function getFieldID();
    /**
     * Deletes items from table. The parameter $mixed_items_to_delete is a pipe-separated
     * value of items, e.g. i4|i5|i1
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $mixed_items_to_delete
     */
    public function delete($str);
    /**
     * Queries $this->table_items
     * 
     * @param string $fields
     * @param string $extra_criteria
     * @param int $start
     * @param int $end
     * @param string $sortby
     * @param string $sortdirection
     * @param bool $from_cache
     * @return array
     */
    public function getAllItems($fields = '*', $extra_criteria = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC', $from_cache = false);

    /**
     * Loads the item and display it with view.item.template.php
     * @param int $id
     * @param bool $from_cache
     */
    public function viewItemByID($id = 1, $from_cache = false);
    /**
     * Returns item by ID
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $id
     * @param bool $from_cache
     * @return array
     */
    public function getItemByID($id, $from_cache = false);
    /**
     * Returns one or more item with the same virtual filename. Used in later classes.
     * There's a parameter $category_id that's not supposed to be in this class but it's there 
     * for compatibility with inherited classes
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $input_filename
     * @param int $category_id
     * @return array
     */
    public function getItemsByVirtualFilename($input_filename, $category_id = -1);

    /**
     * Returns a new name if there's an item with the same name in the specified
     * $fieldname
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $fieldname
     * @param int $id
     * @param string $possible_duplicate
     * @return string
     */   
    public function preventDuplicateValueInItemTable($fieldname, $possible_duplicate, $id);
    /**
     * Given an associative array $data, find possible duplicate from item's table
     * @param array $data
     * @return boolean
     */
    public function findDuplicateItems($data);
    /**
     * Validates save item. If there's an error, it will return an array
     * with one or more error string, otherwise it will return a boolean true
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return bool|array String array
     */
    public function getValidationErrorListBeforeSaveItem($data);
    /**
     * Saves item to database. If the item field has the following field:
     * guid, version, date_created, date_modified, date_available, it will be filled
     * automatically. Return value is an array containing ('status','id','errors')
     * @global cmsDatabase $SystemDB
     * @global basicVersioning $Versioning
     * @param int $id
     * @return array 
     */
    public function saveItem($id, $alternative_datavalues = NULL);

    // search
    public function genericSearch($fieldname, $keyword, $fields_tobe_selected = '*', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');
}

interface interface_cmsApplication_CategorizedList extends interface_cmsApplication_List {

    // get data info
    public function getTotalItemCountByCategoryID($category_id, $criteria = '', $cache = false);

    public function getTotalCategoryCount($criteria = '', $cache = false);

    public function getItemOrCategoryToViewFromFullVirtualFilename($url, $enable_redirect_no_trailingslash_folder = false);

    public function getCategoriesByVirtualFilename($input_filename, $parent_id = -1);

    public function getCategoryTableName();

    public function getCategoryFieldNames();

    public function getFieldCategoryID();

    public function getDefaultCategoryID();

    public function getFullPathByItemID($item_id);

    public function getFullPathByCategoryID($cat_id);

    // display html

    public function viewCategoryByID($id = 1, $pg = 1, $sortby = '', $sortdirection = 'ASC', $criteria = 'status > 0', $from_cache = false);

    // functions
    public function getAllChildItemsInMultipleCategories($multiple_category_ids);

    public function getAllCategories($fields = '*', $extra_criteria = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');

    public function getCategoryByID($id, $from_cache = false);

    public function getItemsByCategoryID($id, $fields = '*', $extra_criteria = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC', $from_cache = false);

    //public function preventDuplicateCategoryInThisCategoryByFieldName($fieldname, $id, $name);

    //public function preventDuplicateItemInThisCategoryByFieldName($fieldname, $id, $name);

    public function findDuplicateCategories($data);

    public function getValidationErrorListBeforeSaveCategory($data);

    public function saveCategory($id, $alternative_datavalues = NULL);
}

interface interface_cmsApplication_HierarchicalTree_List extends interface_cmsApplication_CategorizedList {

    public function getTotalChildCategoryCountByCategoryID($parent_cid, $criteria = '', $cache = false);

    public function traverseCategories($catid);

    public function getChildCategoriesByParentID($id, $fields = '*', $extra_criteria = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC', $from_cache = false);
}

interface interface_cmsApplication_ManyToMany extends interface_cmsApplication_HierarchicalTree_List {

    public function getItemsToCategoryFieldNames();

    public function getItemsToCategoryTableName();

    public function setItemCategory($id, $cid, $state);

    public function getItemCategoryIDsByItemID($id, $fields = '*', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC', $from_cache = false);
}