<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//////////////////////////////////////////////////////////

/**
 * Class for generating HTML tags
 */
class __HTML {

    //_________________________________________________________________________//
    public static function Tag($element, $content = '', $attributes = [], $cleanup = false) {
        if ($cleanup && $content)
            $content = htmlentities($content, ENT_QUOTES, "UTF-8");
        return __HTML::OpenTag($element, $attributes, false) . $content . __HTML::CloseTag($element);
    }

    //_________________________________________________________________________//
    public static function OpenTag($element, $attributes = [], $close_right_away = false) {
        $attrs = ' ';
        if (___c($attributes) > 0)
            foreach ($attributes as $key => $value)
                if (strval($value) != '')
                    $attrs.="{$key}=\"" . htmlspecialchars(strval($value)) . "\" ";
        $attrs =  rtrim($attrs);
        $element = strtolower($element);
        if ($close_right_away) {

            $attrs.=' /';
        }
        $html_element = "<{$element}{$attrs}>";
        return $html_element;
    }

    //_________________________________________________________________________//
    public static function CloseTag($element) {
        return '</' . strtolower($element) . '>';
    }

    public static function H1($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);        
    }

    //_________________________________________________________________________//
    public static function H2($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function H3($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function H4($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function H5($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function H6($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function BR($attributes = []) {
        return __HTML::OpenTag('br', $attributes, true);
    }

//_________________________________________________________________________//
    public static function HR($attributes = []) {
        return __HTML::OpenTag('hr', $attributes, true);
    }

    public static function IFRAME($src, $attributes = []) {
        $attributes['src'] = $src;
        return __HTML::Tag(__FUNCTION__, '', $attributes, false);
    }
    
//_________________________________________________________________________//
    public static function IMG($src, $attributes = []) {
        if (is_array($attributes)) {

            $attributes['src'] = $src;
            return __HTML::OpenTag(__FUNCTION__, $attributes, true);
        } else {
            $argv = func_get_args();
            return __HTML::OpenTag(__FUNCTION__, array('src' => $src, 'alt' => $argv[1], 'width' => $argv[2], 'height' => $argv[3], 'border' => $argv[4], 'id' => $argv[5], 'class' => $argv[6], 'style' => $argv[7]), true);
        }
    }

//_________________________________________________________________________//
    public static function P($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
        //$argv = func_get_args();
        //array_unshift($argv, __FUNCTION__);
        //call_user_func_array('__HTML::Tag', $argv)
        //return is_array($argv[2]) ? call_user_func_array('__HTML::Tag', $argv) : __HTML::Tag(__FUNCTION__, $argv[1], array('id' => $argv[2], 'class' => $argv[3]));
    }

    public static function PRE($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function TITLE($text) {
        return __HTML::Tag('title', $text);
    }

    //_________________________________________________________________________//
    public static function CODE($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function STRONG($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function EM($text, $attributes = []) {
        return __HTML::Tag(__FUNCTION__, $text, $attributes, false);
    }

//_________________________________________________________________________//
    public static function LI($text, $attributes = []) {        
        return __HTML::Tag(__FUNCTION__, $text, $attributes);
    }

//_________________________________________________________________________//
    public static function A($text, $link, $attributes = []) {
        if (is_array($attributes)) {
            $attributes['href'] = $link;
            return __HTML::Tag(__FUNCTION__, $text, $attributes);
        } else {
            $argv = func_get_args();
            return __HTML::Tag(__FUNCTION__, $text, array('href' => $link, 'id' => $argv[2], 'class' => $argv[3], 'target' => $argv[4], 'title' => $argv[5]));
        }
    }
//_________________________________________________________________________//
    public static function I($text='', $attributes = []) {
            return __HTML::Tag(__FUNCTION__, $text, $attributes);
    }

//_________________________________________________________________________//
    public static function SPAN($text, $attributes = []) {
            return __HTML::Tag(__FUNCTION__, $text, $attributes);
    }
//_________________________________________________________________________//
    public static function LI_start($attributes = []) {
        return __HTML::OpenTag('li', $attributes, false);
    }

//_________________________________________________________________________//
    public static function LI_end() {
        return __HTML::CloseTag('li');
    }
    
//_________________________________________________________________________//
    public static function I_start($attributes = []) {
        return __HTML::OpenTag('i', $attributes, false);
    }

//_________________________________________________________________________//
    public static function I_end() {
        return __HTML::CloseTag('i');
    }
//_________________________________________________________________________//
    public static function SPAN_start($attributes = []) {
        return __HTML::OpenTag('span', $attributes, false);
    }

//_________________________________________________________________________//
    public static function SPAN_end() {
        return __HTML::CloseTag('span');
    }
    
//_________________________________________________________________________//
    public static function DIV_start($attributes = []) {
        if (is_array($attributes))
            return __HTML::OpenTag('div', $attributes, false);
        else {
            $argv = func_get_args();
            return __HTML::OpenTag('div', array('id' => $argv[0], 'class' => $argv[1]), false);
        }
    }

//_________________________________________________________________________//
    public static function DIV_end() {
        return __HTML::CloseTag('div');
    }

//_________________________________________________________________________//
    public static function UL_start($attributes = []) {
        if (is_array($attributes))
            return __HTML::OpenTag('ul', $attributes, false);
        else {
            $argv = func_get_args();
            return __HTML::OpenTag('ul', array('id' => $argv[0], 'class' => $argv[1]), false);
        }
    }

//_________________________________________________________________________//
    public static function UL_end() {
        return __HTML::CloseTag('ul');
    }

//_________________________________________________________________________//
    public static function OL_start($attributes = []) {
        return __HTML::OpenTag('ol', $attributes, false);
    }

//_________________________________________________________________________//
    public static function OL_end() {
        return __HTML::CloseTag('ol');
    }

//_________________________________________________________________________//
    public static function FIELDSET_start($attributes = []) {
        if (is_array($attributes))
            return __HTML::OpenTag('fieldset', $attributes, false);
        else {
            $argv = func_get_args();
            return __HTML::OpenTag('fieldset', array('id' => $argv[0], 'class' => $argv[1]), false);
        }
    }

//_________________________________________________________________________//
    public static function FIELDSET_end() {
        return __HTML::CloseTag('fieldset');
    }

//_________________________________________________________________________//
    public static function LEGEND($text, $attributes = []) {
        $argv = func_get_args();
        array_unshift($argv, __FUNCTION__);
        //return is_array($argv[2]) ? call_user_func_array('__HTML::Tag', $argv) : __HTML::Tag(__FUNCTION__, $argv[1], array('id' => $argv[2], 'class' => $argv[3]));
        return call_user_func_array('__HTML::Tag', $argv) ;
    }

//_________________________________________________________________________//
    public static function FORM_start($attributes = []) {
        return __HTML::OpenTag('form', $attributes, false);
    }

//_________________________________________________________________________//
    public static function FORM_end() {
        return __HTML::CloseTag('form');
    }

//_________________________________________________________________________//
    public static function TABLE_start($attributes = []) {
        if (is_array($attributes))
            return __HTML::OpenTag('table', $attributes, false);
        else {
            $argv = func_get_args();
            return __HTML::OpenTag('table', array('id' => $argv[0], 'class' => $argv[1]), false);
        }
    }

//_________________________________________________________________________//

    public static function TABLE_end() {
        return __HTML::CloseTag('table');
    }

//_________________________________________________________________________//
    public static function TR_start() {
        $argv = func_get_args();
        array_unshift($argv, 'tr');         
        return call_user_func_array('__HTML::OpenTag', $argv)  ;
    }

//_________________________________________________________________________//
    public static function TR_end() {
        return __HTML::CloseTag('tr');
    }

//_________________________________________________________________________//
    public static function TD_start() {
        $argv = func_get_args();
        array_unshift($argv, 'td');
        return is_array($argv[1]) ? call_user_func_array('__HTML::OpenTag', $argv) : __HTML::OpenTag($argv[0], array('id' => $argv[1], 'class' => $argv[2]));
    }

//_________________________________________________________________________//
    public static function TD_end() {
        return __HTML::CloseTag('td');
    }

//_________________________________________________________________________//
    public static function TH_start() {
        $argv = func_get_args();
        array_unshift($argv, 'th');
        return is_array($argv[1]) ? call_user_func_array('__HTML::OpenTag', $argv) : __HTML::OpenTag($argv[0], array('id' => $argv[1], 'class' => $argv[2]));
    }

//_________________________________________________________________________//
    public static function TH_end() {
        return __HTML::CloseTag('th');
    }

//_________________________________________________________________________//

    public static function TR($text) {
        $argv = func_get_args();
        array_unshift($argv, __FUNCTION__);
        return is_array($argv[2]) ? call_user_func_array('__HTML::Tag', $argv) : __HTML::Tag(__FUNCTION__, $argv[1], array('id' => $argv[2], 'class' => $argv[3]));
    }

//_________________________________________________________________________//

    public static function TH($text) {
        $argv = func_get_args();
        array_unshift($argv, __FUNCTION__);
        return is_array($argv[2]) ? call_user_func_array('__HTML::Tag', $argv) : __HTML::Tag(__FUNCTION__, $argv[1], array('id' => $argv[2], 'class' => $argv[3]));
    }

//_________________________________________________________________________//

    public static function TD($text) {
        $argv = func_get_args();
        array_unshift($argv, __FUNCTION__);
        return is_array($argv[2]) ? call_user_func_array('__HTML::Tag', $argv) : __HTML::Tag(__FUNCTION__, $argv[1], array('id' => $argv[2], 'class' => $argv[3]));
    }

//_________________________________________________________________________//
    public static function LABEL($label, $input, $before = true, $attributes = []) {
        $text = ($before ? "{$label}{$input}" : "{$input}{$label}");
        if (!is_array($attributes)) {
            $argv = func_get_args();
            $attributes = array('id' => $argv[3], 'class' => $argv[4]);
        }
        return __HTML::Tag(__FUNCTION__, $text, $attributes);
    }

//_________________________________________________________________________//
    public static function LABEL_FOR($label, $input, $attributes = []) {
        if (is_array($attributes))
            $attributes ['for'] = $input;
        else {
            $argv = func_get_args();
            $attributes = array('for' => $input, 'id' => $argv[2], 'class' => $argv[3]);
        }
        return __HTML::Tag('label', $label, $attributes);
    }
    
//_________________________________________________________________________//
    public static function LABEL_Start($attributes = []) {
        if (is_array($attributes))
            return __HTML::OpenTag('label', $attributes, false);
        else {
            $argv = func_get_args();
            return __HTML::OpenTag('label', array('id' => $argv[0], 'class' => $argv[1]), false);
        }
    }
//_________________________________________________________________________//
    public static function LABEL_end() {
        return __HTML::CloseTag('label');
    }

    //_________________________________________________________________________//
    /**
     * Adds a locally hosted CSS file 
     * @param string $local_css_file_relative_path
     * @param string $extra_attributes
     * @return string
     */
    public static function CSS($local_css_file_relative_path, $extra_attributes = []) {
        return self::CSS_EXTERNAL(SCHLIX_SITE_HTTPBASE.$local_css_file_relative_path, $extra_attributes);
    //		return "<link type=\"text/css\" href=\"".SCHLIX_SITE_HTTPBASE."{$filename}\" rel=\"stylesheet\" />\n";
    }

    //_________________________________________________________________________//
    /**
     * Adds a CSS Link tag. You can add type such as media, etc to the extra attr
     * @param string $any_url
     * @param array $extra_attributes
     * @return string
     */
    public static function CSS_EXTERNAL($any_url, array $extra_attributes = []) {
        $attrs = array('type' => 'text/css', 'rel' => 'stylesheet', 'href' => $any_url);
        if (is_array($extra_attributes) && count ($extra_attributes) > 0)
        {
            $attrs = array_merge($attrs, $extra_attributes);
        }
        return __HTML::OpenTag('link', $attrs, true);
    }

    /**
     * Returns a script tag. Parameter is a Javascript text
     * Accepts multiple parameter
     * @return string
     */
    public static function JAVASCRIPT_TEXT() {
        $js = '';
        $totalcount = func_num_args();
        $srcs = func_get_args();
        for ($i = 0; $i < $totalcount; $i++)
            $js.="<script type=\"text/javascript\">\n{$srcs[$i]}\n</script>\n";
        return $js;
    }

    //_________________________________________________________________________//
    /**
     * Returns a script tag. Parameter is an external Javascript URL
     * Accepts multiple parameter
     * @return string
     */
    public static function JAVASCRIPT_EXTERNAL() {
        $js = '';
        $totalcount = func_num_args();
        $filenames = func_get_args();
        for ($i = 0; $i < $totalcount; $i++)
            $js.="<script src=\"{$filenames[$i]}\"></script>\n";
        return $js;
    }
    
}



//______________________________ end class __HTML __________________________________________________________/
/**
 * class for generating HTML input tag
 */

class INPUT {

    //_________________________________________________________________________//
    public static function BASIC($type, $name, $value, $attributes = [], $closetag = true) {
        if (!is_array($attributes))
            $attributes = [];
        $attributes['type'] = strtolower($type);
        $attributes['name'] = $name;
        $attributes['value'] = $value;
        return __HTML::OpenTag('input', $attributes, $closetag);
    }

    //_________________________________________________________________________//
    public static function SUBMIT($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function TEXT($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function NUMBER($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function COLOR($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function EMAIL($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function FILE($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function URL($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function SEARCH($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function PASSWORD($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function HIDDEN($name, $value, $attributes = []) {
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function CSRF($attributes = []) {
        return \INPUT::HIDDEN('_csrftoken', get_csrf_token(), $attributes);
    }

    //_________________________________________________________________________//
    public static function BUTTON($name, $content, $attributes = []) {
        $attributes['name'] = $name;
        return __HTML::Tag(__FUNCTION__, $content, $attributes);
    }

    //_________________________________________________________________________//
    public static function TEXTAREA($name, $value, $attributes = []) {
        $attributes['name'] = $name;
        return __HTML::Tag(__FUNCTION__, $value, $attributes);
    }

    //_________________________________________________________________________//
    public static function OPTION($value, $content, $attributes = []) {
        $attributes['value'] = $value;
        return __HTML::Tag(__FUNCTION__, $content, $attributes);
    }

    //_________________________________________________________________________//
    public static function OPTGROUP_start($label, $attributes = []) {
        $attributes['label'] = $label;
        return __HTML::OpenTag('optgroup', $attributes, false);
    }

    //_________________________________________________________________________//
    public static function OPTGROUP_end() {
        return __HTML::CloseTag('optgroup');
    }

    //_________________________________________________________________________//
    public static function CHECKBOX($name, $value, $checked = false, $attributes = []) {
        if (!is_array($attributes))
            $attributes = [];
        $attributes['checked'] = ($checked ? 'checked' : '');
        
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function RADIO($name, $value, $checked = false, $attributes = []) {
        if (!is_array($attributes))
            $attributes = [];
        $attributes['checked'] = ($checked ? 'checked' : '');
        return \INPUT::BASIC(__FUNCTION__, $name, $value, $attributes, true);
    }

    //_________________________________________________________________________//
    public static function RADIO_GROUP($name, $options, $value, $legend = '', $attributes = [], $key_label = 'label', $key_value = 'value' , $max_item_per_column = 0, $max_item_per_row = 0, $table_attributes = []) {
        $total_options = ___c($options);
        $str = '';
        if ($max_item_per_column == 0 && $max_item_per_row > 0)
            $max_item_per_column = floor($total_options / $max_item_per_row);
        if ($max_item_per_column > 0 && $total_options > $max_item_per_column)
            $str.= \__HTML::TABLE_start($table_attributes) . \__HTML::TR_start() . \__HTML::TD_start(array('valign' => 'top'));
        for ($i = 0; $i < $total_options; $i++) {

            $is_checked = (/* v1.2.2 strval($value) && */ (($value == $options[$i][$key_value]) || (($value == 0) && ($options[$i][$key_value] == '0') )) ) ? 'checked' : '';
            $str.= \__HTML::DIV_start(array('class' => 'radio')) . 
                \__HTML::LABEL($options[$i][$key_label], 
                    \INPUT::RADIO($name, $options[$i][$key_value], $is_checked, $attributes), false) . 
                \__HTML::DIV_end();
            if ($max_item_per_column > 0 && ($i > 0 && (($i + 1) % $max_item_per_column == 0)))
                $str.= \__HTML::TD_end() . \__HTML::TD_start(array('valign' => 'top'));
        }
        if ($max_item_per_column >> 0 && $total_options > $max_item_per_column)
            $str.= \__HTML::TD_end() . \__HTML::TR_end() . \__HTML::TABLE_end();
        if (!empty($legend))
            $str = \__HTML::FIELDSET_start() . \__HTML::LEGEND($legend) . $str . \__HTML::FIELDSET_end();
        return $str;
    }

    //_________________________________________________________________________//
    public static function CHECKBOX_GROUP($name, $options, $value, $legend = '', $attributes = [], $key_label = 'label', $key_value = 'value', $max_item_per_column = 0, $max_item_per_row = 0, $table_attributes = []) {
        $total_options = ___c($options);
        $str = '';
        if (strpos($name, '[]') == false)
            $name.='[]';
        if ($max_item_per_column == 0 && $max_item_per_row > 0)
            $max_item_per_column = floor($total_options / $max_item_per_row);
        if ($max_item_per_column > 0 && $total_options > $max_item_per_column)
            $str.= \__HTML::TABLE_start($table_attributes) . \__HTML::TR_start() . \__HTML::TD_start(array('valign' => 'top'));
        for ($i = 0; $i < $total_options; $i++) {
            $str.= "\n".\__HTML::DIV_start(array('class' => 'checkbox')) ."\n". 
                    \__HTML::LABEL($options[$i][$key_label], 
                    \INPUT::CHECKBOX($name, $options[$i][$key_value], (is_array($value) && array_search($options[$i][$key_value], $value) !== false), $attributes), false ) . "\n".
                    \__HTML::DIV_end()."\n";
            if ($max_item_per_column > 0 && ($i > 0 && (($i + 1) % $max_item_per_column == 0)))
                $str.= \__HTML::TD_end() . \__HTML::TD_start(array('valign' => 'top'));
        }
        $str.= \INPUT::HIDDEN($name, "__null__");
        if ($max_item_per_column >> 0 && $total_options > $max_item_per_column)
            $str.= \__HTML::TD_end() . \__HTML::TR_end() . \__HTML::TABLE_end();
        if (!empty($legend))
            $str = \__HTML::FIELDSET_start() . \__HTML::LEGEND($legend) . $str . \__HTML::FIELDSET_end();
        return $str;
    }

    //_________________________________________________________________________//
    public static function SELECT($name, $options, $value, $attributes = [], $key_label = 'label', $key_value = 'value') {
        $attributes['name'] = $name;
        $str = __HTML::OpenTag(__FUNCTION__, $attributes, false);
        foreach ($options as $option) {
            $selected = (strval($value) && ($value == $option[$key_value])) ? 'selected' : '';
            $str.= __HTML::Tag('option', $option[$key_label], array('value' => $option[$key_value], 'selected' => $selected), false);
        }
        $str.=__HTML::CloseTag(__FUNCTION__);
        return $str;
    }

    //_________________________________________________________________________//
    public static function SELECT_start($name, $attributes = []) {
        $attributes['name'] = $name;
        $str = __HTML::OpenTag('select', $attributes, false);
        return $str;
    }

    //_________________________________________________________________________//
    public static function SELECT_end() {
        return __HTML::CloseTag('select');
    }

    /**
     * Date time picker
     * @deprecated since version 2.2.0
     * @param string $s
     * @param string $value
     * @return string
     */
    public static function DateTimePicker($s, $value) {
        //return \INPUT::TEXT($s,$value,array('id'=>$s,'class'=>'schlix_editor_input')).UI::DateCalendarButton($s);
        /* <div class="container">
          <div class="row">
          <div class='col-sm-6'>
          <div class="form-group">
          <div class='input-group date' id='datetimepicker1'>
          <input type='text' class="form-control" />
          <span class="input-group-addon">
          <span class="fas fa-calendar-alt"></span>
          </span>
          </div>
          </div>
          </div>
          <script type="text/javascript">
          $(function () {
          $('#datetimepicker1').datetimepicker();
          });
          </script>
          </div>
         * 
         * 
          </div>

          <div class="form-group">
          <label>Time picker:</label>
          <div class="input-group">
          <input type="text" class="form-control timepicker" />
          <div class="input-group-addon">
          <i class="far fa-clock"></i>
          </div>
          </div><!-- /.input group -->
          </div><!-- /.form group -->
         *  */
        $div = \__HTML::DIV_start(array('class' => 'form-group')) .
            \__HTML::DIV_start(array('class' => 'input-group datetimepicker', 'id' => 'cal_' . $s)) .
            
            \INPUT::TEXT($s, $value, array('id' => $s, 'class' => 'form-control schlix-datetime-picker')) .
            \__HTML::DIV_start(array('class' => 'input-group-addon')) .
            \__HTML::SPAN('', array('class' => 'fas fa-calendar-alt')) .
            \__HTML::DIV_end() .
            \__HTML::DIV_end() .
            \__HTML::DIV_end();
        return $div;
    }    


    /**
     * 
     * Date picker
     * @deprecated since version 2.2.0
     * @param string $input_name
     * @param string $value
     * @param int $year_start
     * @param int $year_end
     * @param array $attributes
     * @param string $blank_year
     * @param string $blank_month
     * @param string $blank_day
     * @param string $row_class
     * @param string $col_class
     * @return string
     */
    public static function DatePicker($input_name, $value, $year_start, $year_end, $attributes = [], $blank_year = '-Year-', $blank_month = '-Month-', $blank_day = '-Day-', $row_class = 'row', $col_class = 'col-xs-4 col-sm-4 col-md-4 col-lg-4') {
        // Assign values
        $year_options = [];
        $month_options = [];
        $day_options = [];

        $is_required = isset($attributes['required']) && ($attributes['required'] != '');
        $default_select_attr = array('class' => 'form-control');
        if ($is_required)
            $default_select_attr[] = array('required' => 'required');
        $default_col_attr = array('class' => $col_class);
        $default_row_attr = array('class' => $row_class);

        $year_options[] = array('label' => $blank_year, 'value' => '');
        $month_options[] = array('label' => $blank_month, 'value' => '');
        $day_options[] = array('label' => $blank_day, 'value' => '');
        // YEARS
        for ($i = $year_end; $i > $year_start; $i--) {
            $year_options[] = array('label' => $i, 'value' => $i);
        }
        // Month
        for ($i = 1; $i <= 12; $i++) {
            $dt = DateTime::createFromFormat('!m', $i);
            $month_options[] = array('label' => ___($dt->format('F')), 'value' => $i);
        }
        // Day
        for ($i = 1; $i <= 31; $i++) {
            $day_options[] = array('label' => $i, 'value' => $i);
        }
        if (is_date($value, 'Y-m-d') || is_date($value, 'Y-m-d H:i:s')) {
            $tmp_stamp = strtotime($value);
            $value_month = date('m', $tmp_stamp);
            $value_day = date('d', $tmp_stamp);
            $value_year = date('Y', $tmp_stamp);
        } else {
            $value_day = fpost_uint($input_name . '_day');
            $value_month = fpost_uint($input_name . '_month');
            $value_year = fpost_uint($input_name . '_year');
        }

        $div = \__HTML::DIV_start($default_row_attr) . "\n";
        // year
        $div.= \__HTML::DIV_start($default_col_attr) . "\n";
        $div.= \INPUT::SELECT($input_name . '_year', $year_options, $value_year, $default_select_attr) . "\n";
        $div.= \__HTML::DIV_end() . "\n";
        // month
        $div.= \__HTML::DIV_start($default_col_attr) . "\n";
        $div.= \INPUT::SELECT($input_name . '_month', $month_options, $value_month, $default_select_attr) . "\n";
        $div.= \__HTML::DIV_end() . "\n";
        // day
        $div.= \__HTML::DIV_start($default_col_attr) . "\n";
        $div.= \INPUT::SELECT($input_name . '_day', $day_options, $value_day, $default_select_attr) . "\n";
        $div.= \__HTML::DIV_end() . "\n";
        $div.= \__HTML::DIV_end() . "\n";

        return $div;
    }
    
    /**
     * Returns a form-formatted field based on CMS object options (e.g. item/category options))
     * The parameter 'values' is an array in a serialized string format
     * @param string $form_input_name
     * @param array $meta_option_keys
     * @param string $values
     * @param array $default_values
     * @param int $max_item_per_column
     * @param int $column_count
     * @return string
     */
    public static function CMSObjectOptions($form_input_name, $meta_option_keys, $values, $default_values = [], $max_item_per_column = 0, $column_count = 0)
    {
        $column_count = abs( (int) $column_count);
        
        if (is_serialized($default_values))
            $default_values = safe_unserialize_array($default_values) ;
        else if (!is_array($default_values))
            $default_values = [];
        
        $value_array = null;
        if (is_serialized($values))
            $value_array = safe_unserialize_array ($values);
        else if (is_array($values))
            $value_array = $values;
        else 
            $value_array =  $default_values;

        $result = '';
        
        $use_columns = ($column_count > 0 && $max_item_per_column > 0);
        $column_size = $use_columns ? floor (12.0/$column_count) : 12;
        /*if ($column_count >0)
            $result.= \__HTML::DIV_start(array('class' => row));*/
        $col_at_count = 0;
        $item_in_column_count = 0;
        $start_new_row = true;
        $start_new_column = true;
        $row_still_open = true;
        $column_still_open = true;
        foreach ($meta_option_keys as $option_section)
        {
            if ($use_columns)
            {
                if ($start_new_row)
                {
                    $result.= \__HTML::DIV_start(array('class' => 'row'))."\n\n"; 
                    $row_still_open = true;
                    $col_at_count = 0;
                }
                if ($start_new_column)
                {
                    $item_in_column_count = 0;
                    $result.= \__HTML::DIV_start(array('class'=>'col-sm-'.$column_size))."\n"; 
                    $column_still_open = true;
                }
            }
            //////////// start code /////////////
            $opt_type = isset($option_section['type']) ? $option_section['type'] : null;
            switch ($opt_type)
            {
                case 'checkboxgroup':
                    $result.= \INPUT::CHECKBOX_GROUP($form_input_name, $option_section['options'], $value_array, $option_section['label'], null, 'label','key')."\n";
                    break;
                case 'dropdownlist':
                    $current_value = array_key_exists($option_section['key'], $value_array) ?  $value_array[$option_section['key']] : '';                    
                    $result.= \__HTML::LABEL($option_section['label'],
                        \INPUT::SELECT("{$form_input_name}[{$option_section['key']}]", $option_section['options'],  $current_value,
                                         array('class' => 'form-control'),'label','key'))."\n";
                    break;
                case 'radiogroup':                    
                    $current_value = array_key_exists($option_section['key'], $value_array) ?  $value_array[$option_section['key']] : ''; 
                    $result.= \INPUT::RADIO_GROUP("{$form_input_name}[{$option_section['key']}]", $option_section['options'], $current_value, $option_section['label'], null, 'label','key')."\n";
                    break;        
                default:
                    
                    if ($option_section['options'])
                    {
                    $result.= \__HTML::FIELDSET_start()."\n";
                    $result.= \__HTML::LEGEND($option_section['label'])."\n";
                    
                    foreach ($option_section['options'] as $option_sub_section)
                    {
                        $current_value = array_key_exists($option_sub_section['key'], $value_array) ?  $value_array[$option_sub_section['key']] : '';                    
                        switch ($option_sub_section['type'])
                        {
                            case 'dropdownlist':                            
                                $result.= 
                                     \__HTML::LABEL($option_sub_section['label'],
                                     \INPUT::SELECT("{$form_input_name}[{$option_sub_section['key']}]", $option_sub_section['options'], $current_value,
                                         array('class' => 'form-control'),'label','key')).\__HTML::BR()."\n";
                                break;
                            case 'radiogroup':
                                $result.= 
                                     \__HTML::STRONG($option_sub_section['label']).
                                     \INPUT::RADIO_GROUP("{$form_input_name}[{$option_sub_section['key']}]", $option_sub_section['options'], $current_value,  '', [], 'label','key')."\n";
                                break;
                        }
                    }
                    $result.= \__HTML::FIELDSET_end()."\n";
                    } else 
                    {
                        //print_r($option_section);die;
                    }
                    
                    break;
            }
            /////////////// end code //////////////
            
            if ($use_columns)
            {       
                $item_in_column_count++;
                
                if ($start_new_row)
                {
                    $start_new_row = false;
                }
                if ($start_new_column)
                {
                    $start_new_column = false;
                }
                
                if ($item_in_column_count >= $max_item_per_column)
                {
                    $result.= \__HTML::DIV_end()."\n\n";
                    $column_still_open = false;
                    $start_new_column = true;
                    $col_at_count++;
                }
                if ($col_at_count >= $column_count)
                {
                    $result.= \__HTML::DIV_end()."\n"; 
                    $row_still_open = false;
                    $start_new_row = true;
                    
                }
                
                
            }
        }
        
        if ($use_columns)
        {
            if ($column_still_open)
            {
                $result.= \__HTML::DIV_end()."\n";             
            }
            
            if ($row_still_open)
            {
                $result.= \__HTML::DIV_end()."\n";             
            }
        }
        
        /*if ($column_count >0)
            $result.= \__HTML::DIV_end();*/
        
        return $result;
    }
    

    //_________________________________________________________________________//
    public static function TimeZoneSelectList($input_name, $value, $attributes = []) {

        $data = get_sorted_timezone_data();
        
        // now display
        $result = \INPUT::SELECT_start($input_name, $attributes);
        foreach (array_keys($data) as $gmt) {
            $result.= \INPUT::OPTGROUP_start($gmt);
            foreach ($data[$gmt]['places'] as $place) {
                $selected = (strval($value) && ($value == $place)) ? 'selected' : '';
                $result.=\INPUT::OPTION($place, $place, array('selected' => $selected));
            }
            $result.= \INPUT::OPTGROUP_end();
        }

        $result.= \INPUT::SELECT_end();
        return $result;
    }    
    
    //_______________________________________________________________________________________________________________//
    /**
     * Returns a select list containing username
     * @global \App\Users $CurrentUser
     * @param string $fieldname
     * @param string $value
     * @param string $label
     * @param bool $allow_empty
     */
    public static function UserNameSelectionField($fieldname, $value, $label = '', $attributes = []) {
        
        global $CurrentUser;
        
        $all_users = $CurrentUser->getAllItems();
        $user_options_array = [];
        foreach ($all_users as $user)
        {
            $name = $user['username'].' ('.$user['firstname'].' '.$user['lastname'].')';
            $user_options_array[] = array('label' => $name, 'value' => $user[$CurrentUser->getFieldID()]);
        }
        // in case nullified
        if ($attributes == null) $attributes = [];
        $attributes['id'] = $fieldname;
        return \__HTML::LABEL($label, \INPUT::SELECT($fieldname, $user_options_array, $value, $attributes));
    }
    
 
    //_______________________________________________________________________________________________________________//
    /**
     * Returns a checkbox group containing a list of user groups/roles for read permission (Everyone option appears here)
     * @global \App\Users $CurrentUser
     * @param string $permission_name
     * @param string $serialized_permission_value
     * @return string
     */
    public static function UserGroupReadPermissionCheckboxGroup($permission_name, $serialized_permission_value) {

        global $CurrentUser;
        
        $field_category_id = $CurrentUser->getFieldCategoryID();
        $field_groupname = $CurrentUser->getFieldGroupName();
        
        $result = '';
        $checked = false;
        $read_permission_groups = $CurrentUser->getAllCategories("`{$field_category_id}`,`{$field_groupname}`", 0, 0, $field_category_id, 'ASC', "{$field_groupname} <> '" . SCHLIX_DEFAULT_ADMIN_GROUP . "'");
        $result.= "<!-- permission {$permission_name} -->\n";
        if (is_string($serialized_permission_value))
            $permission = unserialize($serialized_permission_value);
        elseif (___c($serialized_permission_value) > 0)
            $permission = $serialized_permission_value;
        $checked = ($serialized_permission_value == '' || $permission == 'everyone');
        if ($serialized_permission_value == '')
            $permission = []; // Aug 23, 2010 - bugfix warning        
        $attr = array('id' => "chk_permission_{$permission_name}_everyone", 'onclick' => "javascript:schlix_toggle_readpermission_check_everyone('{$permission_name}');");
        $input_control = \INPUT::CHECKBOX("permission_{$permission_name}_everyone", 'everyone', $checked, $attr);
        $result.= \__HTML::DIV_start(array('class'=>'checkbox')).\__HTML::LABEL(___('Everyone'), $input_control, '', '', false) .\__HTML::DIV_end() . "\n";        
        if ($read_permission_groups)
        foreach ($read_permission_groups as $group) {
            $checked = ((empty($permission) || $permission == 'everyone' || 
                    (is_array($permission) && in_array($group[$field_category_id], $permission) ) ));

            $attr = array('id' => "chk_permission_{$permission_name}_{$group[$field_category_id]}",
                'class' => 'validate-one-required',
                'onclick' => "javascript:schlix_toggle_readpermission_check(this.id,'{$permission_name}');",
                'value' => $group[$field_category_id]);
            $input_control = \INPUT::CHECKBOX("permission_{$permission_name}[]", $group[$field_category_id], $checked, $attr);

            $result.=  \__HTML::DIV_start(array('class'=>'checkbox')).\__HTML::LABEL($group['groupname'], $input_control, '', '', false).\__HTML::DIV_end();
            
        }
        $result.= "<!-- end permission {$permission_name} -->\n";
        return $result;
    }
   
    //_______________________________________________________________________________________________________________//
    /**
     * Returns a checkbox group containing a list of user groups/roles for write permission (Everyone option won't appear)
     * @global \App\Users $CurrentUser
     * @param string $permission_name
     * @param string $serialized_permission_value
     * @param array $current_user_groups
     * @param bool $enable_current_user_group
     * @return string
     */
    public static function UserGroupWritePermissionCheckboxGroup($permission_name, $serialized_permission_value, $current_user_groups, $enable_current_user_group = true) {
        global $CurrentUser;
        
        //$permission = @unserialize($serialized_permission_value);
        $permission = null;
        if (is_string($serialized_permission_value))
            $permission = safe_unserialize_array ($serialized_permission_value);
        elseif (___c($serialized_permission_value) > 0)
            $permission = $serialized_permission_value;
        
        if ($permission == null) {
            $permission = []; // to prevent PHP warning (June 12, 2010)
        }        
        $result = '';
        $field_category_id = $CurrentUser->getFieldCategoryID();
        $field_groupname = $CurrentUser->getFieldGroupName();
        $write_permission_groups = $CurrentUser->getAllCategories("`{$field_category_id}`,`{$field_groupname}`");
        foreach ($write_permission_groups as $group) {
            $same_group = false;
            foreach ($current_user_groups as $user_group)
                if ($group[$field_category_id] == $user_group[$field_category_id]) {
                    $same_group = true;
                    break;
                }
            $checked = (($enable_current_user_group && $same_group) || $group[$field_groupname] == SCHLIX_DEFAULT_ADMIN_GROUP || 
                    (is_array($permission) && in_array($group[$field_category_id], $permission)) );

            $attr = array('id' => "chk_permission_{$permission_name}_{$group[$field_category_id]}",
                'class' => 'validate-one-required',
                'value' => $group[$field_category_id]);
            if ($group[$field_groupname] == SCHLIX_DEFAULT_ADMIN_GROUP)
                $attr ['onclick'] = "javascript:return false";
            $input_control = \INPUT::CHECKBOX("permission_{$permission_name}[]", $group[$field_category_id], $checked, $attr);
            $result.=  \__HTML::DIV_start(array('class'=>'checkbox')).\__HTML::LABEL($group['groupname'], $input_control, '', '', false).\__HTML::DIV_end();
        }
        return $result;
        
    }
}
        
