<?php
namespace SCHLIX;

/**
 * The purpose of this class is to ease integration with 3rd party CSS frameworks
 * such as Bootstrap, Bulma, Zurb, Semantic UI
 */
abstract class cmsSkin
{
    
    protected $allowed_namespaces = ['x-ui'];
    /**
     * Name of this class
     * @var string 
     */
    protected $name = 'basic';
    
    /**
     * View and form data
     * @var array 
     */
    protected $data;
    /**
     *
     * @var \DOMDocument 
     */
    protected $html_document;
    
    /**
     * List of errors
     * @var array 
     */
    protected $errors;
    
    /**
     * String replacement table
     * @var array
     */
    
    protected $replacements = [];
    
    /**
     * schlix-config workaround for backwared compatibility
     * @var array
     */
    protected $sc_replacements = [];
    
    /**
     * This is set if the form has warning
     * @var bool 
     */
    protected $has_warning;
        
    public function __construct($allowed_namespaces, $viewdata) {
        if (___c($allowed_namespaces) > 0)
            $this->allowed_namespaces = $allowed_namespaces;
        $this->data = ___c($viewdata) > 0 ? $viewdata : array();
    }
    
    protected function cleanUpNameSpaces($html)
    {        
        
        $html = preg_replace('/xmlns[^=]*="[^"]*"/i', '', $html);
        foreach ($this->allowed_namespaces as $ns)
        {
            $html = str_replace("<$ns:",'<', $html); 
            $html = str_replace("</$ns:",'</', $html);
        }
        return $html;
    }
    
    protected function addNewClassNameToClassList($class_list, $new_class_name)
    {
        $result = '';
        $class_list = trim(strval($class_list));
        $new_class_name = trim(strval($new_class_name));
        if (!empty($class_list))
        {
            $class_list = preg_replace('/\s+/', ' ',$class_list);
            $arr_class_list = explode(" ", $class_list);
            if (is_string($new_class_name))
            {
                if (str_contains($new_class_name, ' '))
                {
                   $new_class_name = preg_replace('/\s+/', ' ',$new_class_name);
                   $arr_new_classes = explode(' ', $new_class_name);
                   $arr_class_list = array_merge($arr_class_list, $arr_new_classes);
                } else 
                    $arr_class_list[] = $new_class_name;
            }
            $arr_class_list = array_unique($arr_class_list);
            // new value
            return implode(' ', $arr_class_list);
        } else return $new_class_name;
        
    }
    
    /**
     * Encodes an array and return it as a string
     * @param array $array
     * @return string
     */
    public static function encodeArray($array)
    {
        return base64_encode(json_encode($array));
    }
    
    /**
     * Decodes a base-64, JSON-encoded array
     * @param string $str
     * @return array
     */
    public static function decodeArray($str)
    {
        return json_decode(base64_decode($str), true);
    }
    
    /**
     * Add class attribute
     * @param string $value
     * @param array $attributes
     * @return string
     */
    protected  function addClassAttribute($value, $attributes)
    {
        return $this->addStringAttribute($attributes, 'class', $value);
    }
    
    /**
     * Add a string attribute
     * @param string $attributes
     * @param string $key
     * @param string $value
     * @return string
     */
    protected  function addStringAttribute($attributes, $key, $value )
    {
        if (is_array($attributes)  && array_key_exists($key, $attributes))
        {
            $prev_value = trim(strval($attributes[$key]));
            if (!empty($prev_value))
            {
                $prev_value = preg_replace('/\s+/', ' ',$prev_value);
                $arr_prev_value = explode(" ", $prev_value);
                $arr_prev_value[] = $value;
                $arr_prev_value = array_unique($arr_prev_value);
                // new value
                $attributes[$key] = implode(" ", $arr_prev_value);
            } else 
            $attributes[$key] = $value;
        } else 
        {      
            
            if ($attributes == null)
                $attributes = [];
            $attributes[$key] = $value;
        }
        return $attributes;
    }
    
    
    /**
     * Convert HTML fragment into XML
     * @param string $html
     * @return \SimpleXMLElement
     */
    protected function loadHTMLAsXML($html, $add_xui_ns = true)
    {        
        $xml_header = "<?xml version='1.0' encoding='utf-8'?>".'<!DOCTYPE root [<!ENTITY Tab "&#9;"><!ENTITY NewLine "&#10;"><!ENTITY excl "&#33;"><!ENTITY quot "&#34;"><!ENTITY QUOT "&#34;"><!ENTITY num "&#35;"><!ENTITY dollar "&#36;"><!ENTITY percnt "&#37;"><!ENTITY amp "&#38;#38;"><!ENTITY AMP "&#38;#38;"><!ENTITY apos "&#39;"><!ENTITY lpar "&#40;"><!ENTITY rpar "&#41;"><!ENTITY ast "&#42;"><!ENTITY midast "&#42;"><!ENTITY plus "&#43;"><!ENTITY comma "&#44;"><!ENTITY period "&#46;"><!ENTITY sol "&#47;"><!ENTITY colon "&#58;"><!ENTITY semi "&#59;"><!ENTITY lt "&#38;#60;"><!ENTITY LT "&#38;#60;"><!ENTITY equals "&#61;"><!ENTITY gt "&#62;"><!ENTITY GT "&#62;"><!ENTITY quest "&#63;"><!ENTITY commat "&#64;"><!ENTITY lsqb "&#91;"><!ENTITY lbrack "&#91;"><!ENTITY bsol "&#92;"><!ENTITY rsqb "&#93;"><!ENTITY rbrack "&#93;"><!ENTITY Hat "&#94;"><!ENTITY lowbar "&#95;"><!ENTITY grave "&#96;"><!ENTITY DiacriticalGrave "&#96;"><!ENTITY lcub "&#123;"><!ENTITY lbrace "&#123;"><!ENTITY verbar "&#124;"><!ENTITY vert "&#124;"><!ENTITY VerticalLine "&#124;"><!ENTITY rcub "&#125;"><!ENTITY rbrace "&#125;"><!ENTITY nbsp "&#160;"><!ENTITY NonBreakingSpace "&#160;"><!ENTITY iexcl "&#161;"><!ENTITY cent "&#162;"><!ENTITY pound "&#163;"><!ENTITY curren "&#164;"><!ENTITY yen "&#165;"><!ENTITY brvbar "&#166;"><!ENTITY sect "&#167;"><!ENTITY Dot "&#168;"><!ENTITY die "&#168;"><!ENTITY DoubleDot "&#168;"><!ENTITY uml "&#168;"><!ENTITY copy "&#169;"><!ENTITY COPY "&#169;"><!ENTITY ordf "&#170;"><!ENTITY laquo "&#171;"><!ENTITY not "&#172;"><!ENTITY shy "&#173;"><!ENTITY reg "&#174;"><!ENTITY circledR "&#174;"><!ENTITY REG "&#174;"><!ENTITY macr "&#175;"><!ENTITY OverBar "&#175;"><!ENTITY strns "&#175;"><!ENTITY deg "&#176;"><!ENTITY plusmn "&#177;"><!ENTITY pm "&#177;"><!ENTITY PlusMinus "&#177;"><!ENTITY sup2 "&#178;"><!ENTITY sup3 "&#179;"><!ENTITY acute "&#180;"><!ENTITY DiacriticalAcute "&#180;"><!ENTITY micro "&#181;"><!ENTITY para "&#182;"><!ENTITY middot "&#183;"><!ENTITY centerdot "&#183;"><!ENTITY CenterDot "&#183;"><!ENTITY cedil "&#184;"><!ENTITY Cedilla "&#184;"><!ENTITY sup1 "&#185;"><!ENTITY ordm "&#186;"><!ENTITY raquo "&#187;"><!ENTITY frac14 "&#188;"><!ENTITY frac12 "&#189;"><!ENTITY half "&#189;"><!ENTITY frac34 "&#190;"><!ENTITY iquest "&#191;"><!ENTITY Agrave "&#192;"><!ENTITY Aacute "&#193;"><!ENTITY Acirc "&#194;"><!ENTITY Atilde "&#195;"><!ENTITY Auml "&#196;"><!ENTITY Aring "&#197;"><!ENTITY AElig "&#198;"><!ENTITY Ccedil "&#199;"><!ENTITY Egrave "&#200;"><!ENTITY Eacute "&#201;"><!ENTITY Ecirc "&#202;"><!ENTITY Euml "&#203;"><!ENTITY Igrave "&#204;"><!ENTITY Iacute "&#205;"><!ENTITY Icirc "&#206;"><!ENTITY Iuml "&#207;"><!ENTITY ETH "&#208;"><!ENTITY Ntilde "&#209;"><!ENTITY Ograve "&#210;"><!ENTITY Oacute "&#211;"><!ENTITY Ocirc "&#212;"><!ENTITY Otilde "&#213;"><!ENTITY Ouml "&#214;"><!ENTITY times "&#215;"><!ENTITY Oslash "&#216;"><!ENTITY Ugrave "&#217;"><!ENTITY Uacute "&#218;"><!ENTITY Ucirc "&#219;"><!ENTITY Uuml "&#220;"><!ENTITY Yacute "&#221;"><!ENTITY THORN "&#222;"><!ENTITY szlig "&#223;"><!ENTITY agrave "&#224;"><!ENTITY aacute "&#225;"><!ENTITY acirc "&#226;"><!ENTITY atilde "&#227;"><!ENTITY auml "&#228;"><!ENTITY aring "&#229;"><!ENTITY aelig "&#230;"><!ENTITY ccedil "&#231;"><!ENTITY egrave "&#232;"><!ENTITY eacute "&#233;"><!ENTITY ecirc "&#234;"><!ENTITY euml "&#235;"><!ENTITY igrave "&#236;"><!ENTITY iacute "&#237;"><!ENTITY icirc "&#238;"><!ENTITY iuml "&#239;"><!ENTITY eth "&#240;"><!ENTITY ntilde "&#241;"><!ENTITY ograve "&#242;"><!ENTITY oacute "&#243;"><!ENTITY ocirc "&#244;"><!ENTITY otilde "&#245;"><!ENTITY ouml "&#246;"><!ENTITY divide "&#247;"><!ENTITY div "&#247;"><!ENTITY oslash "&#248;"><!ENTITY ugrave "&#249;"><!ENTITY uacute "&#250;"><!ENTITY ucirc "&#251;"><!ENTITY uuml "&#252;"><!ENTITY yacute "&#253;"><!ENTITY thorn "&#254;"><!ENTITY yuml "&#255;"><!ENTITY Amacr "&#256;"><!ENTITY amacr "&#257;"><!ENTITY Abreve "&#258;"><!ENTITY abreve "&#259;"><!ENTITY Aogon "&#260;"><!ENTITY aogon "&#261;"><!ENTITY Cacute "&#262;"><!ENTITY cacute "&#263;"><!ENTITY Ccirc "&#264;"><!ENTITY ccirc "&#265;"><!ENTITY Cdot "&#266;"><!ENTITY cdot "&#267;"><!ENTITY Ccaron "&#268;"><!ENTITY ccaron "&#269;"><!ENTITY Dcaron "&#270;"><!ENTITY dcaron "&#271;"><!ENTITY Dstrok "&#272;"><!ENTITY dstrok "&#273;"><!ENTITY Emacr "&#274;"><!ENTITY emacr "&#275;"><!ENTITY Edot "&#278;"><!ENTITY edot "&#279;"><!ENTITY Eogon "&#280;"><!ENTITY eogon "&#281;"><!ENTITY Ecaron "&#282;"><!ENTITY ecaron "&#283;"><!ENTITY Gcirc "&#284;"><!ENTITY gcirc "&#285;"><!ENTITY Gbreve "&#286;"><!ENTITY gbreve "&#287;"><!ENTITY Gdot "&#288;"><!ENTITY gdot "&#289;"><!ENTITY Gcedil "&#290;"><!ENTITY Hcirc "&#292;"><!ENTITY hcirc "&#293;"><!ENTITY Hstrok "&#294;"><!ENTITY hstrok "&#295;"><!ENTITY Itilde "&#296;"><!ENTITY itilde "&#297;"><!ENTITY Imacr "&#298;"><!ENTITY imacr "&#299;"><!ENTITY Iogon "&#302;"><!ENTITY iogon "&#303;"><!ENTITY Idot "&#304;"><!ENTITY imath "&#305;"><!ENTITY inodot "&#305;"><!ENTITY IJlig "&#306;"><!ENTITY ijlig "&#307;"><!ENTITY Jcirc "&#308;"><!ENTITY jcirc "&#309;"><!ENTITY Kcedil "&#310;"><!ENTITY kcedil "&#311;"><!ENTITY kgreen "&#312;"><!ENTITY Lacute "&#313;"><!ENTITY lacute "&#314;"><!ENTITY Lcedil "&#315;"><!ENTITY lcedil "&#316;"><!ENTITY Lcaron "&#317;"><!ENTITY lcaron "&#318;"><!ENTITY Lmidot "&#319;"><!ENTITY lmidot "&#320;"><!ENTITY Lstrok "&#321;"><!ENTITY lstrok "&#322;"><!ENTITY Nacute "&#323;"><!ENTITY nacute "&#324;"><!ENTITY Ncedil "&#325;"><!ENTITY ncedil "&#326;"><!ENTITY Ncaron "&#327;"><!ENTITY ncaron "&#328;"><!ENTITY napos "&#329;"><!ENTITY ENG "&#330;"><!ENTITY eng "&#331;"><!ENTITY Omacr "&#332;"><!ENTITY omacr "&#333;"><!ENTITY Odblac "&#336;"><!ENTITY odblac "&#337;"><!ENTITY OElig "&#338;"><!ENTITY oelig "&#339;"><!ENTITY Racute "&#340;"><!ENTITY racute "&#341;"><!ENTITY Rcedil "&#342;"><!ENTITY rcedil "&#343;"><!ENTITY Rcaron "&#344;"><!ENTITY rcaron "&#345;"><!ENTITY Sacute "&#346;"><!ENTITY sacute "&#347;"><!ENTITY Scirc "&#348;"><!ENTITY scirc "&#349;"><!ENTITY Scedil "&#350;"><!ENTITY scedil "&#351;"><!ENTITY Scaron "&#352;"><!ENTITY scaron "&#353;"><!ENTITY Tcedil "&#354;"><!ENTITY tcedil "&#355;"><!ENTITY Tcaron "&#356;"><!ENTITY tcaron "&#357;"><!ENTITY Tstrok "&#358;"><!ENTITY tstrok "&#359;"><!ENTITY Utilde "&#360;"><!ENTITY utilde "&#361;"><!ENTITY Umacr "&#362;"><!ENTITY umacr "&#363;"><!ENTITY Ubreve "&#364;"><!ENTITY ubreve "&#365;"><!ENTITY Uring "&#366;"><!ENTITY uring "&#367;"><!ENTITY Udblac "&#368;"><!ENTITY udblac "&#369;"><!ENTITY Uogon "&#370;"><!ENTITY uogon "&#371;"><!ENTITY Wcirc "&#372;"><!ENTITY wcirc "&#373;"><!ENTITY Ycirc "&#374;"><!ENTITY ycirc "&#375;"><!ENTITY Yuml "&#376;"><!ENTITY Zacute "&#377;"><!ENTITY zacute "&#378;"><!ENTITY Zdot "&#379;"><!ENTITY zdot "&#380;"><!ENTITY Zcaron "&#381;"><!ENTITY zcaron "&#382;"><!ENTITY fnof "&#402;"><!ENTITY imped "&#437;"><!ENTITY gacute "&#501;"><!ENTITY jmath "&#567;"><!ENTITY circ "&#710;"><!ENTITY caron "&#711;"><!ENTITY Hacek "&#711;"><!ENTITY breve "&#728;"><!ENTITY Breve "&#728;"><!ENTITY dot "&#729;"><!ENTITY DiacriticalDot "&#729;"><!ENTITY ring "&#730;"><!ENTITY ogon "&#731;"><!ENTITY tilde "&#732;"><!ENTITY DiacriticalTilde "&#732;"><!ENTITY dblac "&#733;"><!ENTITY DiacriticalDoubleAcute "&#733;"><!ENTITY DownBreve "&#785;"><!ENTITY UnderBar "&#818;"><!ENTITY Alpha "&#913;"><!ENTITY Beta "&#914;"><!ENTITY Gamma "&#915;"><!ENTITY Delta "&#916;"><!ENTITY Epsilon "&#917;"><!ENTITY Zeta "&#918;"><!ENTITY Eta "&#919;"><!ENTITY Theta "&#920;"><!ENTITY Iota "&#921;"><!ENTITY Kappa "&#922;"><!ENTITY Lambda "&#923;"><!ENTITY Mu "&#924;"><!ENTITY Nu "&#925;"><!ENTITY Xi "&#926;"><!ENTITY Omicron "&#927;"><!ENTITY Pi "&#928;"><!ENTITY Rho "&#929;"><!ENTITY Sigma "&#931;"><!ENTITY Tau "&#932;"><!ENTITY Upsilon "&#933;"><!ENTITY Phi "&#934;"><!ENTITY Chi "&#935;"><!ENTITY Psi "&#936;"><!ENTITY Omega "&#937;"><!ENTITY alpha "&#945;"><!ENTITY beta "&#946;"><!ENTITY gamma "&#947;"><!ENTITY delta "&#948;"><!ENTITY epsiv "&#949;"><!ENTITY varepsilon "&#949;"><!ENTITY epsilon "&#949;"><!ENTITY zeta "&#950;"><!ENTITY eta "&#951;"><!ENTITY theta "&#952;"><!ENTITY iota "&#953;"><!ENTITY kappa "&#954;"><!ENTITY lambda "&#955;"><!ENTITY mu "&#956;"><!ENTITY nu "&#957;"><!ENTITY xi "&#958;"><!ENTITY omicron "&#959;"><!ENTITY pi "&#960;"><!ENTITY rho "&#961;"><!ENTITY sigmav "&#962;"><!ENTITY varsigma "&#962;"><!ENTITY sigmaf "&#962;"><!ENTITY sigma "&#963;"><!ENTITY tau "&#964;"><!ENTITY upsi "&#965;"><!ENTITY upsilon "&#965;"><!ENTITY phi "&#966;"><!ENTITY phiv "&#966;"><!ENTITY varphi "&#966;"><!ENTITY chi "&#967;"><!ENTITY psi "&#968;"><!ENTITY omega "&#969;"><!ENTITY thetav "&#977;"><!ENTITY vartheta "&#977;"><!ENTITY thetasym "&#977;"><!ENTITY Upsi "&#978;"><!ENTITY upsih "&#978;"><!ENTITY straightphi "&#981;"><!ENTITY piv "&#982;"><!ENTITY varpi "&#982;"><!ENTITY Gammad "&#988;"><!ENTITY gammad "&#989;"><!ENTITY digamma "&#989;"><!ENTITY kappav "&#1008;"><!ENTITY varkappa "&#1008;"><!ENTITY rhov "&#1009;"><!ENTITY varrho "&#1009;"><!ENTITY epsi "&#1013;"><!ENTITY straightepsilon "&#1013;"><!ENTITY bepsi "&#1014;"><!ENTITY backepsilon "&#1014;"><!ENTITY IOcy "&#1025;"><!ENTITY DJcy "&#1026;"><!ENTITY GJcy "&#1027;"><!ENTITY Jukcy "&#1028;"><!ENTITY DScy "&#1029;"><!ENTITY Iukcy "&#1030;"><!ENTITY YIcy "&#1031;"><!ENTITY Jsercy "&#1032;"><!ENTITY LJcy "&#1033;"><!ENTITY NJcy "&#1034;"><!ENTITY TSHcy "&#1035;"><!ENTITY KJcy "&#1036;"><!ENTITY Ubrcy "&#1038;"><!ENTITY DZcy "&#1039;"><!ENTITY Acy "&#1040;"><!ENTITY Bcy "&#1041;"><!ENTITY Vcy "&#1042;"><!ENTITY Gcy "&#1043;"><!ENTITY Dcy "&#1044;"><!ENTITY IEcy "&#1045;"><!ENTITY ZHcy "&#1046;"><!ENTITY Zcy "&#1047;"><!ENTITY Icy "&#1048;"><!ENTITY Jcy "&#1049;"><!ENTITY Kcy "&#1050;"><!ENTITY Lcy "&#1051;"><!ENTITY Mcy "&#1052;"><!ENTITY Ncy "&#1053;"><!ENTITY Ocy "&#1054;"><!ENTITY Pcy "&#1055;"><!ENTITY Rcy "&#1056;"><!ENTITY Scy "&#1057;"><!ENTITY Tcy "&#1058;"><!ENTITY Ucy "&#1059;"><!ENTITY Fcy "&#1060;"><!ENTITY KHcy "&#1061;"><!ENTITY TScy "&#1062;"><!ENTITY CHcy "&#1063;"><!ENTITY SHcy "&#1064;"><!ENTITY SHCHcy "&#1065;"><!ENTITY HARDcy "&#1066;"><!ENTITY Ycy "&#1067;"><!ENTITY SOFTcy "&#1068;"><!ENTITY Ecy "&#1069;"><!ENTITY YUcy "&#1070;"><!ENTITY YAcy "&#1071;"><!ENTITY acy "&#1072;"><!ENTITY bcy "&#1073;"><!ENTITY vcy "&#1074;"><!ENTITY gcy "&#1075;"><!ENTITY dcy "&#1076;"><!ENTITY iecy "&#1077;"><!ENTITY zhcy "&#1078;"><!ENTITY zcy "&#1079;"><!ENTITY icy "&#1080;"><!ENTITY jcy "&#1081;"><!ENTITY kcy "&#1082;"><!ENTITY lcy "&#1083;"><!ENTITY mcy "&#1084;"><!ENTITY ncy "&#1085;"><!ENTITY ocy "&#1086;"><!ENTITY pcy "&#1087;"><!ENTITY rcy "&#1088;"><!ENTITY scy "&#1089;"><!ENTITY tcy "&#1090;"><!ENTITY ucy "&#1091;"><!ENTITY fcy "&#1092;"><!ENTITY khcy "&#1093;"><!ENTITY tscy "&#1094;"><!ENTITY chcy "&#1095;"><!ENTITY shcy "&#1096;"><!ENTITY shchcy "&#1097;"><!ENTITY hardcy "&#1098;"><!ENTITY ycy "&#1099;"><!ENTITY softcy "&#1100;"><!ENTITY ecy "&#1101;"><!ENTITY yucy "&#1102;"><!ENTITY yacy "&#1103;"><!ENTITY iocy "&#1105;"><!ENTITY djcy "&#1106;"><!ENTITY gjcy "&#1107;"><!ENTITY jukcy "&#1108;"><!ENTITY dscy "&#1109;"><!ENTITY iukcy "&#1110;"><!ENTITY yicy "&#1111;"><!ENTITY jsercy "&#1112;"><!ENTITY ljcy "&#1113;"><!ENTITY njcy "&#1114;"><!ENTITY tshcy "&#1115;"><!ENTITY kjcy "&#1116;"><!ENTITY ubrcy "&#1118;"><!ENTITY dzcy "&#1119;"><!ENTITY ensp "&#8194;"><!ENTITY emsp "&#8195;"><!ENTITY emsp13 "&#8196;"><!ENTITY emsp14 "&#8197;"><!ENTITY numsp "&#8199;"><!ENTITY puncsp "&#8200;"><!ENTITY thinsp "&#8201;"><!ENTITY ThinSpace "&#8201;"><!ENTITY hairsp "&#8202;"><!ENTITY VeryThinSpace "&#8202;"><!ENTITY ZeroWidthSpace "&#8203;"><!ENTITY NegativeVeryThinSpace "&#8203;"><!ENTITY NegativeThinSpace "&#8203;"><!ENTITY NegativeMediumSpace "&#8203;"><!ENTITY NegativeThickSpace "&#8203;"><!ENTITY zwnj "&#8204;"><!ENTITY zwj "&#8205;"><!ENTITY lrm "&#8206;"><!ENTITY rlm "&#8207;"><!ENTITY hyphen "&#8208;"><!ENTITY dash "&#8208;"><!ENTITY ndash "&#8211;"><!ENTITY mdash "&#8212;"><!ENTITY horbar "&#8213;"><!ENTITY Verbar "&#8214;"><!ENTITY Vert "&#8214;"><!ENTITY lsquo "&#8216;"><!ENTITY OpenCurlyQuote "&#8216;"><!ENTITY rsquo "&#8217;"><!ENTITY rsquor "&#8217;"><!ENTITY CloseCurlyQuote "&#8217;"><!ENTITY lsquor "&#8218;"><!ENTITY sbquo "&#8218;"><!ENTITY ldquo "&#8220;"><!ENTITY OpenCurlyDoubleQuote "&#8220;"><!ENTITY rdquo "&#8221;"><!ENTITY rdquor "&#8221;"><!ENTITY CloseCurlyDoubleQuote "&#8221;"><!ENTITY ldquor "&#8222;"><!ENTITY bdquo "&#8222;"><!ENTITY dagger "&#8224;"><!ENTITY Dagger "&#8225;"><!ENTITY ddagger "&#8225;"><!ENTITY bull "&#8226;"><!ENTITY bullet "&#8226;"><!ENTITY nldr "&#8229;"><!ENTITY hellip "&#8230;"><!ENTITY mldr "&#8230;"><!ENTITY permil "&#8240;"><!ENTITY pertenk "&#8241;"><!ENTITY prime "&#8242;"><!ENTITY Prime "&#8243;"><!ENTITY tprime "&#8244;"><!ENTITY bprime "&#8245;"><!ENTITY backprime "&#8245;"><!ENTITY lsaquo "&#8249;"><!ENTITY rsaquo "&#8250;"><!ENTITY oline "&#8254;"><!ENTITY caret "&#8257;"><!ENTITY hybull "&#8259;"><!ENTITY frasl "&#8260;"><!ENTITY bsemi "&#8271;"><!ENTITY qprime "&#8279;"><!ENTITY MediumSpace "&#8287;"><!ENTITY NoBreak "&#8288;"><!ENTITY ApplyFunction "&#8289;"><!ENTITY af "&#8289;"><!ENTITY InvisibleTimes "&#8290;"><!ENTITY it "&#8290;"><!ENTITY InvisibleComma "&#8291;"><!ENTITY ic "&#8291;"><!ENTITY euro "&#8364;"><!ENTITY tdot "&#8411;"><!ENTITY TripleDot "&#8411;"><!ENTITY DotDot "&#8412;"><!ENTITY Copf "&#8450;"><!ENTITY complexes "&#8450;"><!ENTITY incare "&#8453;"><!ENTITY gscr "&#8458;"><!ENTITY hamilt "&#8459;"><!ENTITY HilbertSpace "&#8459;"><!ENTITY Hscr "&#8459;"><!ENTITY Hfr "&#8460;"><!ENTITY Poincareplane "&#8460;"><!ENTITY quaternions "&#8461;"><!ENTITY Hopf "&#8461;"><!ENTITY planckh "&#8462;"><!ENTITY planck "&#8463;"><!ENTITY hbar "&#8463;"><!ENTITY plankv "&#8463;"><!ENTITY hslash "&#8463;"><!ENTITY Iscr "&#8464;"><!ENTITY imagline "&#8464;"><!ENTITY image "&#8465;"><!ENTITY Im "&#8465;"><!ENTITY imagpart "&#8465;"><!ENTITY Ifr "&#8465;"><!ENTITY Lscr "&#8466;"><!ENTITY lagran "&#8466;"><!ENTITY Laplacetrf "&#8466;"><!ENTITY ell "&#8467;"><!ENTITY Nopf "&#8469;"><!ENTITY naturals "&#8469;"><!ENTITY numero "&#8470;"><!ENTITY copysr "&#8471;"><!ENTITY weierp "&#8472;"><!ENTITY wp "&#8472;"><!ENTITY Popf "&#8473;"><!ENTITY primes "&#8473;"><!ENTITY rationals "&#8474;"><!ENTITY Qopf "&#8474;"><!ENTITY Rscr "&#8475;"><!ENTITY realine "&#8475;"><!ENTITY real "&#8476;"><!ENTITY Re "&#8476;"><!ENTITY realpart "&#8476;"><!ENTITY Rfr "&#8476;"><!ENTITY reals "&#8477;"><!ENTITY Ropf "&#8477;"><!ENTITY rx "&#8478;"><!ENTITY trade "&#8482;"><!ENTITY TRADE "&#8482;"><!ENTITY integers "&#8484;"><!ENTITY Zopf "&#8484;"><!ENTITY ohm "&#8486;"><!ENTITY mho "&#8487;"><!ENTITY Zfr "&#8488;"><!ENTITY zeetrf "&#8488;"><!ENTITY iiota "&#8489;"><!ENTITY angst "&#8491;"><!ENTITY bernou "&#8492;"><!ENTITY Bernoullis "&#8492;"><!ENTITY Bscr "&#8492;"><!ENTITY Cfr "&#8493;"><!ENTITY Cayleys "&#8493;"><!ENTITY escr "&#8495;"><!ENTITY Escr "&#8496;"><!ENTITY expectation "&#8496;"><!ENTITY Fscr "&#8497;"><!ENTITY Fouriertrf "&#8497;"><!ENTITY phmmat "&#8499;"><!ENTITY Mellintrf "&#8499;"><!ENTITY Mscr "&#8499;"><!ENTITY order "&#8500;"><!ENTITY orderof "&#8500;"><!ENTITY oscr "&#8500;"><!ENTITY alefsym "&#8501;"><!ENTITY aleph "&#8501;"><!ENTITY beth "&#8502;"><!ENTITY gimel "&#8503;"><!ENTITY daleth "&#8504;"><!ENTITY CapitalDifferentialD "&#8517;"><!ENTITY DD "&#8517;"><!ENTITY DifferentialD "&#8518;"><!ENTITY dd "&#8518;"><!ENTITY ExponentialE "&#8519;"><!ENTITY exponentiale "&#8519;"><!ENTITY ee "&#8519;"><!ENTITY ImaginaryI "&#8520;"><!ENTITY ii "&#8520;"><!ENTITY frac13 "&#8531;"><!ENTITY frac23 "&#8532;"><!ENTITY frac15 "&#8533;"><!ENTITY frac25 "&#8534;"><!ENTITY frac35 "&#8535;"><!ENTITY frac45 "&#8536;"><!ENTITY frac16 "&#8537;"><!ENTITY frac56 "&#8538;"><!ENTITY frac18 "&#8539;"><!ENTITY frac38 "&#8540;"><!ENTITY frac58 "&#8541;"><!ENTITY frac78 "&#8542;"><!ENTITY larr "&#8592;"><!ENTITY leftarrow "&#8592;"><!ENTITY LeftArrow "&#8592;"><!ENTITY slarr "&#8592;"><!ENTITY ShortLeftArrow "&#8592;"><!ENTITY uarr "&#8593;"><!ENTITY uparrow "&#8593;"><!ENTITY UpArrow "&#8593;"><!ENTITY ShortUpArrow "&#8593;"><!ENTITY rarr "&#8594;"><!ENTITY rightarrow "&#8594;"><!ENTITY RightArrow "&#8594;"><!ENTITY srarr "&#8594;"><!ENTITY ShortRightArrow "&#8594;"><!ENTITY darr "&#8595;"><!ENTITY downarrow "&#8595;"><!ENTITY DownArrow "&#8595;"><!ENTITY ShortDownArrow "&#8595;"><!ENTITY harr "&#8596;"><!ENTITY leftrightarrow "&#8596;"><!ENTITY LeftRightArrow "&#8596;"><!ENTITY varr "&#8597;"><!ENTITY updownarrow "&#8597;"><!ENTITY UpDownArrow "&#8597;"><!ENTITY nwarr "&#8598;"><!ENTITY UpperLeftArrow "&#8598;"><!ENTITY nwarrow "&#8598;"><!ENTITY nearr "&#8599;"><!ENTITY UpperRightArrow "&#8599;"><!ENTITY nearrow "&#8599;"><!ENTITY searr "&#8600;"><!ENTITY searrow "&#8600;"><!ENTITY LowerRightArrow "&#8600;"><!ENTITY swarr "&#8601;"><!ENTITY swarrow "&#8601;"><!ENTITY LowerLeftArrow "&#8601;"><!ENTITY nlarr "&#8602;"><!ENTITY nleftarrow "&#8602;"><!ENTITY nrarr "&#8603;"><!ENTITY nrightarrow "&#8603;"><!ENTITY rarrw "&#8605;"><!ENTITY rightsquigarrow "&#8605;"><!ENTITY Larr "&#8606;"><!ENTITY twoheadleftarrow "&#8606;"><!ENTITY Uarr "&#8607;"><!ENTITY Rarr "&#8608;"><!ENTITY twoheadrightarrow "&#8608;"><!ENTITY Darr "&#8609;"><!ENTITY larrtl "&#8610;"><!ENTITY leftarrowtail "&#8610;"><!ENTITY rarrtl "&#8611;"><!ENTITY rightarrowtail "&#8611;"><!ENTITY LeftTeeArrow "&#8612;"><!ENTITY mapstoleft "&#8612;"><!ENTITY UpTeeArrow "&#8613;"><!ENTITY mapstoup "&#8613;"><!ENTITY map "&#8614;"><!ENTITY RightTeeArrow "&#8614;"><!ENTITY mapsto "&#8614;"><!ENTITY DownTeeArrow "&#8615;"><!ENTITY mapstodown "&#8615;"><!ENTITY larrhk "&#8617;"><!ENTITY hookleftarrow "&#8617;"><!ENTITY rarrhk "&#8618;"><!ENTITY hookrightarrow "&#8618;"><!ENTITY larrlp "&#8619;"><!ENTITY looparrowleft "&#8619;"><!ENTITY rarrlp "&#8620;"><!ENTITY looparrowright "&#8620;"><!ENTITY harrw "&#8621;"><!ENTITY leftrightsquigarrow "&#8621;"><!ENTITY nharr "&#8622;"><!ENTITY nleftrightarrow "&#8622;"><!ENTITY lsh "&#8624;"><!ENTITY Lsh "&#8624;"><!ENTITY rsh "&#8625;"><!ENTITY Rsh "&#8625;"><!ENTITY ldsh "&#8626;"><!ENTITY rdsh "&#8627;"><!ENTITY crarr "&#8629;"><!ENTITY cularr "&#8630;"><!ENTITY curvearrowleft "&#8630;"><!ENTITY curarr "&#8631;"><!ENTITY curvearrowright "&#8631;"><!ENTITY olarr "&#8634;"><!ENTITY circlearrowleft "&#8634;"><!ENTITY orarr "&#8635;"><!ENTITY circlearrowright "&#8635;"><!ENTITY lharu "&#8636;"><!ENTITY LeftVector "&#8636;"><!ENTITY leftharpoonup "&#8636;"><!ENTITY lhard "&#8637;"><!ENTITY leftharpoondown "&#8637;"><!ENTITY DownLeftVector "&#8637;"><!ENTITY uharr "&#8638;"><!ENTITY upharpoonright "&#8638;"><!ENTITY RightUpVector "&#8638;"><!ENTITY uharl "&#8639;"><!ENTITY upharpoonleft "&#8639;"><!ENTITY LeftUpVector "&#8639;"><!ENTITY rharu "&#8640;"><!ENTITY RightVector "&#8640;"><!ENTITY rightharpoonup "&#8640;"><!ENTITY rhard "&#8641;"><!ENTITY rightharpoondown "&#8641;"><!ENTITY DownRightVector "&#8641;"><!ENTITY dharr "&#8642;"><!ENTITY RightDownVector "&#8642;"><!ENTITY downharpoonright "&#8642;"><!ENTITY dharl "&#8643;"><!ENTITY LeftDownVector "&#8643;"><!ENTITY downharpoonleft "&#8643;"><!ENTITY rlarr "&#8644;"><!ENTITY rightleftarrows "&#8644;"><!ENTITY RightArrowLeftArrow "&#8644;"><!ENTITY udarr "&#8645;"><!ENTITY UpArrowDownArrow "&#8645;"><!ENTITY lrarr "&#8646;"><!ENTITY leftrightarrows "&#8646;"><!ENTITY LeftArrowRightArrow "&#8646;"><!ENTITY llarr "&#8647;"><!ENTITY leftleftarrows "&#8647;"><!ENTITY uuarr "&#8648;"><!ENTITY upuparrows "&#8648;"><!ENTITY rrarr "&#8649;"><!ENTITY rightrightarrows "&#8649;"><!ENTITY ddarr "&#8650;"><!ENTITY downdownarrows "&#8650;"><!ENTITY lrhar "&#8651;"><!ENTITY ReverseEquilibrium "&#8651;"><!ENTITY leftrightharpoons "&#8651;"><!ENTITY rlhar "&#8652;"><!ENTITY rightleftharpoons "&#8652;"><!ENTITY Equilibrium "&#8652;"><!ENTITY nlArr "&#8653;"><!ENTITY nLeftarrow "&#8653;"><!ENTITY nhArr "&#8654;"><!ENTITY nLeftrightarrow "&#8654;"><!ENTITY nrArr "&#8655;"><!ENTITY nRightarrow "&#8655;"><!ENTITY lArr "&#8656;"><!ENTITY Leftarrow "&#8656;"><!ENTITY DoubleLeftArrow "&#8656;"><!ENTITY uArr "&#8657;"><!ENTITY Uparrow "&#8657;"><!ENTITY DoubleUpArrow "&#8657;"><!ENTITY rArr "&#8658;"><!ENTITY Rightarrow "&#8658;"><!ENTITY Implies "&#8658;"><!ENTITY DoubleRightArrow "&#8658;"><!ENTITY dArr "&#8659;"><!ENTITY Downarrow "&#8659;"><!ENTITY DoubleDownArrow "&#8659;"><!ENTITY hArr "&#8660;"><!ENTITY Leftrightarrow "&#8660;"><!ENTITY DoubleLeftRightArrow "&#8660;"><!ENTITY iff "&#8660;"><!ENTITY vArr "&#8661;"><!ENTITY Updownarrow "&#8661;"><!ENTITY DoubleUpDownArrow "&#8661;"><!ENTITY nwArr "&#8662;"><!ENTITY neArr "&#8663;"><!ENTITY seArr "&#8664;"><!ENTITY swArr "&#8665;"><!ENTITY lAarr "&#8666;"><!ENTITY Lleftarrow "&#8666;"><!ENTITY rAarr "&#8667;"><!ENTITY Rrightarrow "&#8667;"><!ENTITY zigrarr "&#8669;"><!ENTITY larrb "&#8676;"><!ENTITY LeftArrowBar "&#8676;"><!ENTITY rarrb "&#8677;"><!ENTITY RightArrowBar "&#8677;"><!ENTITY duarr "&#8693;"><!ENTITY DownArrowUpArrow "&#8693;"><!ENTITY loarr "&#8701;"><!ENTITY roarr "&#8702;"><!ENTITY hoarr "&#8703;"><!ENTITY forall "&#8704;"><!ENTITY ForAll "&#8704;"><!ENTITY comp "&#8705;"><!ENTITY complement "&#8705;"><!ENTITY part "&#8706;"><!ENTITY PartialD "&#8706;"><!ENTITY exist "&#8707;"><!ENTITY Exists "&#8707;"><!ENTITY nexist "&#8708;"><!ENTITY NotExists "&#8708;"><!ENTITY nexists "&#8708;"><!ENTITY empty "&#8709;"><!ENTITY emptyset "&#8709;"><!ENTITY emptyv "&#8709;"><!ENTITY varnothing "&#8709;"><!ENTITY nabla "&#8711;"><!ENTITY Del "&#8711;"><!ENTITY isin "&#8712;"><!ENTITY isinv "&#8712;"><!ENTITY Element "&#8712;"><!ENTITY in "&#8712;"><!ENTITY notin "&#8713;"><!ENTITY NotElement "&#8713;"><!ENTITY notinva "&#8713;"><!ENTITY niv "&#8715;"><!ENTITY ReverseElement "&#8715;"><!ENTITY ni "&#8715;"><!ENTITY SuchThat "&#8715;"><!ENTITY notni "&#8716;"><!ENTITY notniva "&#8716;"><!ENTITY NotReverseElement "&#8716;"><!ENTITY prod "&#8719;"><!ENTITY Product "&#8719;"><!ENTITY coprod "&#8720;"><!ENTITY Coproduct "&#8720;"><!ENTITY sum "&#8721;"><!ENTITY Sum "&#8721;"><!ENTITY minus "&#8722;"><!ENTITY mnplus "&#8723;"><!ENTITY mp "&#8723;"><!ENTITY MinusPlus "&#8723;"><!ENTITY plusdo "&#8724;"><!ENTITY dotplus "&#8724;"><!ENTITY setmn "&#8726;"><!ENTITY setminus "&#8726;"><!ENTITY Backslash "&#8726;"><!ENTITY ssetmn "&#8726;"><!ENTITY smallsetminus "&#8726;"><!ENTITY lowast "&#8727;"><!ENTITY compfn "&#8728;"><!ENTITY SmallCircle "&#8728;"><!ENTITY radic "&#8730;"><!ENTITY Sqrt "&#8730;"><!ENTITY prop "&#8733;"><!ENTITY propto "&#8733;"><!ENTITY Proportional "&#8733;"><!ENTITY vprop "&#8733;"><!ENTITY varpropto "&#8733;"><!ENTITY infin "&#8734;"><!ENTITY angrt "&#8735;"><!ENTITY ang "&#8736;"><!ENTITY angle "&#8736;"><!ENTITY angmsd "&#8737;"><!ENTITY measuredangle "&#8737;"><!ENTITY angsph "&#8738;"><!ENTITY mid "&#8739;"><!ENTITY VerticalBar "&#8739;"><!ENTITY smid "&#8739;"><!ENTITY shortmid "&#8739;"><!ENTITY nmid "&#8740;"><!ENTITY NotVerticalBar "&#8740;"><!ENTITY nsmid "&#8740;"><!ENTITY nshortmid "&#8740;"><!ENTITY par "&#8741;"><!ENTITY parallel "&#8741;"><!ENTITY DoubleVerticalBar "&#8741;"><!ENTITY spar "&#8741;"><!ENTITY shortparallel "&#8741;"><!ENTITY npar "&#8742;"><!ENTITY nparallel "&#8742;"><!ENTITY NotDoubleVerticalBar "&#8742;"><!ENTITY nspar "&#8742;"><!ENTITY nshortparallel "&#8742;"><!ENTITY and "&#8743;"><!ENTITY wedge "&#8743;"><!ENTITY or "&#8744;"><!ENTITY vee "&#8744;"><!ENTITY cap "&#8745;"><!ENTITY cup "&#8746;"><!ENTITY int "&#8747;"><!ENTITY Integral "&#8747;"><!ENTITY Int "&#8748;"><!ENTITY tint "&#8749;"><!ENTITY iiint "&#8749;"><!ENTITY conint "&#8750;"><!ENTITY oint "&#8750;"><!ENTITY ContourIntegral "&#8750;"><!ENTITY Conint "&#8751;"><!ENTITY DoubleContourIntegral "&#8751;"><!ENTITY Cconint "&#8752;"><!ENTITY cwint "&#8753;"><!ENTITY cwconint "&#8754;"><!ENTITY ClockwiseContourIntegral "&#8754;"><!ENTITY awconint "&#8755;"><!ENTITY CounterClockwiseContourIntegral "&#8755;"><!ENTITY there4 "&#8756;"><!ENTITY therefore "&#8756;"><!ENTITY Therefore "&#8756;"><!ENTITY becaus "&#8757;"><!ENTITY because "&#8757;"><!ENTITY Because "&#8757;"><!ENTITY ratio "&#8758;"><!ENTITY Colon "&#8759;"><!ENTITY Proportion "&#8759;"><!ENTITY minusd "&#8760;"><!ENTITY dotminus "&#8760;"><!ENTITY mDDot "&#8762;"><!ENTITY homtht "&#8763;"><!ENTITY sim "&#8764;"><!ENTITY Tilde "&#8764;"><!ENTITY thksim "&#8764;"><!ENTITY thicksim "&#8764;"><!ENTITY bsim "&#8765;"><!ENTITY backsim "&#8765;"><!ENTITY ac "&#8766;"><!ENTITY mstpos "&#8766;"><!ENTITY acd "&#8767;"><!ENTITY wreath "&#8768;"><!ENTITY VerticalTilde "&#8768;"><!ENTITY wr "&#8768;"><!ENTITY nsim "&#8769;"><!ENTITY NotTilde "&#8769;"><!ENTITY esim "&#8770;"><!ENTITY EqualTilde "&#8770;"><!ENTITY eqsim "&#8770;"><!ENTITY sime "&#8771;"><!ENTITY TildeEqual "&#8771;"><!ENTITY simeq "&#8771;"><!ENTITY nsime "&#8772;"><!ENTITY nsimeq "&#8772;"><!ENTITY NotTildeEqual "&#8772;"><!ENTITY cong "&#8773;"><!ENTITY TildeFullEqual "&#8773;"><!ENTITY simne "&#8774;"><!ENTITY ncong "&#8775;"><!ENTITY NotTildeFullEqual "&#8775;"><!ENTITY asymp "&#8776;"><!ENTITY ap "&#8776;"><!ENTITY TildeTilde "&#8776;"><!ENTITY approx "&#8776;"><!ENTITY thkap "&#8776;"><!ENTITY thickapprox "&#8776;"><!ENTITY nap "&#8777;"><!ENTITY NotTildeTilde "&#8777;"><!ENTITY napprox "&#8777;"><!ENTITY ape "&#8778;"><!ENTITY approxeq "&#8778;"><!ENTITY apid "&#8779;"><!ENTITY bcong "&#8780;"><!ENTITY backcong "&#8780;"><!ENTITY asympeq "&#8781;"><!ENTITY CupCap "&#8781;"><!ENTITY bump "&#8782;"><!ENTITY HumpDownHump "&#8782;"><!ENTITY Bumpeq "&#8782;"><!ENTITY bumpe "&#8783;"><!ENTITY HumpEqual "&#8783;"><!ENTITY bumpeq "&#8783;"><!ENTITY esdot "&#8784;"><!ENTITY DotEqual "&#8784;"><!ENTITY doteq "&#8784;"><!ENTITY eDot "&#8785;"><!ENTITY doteqdot "&#8785;"><!ENTITY efDot "&#8786;"><!ENTITY fallingdotseq "&#8786;"><!ENTITY erDot "&#8787;"><!ENTITY risingdotseq "&#8787;"><!ENTITY colone "&#8788;"><!ENTITY coloneq "&#8788;"><!ENTITY Assign "&#8788;"><!ENTITY ecolon "&#8789;"><!ENTITY eqcolon "&#8789;"><!ENTITY ecir "&#8790;"><!ENTITY eqcirc "&#8790;"><!ENTITY cire "&#8791;"><!ENTITY circeq "&#8791;"><!ENTITY wedgeq "&#8793;"><!ENTITY veeeq "&#8794;"><!ENTITY trie "&#8796;"><!ENTITY triangleq "&#8796;"><!ENTITY equest "&#8799;"><!ENTITY questeq "&#8799;"><!ENTITY ne "&#8800;"><!ENTITY NotEqual "&#8800;"><!ENTITY equiv "&#8801;"><!ENTITY Congruent "&#8801;"><!ENTITY nequiv "&#8802;"><!ENTITY NotCongruent "&#8802;"><!ENTITY le "&#8804;"><!ENTITY leq "&#8804;"><!ENTITY ge "&#8805;"><!ENTITY GreaterEqual "&#8805;"><!ENTITY geq "&#8805;"><!ENTITY lE "&#8806;"><!ENTITY LessFullEqual "&#8806;"><!ENTITY leqq "&#8806;"><!ENTITY gE "&#8807;"><!ENTITY GreaterFullEqual "&#8807;"><!ENTITY geqq "&#8807;"><!ENTITY lnE "&#8808;"><!ENTITY lneqq "&#8808;"><!ENTITY gnE "&#8809;"><!ENTITY gneqq "&#8809;"><!ENTITY Lt "&#8810;"><!ENTITY NestedLessLess "&#8810;"><!ENTITY ll "&#8810;"><!ENTITY Gt "&#8811;"><!ENTITY NestedGreaterGreater "&#8811;"><!ENTITY gg "&#8811;"><!ENTITY twixt "&#8812;"><!ENTITY between "&#8812;"><!ENTITY NotCupCap "&#8813;"><!ENTITY nlt "&#8814;"><!ENTITY NotLess "&#8814;"><!ENTITY nless "&#8814;"><!ENTITY ngt "&#8815;"><!ENTITY NotGreater "&#8815;"><!ENTITY ngtr "&#8815;"><!ENTITY nle "&#8816;"><!ENTITY NotLessEqual "&#8816;"><!ENTITY nleq "&#8816;"><!ENTITY nge "&#8817;"><!ENTITY NotGreaterEqual "&#8817;"><!ENTITY ngeq "&#8817;"><!ENTITY lsim "&#8818;"><!ENTITY LessTilde "&#8818;"><!ENTITY lesssim "&#8818;"><!ENTITY gsim "&#8819;"><!ENTITY gtrsim "&#8819;"><!ENTITY GreaterTilde "&#8819;"><!ENTITY nlsim "&#8820;"><!ENTITY NotLessTilde "&#8820;"><!ENTITY ngsim "&#8821;"><!ENTITY NotGreaterTilde "&#8821;"><!ENTITY lg "&#8822;"><!ENTITY lessgtr "&#8822;"><!ENTITY LessGreater "&#8822;"><!ENTITY gl "&#8823;"><!ENTITY gtrless "&#8823;"><!ENTITY GreaterLess "&#8823;"><!ENTITY ntlg "&#8824;"><!ENTITY NotLessGreater "&#8824;"><!ENTITY ntgl "&#8825;"><!ENTITY NotGreaterLess "&#8825;"><!ENTITY pr "&#8826;"><!ENTITY Precedes "&#8826;"><!ENTITY prec "&#8826;"><!ENTITY sc "&#8827;"><!ENTITY Succeeds "&#8827;"><!ENTITY succ "&#8827;"><!ENTITY prcue "&#8828;"><!ENTITY PrecedesSlantEqual "&#8828;"><!ENTITY preccurlyeq "&#8828;"><!ENTITY sccue "&#8829;"><!ENTITY SucceedsSlantEqual "&#8829;"><!ENTITY succcurlyeq "&#8829;"><!ENTITY prsim "&#8830;"><!ENTITY precsim "&#8830;"><!ENTITY PrecedesTilde "&#8830;"><!ENTITY scsim "&#8831;"><!ENTITY succsim "&#8831;"><!ENTITY SucceedsTilde "&#8831;"><!ENTITY npr "&#8832;"><!ENTITY nprec "&#8832;"><!ENTITY NotPrecedes "&#8832;"><!ENTITY nsc "&#8833;"><!ENTITY nsucc "&#8833;"><!ENTITY NotSucceeds "&#8833;"><!ENTITY sub "&#8834;"><!ENTITY subset "&#8834;"><!ENTITY sup "&#8835;"><!ENTITY supset "&#8835;"><!ENTITY Superset "&#8835;"><!ENTITY nsub "&#8836;"><!ENTITY nsup "&#8837;"><!ENTITY sube "&#8838;"><!ENTITY SubsetEqual "&#8838;"><!ENTITY subseteq "&#8838;"><!ENTITY supe "&#8839;"><!ENTITY supseteq "&#8839;"><!ENTITY SupersetEqual "&#8839;"><!ENTITY nsube "&#8840;"><!ENTITY nsubseteq "&#8840;"><!ENTITY NotSubsetEqual "&#8840;"><!ENTITY nsupe "&#8841;"><!ENTITY nsupseteq "&#8841;"><!ENTITY NotSupersetEqual "&#8841;"><!ENTITY subne "&#8842;"><!ENTITY subsetneq "&#8842;"><!ENTITY supne "&#8843;"><!ENTITY supsetneq "&#8843;"><!ENTITY cupdot "&#8845;"><!ENTITY uplus "&#8846;"><!ENTITY UnionPlus "&#8846;"><!ENTITY sqsub "&#8847;"><!ENTITY SquareSubset "&#8847;"><!ENTITY sqsubset "&#8847;"><!ENTITY sqsup "&#8848;"><!ENTITY SquareSuperset "&#8848;"><!ENTITY sqsupset "&#8848;"><!ENTITY sqsube "&#8849;"><!ENTITY SquareSubsetEqual "&#8849;"><!ENTITY sqsubseteq "&#8849;"><!ENTITY sqsupe "&#8850;"><!ENTITY SquareSupersetEqual "&#8850;"><!ENTITY sqsupseteq "&#8850;"><!ENTITY sqcap "&#8851;"><!ENTITY SquareIntersection "&#8851;"><!ENTITY sqcup "&#8852;"><!ENTITY SquareUnion "&#8852;"><!ENTITY oplus "&#8853;"><!ENTITY CirclePlus "&#8853;"><!ENTITY ominus "&#8854;"><!ENTITY CircleMinus "&#8854;"><!ENTITY otimes "&#8855;"><!ENTITY CircleTimes "&#8855;"><!ENTITY osol "&#8856;"><!ENTITY odot "&#8857;"><!ENTITY CircleDot "&#8857;"><!ENTITY ocir "&#8858;"><!ENTITY circledcirc "&#8858;"><!ENTITY oast "&#8859;"><!ENTITY circledast "&#8859;"><!ENTITY odash "&#8861;"><!ENTITY circleddash "&#8861;"><!ENTITY plusb "&#8862;"><!ENTITY boxplus "&#8862;"><!ENTITY minusb "&#8863;"><!ENTITY boxminus "&#8863;"><!ENTITY timesb "&#8864;"><!ENTITY boxtimes "&#8864;"><!ENTITY sdotb "&#8865;"><!ENTITY dotsquare "&#8865;"><!ENTITY vdash "&#8866;"><!ENTITY RightTee "&#8866;"><!ENTITY dashv "&#8867;"><!ENTITY LeftTee "&#8867;"><!ENTITY top "&#8868;"><!ENTITY DownTee "&#8868;"><!ENTITY bottom "&#8869;"><!ENTITY bot "&#8869;"><!ENTITY perp "&#8869;"><!ENTITY UpTee "&#8869;"><!ENTITY models "&#8871;"><!ENTITY vDash "&#8872;"><!ENTITY DoubleRightTee "&#8872;"><!ENTITY Vdash "&#8873;"><!ENTITY Vvdash "&#8874;"><!ENTITY VDash "&#8875;"><!ENTITY nvdash "&#8876;"><!ENTITY nvDash "&#8877;"><!ENTITY nVdash "&#8878;"><!ENTITY nVDash "&#8879;"><!ENTITY prurel "&#8880;"><!ENTITY vltri "&#8882;"><!ENTITY vartriangleleft "&#8882;"><!ENTITY LeftTriangle "&#8882;"><!ENTITY vrtri "&#8883;"><!ENTITY vartriangleright "&#8883;"><!ENTITY RightTriangle "&#8883;"><!ENTITY ltrie "&#8884;"><!ENTITY trianglelefteq "&#8884;"><!ENTITY LeftTriangleEqual "&#8884;"><!ENTITY rtrie "&#8885;"><!ENTITY trianglerighteq "&#8885;"><!ENTITY RightTriangleEqual "&#8885;"><!ENTITY origof "&#8886;"><!ENTITY imof "&#8887;"><!ENTITY mumap "&#8888;"><!ENTITY multimap "&#8888;"><!ENTITY hercon "&#8889;"><!ENTITY intcal "&#8890;"><!ENTITY intercal "&#8890;"><!ENTITY veebar "&#8891;"><!ENTITY barvee "&#8893;"><!ENTITY angrtvb "&#8894;"><!ENTITY lrtri "&#8895;"><!ENTITY xwedge "&#8896;"><!ENTITY Wedge "&#8896;"><!ENTITY bigwedge "&#8896;"><!ENTITY xvee "&#8897;"><!ENTITY Vee "&#8897;"><!ENTITY bigvee "&#8897;"><!ENTITY xcap "&#8898;"><!ENTITY Intersection "&#8898;"><!ENTITY bigcap "&#8898;"><!ENTITY xcup "&#8899;"><!ENTITY Union "&#8899;"><!ENTITY bigcup "&#8899;"><!ENTITY diam "&#8900;"><!ENTITY diamond "&#8900;"><!ENTITY Diamond "&#8900;"><!ENTITY sdot "&#8901;"><!ENTITY sstarf "&#8902;"><!ENTITY Star "&#8902;"><!ENTITY divonx "&#8903;"><!ENTITY divideontimes "&#8903;"><!ENTITY bowtie "&#8904;"><!ENTITY ltimes "&#8905;"><!ENTITY rtimes "&#8906;"><!ENTITY lthree "&#8907;"><!ENTITY leftthreetimes "&#8907;"><!ENTITY rthree "&#8908;"><!ENTITY rightthreetimes "&#8908;"><!ENTITY bsime "&#8909;"><!ENTITY backsimeq "&#8909;"><!ENTITY cuvee "&#8910;"><!ENTITY curlyvee "&#8910;"><!ENTITY cuwed "&#8911;"><!ENTITY curlywedge "&#8911;"><!ENTITY Sub "&#8912;"><!ENTITY Subset "&#8912;"><!ENTITY Sup "&#8913;"><!ENTITY Supset "&#8913;"><!ENTITY Cap "&#8914;"><!ENTITY Cup "&#8915;"><!ENTITY fork "&#8916;"><!ENTITY pitchfork "&#8916;"><!ENTITY epar "&#8917;"><!ENTITY ltdot "&#8918;"><!ENTITY lessdot "&#8918;"><!ENTITY gtdot "&#8919;"><!ENTITY gtrdot "&#8919;"><!ENTITY Ll "&#8920;"><!ENTITY Gg "&#8921;"><!ENTITY ggg "&#8921;"><!ENTITY leg "&#8922;"><!ENTITY LessEqualGreater "&#8922;"><!ENTITY lesseqgtr "&#8922;"><!ENTITY gel "&#8923;"><!ENTITY gtreqless "&#8923;"><!ENTITY GreaterEqualLess "&#8923;"><!ENTITY cuepr "&#8926;"><!ENTITY curlyeqprec "&#8926;"><!ENTITY cuesc "&#8927;"><!ENTITY curlyeqsucc "&#8927;"><!ENTITY nprcue "&#8928;"><!ENTITY NotPrecedesSlantEqual "&#8928;"><!ENTITY nsccue "&#8929;"><!ENTITY NotSucceedsSlantEqual "&#8929;"><!ENTITY nsqsube "&#8930;"><!ENTITY NotSquareSubsetEqual "&#8930;"><!ENTITY nsqsupe "&#8931;"><!ENTITY NotSquareSupersetEqual "&#8931;"><!ENTITY lnsim "&#8934;"><!ENTITY gnsim "&#8935;"><!ENTITY prnsim "&#8936;"><!ENTITY precnsim "&#8936;"><!ENTITY scnsim "&#8937;"><!ENTITY succnsim "&#8937;"><!ENTITY nltri "&#8938;"><!ENTITY ntriangleleft "&#8938;"><!ENTITY NotLeftTriangle "&#8938;"><!ENTITY nrtri "&#8939;"><!ENTITY ntriangleright "&#8939;"><!ENTITY NotRightTriangle "&#8939;"><!ENTITY nltrie "&#8940;"><!ENTITY ntrianglelefteq "&#8940;"><!ENTITY NotLeftTriangleEqual "&#8940;"><!ENTITY nrtrie "&#8941;"><!ENTITY ntrianglerighteq "&#8941;"><!ENTITY NotRightTriangleEqual "&#8941;"><!ENTITY vellip "&#8942;"><!ENTITY ctdot "&#8943;"><!ENTITY utdot "&#8944;"><!ENTITY dtdot "&#8945;"><!ENTITY disin "&#8946;"><!ENTITY isinsv "&#8947;"><!ENTITY isins "&#8948;"><!ENTITY isindot "&#8949;"><!ENTITY notinvc "&#8950;"><!ENTITY notinvb "&#8951;"><!ENTITY isinE "&#8953;"><!ENTITY nisd "&#8954;"><!ENTITY xnis "&#8955;"><!ENTITY nis "&#8956;"><!ENTITY notnivc "&#8957;"><!ENTITY notnivb "&#8958;"><!ENTITY barwed "&#8965;"><!ENTITY barwedge "&#8965;"><!ENTITY Barwed "&#8966;"><!ENTITY doublebarwedge "&#8966;"><!ENTITY lceil "&#8968;"><!ENTITY LeftCeiling "&#8968;"><!ENTITY rceil "&#8969;"><!ENTITY RightCeiling "&#8969;"><!ENTITY lfloor "&#8970;"><!ENTITY LeftFloor "&#8970;"><!ENTITY rfloor "&#8971;"><!ENTITY RightFloor "&#8971;"><!ENTITY drcrop "&#8972;"><!ENTITY dlcrop "&#8973;"><!ENTITY urcrop "&#8974;"><!ENTITY ulcrop "&#8975;"><!ENTITY bnot "&#8976;"><!ENTITY profline "&#8978;"><!ENTITY profsurf "&#8979;"><!ENTITY telrec "&#8981;"><!ENTITY target "&#8982;"><!ENTITY ulcorn "&#8988;"><!ENTITY ulcorner "&#8988;"><!ENTITY urcorn "&#8989;"><!ENTITY urcorner "&#8989;"><!ENTITY dlcorn "&#8990;"><!ENTITY llcorner "&#8990;"><!ENTITY drcorn "&#8991;"><!ENTITY lrcorner "&#8991;"><!ENTITY frown "&#8994;"><!ENTITY sfrown "&#8994;"><!ENTITY smile "&#8995;"><!ENTITY ssmile "&#8995;"><!ENTITY cylcty "&#9005;"><!ENTITY profalar "&#9006;"><!ENTITY topbot "&#9014;"><!ENTITY ovbar "&#9021;"><!ENTITY solbar "&#9023;"><!ENTITY angzarr "&#9084;"><!ENTITY lmoust "&#9136;"><!ENTITY lmoustache "&#9136;"><!ENTITY rmoust "&#9137;"><!ENTITY rmoustache "&#9137;"><!ENTITY tbrk "&#9140;"><!ENTITY OverBracket "&#9140;"><!ENTITY bbrk "&#9141;"><!ENTITY UnderBracket "&#9141;"><!ENTITY bbrktbrk "&#9142;"><!ENTITY OverParenthesis "&#9180;"><!ENTITY UnderParenthesis "&#9181;"><!ENTITY OverBrace "&#9182;"><!ENTITY UnderBrace "&#9183;"><!ENTITY trpezium "&#9186;"><!ENTITY elinters "&#9191;"><!ENTITY blank "&#9251;"><!ENTITY oS "&#9416;"><!ENTITY circledS "&#9416;"><!ENTITY boxh "&#9472;"><!ENTITY HorizontalLine "&#9472;"><!ENTITY boxv "&#9474;"><!ENTITY boxdr "&#9484;"><!ENTITY boxdl "&#9488;"><!ENTITY boxur "&#9492;"><!ENTITY boxul "&#9496;"><!ENTITY boxvr "&#9500;"><!ENTITY boxvl "&#9508;"><!ENTITY boxhd "&#9516;"><!ENTITY boxhu "&#9524;"><!ENTITY boxvh "&#9532;"><!ENTITY boxH "&#9552;"><!ENTITY boxV "&#9553;"><!ENTITY boxdR "&#9554;"><!ENTITY boxDr "&#9555;"><!ENTITY boxDR "&#9556;"><!ENTITY boxdL "&#9557;"><!ENTITY boxDl "&#9558;"><!ENTITY boxDL "&#9559;"><!ENTITY boxuR "&#9560;"><!ENTITY boxUr "&#9561;"><!ENTITY boxUR "&#9562;"><!ENTITY boxuL "&#9563;"><!ENTITY boxUl "&#9564;"><!ENTITY boxUL "&#9565;"><!ENTITY boxvR "&#9566;"><!ENTITY boxVr "&#9567;"><!ENTITY boxVR "&#9568;"><!ENTITY boxvL "&#9569;"><!ENTITY boxVl "&#9570;"><!ENTITY boxVL "&#9571;"><!ENTITY boxHd "&#9572;"><!ENTITY boxhD "&#9573;"><!ENTITY boxHD "&#9574;"><!ENTITY boxHu "&#9575;"><!ENTITY boxhU "&#9576;"><!ENTITY boxHU "&#9577;"><!ENTITY boxvH "&#9578;"><!ENTITY boxVh "&#9579;"><!ENTITY boxVH "&#9580;"><!ENTITY uhblk "&#9600;"><!ENTITY lhblk "&#9604;"><!ENTITY block "&#9608;"><!ENTITY blk14 "&#9617;"><!ENTITY blk12 "&#9618;"><!ENTITY blk34 "&#9619;"><!ENTITY squ "&#9633;"><!ENTITY square "&#9633;"><!ENTITY Square "&#9633;"><!ENTITY squf "&#9642;"><!ENTITY squarf "&#9642;"><!ENTITY blacksquare "&#9642;"><!ENTITY FilledVerySmallSquare "&#9642;"><!ENTITY EmptyVerySmallSquare "&#9643;"><!ENTITY rect "&#9645;"><!ENTITY marker "&#9646;"><!ENTITY fltns "&#9649;"><!ENTITY xutri "&#9651;"><!ENTITY bigtriangleup "&#9651;"><!ENTITY utrif "&#9652;"><!ENTITY blacktriangle "&#9652;"><!ENTITY utri "&#9653;"><!ENTITY triangle "&#9653;"><!ENTITY rtrif "&#9656;"><!ENTITY blacktriangleright "&#9656;"><!ENTITY rtri "&#9657;"><!ENTITY triangleright "&#9657;"><!ENTITY xdtri "&#9661;"><!ENTITY bigtriangledown "&#9661;"><!ENTITY dtrif "&#9662;"><!ENTITY blacktriangledown "&#9662;"><!ENTITY dtri "&#9663;"><!ENTITY triangledown "&#9663;"><!ENTITY ltrif "&#9666;"><!ENTITY blacktriangleleft "&#9666;"><!ENTITY ltri "&#9667;"><!ENTITY triangleleft "&#9667;"><!ENTITY loz "&#9674;"><!ENTITY lozenge "&#9674;"><!ENTITY cir "&#9675;"><!ENTITY tridot "&#9708;"><!ENTITY xcirc "&#9711;"><!ENTITY bigcirc "&#9711;"><!ENTITY ultri "&#9720;"><!ENTITY urtri "&#9721;"><!ENTITY lltri "&#9722;"><!ENTITY EmptySmallSquare "&#9723;"><!ENTITY FilledSmallSquare "&#9724;"><!ENTITY starf "&#9733;"><!ENTITY bigstar "&#9733;"><!ENTITY star "&#9734;"><!ENTITY phone "&#9742;"><!ENTITY female "&#9792;"><!ENTITY male "&#9794;"><!ENTITY spades "&#9824;"><!ENTITY spadesuit "&#9824;"><!ENTITY clubs "&#9827;"><!ENTITY clubsuit "&#9827;"><!ENTITY hearts "&#9829;"><!ENTITY heartsuit "&#9829;"><!ENTITY diams "&#9830;"><!ENTITY diamondsuit "&#9830;"><!ENTITY sung "&#9834;"><!ENTITY flat "&#9837;"><!ENTITY natur "&#9838;"><!ENTITY natural "&#9838;"><!ENTITY sharp "&#9839;"><!ENTITY check "&#10003;"><!ENTITY checkmark "&#10003;"><!ENTITY cross "&#10007;"><!ENTITY malt "&#10016;"><!ENTITY maltese "&#10016;"><!ENTITY sext "&#10038;"><!ENTITY VerticalSeparator "&#10072;"><!ENTITY lbbrk "&#10098;"><!ENTITY rbbrk "&#10099;"><!ENTITY lobrk "&#10214;"><!ENTITY LeftDoubleBracket "&#10214;"><!ENTITY robrk "&#10215;"><!ENTITY RightDoubleBracket "&#10215;"><!ENTITY lang "&#10216;"><!ENTITY LeftAngleBracket "&#10216;"><!ENTITY langle "&#10216;"><!ENTITY rang "&#10217;"><!ENTITY RightAngleBracket "&#10217;"><!ENTITY rangle "&#10217;"><!ENTITY Lang "&#10218;"><!ENTITY Rang "&#10219;"><!ENTITY loang "&#10220;"><!ENTITY roang "&#10221;"><!ENTITY xlarr "&#10229;"><!ENTITY longleftarrow "&#10229;"><!ENTITY LongLeftArrow "&#10229;"><!ENTITY xrarr "&#10230;"><!ENTITY longrightarrow "&#10230;"><!ENTITY LongRightArrow "&#10230;"><!ENTITY xharr "&#10231;"><!ENTITY longleftrightarrow "&#10231;"><!ENTITY LongLeftRightArrow "&#10231;"><!ENTITY xlArr "&#10232;"><!ENTITY Longleftarrow "&#10232;"><!ENTITY DoubleLongLeftArrow "&#10232;"><!ENTITY xrArr "&#10233;"><!ENTITY Longrightarrow "&#10233;"><!ENTITY DoubleLongRightArrow "&#10233;"><!ENTITY xhArr "&#10234;"><!ENTITY Longleftrightarrow "&#10234;"><!ENTITY DoubleLongLeftRightArrow "&#10234;"><!ENTITY xmap "&#10236;"><!ENTITY longmapsto "&#10236;"><!ENTITY dzigrarr "&#10239;"><!ENTITY nvlArr "&#10498;"><!ENTITY nvrArr "&#10499;"><!ENTITY nvHarr "&#10500;"><!ENTITY Map "&#10501;"><!ENTITY lbarr "&#10508;"><!ENTITY rbarr "&#10509;"><!ENTITY bkarow "&#10509;"><!ENTITY lBarr "&#10510;"><!ENTITY rBarr "&#10511;"><!ENTITY dbkarow "&#10511;"><!ENTITY RBarr "&#10512;"><!ENTITY drbkarow "&#10512;"><!ENTITY DDotrahd "&#10513;"><!ENTITY UpArrowBar "&#10514;"><!ENTITY DownArrowBar "&#10515;"><!ENTITY Rarrtl "&#10518;"><!ENTITY latail "&#10521;"><!ENTITY ratail "&#10522;"><!ENTITY lAtail "&#10523;"><!ENTITY rAtail "&#10524;"><!ENTITY larrfs "&#10525;"><!ENTITY rarrfs "&#10526;"><!ENTITY larrbfs "&#10527;"><!ENTITY rarrbfs "&#10528;"><!ENTITY nwarhk "&#10531;"><!ENTITY nearhk "&#10532;"><!ENTITY searhk "&#10533;"><!ENTITY hksearow "&#10533;"><!ENTITY swarhk "&#10534;"><!ENTITY hkswarow "&#10534;"><!ENTITY nwnear "&#10535;"><!ENTITY nesear "&#10536;"><!ENTITY toea "&#10536;"><!ENTITY seswar "&#10537;"><!ENTITY tosa "&#10537;"><!ENTITY swnwar "&#10538;"><!ENTITY rarrc "&#10547;"><!ENTITY cudarrr "&#10549;"><!ENTITY ldca "&#10550;"><!ENTITY rdca "&#10551;"><!ENTITY cudarrl "&#10552;"><!ENTITY larrpl "&#10553;"><!ENTITY curarrm "&#10556;"><!ENTITY cularrp "&#10557;"><!ENTITY rarrpl "&#10565;"><!ENTITY harrcir "&#10568;"><!ENTITY Uarrocir "&#10569;"><!ENTITY lurdshar "&#10570;"><!ENTITY ldrushar "&#10571;"><!ENTITY LeftRightVector "&#10574;"><!ENTITY RightUpDownVector "&#10575;"><!ENTITY DownLeftRightVector "&#10576;"><!ENTITY LeftUpDownVector "&#10577;"><!ENTITY LeftVectorBar "&#10578;"><!ENTITY RightVectorBar "&#10579;"><!ENTITY RightUpVectorBar "&#10580;"><!ENTITY RightDownVectorBar "&#10581;"><!ENTITY DownLeftVectorBar "&#10582;"><!ENTITY DownRightVectorBar "&#10583;"><!ENTITY LeftUpVectorBar "&#10584;"><!ENTITY LeftDownVectorBar "&#10585;"><!ENTITY LeftTeeVector "&#10586;"><!ENTITY RightTeeVector "&#10587;"><!ENTITY RightUpTeeVector "&#10588;"><!ENTITY RightDownTeeVector "&#10589;"><!ENTITY DownLeftTeeVector "&#10590;"><!ENTITY DownRightTeeVector "&#10591;"><!ENTITY LeftUpTeeVector "&#10592;"><!ENTITY LeftDownTeeVector "&#10593;"><!ENTITY lHar "&#10594;"><!ENTITY uHar "&#10595;"><!ENTITY rHar "&#10596;"><!ENTITY dHar "&#10597;"><!ENTITY luruhar "&#10598;"><!ENTITY ldrdhar "&#10599;"><!ENTITY ruluhar "&#10600;"><!ENTITY rdldhar "&#10601;"><!ENTITY lharul "&#10602;"><!ENTITY llhard "&#10603;"><!ENTITY rharul "&#10604;"><!ENTITY lrhard "&#10605;"><!ENTITY udhar "&#10606;"><!ENTITY UpEquilibrium "&#10606;"><!ENTITY duhar "&#10607;"><!ENTITY ReverseUpEquilibrium "&#10607;"><!ENTITY RoundImplies "&#10608;"><!ENTITY erarr "&#10609;"><!ENTITY simrarr "&#10610;"><!ENTITY larrsim "&#10611;"><!ENTITY rarrsim "&#10612;"><!ENTITY rarrap "&#10613;"><!ENTITY ltlarr "&#10614;"><!ENTITY gtrarr "&#10616;"><!ENTITY subrarr "&#10617;"><!ENTITY suplarr "&#10619;"><!ENTITY lfisht "&#10620;"><!ENTITY rfisht "&#10621;"><!ENTITY ufisht "&#10622;"><!ENTITY dfisht "&#10623;"><!ENTITY lopar "&#10629;"><!ENTITY ropar "&#10630;"><!ENTITY lbrke "&#10635;"><!ENTITY rbrke "&#10636;"><!ENTITY lbrkslu "&#10637;"><!ENTITY rbrksld "&#10638;"><!ENTITY lbrksld "&#10639;"><!ENTITY rbrkslu "&#10640;"><!ENTITY langd "&#10641;"><!ENTITY rangd "&#10642;"><!ENTITY lparlt "&#10643;"><!ENTITY rpargt "&#10644;"><!ENTITY gtlPar "&#10645;"><!ENTITY ltrPar "&#10646;"><!ENTITY vzigzag "&#10650;"><!ENTITY vangrt "&#10652;"><!ENTITY angrtvbd "&#10653;"><!ENTITY ange "&#10660;"><!ENTITY range "&#10661;"><!ENTITY dwangle "&#10662;"><!ENTITY uwangle "&#10663;"><!ENTITY angmsdaa "&#10664;"><!ENTITY angmsdab "&#10665;"><!ENTITY angmsdac "&#10666;"><!ENTITY angmsdad "&#10667;"><!ENTITY angmsdae "&#10668;"><!ENTITY angmsdaf "&#10669;"><!ENTITY angmsdag "&#10670;"><!ENTITY angmsdah "&#10671;"><!ENTITY bemptyv "&#10672;"><!ENTITY demptyv "&#10673;"><!ENTITY cemptyv "&#10674;"><!ENTITY raemptyv "&#10675;"><!ENTITY laemptyv "&#10676;"><!ENTITY ohbar "&#10677;"><!ENTITY omid "&#10678;"><!ENTITY opar "&#10679;"><!ENTITY operp "&#10681;"><!ENTITY olcross "&#10683;"><!ENTITY odsold "&#10684;"><!ENTITY olcir "&#10686;"><!ENTITY ofcir "&#10687;"><!ENTITY olt "&#10688;"><!ENTITY ogt "&#10689;"><!ENTITY cirscir "&#10690;"><!ENTITY cirE "&#10691;"><!ENTITY solb "&#10692;"><!ENTITY bsolb "&#10693;"><!ENTITY boxbox "&#10697;"><!ENTITY trisb "&#10701;"><!ENTITY rtriltri "&#10702;"><!ENTITY LeftTriangleBar "&#10703;"><!ENTITY RightTriangleBar "&#10704;"><!ENTITY race "&#10714;"><!ENTITY iinfin "&#10716;"><!ENTITY infintie "&#10717;"><!ENTITY nvinfin "&#10718;"><!ENTITY eparsl "&#10723;"><!ENTITY smeparsl "&#10724;"><!ENTITY eqvparsl "&#10725;"><!ENTITY lozf "&#10731;"><!ENTITY blacklozenge "&#10731;"><!ENTITY RuleDelayed "&#10740;"><!ENTITY dsol "&#10742;"><!ENTITY xodot "&#10752;"><!ENTITY bigodot "&#10752;"><!ENTITY xoplus "&#10753;"><!ENTITY bigoplus "&#10753;"><!ENTITY xotime "&#10754;"><!ENTITY bigotimes "&#10754;"><!ENTITY xuplus "&#10756;"><!ENTITY biguplus "&#10756;"><!ENTITY xsqcup "&#10758;"><!ENTITY bigsqcup "&#10758;"><!ENTITY qint "&#10764;"><!ENTITY iiiint "&#10764;"><!ENTITY fpartint "&#10765;"><!ENTITY cirfnint "&#10768;"><!ENTITY awint "&#10769;"><!ENTITY rppolint "&#10770;"><!ENTITY scpolint "&#10771;"><!ENTITY npolint "&#10772;"><!ENTITY pointint "&#10773;"><!ENTITY quatint "&#10774;"><!ENTITY intlarhk "&#10775;"><!ENTITY pluscir "&#10786;"><!ENTITY plusacir "&#10787;"><!ENTITY simplus "&#10788;"><!ENTITY plusdu "&#10789;"><!ENTITY plussim "&#10790;"><!ENTITY plustwo "&#10791;"><!ENTITY mcomma "&#10793;"><!ENTITY minusdu "&#10794;"><!ENTITY loplus "&#10797;"><!ENTITY roplus "&#10798;"><!ENTITY Cross "&#10799;"><!ENTITY timesd "&#10800;"><!ENTITY timesbar "&#10801;"><!ENTITY smashp "&#10803;"><!ENTITY lotimes "&#10804;"><!ENTITY rotimes "&#10805;"><!ENTITY otimesas "&#10806;"><!ENTITY Otimes "&#10807;"><!ENTITY odiv "&#10808;"><!ENTITY triplus "&#10809;"><!ENTITY triminus "&#10810;"><!ENTITY tritime "&#10811;"><!ENTITY iprod "&#10812;"><!ENTITY intprod "&#10812;"><!ENTITY amalg "&#10815;"><!ENTITY capdot "&#10816;"><!ENTITY ncup "&#10818;"><!ENTITY ncap "&#10819;"><!ENTITY capand "&#10820;"><!ENTITY cupor "&#10821;"><!ENTITY cupcap "&#10822;"><!ENTITY capcup "&#10823;"><!ENTITY cupbrcap "&#10824;"><!ENTITY capbrcup "&#10825;"><!ENTITY cupcup "&#10826;"><!ENTITY capcap "&#10827;"><!ENTITY ccups "&#10828;"><!ENTITY ccaps "&#10829;"><!ENTITY ccupssm "&#10832;"><!ENTITY And "&#10835;"><!ENTITY Or "&#10836;"><!ENTITY andand "&#10837;"><!ENTITY oror "&#10838;"><!ENTITY orslope "&#10839;"><!ENTITY andslope "&#10840;"><!ENTITY andv "&#10842;"><!ENTITY orv "&#10843;"><!ENTITY andd "&#10844;"><!ENTITY ord "&#10845;"><!ENTITY wedbar "&#10847;"><!ENTITY sdote "&#10854;"><!ENTITY simdot "&#10858;"><!ENTITY congdot "&#10861;"><!ENTITY easter "&#10862;"><!ENTITY apacir "&#10863;"><!ENTITY apE "&#10864;"><!ENTITY eplus "&#10865;"><!ENTITY pluse "&#10866;"><!ENTITY Esim "&#10867;"><!ENTITY Colone "&#10868;"><!ENTITY Equal "&#10869;"><!ENTITY eDDot "&#10871;"><!ENTITY ddotseq "&#10871;"><!ENTITY equivDD "&#10872;"><!ENTITY ltcir "&#10873;"><!ENTITY gtcir "&#10874;"><!ENTITY ltquest "&#10875;"><!ENTITY gtquest "&#10876;"><!ENTITY les "&#10877;"><!ENTITY LessSlantEqual "&#10877;"><!ENTITY leqslant "&#10877;"><!ENTITY ges "&#10878;"><!ENTITY GreaterSlantEqual "&#10878;"><!ENTITY geqslant "&#10878;"><!ENTITY lesdot "&#10879;"><!ENTITY gesdot "&#10880;"><!ENTITY lesdoto "&#10881;"><!ENTITY gesdoto "&#10882;"><!ENTITY lesdotor "&#10883;"><!ENTITY gesdotol "&#10884;"><!ENTITY lap "&#10885;"><!ENTITY lessapprox "&#10885;"><!ENTITY gap "&#10886;"><!ENTITY gtrapprox "&#10886;"><!ENTITY lne "&#10887;"><!ENTITY lneq "&#10887;"><!ENTITY gne "&#10888;"><!ENTITY gneq "&#10888;"><!ENTITY lnap "&#10889;"><!ENTITY lnapprox "&#10889;"><!ENTITY gnap "&#10890;"><!ENTITY gnapprox "&#10890;"><!ENTITY lEg "&#10891;"><!ENTITY lesseqqgtr "&#10891;"><!ENTITY gEl "&#10892;"><!ENTITY gtreqqless "&#10892;"><!ENTITY lsime "&#10893;"><!ENTITY gsime "&#10894;"><!ENTITY lsimg "&#10895;"><!ENTITY gsiml "&#10896;"><!ENTITY lgE "&#10897;"><!ENTITY glE "&#10898;"><!ENTITY lesges "&#10899;"><!ENTITY gesles "&#10900;"><!ENTITY els "&#10901;"><!ENTITY eqslantless "&#10901;"><!ENTITY egs "&#10902;"><!ENTITY eqslantgtr "&#10902;"><!ENTITY elsdot "&#10903;"><!ENTITY egsdot "&#10904;"><!ENTITY el "&#10905;"><!ENTITY eg "&#10906;"><!ENTITY siml "&#10909;"><!ENTITY simg "&#10910;"><!ENTITY simlE "&#10911;"><!ENTITY simgE "&#10912;"><!ENTITY LessLess "&#10913;"><!ENTITY GreaterGreater "&#10914;"><!ENTITY glj "&#10916;"><!ENTITY gla "&#10917;"><!ENTITY ltcc "&#10918;"><!ENTITY gtcc "&#10919;"><!ENTITY lescc "&#10920;"><!ENTITY gescc "&#10921;"><!ENTITY smt "&#10922;"><!ENTITY lat "&#10923;"><!ENTITY smte "&#10924;"><!ENTITY late "&#10925;"><!ENTITY bumpE "&#10926;"><!ENTITY pre "&#10927;"><!ENTITY preceq "&#10927;"><!ENTITY PrecedesEqual "&#10927;"><!ENTITY sce "&#10928;"><!ENTITY succeq "&#10928;"><!ENTITY SucceedsEqual "&#10928;"><!ENTITY prE "&#10931;"><!ENTITY scE "&#10932;"><!ENTITY prnE "&#10933;"><!ENTITY precneqq "&#10933;"><!ENTITY scnE "&#10934;"><!ENTITY succneqq "&#10934;"><!ENTITY prap "&#10935;"><!ENTITY precapprox "&#10935;"><!ENTITY scap "&#10936;"><!ENTITY succapprox "&#10936;"><!ENTITY prnap "&#10937;"><!ENTITY precnapprox "&#10937;"><!ENTITY scnap "&#10938;"><!ENTITY succnapprox "&#10938;"><!ENTITY Pr "&#10939;"><!ENTITY Sc "&#10940;"><!ENTITY subdot "&#10941;"><!ENTITY supdot "&#10942;"><!ENTITY subplus "&#10943;"><!ENTITY supplus "&#10944;"><!ENTITY submult "&#10945;"><!ENTITY supmult "&#10946;"><!ENTITY subedot "&#10947;"><!ENTITY supedot "&#10948;"><!ENTITY subE "&#10949;"><!ENTITY subseteqq "&#10949;"><!ENTITY supE "&#10950;"><!ENTITY supseteqq "&#10950;"><!ENTITY subsim "&#10951;"><!ENTITY supsim "&#10952;"><!ENTITY subnE "&#10955;"><!ENTITY subsetneqq "&#10955;"><!ENTITY supnE "&#10956;"><!ENTITY supsetneqq "&#10956;"><!ENTITY csub "&#10959;"><!ENTITY csup "&#10960;"><!ENTITY csube "&#10961;"><!ENTITY csupe "&#10962;"><!ENTITY subsup "&#10963;"><!ENTITY supsub "&#10964;"><!ENTITY subsub "&#10965;"><!ENTITY supsup "&#10966;"><!ENTITY suphsub "&#10967;"><!ENTITY supdsub "&#10968;"><!ENTITY forkv "&#10969;"><!ENTITY topfork "&#10970;"><!ENTITY mlcp "&#10971;"><!ENTITY Dashv "&#10980;"><!ENTITY DoubleLeftTee "&#10980;"><!ENTITY Vdashl "&#10982;"><!ENTITY Barv "&#10983;"><!ENTITY vBar "&#10984;"><!ENTITY vBarv "&#10985;"><!ENTITY Vbar "&#10987;"><!ENTITY Not "&#10988;"><!ENTITY bNot "&#10989;"><!ENTITY rnmid "&#10990;"><!ENTITY cirmid "&#10991;"><!ENTITY midcir "&#10992;"><!ENTITY topcir "&#10993;"><!ENTITY nhpar "&#10994;"><!ENTITY parsim "&#10995;"><!ENTITY parsl "&#11005;"><!ENTITY fflig "&#64256;"><!ENTITY filig "&#64257;"><!ENTITY fllig "&#64258;"><!ENTITY ffilig "&#64259;"><!ENTITY ffllig "&#64260;"><!ENTITY Ascr "&#119964;"><!ENTITY Cscr "&#119966;"><!ENTITY Dscr "&#119967;"><!ENTITY Gscr "&#119970;"><!ENTITY Jscr "&#119973;"><!ENTITY Kscr "&#119974;"><!ENTITY Nscr "&#119977;"><!ENTITY Oscr "&#119978;"><!ENTITY Pscr "&#119979;"><!ENTITY Qscr "&#119980;"><!ENTITY Sscr "&#119982;"><!ENTITY Tscr "&#119983;"><!ENTITY Uscr "&#119984;"><!ENTITY Vscr "&#119985;"><!ENTITY Wscr "&#119986;"><!ENTITY Xscr "&#119987;"><!ENTITY Yscr "&#119988;"><!ENTITY Zscr "&#119989;"><!ENTITY ascr "&#119990;"><!ENTITY bscr "&#119991;"><!ENTITY cscr "&#119992;"><!ENTITY dscr "&#119993;"><!ENTITY fscr "&#119995;"><!ENTITY hscr "&#119997;"><!ENTITY iscr "&#119998;"><!ENTITY jscr "&#119999;"><!ENTITY kscr "&#120000;"><!ENTITY lscr "&#120001;"><!ENTITY mscr "&#120002;"><!ENTITY nscr "&#120003;"><!ENTITY pscr "&#120005;"><!ENTITY qscr "&#120006;"><!ENTITY rscr "&#120007;"><!ENTITY sscr "&#120008;"><!ENTITY tscr "&#120009;"><!ENTITY uscr "&#120010;"><!ENTITY vscr "&#120011;"><!ENTITY wscr "&#120012;"><!ENTITY xscr "&#120013;"><!ENTITY yscr "&#120014;"><!ENTITY zscr "&#120015;"><!ENTITY Afr "&#120068;"><!ENTITY Bfr "&#120069;"><!ENTITY Dfr "&#120071;"><!ENTITY Efr "&#120072;"><!ENTITY Ffr "&#120073;"><!ENTITY Gfr "&#120074;"><!ENTITY Jfr "&#120077;"><!ENTITY Kfr "&#120078;"><!ENTITY Lfr "&#120079;"><!ENTITY Mfr "&#120080;"><!ENTITY Nfr "&#120081;"><!ENTITY Ofr "&#120082;"><!ENTITY Pfr "&#120083;"><!ENTITY Qfr "&#120084;"><!ENTITY Sfr "&#120086;"><!ENTITY Tfr "&#120087;"><!ENTITY Ufr "&#120088;"><!ENTITY Vfr "&#120089;"><!ENTITY Wfr "&#120090;"><!ENTITY Xfr "&#120091;"><!ENTITY Yfr "&#120092;"><!ENTITY afr "&#120094;"><!ENTITY bfr "&#120095;"><!ENTITY cfr "&#120096;"><!ENTITY dfr "&#120097;"><!ENTITY efr "&#120098;"><!ENTITY ffr "&#120099;"><!ENTITY gfr "&#120100;"><!ENTITY hfr "&#120101;"><!ENTITY ifr "&#120102;"><!ENTITY jfr "&#120103;"><!ENTITY kfr "&#120104;"><!ENTITY lfr "&#120105;"><!ENTITY mfr "&#120106;"><!ENTITY nfr "&#120107;"><!ENTITY ofr "&#120108;"><!ENTITY pfr "&#120109;"><!ENTITY qfr "&#120110;"><!ENTITY rfr "&#120111;"><!ENTITY sfr "&#120112;"><!ENTITY tfr "&#120113;"><!ENTITY ufr "&#120114;"><!ENTITY vfr "&#120115;"><!ENTITY wfr "&#120116;"><!ENTITY xfr "&#120117;"><!ENTITY yfr "&#120118;"><!ENTITY zfr "&#120119;"><!ENTITY Aopf "&#120120;"><!ENTITY Bopf "&#120121;"><!ENTITY Dopf "&#120123;"><!ENTITY Eopf "&#120124;"><!ENTITY Fopf "&#120125;"><!ENTITY Gopf "&#120126;"><!ENTITY Iopf "&#120128;"><!ENTITY Jopf "&#120129;"><!ENTITY Kopf "&#120130;"><!ENTITY Lopf "&#120131;"><!ENTITY Mopf "&#120132;"><!ENTITY Oopf "&#120134;"><!ENTITY Sopf "&#120138;"><!ENTITY Topf "&#120139;"><!ENTITY Uopf "&#120140;"><!ENTITY Vopf "&#120141;"><!ENTITY Wopf "&#120142;"><!ENTITY Xopf "&#120143;"><!ENTITY Yopf "&#120144;"><!ENTITY aopf "&#120146;"><!ENTITY bopf "&#120147;"><!ENTITY copf "&#120148;"><!ENTITY dopf "&#120149;"><!ENTITY eopf "&#120150;"><!ENTITY fopf "&#120151;"><!ENTITY gopf "&#120152;"><!ENTITY hopf "&#120153;"><!ENTITY iopf "&#120154;"><!ENTITY jopf "&#120155;"><!ENTITY kopf "&#120156;"><!ENTITY lopf "&#120157;"><!ENTITY mopf "&#120158;"><!ENTITY nopf "&#120159;"><!ENTITY oopf "&#120160;"><!ENTITY popf "&#120161;"><!ENTITY qopf "&#120162;"><!ENTITY ropf "&#120163;"><!ENTITY sopf "&#120164;"><!ENTITY topf "&#120165;"><!ENTITY uopf "&#120166;"><!ENTITY vopf "&#120167;"><!ENTITY wopf "&#120168;"><!ENTITY xopf "&#120169;"><!ENTITY yopf "&#120170;"><!ENTITY zopf "&#120171;">]>';
        //$utf8_header = '<meta http-equiv="content-type" content="text/html; charset=utf-8">';
        $xml_prefix = $xml_suffix = '';
        if ($add_xui_ns)
        {
            
            foreach ($this->allowed_namespaces as $ns)
            {
                $xml_prefix.= "\n".'<'.$ns.' xmlns:'.$ns.'="'.$ns.'">'."\n";
                $xml_suffix = "</{$ns}>"."\n".$xml_suffix;
            }            
        }
        $matches = [];
  //$re1='/.*?(&)(?:[a-z][a-z0-9_]*)/';	# Variable Name 1        
        
        preg_match_all("/&([^;]+?)[\s<&]/",$html, $matches);
        //preg_match_all('/&(?!amp;)[a-z][a-z0-9_]/', $html, $matches);
        //preg_match_all($re1, $html, $matches);
        
        foreach ($matches[0] as $m)
        {
            $trimmed_m = trim($m);
            $trimmed_m = rtrim($m, '&');
            if ($trimmed_m != '' && $trimmed_m != '&')
            {
                
                $m_replaced = str_replace('&', '&amp;', $trimmed_m);                
                $html = str_replace($trimmed_m, $m_replaced, $html);
            }
        }
        $html = preg_replace("|&([^;]+?)[\s<&]|","&amp;$1 ",$html);
        //print_r($matches);die;
        // buggy - 
        
        $config_doc = $xml_header . $xml_prefix . $html . $xml_suffix;
        
        ///////////////////////////////////
        /////////  prevent XXE ////////////
        if (\PHP_VERSION_ID < 80000) {
            libxml_disable_entity_loader(true);
        }
        ///////////////////////////////////
        libxml_use_internal_errors(true);
        // prevent XXE ehh
        //$opt = LIBXML_ERR_WARNING | LIBXML_PARSEHUGE | LIBXML_NOEMPTYTAG | LIBXML_NONET | LIBXML_DTDLOAD | LIBXML_DTDATTR | LIBXML_NOENT; // set to 0 to see config parse errors
        $opt = LIBXML_ERR_WARNING |  LIBXML_PARSEHUGE |  LIBXML_NONET | LIBXML_HTML_NODEFDTD | LIBXML_HTML_NOIMPLIED;
        //$xml = new \SimpleXMLElement($config_doc, $opt, false, 'x-ui'); // simplexml_load_string($config_doc);
        $xml = new \SimpleXMLElement($config_doc, $opt, false); // simplexml_load_string($config_doc);
        $xml_errors = libxml_get_errors();
        if ($xml_errors)
        {
            echo $this->getFormattedXMLErrors($xml_errors);
            libxml_clear_errors();
        }
        return $xml;
    }
    

    protected function getFormattedXMLErrors($xml_errors)
    {
        //$xmlstr = explode("\n", $xml);        
        $err_type = [LIBXML_ERR_WARNING => ___('Warning'), LIBXML_ERR_ERROR => ___('Error'), LIBXML_ERR_FATAL => ___('Fatal Error')];
        $errs = [];
        $msg = '<div class="alert alert-error"><h4>XML Errors</h4><ul>';
        foreach ($xml_errors as $error)
        {
            //print_r($error);die;
            //$error_line =  $xmlstr[$error->line - 1] ;
            $errmsg = trim($error->message);
            $line = ___('Line').' '.$error->line.' ~ '.$err_type[$error->level].' #'.$error->code.' '. ___h($errmsg);
            //$line = ___('Line').' '.$error->line.' ~ '.$err_type[$error->level].' #'.$error->code.': '.___h($error_line).' '. $errmsg;
            $msg.= '<li>'.$line.'</li>';
        }
        $msg.= '</ul></div>';        
        return $msg;

    }
    /**
     * Returns doc fragment from string
     * @param string $html
     * @return \DOMNode
     */
    protected function html2node($html)
    {        
        $xml = $this->loadHTMLAsXML($html, false);
        return $this->xml2node($xml);
    }
    /**
     * Returns a dom node from simple XML Element
     * @param \SimpleXMLElement $xml
     * @return \DOMNode
     */
    protected function xml2node(\SimpleXMLElement $xml)
    {
        
        $dom = new \DOMDocument("1.0", "utf-8");
        $dom->xmlStandalone = false;        
        $str = $xml->asXML();
        $dom->loadXML($str);
        $dom->removeChild($dom->doctype);
        $output = $dom->saveXML($dom->getElementsByTagName('x-ui')->item(0));
        
        $df = $this->_n();
        $output = str_replace('<?xml version="1.0" encoding="utf-8"?>','', $output);
        //$output =   "<![CDATA[\n".$output."]]>";        
        $df->appendXML($output);
        return $df;        
    }
    
    protected function getChildWithBooleanAttribute(\DOMNode $el, $name, $attribute_name)
    {
        foreach ($el->childNodes as $c)
        {
            if ($c->localName === $name)
            {
                $attr = $c->getAttribute($attribute_name);
                if (is_value_true($attr))
                    return $c;
            }
        }
        return null;
    }
        
    protected function getFirstChildNode(\DOMNode $el, $name)
    {
        foreach ($el->childNodes as $c)
        {
            if ($c->localName === $name)
            {
                    return $c;
            }
        }
        return null;        
    }
    


    //_____________________________________//
    protected function getSpecificTag($tagname, $source) {
        $regex = '/<' . $tagname . '\\ (.*)>(.+?)<\/' . $tagname . '>/s';
        preg_match_all($regex, $source, $matches);
        return $matches;
    }

    
    
    protected function getApp()
    {
        return $this->data['__app__'];
        
    }
    
    protected function isSCHLIXConfig()
    {
        return ($this->getFormDataKey() == 'config');
    }
    
    protected  function isAuthenticated()
    {
        global $CurrentUser;
        
        return $CurrentUser->authenticated();
        
    }
    
    
    protected  function isAdminApp()
    {
        $app_admin = $this->data['__app__'];
        return ($app_admin != null && $app_admin instanceof \SCHLIX\cmsAdmin_Basic);
    }

    protected function addCustomHTML($html)
    {
        $key = new_uuid_v4();
        $this->replacements[$key] = $html;
        return $this->_e('schlix-xui-html', ['id' => $key, 'class' => 'xui-html'], 'x');
    }
    

    public function containsAllowableNS($str)
    {
        foreach ($this->allowed_namespaces as $ns) if (str_contains($str, '<'.$ns.':')) return true; return false;
    }
    /**
     * Run all tags tags
     * @param string $html
     * @param array $allowed_tagns
     * @return string
     */
    public function Run($html) {

        if (!$this->containsAllowableNS($html))
            return $html;
        if (str_contains($html, '<!ENTITY'))
                die('Entity cannot be used');
        // for securty, all must be replaced as blank first
        $html = $this->performReplacements($html);
        $xml = $this->loadHTMLAsXML($html);
        //LIBXML_HTML_NOIMPLIED
        
        $this->html_document = new \DOMDocument("1.0", "utf-8");
        $this->html_document->xmlStandalone = false;        
        $str = $xml->asXML();
        //$str = mb_convert_encoding($str, 'HTML-ENTITIES', 'UTF-8');
        $this->html_document->loadXML($str);
        

        $this->processAllNodes();

        //$xpath = new \DOMXpath($this->html_document);     
        foreach ($this->allowed_namespaces as $ns)
        {
            //$elements = $xpath->query("*//{$ns}:*");
            $elements = $this->html_document->getElementsByTagNameNS($ns, '*');                    
            if ($elements)
            foreach ($elements as $elem)
            {
                $elem->removeAttributeNS($ns, $elem->localName);            
            }
        }
        
        $this->html_document->formatOutput = true;
        $this->html_document->preserveWhiteSpace = false;
        
        if ($this->html_document->doctype)
        $this->html_document->removeChild($this->html_document->doctype);
        ////$final = $this->html_document->saveHTML();
        
        $final = $this->html_document->saveXML(null, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);

       // echo $this->html_document->saveXML($dom_output, LIBXML_NOEMPTYTAG);
        //$final = str_replace('><', ">\n<", $final); //debug
        //$final = str_replace('/>', "/>\n", $final); //debug
                
        foreach ($this->allowed_namespaces as $ns)
        {
            $final = str_replace(['<'.$ns.' xmlns:'.$ns.'="'.$ns.'">', '</'.$ns.'>'],'', $final);
            //$final = str_replace(['<x-ui xmlns:x-ui="x-ui">', '</x-ui>'],'', $final);
        }
        $final = str_replace('<?xml version="1.0" encoding="utf-8"?>', '', $final);
        $final = $this->cleanUpNameSpaces($final);
        
        preg_match_all( '#<(area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)(\b[^>]*)>#', $final, $matches);
        
        $ttr = $matches[1];
        
        if (___c($ttr) > 0)
        {
            $ttr = array_unique($ttr);
            foreach ($ttr as $t)
                $final = str_replace("></{$t}>",' />', $final);
        }        
        
        $final = $this->performReplacements($final);
        if ($this->has_warning)
        {
            $warning = '<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> '.___('Some values have not been set and may cause some errors. Please configure it and click Save when done').'</div>';
            $final = $warning.$final;
        }
        if ($this->errors)
        {            
            $errors = '<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> '.___('Error');
            $errors.= '<ul class="list-unstyled">';
            foreach ($this->errors as $error)
            {
                $errors.= '<li>'.___h($error).'</li>';
            }
            $errors.='</ul></div>';
            $final = $errors.$final;
        }
        
        return $final;
        //return $html;
    }    
    
    protected function performReplacements($html)
    {
        preg_match_all('#<schlix-xui-html id\="(.*)" class\="xui-html">x</schlix-xui-html>#', $html, $matches);
        $match_count = ___c($matches[0]);
        if ($match_count > 0) {
            for ($i = 0; $i < $match_count; $i++) {
                $full_tag = $matches[0][$i];
                $tag_id = $matches[1][$i];
                //$attrs = $matches[2][$i];
                //$result = $this->parseConfigTag($app_name, $tag_type, $attrs);
                $html = str_replace($full_tag, $this->replacements ? $this->replacements[$tag_id] : '', $html);
            }
        }
        return $html;
    }
    
    /**
     * Traverse array
     * @param array $treecat
     * @param string $method_folder
     * @param string $method_item
     * @param int $parent
     * @param int $depth
     * @param string $field_id
     * @param string $field_cid
     * @param string $field_parent_id
     * @param string $field_title
     * @param string $primary_category_text
     * @return \DOMElement
     */
    protected function traverseArray($treecat, $method_folder, $method_item, $parent = 0, $depth = 0, $field_id = 'id', $field_cid = 'cid', $field_parent_id = 'parent_id', $field_title = 'title', $primary_category_text = 'Primary Category', $has_primary_category = false)
    {
        $ul =  call_user_func([$this, $method_folder], $parent, $depth);        
        
        $menu_count = ___c($treecat);
        
        for ($i = 0; $i < $menu_count; $i++) {
            if ($treecat[$i][$field_parent_id] == $parent) {                
                $tc = $treecat[$i];                
                //array_shift($treecat);
                //unset($treecat[$i]); failed test
                
                $childnodes = $this->traverseArray($treecat, $method_folder, $method_item, $tc[$field_cid], $depth + 1, $field_id, $field_cid, $field_parent_id, $field_title, $primary_category_text, $has_primary_category);
                $c = call_user_func([$this, $method_item], $tc, $childnodes, $field_id, $field_cid, $field_title, $primary_category_text, $has_primary_category);
                $ul->appendChild(($c));                                
                $ul->appendChild($this->_nl());
            }            
        }
        return $ul->hasChildNodes() ? $ul : null;        
    }
    /**
     * Walk ul/li recursively
     * @param \DOMElement $nl
     * @param function $method_folder
     * @param function $method_item
     * @param string $ns
     * @param string $ul_tag
     * @param string $li_tag
     * @return \DOMElement
     */
    protected function traverseList(\DOMElement $nl, $method_folder, $method_item, $ns = 'x-ui', $ul_tag = 'ul', $li_tag = 'li') {
        $result = $this->html_document->createDocumentFragment();
        $add_count = 0;
        foreach ($nl->childNodes as $c)
        {     
            //if ($c->)
            //$full_tag = $c->tagName.':'.$c->nodeValue;
            $the_tag = property_exists($c, 'tagName') ?  $c->tagName : null;
            if ($the_tag == "{$ns}:{$ul_tag}" && $c->hasChildNodes() )
            {
                
                $n_li = call_user_func([$this, $method_folder], $c);
                $n_li_ul = null;
                foreach ($n_li->childNodes as $first_ul) $n_li_ul = $first_ul;                
                $n_li_ul_li = $this->traverseList($c, $method_folder, $method_item, $ns, $ul_tag, $li_tag);
                $n_li_ul->appendChild($n_li_ul_li);
                $result->appendChild($n_li);// dont combine
            }
            elseif ($the_tag == "{$ns}:{$li_tag}" )
            {
                
                $n_li = call_user_func([$this, $method_item], $c);
                $result->appendChild($n_li);
                $result->appendChild($this->_nl()); // dont combine
            }
            
        }
        return $result;
    }    
    
    /**
     * Clean up unwanted attributes
     * @param \DOMNode $node
     * @param array $whitelist
     * @return \DOMNode
     */
    protected function whitelistAttributes(\DOMNode $node, array $whitelist)
    {
        if (___c($whitelist) > 0)
        {
            if ($node->hasAttributes())
            foreach ($node->attributes as $attr)
            {
                if (!in_array($attr->name, $whitelist))
                        $node->removeAttribute($attr->name);
            }
        }
        return $node;
    }
    
    
    /**
     * Clean up unwanted attributes
     * @param \DOMNode $node
     * @param array $blacklist
     * @return \DOMNode
     */
    protected function cleanUpAttributes(\DOMNode $node, array $blacklist)
    {
        if (___c($blacklist) > 0)
        {
            if ($node->hasAttributes())
            {
                $ntr = [];
                foreach ($node->attributes as $attr)
                {                
                    if (in_array($attr->name, $blacklist))                
                    {                    
                        $ntr[] = $attr->name;
                        //$node->removeAttribute($attr->name);
                    }
                }
                foreach ($ntr as $n)
                    $node->removeAttribute($n);
            }
        }
        return $node;
    }
    

    /**
     * Returns a new commnet
     * @param string $string
     * @return \DOMComment
     */
    protected function _comment($string)
    {
        return $this->html_document->createComment($string);
    }
    
    /**
     * Returns a new line \n
     * @return \DOMText
     */
    protected function _nl()
    {
        return $this->_t("\n");
    }
    

    /**
     * Internal - create dom element
     * @param string $element
     * @param array $attrs
     * @param string $node_val
     * @param array|\DOMNode $node_children
     * @return \DOMElement
     */
    protected function _e($element, $attrs = null, $node_val = null, $node_children = null) 
    {
        if ( isset($attrs) && !is_array($attrs))
            throw new \Exception('attrs must be an instance of array');
        $node_val = (string) $node_val;
        $newnode = $this->html_document->createElement($element, $node_val);
        if (___c($attrs) > 0) {
            foreach ($attrs as $key => $val) {
                if (is_null($val))
                    $val = '';
                $newnode->setAttribute($key, $val);
            }
        }
        
        if (is_array($node_children))
        {
            foreach ($node_children as $node)
            {
                
                $newnode->appendChild($node);
            }
        } else if ($node_children instanceof \DOMNode)
        {
            $newnode->appendChild($node_children);
        }
        return $newnode;
    }
    
    /**
     * Internal - create dom element with simple text value
     * @param string $element
     * @param array $attrs
     * @param string $node_val
     * @return \DOMElement
     */
    protected function _es($element, $attrs = null, $node_val = null) 
    {
        if ( isset($attrs) && !is_array($attrs))
            throw new \Exception('attrs must be an instance of array');        
        return $this->_e($element, $attrs, $node_val);
    }
    
    /**
     * Internal - create dom element with nodes
     * @param string $element
     * @param array $attrs
     * @param array|\DOMNode $node_children
     * @return \DOMElement
     */
    protected function _el($element, $attrs = null, $node_children = null) 
    {
        if ( isset($attrs) && !is_array($attrs))
            throw new \Exception('attrs must be an instance of array');        
        return $this->_e($element, $attrs, null, $node_children);
    }    
    
    
    /**
     * Return a new text node
     * @param string $t
     * @return \DOMNode
     */
    protected function _t($t) 
    {
        return $this->html_document->createTextNode($t);
    }    
    
    /**
     * Create a new document fragment
     * @return \DOMNode
     */
    protected function _n()
    {
        return $this->html_document->createDocumentFragment();
    }
    
    /**
     * Clone all child nodes. $prevent_xui_clone parameter is set to true by default, will have to be forced to 
     * @param \DOMNode $origin
     * @param \DOMNode $new_node
     * @param bool $prevent_xui_clone
     * @return \DOMNode
     */
    protected function cloneChildNodes(\DOMNode $origin, \DOMNode $new_node, $prevent_xui_clone = false)
    {
        if (($origin instanceof \DOMElement) || ($new_node instanceof \DOMElement))
        {
            if ($origin->localName == 'textarea')
                $prevent_xui_clone = true;
        }
        if ($origin->hasChildNodes())
        foreach ($origin->childNodes as $c)
        {
            $can_clone = true;
            if ($prevent_xui_clone)
            {
                if ($c instanceof \DOMElement)
                {
                    $can_clone = !str_starts_with($c->tagName,'x-ui') && !str_starts_with($c->tagName,'schlix-config');
                }
            }
            if ($can_clone)
                $new_node->appendChild( $c->cloneNode(true));
        }
        return $new_node;        
    }
    
    protected function getRadioCheckboxCheckedValue(\DOMElement $origin, $standalone)
    {
        $result_chk = false;
        $orig_value =  $origin->getAttribute('value');        
        $a_datafield = trim($origin->getAttribute('data-field'));
        $a_datavar = trim($origin->getAttribute('data-var'));
        $a_name = trim($origin->getAttribute('name'));
                
        if ($standalone && is_postback())
        {
            
            if (isset($_POST[$a_name]))
            {
                $posted_var = $_POST[$a_name];
                $result_chk = $posted_var == $orig_value;
            }
            
        } else 
        
            $result_chk =  !empty($a_datafield) ? ($this->getFormData($a_datafield) === $orig_value) : (!empty($a_datavar) ? (isset($this->data[$a_datavar]) && $this->data[$a_datavar] === $orig_value) : false);
        
        
        
        //$input_value = $this->getInputValue($origin);
        //$result_chk = ($input_value == $orig_value);
        return $result_chk;
    }
            
    
    protected function getFormDataArray()
    {        
        $viewdata = $this->data['view'];
        return $this->data[$viewdata];
    }
    
    protected function getFormDataKey()
    {
        return is_array($this->data) && array_key_exists('view', $this->data) ? $this->data['view'] : null;
    }
    
    protected function getFormData($key)
    {        
        $viewdata = null;
        if (is_array($this->data) && array_key_exists('view', $this->data))
            $viewdata = $this->data['view'];
        return !empty($this->data[$viewdata][$key]) ? $this->data[$viewdata][$key] : null;
    }
    
    /**
     * Return true if a key exists in the form data key
     * @param string $key
     * @return bool
     */
    protected function formDataKeyExists($key)
    {
        $da = $this->getFormDataArray();
        return is_array($da) && array_key_exists($key, $da);
    }
    
    protected function getSanitizedFormData($key)
    {
        return ___h($this->getFormData($key));
    }
    
    
    /**
     * Copy attributes from one node to another
     * @param \DOMElement $origin
     * @param \DOMElement $new_dom_node
     * @param array $whitelist
     * @return \DOMElement
     */
    public function copyAttributesFromNode(\DOMElement $origin, \DOMElement $new_dom_node, $whitelist = [])
    {
        if ($origin != null && $new_dom_node != null)
        {
            foreach ($origin->attributes as $key => $value) {

                $val = trim($value->textContent);
                if (strtolower($key) == 'class')
                {
                    $val = $this->addNewClassNameToClassList($origin->getAttribute($key), $new_dom_node->getAttribute($key)) ; //$old_attr;
                }
                if (___c($whitelist) > 0)
                {
                    if (in_array($key, $whitelist)) $new_dom_node->setAttribute($key, $val);
                } else
                {
                    $new_dom_node->setAttribute($key, $val);
                }
            }     
            return $new_dom_node;
        }
    }
    
    public function copyAttributesFromArray(\DOMElement $new_dom_node, $attrs)
    {
        if (___c($attrs) > 0 && $new_dom_node != null)
        {
            foreach ($attrs as $key => $value) {

                $val = trim($value);
                if (strtolower($key) == 'class')
                {
                    $val = $this->addNewClassNameToClassList($key, $new_dom_node->getAttribute($key)) ; //$old_attr;
                }
                $new_dom_node->setAttribute($key, $val);
            }     
            return $new_dom_node;
        }
    }
    
    /**
     * Get input value from any of the following attributes:
     * data-field, data-var, default-value. You can also specify the alternative
     * name attribute on the second parameter
     * 
     * If there is a postback, the value will be retrieved from the $_POST variable if the posted CSRF token is valid
     * @param \DOMElement $node
     * @param string $attr_name
     * @return mixed
     */
    protected function getInputValue(\DOMElement $node, $attr_name = '')
    {
        $attr_default_value = trim($node->getAttribute('default-value'));
        $attr_data_field = $node->getAttribute('data-field');      
        $attr_data_var = $node->getAttribute('data-var');
        $attr_name = !empty($attr_name) ? $attr_name : $node->getAttribute('name');
        
        $value = null;
        if ($attr_data_field || $attr_data_var)
        {
            if (!is_postback())
            {        
                if ($attr_data_field)
                {
                    $value = $this->getFormData($attr_data_field);
                } else if ($attr_data_var)
                {                
                    $value = isset($this->data[$attr_data_var]) ? $this->data[$attr_data_var] : null;
                }
                $non_zero =  ((int) $node->getAttribute('min') > 0) && ($value == 0);
                if (($value == NULL || $value == '' || $non_zero) && !empty($attr_default_value))         
                {
                    
                    $value = $attr_default_value;   
                }
                
            } else 
            {
                if (is_valid_csrf())
                {
                    //echo $attr_data_field.'~'.$attr_name.'|';
                    //if (str_contains($attr_name, $needle))
                    $x_name = empty($attr_name) ? $attr_data_field : $attr_name;
                    $x_name = str_replace('[]','', $x_name);
                    $value = isset($_POST[$x_name]) ? $_POST[$x_name] : null;
                    if (is_string($value))
                        $value = trim($value);
                    
                }
            }        
        }
        return $value;
    }
    
    protected function autoSetFormAttributeValue($node, $attr_field_value = 'value')
    {
        $textareas = ['textarea', 'wysiwyg'];
        if ($node == null)
            return;
        
        $attr_data_field = $node->getAttribute('data-field');
        $attr_data_var = $node->getAttribute('data-var');
        $attr_name = $node->getAttribute('name');
        $attr_id = $node->getAttribute('id');
        
        $value = $this->getInputValue($node, $attr_name);
        if (!empty($attr_data_field) || !empty($attr_data_var))
        {
            switch ($node->localName)
            {
                case 'textarea':
                case 'wysiwyg':
                    if ($value == null)
                        $value = '';
                    $value = str_replace(['<x-ui:','<schlix-config:'],'', $value);
                    $node->appendChild($this->_t($value));
                    break;
                default:
                    // Add handling for datetime-local
                    if ($node->getAttribute('type') == 'datetime-local')
                    {
                        if (is_date($value, 'Y-m-d H:i:s'))
                            $value = str_replace(' ','T', $value);
                    }
                    //// end 
                    if (!empty($value))
                    {
                        //echo "SET {$attr_name} {$attr_field_value} = {$value}<br />";
                        $node->setAttribute($attr_field_value, $value);                        
                    }
                    
            }
            /*if (in_array($node->localName, $textareas))
            {
            } else 
            {
                if (!empty($value))
                {
                    //echo "SET {$attr_name} {$attr_field_value} = {$value}<br />";
                    $node->setAttribute($attr_field_value, $value);                        
                }
            }*/

        } else 
        {
            throw new \Exception ("Invalid operation: data-field attribute is not defined for node {$node->localName} id={$attr_id} and name={$attr_name}");
        }
        return $node;
    }

    
    /**
     * Clone a node
     * @param \DOMNode $original_node
     * @param string $input
     * @param array $attrs
     * @param string $node_val
     * @param array $node_children
     * @return type
     */
    protected function _input($original_node, $input, $attrs = null, $node_val = null, $node_children = null, $set_view_data = true) 
    {        
        if ( isset($attrs) && !is_array($attrs))
            throw new \Exception('attrs must be an instance of array');        
        $n = $this->_e($input, $attrs, $node_val, $node_children);
        if ($original_node != null)
        {
            $this->copyAttributesFromNode($original_node, $n);
            $dt_field = $original_node->attributes['data-field'];
            $dt_var = $original_node->attributes['data-var'];

            if ($set_view_data && (!empty($dt_field) || !empty($dt_var)))
            {
                //$k = $dt_field->textContent;
                // safety check
                //$n->setAttribute('value', $this->getSanitizedFormData($k));
                if ($n->getAttribute('data-field') || $n->getAttribute('data-var'))
                $n = $this->autoSetFormAttributeValue($n);
            }
            $n = $this->cleanUpAttributes($n, ['data-field', 'data-var', 'default-value']);
        }
        return $n;        
    }
    
    /**
     * Clone a node
     * @param \DOMNode $original_node
     * @param string $input
     * @param array $attrs
     * @param string $node_val
     * @param array $node_children
     * @return type
     */
    protected function _elems($original_node, $input, $attrs = null, $node_val = null, $node_children = null) 
    {
        if ( isset($attrs) && !is_array($attrs))
            throw new \Exception('attrs must be an instance of array');        
        $n = $this->_e($input, $attrs, $node_val, $node_children);
        if ($original_node != null)
        {
            $this->copyAttributesFromNode($original_node, $n);
            $this->cloneChildNodes($original_node, $n);
        }
        return $n;        
    }
    
    protected function dom_font_icon($icon)
    {
        $node = $this->_e('i',['class' => $icon]);
        return $node;
    }
            
        
    protected function nodeHasChildAnyType(\DOMNode $node, array $possibles) {
        
        if ($node->hasChildNodes())
        {
            foreach ($node->childNodes as $old_child_node) 
            {
                if (in_array($possibles, $old_child_node->nodeName, true))
                {
                    return true;                
                }
            }
        }
        return false;
    }
    

    private function replaceNodeWithNewTag($ns, $old_tag) {

        $tag_name = $old_tag;
        $xns = alpha_numeric_only($ns);
        $methodname = $xns.'_' . str_replace('-', '_', $tag_name);
        
        try {

            if (method_exists($this, $methodname)) {
                $dom_list = $this->html_document->getElementsByTagNameNS($ns, $old_tag); //all namespaces, all local names        

                $i = $dom_list->length - 1;

                while ($i > -1) {
                    $element = $dom_list->item($i);
                    $ignore = false;
                    
                    $new_node = call_user_func([$this, $methodname], $element);
                    if ($new_node != null)
                        $element->parentNode->replaceChild($new_node, $element);
                    $i--;
                }
            }
        } catch (\Exception $c) {
            $this->errors[] = $c->getMessage();
        }
    }

    public function processAllNodes()
    {        
        foreach ($this->allowed_namespaces as $ns)
        {
            $elements = $this->html_document->getElementsByTagNameNS($ns, '*');        
            $has_hook = false;

            $all_elems = [];
            foreach ($elements as $elem)
            {
                $ln = $elem->localName;
                if (!in_array($ln, $all_elems))
                {
                    if (strtolower($ln) === 'hook')
                        $has_hook = true;
                    else 
                        $all_elems[] = $ln;
                }
            }
            if ($has_hook)
                array_unshift ($all_elems, 'hook');
            foreach ($all_elems as $e)
            {
                $this->replaceNodeWithNewTag($ns,$e);
            }
        }
        
    }    
    
    private function sanitizeResult($c)
    {
        $config_key = $c['key'];
        $config_prefix = '';
        $prefix_pos = strpos($config_key, '_');
        if ($prefix_pos !== FALSE) {
            $config_prefix = substr($config_key, 0, $prefix_pos);
        }
        switch ($config_prefix) {
            case 'array':
                $result = safe_unserialize_array($c['value']);
                break;
            case 'float':
                $result = (float) $c['value'];
                break;
            case 'double':
                $result = (float) $c['value'];
                break;
            case 'int':
                $result = (int) $c['value'];
                break;
            case 'bool':
                if ($c['value'] === '' || $c['value'] === NULL)
                    $result = NULL;
                else
                {
                    $result = ((bool) $c['value']) ? 1: 0;
                }
                
                break;
            case 'str':
            case 'string':
            default:
                $result = strval($c['value']);
                break;
        }
        return $result;
    }

    protected function determineConfigValue(\DOMElement $origin)
    {
        return $this->determineInputValue($origin, 'value', 'config-default-value', 'config-key', true);
    }


    //________________________________________________________________________//
    /**
     * Load config file for components
     * @param string $component_name
     * @param string $item
     * @param string $item_name
     * @param string $instance_name
     * @return string
     */
    public static function loadConfigFile($component_name, $item, $item_name, $instance_name)
    {
        // $item is used in the config file, do not delete from the parameter despite netbeans indicating that it's not being used
        $tbla = ['wysiwygeditors' =>'gk_wysiwyg_config', 'macros' => 'gk_macro_config', 'blocks' => 'gk_block_config', 'themes' => 'gk_theme_config'];
        $tbl = $tbla[$component_name];
        if (!$tbl)
            die (___('Error: could not determine the table name for this configuration set'));
        $item_name = convert_to_safe_filename($item_name);
        $filename = get_system_or_user_file("/{$component_name}/{$item_name}/config.template.php",false); 
        if (file_exists($filename)) {
            
            $admin_language = SCHLIX_DEFAULT_LANGUAGE;
            if ($admin_language != 'en_us')
            {
                $language_filename = get_system_or_user_file("/{$component_name}/{$item_name}/languages/{$admin_language}.lang.php", FALSE); 
                if (file_exists($language_filename))
                    include_once($language_filename);
            }
            
            $component_config = new \SCHLIX\cmsConfigRegistry($tbl);
            // ugh - backward compatibility. these variables will be required in the template file
            switch ($component_name)
            {
                case 'wysiwygeditors': $wysiwyg_config = $component_config; break;
                case 'blocks': $block_config = $component_config; break;
                case 'macros': $macro_config = $component_config; break;
                case 'themes': $theme_config = $component_config; break;
            }

            ob_start();
            // $item will be needed here
            include_once ($filename);
            $config_html = ob_get_contents();
            ob_end_clean();
            
            $config_vars = $component_config->get($instance_name);
            
            
            $vars = ['app' => $component_config, 'view' => 'config', 'config' => $config_vars];
            //$local_variables['view'] = 'item';
            
            
            //return $component_config->processConfigTags($instance_name, $config_html);
            
            return skin_html($config_html, $vars, ['x-ui','schlix-config']);
        } else
            return \__HTML::P(sprintf(___('No configuration file can be found for %s'), ___h($item_name)));
    }    
    /**************************************************************************/

    protected function determineInputValue(\DOMElement $origin, $attr_value = 'value', $attr_default_value = 'default-value', $attr_data_field = 'data-field', $generate_warning = false)
    {
        $default_value = $origin->getAttribute($attr_default_value);
        $a_df = $origin->getAttribute($attr_data_field);
        $value = $this->getFormData($a_df);
        
        
        $original_value = $value;
        if (($value == NULL || $value == '') && !empty($default_value)) {            
            $value = $default_value;
            //$origin->setAttribute($attr_value, $default_value);
            /*$formgroup_css_class.= ' has-warning';
            $wrapper_warning = ' '.\__HTML::I('',array('class' => 'fa fa-exclamation-triangle'));
            $this->has_warning = true;*/
            return ['warning' => true, 'value' => $value, 'default' => $default_value];
        } else 
        {
            return ['warning' => false, 'value' => $value, 'default' => $default_value];
        }
        
    }
    
    /**
     * Parse attributes from a taag, e.g.
     * <schlix-config config-key="int_number" value="test" label="This Key" config-default-value="123" />
     * @param \DOMElement $origin
     * @return string
     */
    protected function parseAttributes($origin) {

        $final_attrs = [];
        $label = '';
        $name = '';
        $fonticon = '';
        $default_value = null;
        if ($origin->hasAttributes()) {
                foreach ($origin->attributes as $attr) {
                    $key = $attr->nodeName;
                    $value = $attr->nodeValue;
                    switch ($attr->nodeName) {

                    case 'label':
                        $label = $value;
                        break;
                    case 'config-default-value':
                        $default_value = $value;
                        break;
                    case 'config-key':
                        if (!isset($final_attrs['id'] ))
                            $final_attrs['id'] = $value;
                        $final_attrs['data-field'] = $value;
                        $name = $value;
                        break;
                    case 'config-fonticon':
                        $fonticon = $value;
                        break;
                    default:
                        $final_attrs[$key] = $value;
                        break;
                }
            }
        }
        $result = array('label' => $label, 'attributes' => $final_attrs, 'name' => $name, 'default_value' => $default_value, 'fonticon' => $fonticon);
        if (isset($default_value))
            $result['default_value'] = $default_value;
        return $result;
    }


    /**
     * Old version
     
    protected function parseAttributes($str_attribute) {

        // v2.1.0-2 $regex = "@(\S+)=(\"|'|)(.*)(\"|'|>)@isU";
        // v2.1.1-1 update regex
        $regex = "@(?:(\S+)\s*=\s*(\"[^\"]*\"|'[^']*'|[^\"'<>\s]+)\s+)+@isU";
        preg_match_all($regex, $str_attribute, $matches);
        $match_count = ___c($matches[0]);
        $attrs = [];
        if ($match_count > 0) {
            for ($i = 0; $i < $match_count; $i++) {
                $quoted_value = $matches[2][$i];
                $unquoted_value = substr($quoted_value,1,strlen($quoted_value)-2);
                $key = $matches[1][$i];
                $value = $unquoted_value; // $matches[3][$i];
                $attrs[$key] = $value;
            }
        }
        $result = $this->generateNewAttributes($attrs);
        
        return $result;
    }    */


    protected function safe_attribute_name($name)
    {
        $name = preg_replace('/[^a-zA-Z0-9-_\[\]]/', '-', $name);
        return trim($name, ' -');
    }
    

       
    protected function safe_var($var, $encode)
    {
        $forbidden = ['<x-ui:','<!ENTITY'];
        if ($var == NULL)
            $var = '';
        $var = str_replace($forbidden,'', $var);
        /*foreach ($blank_replace as $r)
        /*if (str_contains($var, $r))
        {
            $var = str_replace($r,'', $var);
        }*/
        return $encode ? ___h($var) : $var;
    }
    /**
     * Safe html, not html-encoded to use html-encoding, add parameter html-encode="1"
     * @param \DOMElement $origin
     * @return string
     */
    
    protected function xui_echo_safe_html_var(\DOMElement $origin)
    {
        $a_var = $origin->getAttribute('var');
        $a_encode = is_value_true($origin->getAttribute('encode'));
        $var = $this->data[$a_var];
        
        return $this->addCustomHTML( $this->safe_var($var, $a_encode) );
    }
    
    protected function xui_echo_safe_html_field(\DOMElement $origin)
    {
        $a_var = $origin->getAttribute('var');
        $a_encode = is_value_true($origin->getAttribute('encode'));
        $var = $this->getFormData($a_var);
        
        return $this->addCustomHTML( $this->safe_var($var, $a_encode) );
    }
    
    protected function xui_echo_safe_config_value(\DOMElement $origin)
    {
        $app = $this->getApp();
        $a_var = $origin->getAttribute('key');
        $a_encode = is_value_true($origin->getAttribute('encode'));
        if (method_exists($app, 'getConfig'))
        {
            $var = $app->getConfig($a_var);
            return $this->addCustomHTML( $this->safe_var($var, $a_encode) );
        }
        
    }
    

    /**
     * Temporary fix 
     * @internal
     * @param \DOMElement $origin
     * @return array
     */
    protected function getSchlixConfigTempFixDOMAttr(\DOMElement $origin)
    {
        $tag_conf = $this->parseAttributes($origin);       
        // exception
        if ($origin->getAttribute('name') == 'str_alias')
            $value = $this->getFormData('str_alias');
        else
            $value = $this->getFormData($tag_conf['name']);
        
        $default_value = $tag_conf['default_value'];
        $has_warning = false;
        if (($value == NULL || $value == '') && !empty($default_value)) {                        
            $value = $default_value;
            $has_warning = true;            
            $this->has_warning = true;
        }
        $attrs = [];
            $attrs['fonticon'] = $tag_conf['fonticon'];
        
        $attrs['label'] = $tag_conf['label'];
        $attrs['name'] = $tag_conf['name'];        
        if (isset($value))
            $attrs['value'] = $value;
        if ($has_warning)
            $attrs['has-warning'] = 1;
        foreach ($tag_conf['attributes'] as $k => $v)
            $attrs[$k] = $v;
        return $attrs;
        
    }
    

    /**
     * Config action toolbar buttons
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function schlixconfig_action_buttons (\DOMElement $origin) 
    {        
    }    
    
    /**
     * Config - application alias
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function schlixconfig_app_alias(\DOMElement $origin) 
    {
        $origin->setAttribute('data-field', 'str_alias');
        $origin->setAttribute('name', 'str_alias');
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        $value = $this->getFormData('str_alias');
        if (empty($value))
            $value = $this->getApp()->frontendApp()->getApplicationNameOnly();
        $label = ___('Application Alias');
        $attrs['data-field'] =  $attrs['name'] = $attrs['id'] = 'str_alias';
        $attrs['placeholder'] = $label;
        $attrs['value'] = $value;
        $attrs['required'] = 'required';
        $attrs['fonticon'] = 'fa fa-puzzle-piece';
        $attrs['label'] = $label;
        $attrs['pattern'] = '^[a-zA-Z][a-zA-Z0-9\-_\.]{1,50}$';
        
        return $this->xui_textbox($this->_e('input',$attrs));
        
    }
    
        
    /**
     * Config - application description
     * @param \DOMElement $origin
     * @return \DOMElement
     */

    protected function schlixconfig_app_description(\DOMElement $origin) {
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        $value = $this->getFormData('str_alias');
        if (empty($value))
            $value = $this->getApp()->frontendApp()->getApplicationNameOnly();
        $label = ___('Application Description');
        $attrs['data-field'] =  $attrs['name'] = $attrs['id'] = 'str_app_description';
        $attrs['placeholder'] = $label;
        $attrs['value'] = $value;
        $attrs['fonticon'] = 'far fa-file-alt';
        $attrs['label'] = $label;
        $attrs['pattern'] = '.{1,50}';
        
        return $this->xui_textbox($this->_e('input',$attrs));
        
    }
    protected function xui_schlix_multi_source_media_uploader(\DOMElement $origin) {
        
    }
    
    protected function schlixconfig_schlix_multi_source_media_uploader(\DOMElement $origin) {
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);

        $attrs['data-field'] = $origin->getAttribute('config-key');
        
        $el = $this->_el('input', $attrs);
        
        return $this->xui_schlix_multi_source_media_uploader($el);
        
    }    
    protected function schlixconfig_image_selector(\DOMElement $origin) {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        $attrs['id'] = $attrs['name'];
        $attrs['placeholder'] = ___('Image URL/path');
        
        $ig = $this->xui_input_group($this->_e('div'));
        $fg = $this->xui_form_group($this->_e('div'));
        $iga = $this->xui_input_addon($this->_el('span', null, $this->internal_fonticon('fa fa-image')));        
        $input = $this->xui_textbox($this->_e('input',$attrs));
        $iga_button = $this->xui_input_addon($this->_el('span', null, $this->_el('a', ['href' => 'javascript:void(0)', 'class' => 'schlix-image-picker schlix-image-picker-file', 'data-target' => $attrs['id']], $this->internal_icon_text( $this->_e('span', ['label' =>___('Please select an image'), 'fonticon' => 'fa fa-image'] )))));
        
        
        $ig->appendChild($iga);
        $ig->appendChild($input);
        $ig->appendChild($iga_button);
        $fg->appendchild($ig);
        
        
        return $fg;
        
    }
    
    
    protected function schlixconfig_colorpicker(\DOMElement $origin) {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        $attrs['type'] = 'color';   
        return $this->xui_textbox($this->_e('input',$attrs));
        
    }
    protected function schlixconfig_fonticon(\DOMElement $origin) {
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        
        $attrs['data-icon'] = isset($attrs['value']) ? $attrs['value'] : null;
        $attrs['data-iconset'] = 'fontawesome';
        $attrs['role'] = 'iconpicker';
        
        unset($attrs['value']);
        
        return $this->xui_button_default($this->_e('input',$attrs));
        
    }
    protected function schlixconfig_hidden(\DOMElement $origin) {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        
        return $this->xui_hidden($this->_e('input',$attrs));
        
    }
    protected function schlixconfig_textarea(\DOMElement $origin) {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        return $this->xui_textarea($this->_e('textarea',$attrs));
        
/*                $tag_conf['attributes']['class'] = 'form-control';
                $str_result = \INPUT::TEXTAREA($tag_conf['name'], $value , $tag_conf['attributes']);
                if ($tag_conf['label'])
                    $str_result = \__HTML::LABEL_FOR($tag_conf['label'], $tag_conf['name']) . $str_result;
*/        
        //$str = $this->_schlixconfig_legacy_code($origin, 'textarea');
        //return $this->addCustomHTML($str);
        
    }
    
    
    protected function schlixconfig_checkbox(\DOMElement $origin)
    {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        //print_r($attrs);
        $original_value = $this->getFormData($attrs['name']);
        $attrv = isset($attrs['value']) ? $attrs['value'] : null;
        $real_warning = ($this->has_warning && $attrv ===NULL);
        $checked = (int) $attrv > 0; //($original_value === NULL && $attrs['default_value']);
        if ($checked)
            $attrs['checked'] = 'checked';
        //print_r($original_value);
        
        return $this->xui_checkbox($this->_e('checkbox',$attrs)); 
    }

    
    protected function schlixconfig_textbox(\DOMElement $origin) {
        
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        
        return $this->xui_textbox($this->_e('input',$attrs));
        
        
    }
    
    protected function schlixconfig_integerbox(\DOMElement $origin) {
        
        $attrs = $this->getSchlixConfigTempFixDOMAttr($origin);
        $attrs['type'] = 'number';
        return $this->xui_textbox($this->_e('input',$attrs));
        
        //$str = $this->_schlixconfig_legacy_code($origin, 'integerbox');
        //return $this->addCustomHTML($str);
        
    }

    
    protected function schlixconfig_meta_options(\DOMElement $origin) {
        $str = $this->_schlixconfig_legacy_code($origin, 'meta_options');
        return $this->addCustomHTML($str);
        
    } 
    
    protected function schlixconfig_item_meta_options(\DOMElement $origin) {
        $str = $this->_schlixconfig_legacy_code($origin, 'item_meta_options');
        return $this->addCustomHTML($str);
        
    } 
    
    protected function schlixconfig_category_meta_options(\DOMElement $origin) {
        $str = $this->_schlixconfig_legacy_code($origin, 'category_meta_options');
        return $this->addCustomHTML($str);
        
    } 
    
    
    protected function schlixconfig_main_page_meta_options(\DOMElement $origin) {
        $str = $this->_schlixconfig_legacy_code($origin, 'main_page_meta_options');
        return $this->addCustomHTML($str);
        
    } 


    /**
     * TODO: This function needs to be refactored. Legacy code from pre-2.2.0
     * @param \DOMElement $origin
     * @param string $tag_type
     * @return string
     */
    protected function _schlixconfig_legacy_code(\DOMElement $origin, $tag_type) {
        $app_admin = $this->getApp();
        $tag_conf = $this->parseAttributes($origin);
        
        if ($tag_type == 'app_alias')
            $value = $this->getFormData('str_alias');
        else
        if ($tag_type != 'app_description')
            $value = $this->getFormData($tag_conf['name']);
        $default_value = $tag_conf['default_value'];

        $formgroup_css_class = 'form-group';
        $wrapper_warning = '';
        $original_value = $value;
        if (($value == NULL || $value == '') && !empty($default_value)) {            
            $value = $default_value;
           
            $formgroup_css_class.= ' has-warning';
            $wrapper_warning = ' '.\__HTML::I('',array('class' => 'fa fa-exclamation-triangle'));
            $this->has_warning = true;
        }
        
        $fg = \__HTML::DIV_start(array('class' => $formgroup_css_class));
        $fg_end = \__HTML::DIV_end();
        
        $needs_input_group = !empty($tag_conf['fonticon']);
        
        $ig = \__HTML::DIV_start(array('class' => 'input-group'));
        $ig_end = \__HTML::DIV_end();
        
        $iga = \__HTML::DIV_start(array('class' => 'input-group-addon'));
        $iga_end = \__HTML::DIV_end();
        $str_result = null;
        
        switch ($tag_type) {
           /* case 'app_alias' :
                $value = $this->getFormData('str_alias');

                $label = ___('Application Alias');
                $tag_conf['attributes']['id'] = 'str_alias';
                $tag_conf['attributes']['placeholder'] = $label;
                $tag_conf['attributes']['required'] = 'required';
                $tag_conf['attributes']['class'] = 'form-control';
                $tag_conf['attributes']['pattern'] = '^[a-zA-Z][a-zA-Z0-9-_\.]{1,50}$';
                if (empty($value))
                    $value = $default_value;
                
                $str_result =  $ig.$iga.\__HTML::I_start(['class'=>'fa fa-puzzle-piece']).\__HTML::I_end().$iga_end;
                $str_result.= \INPUT::TEXT('str_alias', $value, $tag_conf['attributes']);
                $str_result.= $ig_end;
                
                
                $str_result = $fg.\__HTML::LABEL_FOR($label.$wrapper_warning, 'str_alias') . $str_result. $fg_end;
                break
            case 'app_description':
                $value = $this->getFormData('str_app_description');
                $label = ___('Application Description');
                $tag_conf['attributes']['id'] = 'str_app_description';
                $tag_conf['attributes']['class'] = 'form-control';
                $tag_conf['attributes']['placeholder'] = $label;
                //$tag_conf['attributes']['required'] = 'required';
                $tag_conf['attributes']['pattern'] = '.{1,50}';
                $str_result = $fg;
                if ($tag_conf['label'])
                    $str_result.= \__HTML::LABEL_FOR($tag_conf['label'].$wrapper_warning, $tag_conf['name']);
                else
                    $str_result.= \__HTML::LABEL_FOR($label.$wrapper_warning, 'str_app_description');
                $str_result.=  $ig.$iga.\__HTML::I_start(['class'=>'far fa-file-alt']).\__HTML::I_end().$iga_end;                
                $str_result.= \INPUT::TEXT('str_app_description', $value, $tag_conf['attributes']);
                $str_result.= $ig_end;                
                $str_result.= $fg_end;
                break;;*/
            case 'main_page_meta_options': 
                
                $item_per_column = $tag_conf['attributes']['item-per-column'] ?  $tag_conf['attributes']['item-per-column'] : 1;
                $column_count =  $tag_conf['attributes']['column-count'] ? $tag_conf['attributes']['column-count'] : 3;
                
                $arr_opt = $app_admin ? $this->getApp()->frontendApp()->getMainpageMetaOptionKeys() : []; //self::decodeArray($tag_conf['attributes']['config-options']);
                
                $arr_values =  is_string($value) ? '' : @serialize($value);
/*config-options="<?= \SCHLIX\cmsConfigRegistry::encodeArray($this->app->getMainpageMetaOptionKeys()) ?>" config-default-value="<?= \SCHLIX\cmsConfigRegistry::encodeArray($this->app->getDefaultMainpageMetaOptionKeys()) ?>" */                
                $arr_default_options = $app_admin ? $this->getApp()->frontendApp()->getDefaultMainpageMetaOptionKeys() : [];
                $str_result.=  \INPUT::CMSObjectOptions($tag_conf['name'], $arr_opt, $arr_values, $arr_default_options, $item_per_column, $column_count);
                
                break;
            
            case 'item_meta_options': 
                
                $item_per_column = $tag_conf['attributes']['item-per-column'] ?  $tag_conf['attributes']['item-per-column'] : 1;
                $column_count =  $tag_conf['attributes']['column-count'] ? $tag_conf['attributes']['column-count'] : 3;
                
                $arr_opt = $app_admin ? $this->getApp()->frontendApp()->getItemMetaOptionKeys() : []; //self::decodeArray($tag_conf['attributes']['config-options']);
                
                $arr_values =  is_string($value) ? '' : @serialize($value);
                
                $arr_default_options = $app_admin ? $this->getApp()->frontendApp()->getDefaultItemMetaOptionKeys() : [];
                $str_result.=  \INPUT::CMSObjectOptions($tag_conf['name'], $arr_opt, $arr_values, $arr_default_options, $item_per_column, $column_count);
                
                break;
            
            case 'category_meta_options': 
                $item_per_column = $tag_conf['attributes']['item-per-column'] ?  $tag_conf['attributes']['item-per-column'] : 1;
                $column_count =  $tag_conf['attributes']['column-count'] ? $tag_conf['attributes']['column-count'] : 3;
                
                
                $arr_opt = $app_admin ? $this->getApp()->frontendApp()->getCategoryMetaOptionKeys() : []; //self::decodeArray($tag_conf['attributes']['config-options']);
                
                $arr_values =  is_string($value) ? '' : @serialize($value);
                
                $arr_default_options = $app_admin ?  $this->getApp()->frontendApp()->getDefaultCategoryMetaOptionKeys() : [];
                $str_result.=  \INPUT::CMSObjectOptions($tag_conf['name'], $arr_opt, $arr_values, $arr_default_options, $item_per_column, $column_count);
                
                break;
            
                
            case 'meta_options': 
                $item_per_column = $tag_conf['attributes']['item-per-column'] ?  $tag_conf['attributes']['item-per-column'] : 1;
                $column_count =  $tag_conf['attributes']['column-count'] ? $tag_conf['attributes']['column-count'] : 3;
                
                $arr_opt = self::decodeArray($tag_conf['attributes']['config-options']);
                $arr_values =  is_string($value) ? '' : @serialize($value);
                
                $arr_default_options = self::decodeArray($default_value);
                $str_result.=  \INPUT::CMSObjectOptions($tag_conf['name'], $arr_opt, $arr_values, $arr_default_options, $item_per_column, $column_count);
                
                break;
            /*case 'integerbox':
                $str_result = $fg;
                if ($tag_conf['label'])
                    $str_result.= \__HTML::LABEL_FOR($tag_conf['label'].$wrapper_warning, $tag_conf['name']);
                $tag_conf['attributes']['class'] = 'form-control';
                $tag_conf['attributes']['class'] = $tag_conf['attributes']['class'] . ' numericbox';
                $str_result.= \INPUT::NUMBER($tag_conf['name'], $value, $tag_conf['attributes']);
                $str_result.= $fg_end;
                break; 
            case 'imageselector':
                $str_result = $fg;
                if ($tag_conf['label'])
                    $str_result.= \__HTML::LABEL_FOR($tag_conf['label'].$wrapper_warning, $tag_conf['name']);
                $str_result.= \__HTML::DIV_start(['class' => 'input-group']);
                $tag_conf['attributes']['class'] = $tag_conf['attributes']['class'] . ' imagebox';
                $str_result.= \INPUT::TEXT($tag_conf['name'], $value, $tag_conf['attributes']);
                $str_result.= \__HTML::SPAN_start(['class'=>'input-group-addon']);
                $str_result.= \__HTML::A(___('Select an image'),'javascript:void(0)',
                    ['class' => 'schlix-media-select', 
                    'data-target'=> $tag_conf['name']]);
                $str_result.= \__HTML::SPAN_end();
                $str_result.= \__HTML::DIV_end();
                $str_result.= $fg_end;
                break;
                
            /*case 'colorpicker':
                $tag_conf['attributes']['class'] = $tag_conf['attributes']['class'] . ' short-text';
                $str_result = \INPUT::COLOR($tag_conf['name'], $value, $tag_conf['attributes']);

                if ($tag_conf['label'])
                    $str_result = \__HTML::LABEL_FOR($tag_conf['label'], $tag_conf['name']) . $str_result;
                break;
            case 'fonticon':
                $str_result = $fg;
                if ($tag_conf['label'])
                    $str_result.= \__HTML::LABEL_FOR($tag_conf['label'].$wrapper_warning, $tag_conf['name']);
                
                $tag_conf['attributes']['class'] = $tag_conf['attributes']['class'] . ' fonticon-button-selector';
                // data-iconset="fontawesome" data-icon
                $tag_conf['attributes']['data-icon'] = $value;
                $tag_conf['attributes']['data-iconset'] = 'fontawesome';
                $tag_conf['attributes']['role'] = 'iconpicker';
                //echo \INPUT::BUTTON($tag_conf['name'], $value, $tag_conf['attributes']);;die;
                $str_result.= \INPUT::BUTTON($tag_conf['name'], '', $tag_conf['attributes']);
                $str_result.= $fg_end;
                break;
            /*case 'hidden':
                $str_result.= \INPUT::HIDDEN($tag_conf['name'], $value, $tag_conf['attributes']);                
                break;
            case 'textbox':
                $str_result = $fg;
                $tag_conf['attributes']['class'] = 'form-control';
                if ($tag_conf['label'])
                    $str_result.= \__HTML::LABEL_FOR($tag_conf['label'].$wrapper_warning, $tag_conf['name']);
                if ($needs_input_group)
                    $str_result.=  $ig.$iga.\__HTML::I_start(['class'=>$tag_conf['fonticon']]).\__HTML::I_end().$iga_end;
                $str_result.= \INPUT::TEXT($tag_conf['name'], $value, $tag_conf['attributes']);
                if ($needs_input_group)
                    $str_result.= $ig_end;                
                $str_result.= $fg_end;
                
                break;
            case 'textarea':
                //$str_result = \INPUT::TEXTAREA($tag_conf['name'], "<![CDATA[\n" . $value . "]]>", $tag_conf['attributes']);
                $tag_conf['attributes']['class'] = 'form-control';
                $str_result = \INPUT::TEXTAREA($tag_conf['name'], $value , $tag_conf['attributes']);
                if ($tag_conf['label'])
                    $str_result = \__HTML::LABEL_FOR($tag_conf['label'], $tag_conf['name']) . $str_result;
                break;
            case 'checkbox':
                $real_warning = ($this->has_warning && $original_value===NULL);
                if ($original_value === NULL && $default_value)
                    $original_value = true; // what a mess
                $extra_warning = $real_warning && $value == false ? ' ('.___('unchecked by default').')' : '';
                $str_checkbox = \INPUT::HIDDEN($tag_conf['name'], '0') . \INPUT::CHECKBOX($tag_conf['name'], '1', $original_value, $tag_conf['attributes']);
                if ($tag_conf['label'])
                    $str_result = \__HTML::LABEL($tag_conf['label'].$extra_warning, $str_checkbox, false);
                
                $checkbox_class = $real_warning ? 'checkbox '.$formgroup_css_class : 'checkbox';
                $str_result = \__HTML::DIV_start(array('class' => $checkbox_class)) . $str_result . \__HTML::DIV_end();
                break;*/
            default: return '';
        }

        return $str_result;
    }
    

    /**
     * 
     * @internal Combo - checkox/radio group & user permission group
     * @global \App\Users $CurrentUser
     * @param string $input_type
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function _schlixconfig_checkbox_radio_group($input_type, \DOMElement $origin) {
        
        global $CurrentUser;
        
        $new_node_options = $this->parseAttributes($origin);
        $attr = $new_node_options['attributes'];
        $config_key = $new_node_options['name'];
        
        if ($config_key != 'app_alias' && $config_key != 'app_description')
            $config_value = $this->getFormData( $config_key);
        
        switch ($input_type) {

            case 'radio-group':
            case 'radiogroup':
                $parent_class = 'radiogroup';
                $option_item_wrapper_class = 'radio';
                $multi_select = false;
                $option_tag = 'input';
                $option_tag_type = 'radio';
                $__not_done = true;
                $option_item = [];
                foreach ($origin->childNodes as $old_child_node) {
                    if ($old_child_node->nodeName === 'schlix-config:option')
                        $option_item[$old_child_node->getAttribute('value')] = $old_child_node->nodeValue;
                }
                break;
            case 'checkbox-group':
            case 'checkboxgroup':
                $parent_class = 'checkboxgroup';
                $option_item_wrapper_class = 'checkbox';
                $option_tag = 'input';
                $option_tag_type = 'checkbox';
                $multi_select = true;
                $__not_done = true;
                $option_item = [];
                foreach ($origin->childNodes as $old_child_node) {
                    if ($old_child_node->nodeName === 'schlix-config:option')
                        $option_item[$old_child_node->getAttribute('value')] = $old_child_node->nodeValue;
                }

                break;
            case 'permission-user-groups':
            case 'permission-usergroups':
            case 'permission-backend-access':
                $parent_class = 'checkboxgroup';
                $option_item_wrapper_class = 'checkbox';
                $option_tag = 'input';
                $option_tag_type = 'checkbox';
                $multi_select = true;
                $__not_done = true;
                $option_item = [];
                $user_groups = $CurrentUser->getGroupIDArrayForPermission();                
                foreach ($user_groups as $user_group) {                 
                    $add_group = true;
                    if (($input_type === 'permission-backend-access') && ($user_group['label'] === 'Registered Users'))
                    {
                        $add_group = false;
                    }
                    if ($add_group)
                        $option_item[$user_group['value']] = $user_group['label'];
                }
                $__not_done = true;
                break;
        }

        if ($__not_done) { // for checkboxgroup & radiogroup
            ///// begin /////
            $parent = $this->_e('div', array(
              'id' => $new_node_options['name'],
              'class' => $parent_class));
            foreach ($attr as $key => $value) {
                $parent->setAttribute($key, $value);
            }
            
            if (___c($option_item) > 0) {
                $legend = $this->_e('legend', null, $new_node_options['label']);
                $fieldset = $this->_e('fieldset');
                $fieldset->appendChild($legend);                
                $multi_default_value = [];
                if ($multi_select && (array_key_exists('default_value', $new_node_options)))
                {
                    // for checkboxgroup default values
                    // PHP 8.4 fix
                    $nno_default_value = $new_node_options['default_value'];
                    if ($nno_default_value == null)
                        $nno_default_value = '';
                    $trimmed_default_Value = trim($nno_default_value);
                    if ($trimmed_default_Value)
                        $trimmed_default_Value = preg_replace('#\s{1,}#', '', $trimmed_default_Value);
                    $multi_default_value = explode(',', trim($trimmed_default_Value));
                }
                foreach ($option_item as $option_item_value => $option_item_label) {
                    $checkbox_wrapper = $this->_e('div', array('class' => $option_item_wrapper_class));
                    $newnode_label = $this->_e('label');
                    $newnode_label_text = $this->_e('span', NULL, $option_item_label);
                    $item_opt_name = ($multi_select) ? $new_node_options['name'] . '[]' : $new_node_options['name'];
                    
                    $is_selected = $multi_select ? empty($config_value) ? (___c($multi_default_value) > 0 ? in_array($option_item_value, $multi_default_value) : false) : (is_array($config_value) && in_array($option_item_value, $config_value)) : 
                        (empty($config_value) ? (array_key_exists('default_value', $new_node_options) && $new_node_options['default_value'] == $option_item_value) : ($config_value == $option_item_value));
                    $new_node_attrs = ['type' => $option_tag_type,'name' => $item_opt_name, 'value' => $option_item_value];
                    if ($is_selected)
                        $new_node_attrs['checked'] = 'checked';
                    $newnode = $this->_e('input', $new_node_attrs);
                    
                    $newnode_label->appendChild($newnode);
                    $newnode_label->appendChild($newnode_label_text);
                    $checkbox_wrapper->appendChild($newnode_label);
                    $fieldset->appendChild($checkbox_wrapper);
                }
                //add for blank option
                 if ($multi_select)
                 {
                     //$hidden_opt = $this->_e('input',['type' => 'hidden', 'name' => $item_opt_name, 'value' => '__null__']);
                     //$parent->appendChild($hidden_opt);
                 }
                // Now the legend and fieldset

                $parent->appendChild($fieldset);
                return $parent;
            }
        }

        return null;
    }

    
    

    protected function schlixconfig_radiogroup(\DOMElement $origin) {
        return $this->_schlixconfig_checkbox_radio_group('radiogroup', $origin);
        
    }
    
    protected function schlixconfig_checkboxgroup(\DOMElement $origin) {
        return $this->_schlixconfig_checkbox_radio_group('checkboxgroup', $origin);
        
    } 
    
    protected function schlixconfig_radio_group(\DOMElement $origin) {
        return $this->schlixconfig_radiogroup($origin);
        
    }
    
    protected function schlixconfig_checkbox_group(\DOMElement $origin) {
        return $this->schlixconfig_checkboxgroup($origin);
        
    }

    protected function internal_permission_access(\DOMElement $origin, $is_backend)
    {
        global $CurrentUser;
        
        $cfg_key = $origin->getAttribute('config-key');
        $origin->setAttribute('data-field', $cfg_key);
        $origin->setAttribute('name', $cfg_key);
        $user_groups = $is_backend ? $CurrentUser->getGroupIDArrayForBackendAccessPermission() : $CurrentUser->getGroupIDArrayForPermission();
        foreach ($user_groups as $user_group) {
            //$option_item[$user_group['value']] = $user_group['label'];
            $origin->appendChild($this->_e('option', ['label' => $user_group['label'], 'value' => $user_group['value']]));
        }
        
        return $this->internal_radio_checkbox_group($origin,'checkbox');                
        
    }
    protected function schlixconfig_permission_usergroups(\DOMElement $origin) 
    {
        
        return $this->internal_permission_access($origin, false);             
    }
    
    protected function schlixconfig_permission_backend_access(\DOMElement $origin) {
        
        return $this->internal_permission_access($origin, true);               
    }
    
/*
    protected function schlixconfig_radiogroup(\DOMElement $origin) {
        $cfg_key = $origin->getAttribute('config-key');
        $origin->setAttribute('data-field', $cfg_key);
        $origin->setAttribute('name', $cfg_key);
        return $this->internal_radio_checkbox_group($origin,'radio');                
        
    }
    
    protected function schlixconfig_checkboxgroup(\DOMElement $origin) {
        //return $this->_schlixconfig_checkbox_radio_group('checkboxgroup', $origin);
        $cfg_key = $origin->getAttribute('config-key');
        $origin->setAttribute('data-field', $cfg_key);
        $origin->setAttribute('name', $cfg_key);
        return $this->internal_radio_checkbox_group($origin,'checkbox');                
    }*/
    /**
     * Generates radio/checkbox group
     * @param \DOMElement $origin
     * @param string $input_type
     * @return \DOMElement
     */
    
    protected function internal_radio_checkbox_group(\DOMElement $origin, $input_type)
    {
        die('Please implement');
    }    
    //________________________________________________________________________//
    

    protected function schlixconfig_dropdownlist(\DOMElement $origin) {
        
        return $this->xui_select($origin);
    }
    
    protected function internal_schlix_data_explorer(\DOMElement $origin, $element_name, $type='item')
    {
        // left blank on [urpose
    }

    protected function xui_schlix_data_explorer_categorized_list(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-explorer-categorized-list');
    }
    
    protected function xui_schlix_data_explorer_hierarchical_treelist(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-explorer-hierarchical-treelist');
    }
    
    protected function xui_schlix_data_explorer_many_to_many(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-explorer-many-to-many');
    }
    
    
    protected function xui_schlix_data_explorer_list(\DOMElement $origin)
    {       

        return $this->internal_schlix_data_explorer($origin, 'schlix-data-explorer-list');
    }
    
    
    protected function xui_schlix_data_explorer_blank(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-explorer-blank');
    }
    
    protected function xui_schlix_data_editor(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-editor');
    }
    
    protected function xui_schlix_category_editor(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-editor', 'category');
    }    

    protected function xui_schlix_item_editor(\DOMElement $origin)
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-data-editor', 'item');
    }    
    
    
    protected function schlixconfig_data_editor(\DOMElement $origin) 
    {
        return $this->internal_schlix_data_explorer($origin, 'schlix-config-data-editor', 'config');
    }
    
    

    protected function xui_alert(\DOMElement $origin) {} 
    protected function xui_button(\DOMElement $origin) {}
    protected function xui_link_button(\DOMElement $origin) {}
    
    protected function xui_button_cancel(\DOMElement $origin) {}
    protected function xui_button_default(\DOMElement $origin) {} 
    protected function xui_button_info(\DOMElement $origin) {} 
    protected function xui_button_ok(\DOMElement $origin) {} 
    protected function xui_button_primary(\DOMElement $origin) {} 
    protected function xui_button_warning(\DOMElement $origin) {} 
    protected function xui_captcha(\DOMElement $origin) {} 
    protected function xui_checkbox(\DOMElement $origin) {} 
    protected function xui_checkbox_group(\DOMElement $origin) {} 
    protected function xui_clearboth(\DOMElement $origin) {} 
    protected function xui_clearfix(\DOMElement $origin) {} 
    protected function xui_column(\DOMElement $origin) {} 
    protected function xui_container(\DOMElement $origin) {} 
    protected function xui_csrf(\DOMElement $origin) {} 

    protected function xui_fieldset(\DOMElement $origin) {} 
    protected function xui_file_upload(\DOMElement $origin) {} 
    protected function xui_form(\DOMElement $origin) {} 
    protected function xui_form_group(\DOMElement $origin) {} 
    protected function xui_form_simple_ajax(\DOMElement $origin) {} 
    protected function xui_hidden(\DOMElement $origin) {} 
    protected function xui_input_addon(\DOMElement $origin) {} 
    protected function xui_input_addon_button(\DOMElement $origin) {} 
    protected function xui_input_group(\DOMElement $origin) {} 
    protected function xui_input_group_addon(\DOMElement $origin) {} 
    protected function xui_members_mainpage_column_box(\DOMElement $origin) {} 
    protected function xui_panel(\DOMElement $origin) {} 
    protected function xui_password(\DOMElement $origin) {} 
    protected function xui_radio(\DOMElement $origin) {} 
    protected function xui_radio_group(\DOMElement $origin) {} 
    protected function xui_row(\DOMElement $origin) {} 
    protected function xui_schlix_cms_common_dialog(\DOMElement $origin) {} 
    protected function xui_schlix_cms_dialog_button_cancel(\DOMElement $origin) {} 
    protected function xui_schlix_cms_dialog_button_submit(\DOMElement $origin) {} 
    protected function xui_schlix_config_action_buttons(\DOMElement $origin) {} 
    protected function xui_schlix_config_save_result(\DOMElement $origin) {} 
    
    protected function xui_schlix_datetime_picker(\DOMElement $origin) {} 
    protected function xui_schlix_document_image_uploader(\DOMElement $origin) {} 
    protected function xui_schlix_document_multi_category_selector(\DOMElement $origin) {} 
    protected function xui_schlix_document_save_result(\DOMElement $origin) {} 
    protected function xui_schlix_document_status(\DOMElement $origin) {} 
    protected function xui_schlix_document_title(\DOMElement $origin) {} 
    protected function xui_schlix_document_version(\DOMElement $origin) {} 
    protected function xui_schlix_document_virtual_filename(\DOMElement $origin) {} 
    protected function xui_schlix_editor_action_buttons(\DOMElement $origin) {} 
    protected function xui_schlix_editor_category_meta_options(\DOMElement $origin) {} 
    protected function xui_schlix_editor_form(\DOMElement $origin) {} 
    protected function xui_schlix_editor_item_meta_options(\DOMElement $origin) {} 
    protected function xui_schlix_editor_top_left(\DOMElement $origin) {} 
    protected function xui_schlix_editor_top_right(\DOMElement $origin) {} 
    protected function xui_schlix_editor_top_row(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_breadcrumb(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_left_column(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_menu_command_divider(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_pagination(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_right_column(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_row(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_sub_application_header(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_toolbar(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_toolbar_menu(\DOMElement $origin) {} 
    protected function xui_schlix_explorer_toolbar_search(\DOMElement $origin) {} 
    protected function xui_schlix_file_upload(\DOMElement $origin) {} 
    protected function xui_schlix_info_box(\DOMElement $origin) {} 
    protected function xui_schlix_permission_read(\DOMElement $origin) {} 
    protected function xui_schlix_permission_write(\DOMElement $origin) {} 
    protected function xui_schlix_stat_box(\DOMElement $origin) {} 
    protected function xui_schlix_sub_application_toolbar(\DOMElement $origin) {} 
    protected function xui_schlix_tab_container(\DOMElement $origin) {} 
    protected function xui_schlix_user_selection(\DOMElement $origin) {} 
    protected function xui_schlix_versioning_control(\DOMElement $origin) {} 
    protected function xui_select(\DOMElement $origin) {} 
    protected function xui_tagbox(\DOMElement $origin) {} 
    protected function xui_textarea(\DOMElement $origin) {} 
    protected function xui_textbox(\DOMElement $origin) {} 
    protected function xui_well(\DOMElement $origin) {} 
    protected function xui_wysiwyg(\DOMElement $origin) {} 
    
}

