/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.txt for details
 */

SCHLIX.CMS_FrontendEditControl = class
{
    /**
     * Constructor
     */

    constructor()
    {

        var block_cookie_name = 'schlix_frontendedit_control_showblock';
        var block_cookie_value = SCHLIX.Cookie.get(block_cookie_name);
        if (isNaN(block_cookie_value) || block_cookie_value == null)
        {
            SCHLIX.Cookie.remove(block_cookie_name);
            SCHLIX.Cookie.set(block_cookie_name, -2, {path: "/"});
        }     
        
        // Close button
        this.toggleControl('',   'schlix_frontendedit_control_showhide',   'frontendeditcontrol-bar', true);
        SCHLIX.Event.on('frontendeditcontrol-btn-close','click', this.toggleShowBar, this, true);
        SCHLIX.Event.on('frontendeditcontrol-btn-open','click', this.toggleShowBar, this, true);
        
        // Edit control for doc/article
        this.toggleControl('frontendeditcontrol-indicator-showdoc',   'schlix_frontendedit_control_showdoc',   'frontendeditcontrol-doc-container', true);
        SCHLIX.Event.on('frontendeditcontrol-btn-showdoc','click', this.toggleShowDocumentControl, this, true);

        // Edit control for block
        this.toggleControl('frontendeditcontrol-indicator-showblock', 'schlix_frontendedit_control_showblock', 'frontendeditcontrol-block-container', true);
        SCHLIX.Event.on('frontendeditcontrol-btn-showblock','click', this.toggleShowBlockControl, this, true);

        
        
    };

    /**
     * Toggle the control
     * @param {string} indicator_id
     * @param {string} cookie_name
     * @param {string} container_class
     * @param {bool} first_set
     * @returns {unresolved}
     */
    toggleControl(indicator_id, cookie_name, container_class, first_set)
    {
        var cookie_value = parseInt(SCHLIX.Cookie.get(cookie_name), 10);    
        var indicator = SCHLIX.Dom.get(indicator_id);  
        
        if (isNaN(cookie_value) || cookie_value === null)    
        {        
            cookie_value = -2;
        }
        if (!first_set)
        {            
            cookie_value = (cookie_value === 2) ? -2 : 2;
        }  
        SCHLIX.Cookie.remove(cookie_name);
        SCHLIX.Cookie.set(cookie_name, cookie_value, {path: "/"});
         

        var class_to_set = SCHLIX.Dom.get('{.' + container_class + '}');
        var the_style = (cookie_value === 2) ? '' : 'none';
        var the_opacity = (cookie_value === 2) ? 1 : 0;
        if (class_to_set)
        for (var i = 0; i < class_to_set.length;i++)
        {
            class_to_set[i].style.opacity = the_opacity;
            class_to_set[i].style.display = the_style;
        }
        if (indicator != null)
            indicator.className = (cookie_value === 2) ? 'fas fa-check-circle frontendeditcontrol-green' : 'fas fa-square frontendeditcontrol-gray';
        return false;    
    };
    toggleShowBar()
    {
        this.toggleControl('',  'schlix_frontendedit_control_showhide',   'frontendeditcontrol-bar');
        return false;
    };

    toggleShowDocumentControl()
    {
        this.toggleControl('frontendeditcontrol-indicator-showdoc', 'schlix_frontendedit_control_showdoc','frontendeditcontrol-doc-container');
        return false;
    };

    toggleShowBlockControl()
    {
        this.toggleControl('frontendeditcontrol-indicator-showblock', 'schlix_frontendedit_control_showblock','frontendeditcontrol-block-container');
        SCHLIX.Event.onDOMReady(function () { 
            
        setTimeout(function () { 
          window.location.href = window.location.href;
        }, 250);            
          
        });
        return false;
    };

}

SCHLIX.Event.onDOMReady(
    
function ()
{
    var frontend_edit_control = new SCHLIX.CMS_FrontendEditControl();
}  
    
);