<?php
namespace Macro;
/**
 * Insert Contact Form - macro class
 * 
 * Insert contact form in the middle of article content. Syntax example: {insertcontact id="1" class="css-class-name"}
 * 
 * @copyright SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package insertcontactform
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    https://www.schlix.com
 */

class InsertContactForm extends \SCHLIX\cmsMacro {

    /**
     * Contacts app
     * @var \App\Contacts
     */
    protected $app_contact = NULL;
    /**
     * To limit 1 instance of this macro per page
     * @var bool 
     */
    protected static $has_this_macro_been_called;
    
    private function processText($text) {
        
        $macros = $this->getGenericAttributesFromText($text, 'insertcontactform');
        if ($macros)
        {
            foreach ($macros as $insert_contact_form_macro)
            {
                $attrs = $insert_contact_form_macro['attributes'];
                $macro = $insert_contact_form_macro['macro'];

                $id = (int) $attrs['id'];
                if ($id > 0)
                {
                    // create an instance
                    if ($this->app_contact === NULL)
                        $this->app_contact = new \App\Contacts();
                    $item = $this->app_contact->getItemByID($id);
                    start_output_buffer();
                    $this->app_contact->viewContactFormByID($id);
                    $contact_form_replacement_text = end_output_buffer();
                    if (empty ($contact_form_replacement_text))                        
                        $contact_form_replacement_text = sprintf(___('Contact ID# %d cannot be found'), $id);
                    $text = str_replace($macro, $contact_form_replacement_text, $text);
                    // there can only be 1 contact form per page
                    static::$has_this_macro_been_called = 'yes';
                }
            } 
        }
        return $text;
    }
    
    /*
     * Run the macro
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        global $HTMLHeader;
        if (static::$has_this_macro_been_called != 'yes'){

            if (is_array($data)) { // don't enable it for block (string)
                //$this->app_media->loadAssetHeaders();
                if (array_key_exists('summary', $data))
                    $data['summary'] = $this->processText($data['summary']);
                if (array_key_exists('description', $data))
                    $data['description'] = $this->processText($data['description']);
            } else{
                $data = $this->processText($data);
            }

            return true;
        }
    }

}
            