<?php
namespace Skin;

class bootstrap5 extends \Skin\bootstrap4
{
    
    public function getDefaultCSS()
    {
        return get_system_or_user_url_path('/skins/bootstrap5/bootstrap.min.css');
    }
    
    protected function xui_input_addon(\DOMElement $origin)
    {
        $a_label = $origin->getAttribute('label');
        $a_fonticon = $origin->getAttribute('fonticon');
        $attrs = ['class' => 'input-group-prepend'];
        
        if ($a_label || $a_fonticon) 
        {
            $inner = $this->_el('span',['class' => 'input-group-text']);
            $it = $this->internal_icon_text($origin);            
            foreach ($it as $i)
                $inner->appendChild($i);
            $div = $this->_el('div', $attrs, $inner);
        }
        else
        {
            //$inner = $this->_el('span',['class' => 'input-group-text']);
            $inner = $this->_elems($origin,'span',['class' => 'input-group-text']);
            $div = $this->_el('div', $attrs, $inner);
        }
        return $div;
    }
    

    
    /**
     * Grid - column
     * @param \DOMElement $origin
     */
    protected function xui_column(\DOMElement $origin)
    {
        $cl = []; $g = [];
        $attrs = ['xs','sm','md','lg','xl', 'xxl', 'xs-offset','sm-offset','md-offset','lg-offset', 'xl-offset', 'xxl-offset'];
        foreach ($attrs as $a)
            $g[$a] = (int) trim($origin->getAttribute($a));
          
        $cn = '';
        if (___c($g) > 0) 
        {
            foreach ($g as $k => $v) if ($v > 0) {
                $kv = ($k == 'xs') ?  $v : $k.'-'.$v;
                $cl[] = 'col-'.$kv; $origin->removeAttribute($k);                
            }
            $cn = implode(' ', $cl);
        }
        return $this->_elems($origin,'div',['class' => $cn]);
    }

    
    /**
     * XUI - Textbox/select
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function internal_form_input(\DOMElement $origin, $input_tag, $custom_class = '') 
    {
        $nv_input_tags = ['select','textarea'];
        $attrs = ['class' => 'form-control'];
        if (!empty($custom_class))
            $attrs['class'] = $this->addNewClassNameToClassList ($attrs['class'], $custom_class);
        $input = $this->_input($origin, $input_tag, $attrs);
        $fonticon = trim($input->getAttribute('fonticon'));
        $attr_type = trim($input->getAttribute('type'));
        $attr_label = trim($input->getAttribute('label'));
        $attr_prefix = trim($input->getAttribute('prefix'));
        $attr_suffix = trim($input->getAttribute('suffix'));
        $attr_has_warning = is_value_true($input->getAttribute('has-warning'));
        $attr_has_error = is_value_true($input->getAttribute('has-error'));
        $attr_help_block = trim($input->getAttribute('help-text'));
        $attr_input_size = trim($input->getAttribute('input-group-size'));
        $attr_class_input_size = $attr_input_size == 'large' ? 'input-group-lg' : ($attr_input_size == 'small' ? 'input-group-sm' : '');
        
        $attr_suffixinternal_fonticon = trim($input->getAttribute('suffix-fonticon'));
        $attr_disableformgroup = trim($input->getAttribute('disable-form-group'));        
        $attr_id = trim($input->getAttribute('id'));
        
        if (empty($attr_type) && $input_tag == 'input')
            $input->setAttribute('type','text');
        if (in_array($input_tag, $nv_input_tags))
        {
            $input->removeAttribute('value');
            if ($input_tag == 'textarea')
            {
                if ($origin->hasChildNodes())
                    $this->cloneChildNodes ($origin, $input);
            }
        }        
        $this->cleanUpAttributes($input, ['fonticon','label','prefix','suffix','suffix-fonticon','disable-form-group','has-warning','has-error','data-field','data-var']);
        
        $h_suffixinternal_fonticon = !empty($attr_suffixinternal_fonticon);
        $h_suffix = !empty($attr_suffix);
        $h_prefix = !empty($attr_prefix);
        $hinternal_fonticon = !empty ($fonticon);
        $h_label = !empty($attr_label);
        $rq_ig =   $hinternal_fonticon || $h_prefix || $h_suffix || $h_suffixinternal_fonticon || $attr_has_warning || $attr_has_error;
        $inner_elems = [];    
        $input_group = null;
        
        $el_label = null;
        $class_input_group_addon_prefix = 'input-group-prepend';
        $class_input_group_addon_suffix = 'input-group-append';
        $icon = '';
        //$df = $this->_n();
        if (!empty($attr_label))
        {
            if ($attr_has_error)
                $icon = 'fa fa-times';
            else if ($attr_has_warning)
                $icon = 'fa fa-exclamation-triangle';
            $el_label = $this->internal_label($icon,$attr_label, $attr_id );
        }        
        if ($rq_ig)
        {
            
            if ($hinternal_fonticon && $h_prefix)
            {                
                $n_icon = $this->_e('i',['class' => $fonticon]);
                $n_prefix = $this->_t(' '.$h_prefix);
                //$inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_prefix], null, [$n_icon, $n_prefix]);
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_prefix], null, [$n_icon, $n_prefix]);
                
            } else 
            {
                if ($hinternal_fonticon)
                {                   
                    
                    $iga_text = $this->_el('span',['class' =>'input-group-text'], $this->_e('i',['class' => $fonticon])); 
                    $inner_elems[] = $iga_text; // $this->_el('span',['class' => $class_input_group_addon_prefix], $iga_text);
                } else if ($h_prefix)
                {
                    $iga_text = $this->_es('span',['class' =>'input-group-text'], $attr_prefix); 
                    $inner_elems[] = $this->_el('span',['class' => $class_input_group_addon_prefix], $iga_text); 
                }
            }
            $inner_elems[] = $input;
            if ($h_suffix)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_suffix], null, $this->_e('span', ['class' => 'input-group-text'], $attr_suffix));
            } elseif ($attr_suffixinternal_fonticon)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_suffix], null, $this->_e('i',['class' => $attr_suffixinternal_fonticon]));
            }
            $ig_class = 'input-group';            
            if (!empty($attr_class_input_size))
                $ig_class.= ' '.$attr_class_input_size;
            $input_group = $this->_e('div', ['class' => $ig_class], null, $inner_elems);
                        
        }
        // add form group if necessary
        $this->cleanUpAttributes($input, ['data-field', 'data-var', 'default-value','fonticon','label']);
        if ((($rq_ig && $h_label && !$attr_disableformgroup) || ($attr_has_error || $attr_has_warning) ) && !$attr_disableformgroup)
        {
            $el_insert = [$el_label];
            $fg_class = 'form-group';
            $add_inner_elems_only = true;
            if ($attr_has_warning)
            {
                $fg_class.= ' has-warning';
            } else if ($attr_has_error)
            {
                $fg_class.= ' has-error';
            }/* else --- the commented code below conflicts with str_alias
            {
                $el_insert[] = $input_group;
                $add_inner_elems_only = false;
            }*/
            $el_insert[] = $input_group;
            $add_inner_elems_only = false;
            
            
            if ($add_inner_elems_only && ___c($inner_elems) > 0)
                $el_insert = array_merge ($el_insert, $inner_elems);
            else
            if ($el_insert[0] == null)
            {
                $el_insert = $inner_elems;
            }
            $fg = $this->_e('div', ['class' => $fg_class], null, $el_insert);
            
            return $fg;
        } else if ($rq_ig)
        {
            return $input_group;
        }
        else if ($h_label)
        {
            $tn = $this->html_document->createDocumentFragment();
            $tn->appendChild($el_label);
            $tn->appendChild($input);
            return $tn;
        } 
        return $input;
    }    
     
}

