<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace WysiwygEditor;

class blank extends \SCHLIX\cmsWysiwygEditor {

    /**
     * Array of default profiles
     * @var array 
     */
    
    
    protected $default_profiles =
        ['blank' => ['title' => 'Blank Text Area', 'profile'=>'blank']];
    
    /**
     * Returns a key/value array from the config. If the config key contains
     * a prefix of str_config_ or bool_config_ or int_config_, then it will
     * be moved into 'processed' key in the result array, otherwise it will be
     * moved to 'unprocessed' key
     * @return array
     */
    public function generateConfigurationArrayFromConfig()
    {
        return [];
    }     
                
    /**
     * Given $array_config containing 2 keys: unprocessed and processed,
     * process them and move it to $array_config['processed']
     * @param string $array_config
     * @return string
     */
    public function modifyUnprocessedConfig($array_config)
    {
         return [];
    }

     /**
     * The options specified here cannot be modified by user configuration
     * @param array $options
     * @return string
     */
    protected function forceDefaultConfigOptions($options)
    { 
        return [];
    }
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveConfig($datavalues) {
        $datavalues = parent::onModifyDataBeforeSaveConfig($datavalues);
        
        return $datavalues;
    }
    
    /**
     * After config has been saved
     * @param int $profile_id
     */
    public function onAfterSaveConfig($profile_id) 
    {
        parent::onAfterSaveConfig($profile_id);
        return;
    }    
    
    /**
     * Returns an array of default config key/value array. Profile name can be simple, full, etc...
     * @param string $reset_profile_name
     * @return array
     */
    public function getDefaultProfileResetSettings($reset_profile_name)
    {
        return array('blank' => true);
    }
            
    
    /**
     * Returns the configuration script, uncached
     * @return string
     */
    public function getUncachedConfigurationScript()
    {
        return NULL;
    }
    /**
     * View init script
     * @return boolean
     */
    public function viewInitScript()
    {
        $local_variables = compact(array_keys(get_defined_vars())); 
        $result = $this->loadTemplateFile('view.wysiwyg.init.js', $local_variables);
        if (!$result)
        {
            echo ___('Cannot load view.wysiwyg.init.js');
        }
        return false;
    }
    
    

}
