//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

        
SCHLIX.CMS.WysiwygHelper = {
    onDOMReady: function ()
    {
        var selector = '.wysiwyg';
        var editor_els = SCHLIX.Dom.get('{' + selector + '}');
        if (editor_els && editor_els.length > 0)        
        {
            SCHLIX.CMS.WysiwygHelper.loadJavascriptFile();
        }
    },
    getUrlParam: function (paramName)
    {
        var reParam = new RegExp('(?:[\?&]|&amp;)' + paramName + '=([^&]+)', 'i');
        var match = window.location.search.match(reParam);

        return (match && match.length > 1) ? match[1] : '';
    },
    
    fixAutoUpdateForm: function(e)
    {
        for (var instance in CKEDITOR.instances )
        {        
            CKEDITOR.instances[instance].updateElement();
        }
    },
    
    initCKEditor: function ()
    {
        SCHLIX.CMS.WysiwygHelper.CKEDITOR = CKEDITOR;
        __initCKEditor4();
        return; 
    },
    
    onWywiwygLoaded: function ()
    {
        SCHLIX.CMS.WysiwygHelper.initCKEditor();
        
    },
    loadJavascriptFile: function ()
    {
        SCHLIX.CMS.WysiwygHelper.EditorLoader = new SCHLIX.Core.JSLoader({
            onSuccess: SCHLIX.CMS.WysiwygHelper.onWywiwygLoaded
        });
        SCHLIX.CMS.WysiwygHelper.EditorLoader.addModule({
            name: 'wysiwyg', type: 'js', varName: "ckeditor4", fullpath: site_httpbase + '/system/wysiwygeditors/ckeditor4/ckeditor.js' //,
        });

        SCHLIX.CMS.WysiwygHelper.EditorLoader.require("wysiwyg"); 
        SCHLIX.CMS.WysiwygHelper.EditorLoader.insert();
    },
    
    insertURL: function (url)
    {
        var funcNum = SCHLIX.CMS.WysiwygHelper.getUrlParam('CKEditorFuncNum');        
        if (parent.window.CKEDITOR !== undefined && parent.window.CKEDITOR.config.schlixfm === 'inline')
        {
            parent.window.CKEDITOR.tools.callFunction(funcNum, url);
            parent.window.CKEDITOR.dialog.getCurrent().hide();            
        } else
        {
            window.opener.CKEDITOR.tools.callFunction( funcNum, url );
            window.close();
        }   
    }

};
/******************************/
/****__insert_config_here__****/
/******************************/
/***************************************/
/****__insert_extra_function_setup__****/
/***************************************/

function __initCKEditor4()
{
    
    for (var plg in __ckeditor4_config.schlix_external_plugins) 
    {        
        var loc = __ckeditor4_config.schlix_external_plugins[plg];
        CKEDITOR.plugins.addExternal(plg,loc + '/plugin.js');
    }
    SCHLIX.Util.augmentObject(CKEDITOR.config, __ckeditor4_config,true);
    CKEDITOR.replaceClass = __ckeditor4_config.schlix_selector;
    if (__ckeditor4_config.dtd_do_not_remove_these)
    {
        var z = __ckeditor4_config.dtd_do_not_remove_these.split(',');
        for (var i = 0; i < z.length; i++) CKEDITOR.dtd.$removeEmpty[z[i]] = false;
    }
    //for (var instance in CKEDITOR.instances )
    //{           
        //CKEDITOR.instances[instance].on( 'change', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);
    //}    
    /**************************************/
    /****__insert_extra_function_init__****/
    /**************************************/
    
}

SCHLIX.Event.onDOMReady(SCHLIX.CMS.WysiwygHelper.onDOMReady);

