<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $HTMLHeader;

$HTMLHeader->CSS(get_system_or_user_url_path('/wysiwygeditors/tinymce4/skins/lightgray/skin.min.css'));
$HTMLHeader->CSS(get_system_or_user_url_path('/wysiwygeditors/tinymce4/config.css'));
$HTMLHeader->JAVASCRIPT(get_system_or_user_url_path('/wysiwygeditors/tinymce4/config.js'));

$tinymce4 = new \WysiwygEditor\tinyMCE4($id);

$possible_css_files = $tinymce4->getPossibleContentCSSFiles();
$system_langs = $tinymce4->getListOfFileBasedExtensions('system', 'langs','js');
$system_plugins = ['advlist', 'anchor', 'autolink', 'autoresize', 'autosave', 'bbcode', 'charmap', 'code', 'codemirror', 'codesample', 'colorpicker', 'compat3x', 'contextmenu', 'directionality', 'emoticons', 'fontawesome', 'fullpage', 'fullscreen', 'help', 'hr', 'image', 'imagetools', 'importcss', 'insertdatetime', 'legacyoutput', 'link', 'lists', 'media', 'nonbreaking', 'noneditable', 'pagebreak', 'paste', 'preview', 'print', 'save', 'searchreplace', 'spellchecker', 'tabfocus', 'table', 'template', 'textcolor', 'textpattern', 'toc', 'visualblocks', 'visualchars'];
        //$tinymce4->getListOfDirBasedExtensions('system', 'plugins','plugin.min.js');

$system_themes = ['modern','inlite','mobile'];
//$tinymce4->getListOfDirBasedExtensions('system', 'themes','theme.min.js');
$system_skins = $tinymce4->getListOfDirBasedExtensions('system', 'skins','skin.min.css');

$user_plugins = $tinymce4->getListOfDirBasedExtensions('user', 'plugins','plugin.min.js');
$user_themes = $tinymce4->getListOfDirBasedExtensions('user',  'themes','theme.min.js');
$user_skins = $tinymce4->getListOfDirBasedExtensions('user',  'skins','skin.min.css');

$url_user_plugins = $tinymce4->getExtensionURLPath('user', 'plugins');
$url_user_skins = $tinymce4->getExtensionURLPath('user', 'skins');
$url_user_themes = $tinymce4->getExtensionURLPath('user', 'themes');

$extra_buttons = $tinymce4->getExtraExtensionButtons();

$system_buttons = ['|', 'newdocument', 'bold', 'italic', 'underline', 'strikethrough', 'alignleft', 'aligncenter', 'alignright', 'alignjustify', 'alignnone', 'styleselect', 'formatselect', 'fontselect', 'fontsizeselect', 'cut', 'copy', 'paste', 'bullist', 'numlist', 'outdent', 'indent', 'blockquote', 'undo', 'redo', 'removeformat', 'subscript', 'superscript', /* 'visualaid', */ 'insert', 'hr', 'link', 'unlink', /* 'openlink', */ 'image', 'charmap', 'pastetext', 'print', 'preview', 'anchor', 'pagebreak', 'spellchecker', 'searchreplace', 'visualblocks', 'visualchars', 'code', 'codesample', 'fullscreen', 'insertdatetime', 'media', 'nonbreaking', 'save'/* ,'cancel' */, 'table', 'tabledelete', 'tablecellprops', 'tablemergecells', 'tablesplitcells', 'tableinsertrowbefore', 'tableinsertrowafter', 'tabledeleterow', 'tablerowprops', /* 'tablecutrow','tablecopyrow','tablepasterowbefore','tablepasterowafter', */ 'tableinsertcolbefore', 'tableinsertcolafter', 'tabledeletecol', 'fontawesome', /* 'rotateleft','rotateright','flipv','fliph','editimage','imageoptions', */ 'fullpage', 'ltr', 'rtl', 'emoticons', 'template', 'forecolor', 'backcolor', 'restoredraft', /* 'insertfile', 'a11ycheck', */ 'toc' /* ,'quickimage','quicktable','quicklink' */];
/*if ($extra_buttons)
    $system_buttons = array_merge($system_buttons, $extra_buttons); */
$unused_buttons = ['|'];
$used_buttons = [];

$tinymce_text_buttons = ['styleselect', 'formatselect', 'fontsizeselect', 'fontselect'];
$custom_addon_buttons = ['fontawesome'];

$default_toolbars =  $arr_toolbars = [];
/* $default_toolbars[1] = "undo redo | insert | styleselect forecolor backcolor | bold italic underline strikethrough subscript superscript | removeformat | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent blockquote hr";
  $default_toolbars[2] = "table | link unlink anchor image media | charmap | visualchars visualblocks nonbreaking | codesample | code";
  $default_toolbars[3] = $default_toolbars[4] = "";
 */
$default_menubar_top = ['file', 'edit', 'insert', 'view', 'format', 'table', 'tools'];

$default_toolbars[1] = ['undo', 'redo', '|',  'styleselect', 'forecolor', 'backcolor', '|','insert', '|', 'link', 'unlink', 'anchor', 'image', 'media', 'table','|', 'charmap', 'fontawesome', '|',  'visualblocks',  '|',  'codesample'];

$default_toolbars[2] = ['bold', 'italic', 'underline', 'strikethrough', 'subscript', 'superscript', '|', 'removeformat', '|', 'alignleft', 'aligncenter', 'alignright', 'alignjustify', '|', 'bullist', 'numlist', 'outdent', 'indent', 'blockquote', 'hr','|', 'code'];


$default_toolbars[3] = $default_toolbars[4] = [];
for ($i = 1; $i <= 4; $i++) {
    $arr_toolbars[$i] = $wysiwyg_config->get($item['virtual_filename'], "array_toolbar{$i}");
    //if (empty($arr_toolbars[$i])) $arr_toolbars[$i] = $default_toolbars[$i];
    if ($arr_toolbars[$i]) foreach ($arr_toolbars[$i] as $button) if (!in_array($button, $used_buttons) && ($button != '|'))  $used_buttons[] = $button;
}
foreach ($system_buttons as $button) if (!in_array($button, $unused_buttons) && !in_array($button, $used_buttons) && ($button != '|')) $unused_buttons[] = $button;
foreach ($extra_buttons as $button) if (!in_array($button, $unused_buttons) && !in_array($button, $used_buttons) && ($button != '|')) $unused_buttons[] = $button;
?>
<schlix-config:textbox config-key="str_config_selector" label="<?= ___('Text Area Selector - set it to textarea.wysiwyg for backend editing') ?>" config-default-value="textarea.wysiwyg" placeholder="<?= ___('e.g.') ?> textarea.wysiwyg ~ <?= ___('This option allows you to specify a CSS selector for the areas that TinyMCE should make editable') ?>" />
<br />
<!-- begin tabs -->
<x-ui:schlix-tab-container>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_extensions" fonticon="fas fa-puzzle-piece" label="<?= ___('Extensions') ?>"> 
        <!-- tab content -->
        <x-ui:row>
            <!-- col -->
            <x-ui:column sm="6" md="3">
                <!-- ext -->
                <schlix-config:checkboxgroup  config-key="array_plugins" label="<?= ___('Plugins') ?>" config-default-value="advlist,autolink,autoresize,lists,link,image,charmap,print,preview,hr,anchor,pagebreak,codesample,searchreplace,wordcount,visualblocks,visualchars,code,fullscreen,insertdatetime,media,nonbreaking,save,table,contextmenu,directionality,emoticons,template,paste,textcolor,colorpicker,textpattern,imagetools,codemirror,fontawesome,noneditable" >
                    <!-- system -->
                    <?php if ($system_plugins): ?>
                        <?php foreach ($system_plugins as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system plugin') ?>
                    <?php endif ?>
                    <!-- user -->
                    <?php if ($user_plugins): ?>
                        <?php foreach ($user_plugins as $ext): ?>
                            <schlix-config:option value="||<?= ___h($ext) ?>"><?= ___h($ext) ?> (<?= ___('addon') ?>)</schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= sprintf(___('No additional plugin in %s'), $url_user_plugins) ?>
                    <?php endif ?>

                </schlix-config:checkboxgroup>                     
                <!-- end ext -->
                <p><em><?= sprintf(___('Additional plugins can be installed to %s'), $url_user_plugins) ?></em></p>


            </x-ui:column>
            <!-- col -->
            <x-ui:column sm="6" md="3">
                <!-- ext -->
                <schlix-config:radiogroup  config-key="str_config_language" label="<?= ___('Language') ?>" >
                    <!-- system -->
                    <schlix-config:option value=""><?= ___('English (default)') ?></schlix-config:option>
                    <?php if ($system_langs): ?>
                        <?php foreach ($system_langs as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system theme') ?>
                    <?php endif ?>
                </schlix-config:radiogroup>                     
                <!-- end ext -->        

            </x-ui:column>
            <!-- col -->
            <x-ui:column sm="6" md="3">
                <!-- ext -->
                <schlix-config:radiogroup  config-key="str_config_theme" label="<?= ___('Themes') ?>" config-default-value="modern" >
                    <!-- system -->
                    <?php if ($system_themes): ?>
                        <?php foreach ($system_themes as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system theme') ?>
                    <?php endif ?>
                    <!-- user -->
                    <?php if ($user_themes): ?>
                        <?php foreach ($user_themes as $ext): ?>
                            <schlix-config:option value="||<?= ___h($ext) ?>"><?= ___h($ext) ?> (<?= ___('addon') ?>)</schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= sprintf(___('No additional theme in %s'), $url_user_themes) ?>                            
                    <?php endif ?>
                </schlix-config:radiogroup>                     
                <!-- end ext -->        
                <p><em><?= sprintf(___('Additional themes can be installed to %s'), $url_user_themes) ?></em></p>


            </x-ui:column>            
            <!-- col -->
            <x-ui:column sm="6" md="3">
                <!-- ext -->
                <schlix-config:radiogroup  config-key="str_config_skin" label="<?= ___('Skins') ?>" config-default-value="lightgray"  >
                    <!-- system -->
                    <?php if ($system_skins): ?>
                        <?php foreach ($system_skins as $ext): ?>
                            <schlix-config:option value="<?= ___h($ext) ?>"><?= ___h($ext) ?></schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= ___('Error: no system skin') ?>
                    <?php endif ?>
                    <!-- user -->
                    <?php if ($user_skins): ?>
                        <?php foreach ($user_skins as $ext): ?>
                            <schlix-config:option value="||<?= ___h($ext) ?>"><?= ___h($ext) ?> (<?= ___('addon') ?>)</schlix-config:option>
                        <?php endforeach ?>
                    <?php else: ?>
                        <?= sprintf(___('No additional skin in %s'), $url_user_skins) ?>
                    <?php endif ?>
                </schlix-config:radiogroup>                     
                <!-- end ext -->  
                <p><em><?= sprintf(___('Additional skins can be installed to %s'), $url_user_skins) ?></em></p>

            </x-ui:column>            
            <!-- col -->
        </x-ui:row>
    </x-ui:schlix-tab>

    <!-- tab -->
    <x-ui:schlix-tab id="tab_basic" fonticon="fas fa-stream" label="<?= ___('Basic Setup') ?>"> 
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:radiogroup  config-key="str_media_permission" label="<?= ___('SCHLIX CMS Media Manager File Permission') ?>" config-default-value="full" >
                    <schlix-config:option value=""><?= ___('None - will disable all other media options below') ?></schlix-config:option>
                    <schlix-config:option value="full"><?= ___('Full access (backend)') ?></schlix-config:option>
                    <schlix-config:option value="limiteduser"><?= ___('User directory only') ?></schlix-config:option>
                </schlix-config:radiogroup> 

                <schlix-config:radiogroup  config-key="str_media_manager" label="<?= ___('Media Manager') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup> 

                <schlix-config:radiogroup  config-key="str_media_manager_link_list" label="<?= ___('Media Manager - File link list') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup>             

                <schlix-config:radiogroup  config-key="str_media_manager_image_list" label="<?= ___('Media Manager - Image list') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup>             

                <schlix-config:radiogroup  config-key="str_media_manager_media_list" label="<?= ___('Media Manager - Media list') ?>" config-default-value="schlix" >
                    <schlix-config:option value="none"><?= ___('None') ?></schlix-config:option>
                    <schlix-config:option value="schlix"><?= ___('Use the default from SCHLIX CMS') ?></schlix-config:option>
                    <?php /* <schlix-config:option value="custom"><?= ___('Custom function') ?></schlix-config:option> */ ?>
                </schlix-config:radiogroup>             

            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->

                <schlix-config:checkbox config-key="bool_config_hidden_input" label="<?= ___('Enable hidden input (preferred). This option gives you the ability to disable the auto generation of hidden input fields for inline editing elements. By default all inline editors have a hidden input element in which content gets saved when an editor.save() or tinymce.triggerSave() is executed') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_browser_spellcheck" label="<?= ___('Enable browser native spell checker') ?>" />


                <schlix-config:textbox config-key="str_config_target" label="<?= ___('Text Area Target (optional)') ?>" placeholder="<?= ___('e.g.') ?> custom_dom_element or function ~ <?= ___('where this is an existing Javascript variable') ?>"   />
                <em><?= ___('This should be left blank for most cases. You can use this option for textarea element dynamically created with Javascript') ?></em>

                <hr />
                <schlix-config:textarea config-key="str_config_init_instance_callback" class="monospaced" label="<?= ___('Custom Function: Init instance callback') ?>" placeholder="function(editor) {.......}" config-default-value="function (inst) { 
                                        // inst.execCommand('mceAutoResize'); // please enable the autoresize plugin
                                        }" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to specify a function name to be executed each time an editor instance is initialized. The format of this function is initInstance(editor) where editor is the editor instance object reference.'), 'https://www.tinymce.com/docs/configure/integration-and-setup/#init_instance_callback') ?></em> 

                <hr />
                <schlix-config:textarea config-key="str_config_setup" class="monospaced" label="<?= ___('Custom Function: Setup') ?>" placeholder="function(editor) {.......}" config-default-value="function (editor) {
                                        editor.on('change', function () {
                                        tinymce.triggerSave(); // this function is necessary for SCHLIX CMS - DO NOT REMOVE THIS LINE!
                                        });
                                        }"  />
                <p><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to specify a callback that will be executed before the TinyMCE editor instance is rendered.'), 'https://www.tinymce.com/docs/configure/integration-and-setup/#setup') ?></p> 

                <!-- end col content -->                    

            </x-ui:column>            
        </x-ui:row>
    </x-ui:schlix-tab>

    <!-- tab -->
    <x-ui:schlix-tab id="tab_editor_appearance" fonticon="far fa-window-restore" label="<?= ___('Appearance') ?>"> 

        <schlix-config:checkbox config-key="bool_config_statusbar" label="<?= ___('Show status bar at the bottom of the editor') ?>" config-default-value="1" />
        <schlix-config:checkbox config-key="bool_config_elementpath" label="<?= ___('Show element path within the status bar at the bottom of the editor.') ?>" config-default-value="1" />
        <schlix-config:checkbox config-key="bool_config_visual" label="<?= ___('Turn on/off the visual aid for tables with no borders') ?>" config-default-value="1" />
        <!-- menubar -->
        <h3><?= ___('Menu Bar') ?></h3>

        <div class="form-inline tinymce-menubar-top">
            <schlix-config:checkboxgroup  config-key="array_menubar_top" config-default-value="<?= implode(',', $default_menubar_top) ?>" >
                <?php foreach ($default_menubar_top as $menu_top): ?>
                    <schlix-config:option value="<?= $menu_top ?>"><?= ucwords($menu_top) ?></schlix-config:option>
                <?php endforeach ?>
            </schlix-config:checkboxgroup>
        </div>           

        <!-- used buttons -->
        <h3><?= ___('Buttons') ?></h3>
        <!-- show used buttons -->
        <?php for ($i = 1; $i <= 4; $i++): ?>
            <ul id="toolbar_<?= $i ?>" class="tinymce-toolbars button-target">
                <?php if ($arr_toolbars[$i]): ?>               
                    <!-- now show the buttons -->
                    <?php $j = 1 ?>
                    <?php foreach ($arr_toolbars[$i] as $button): ?>
                        <?php if ($button == '|'): ?>
                            <li class="tinymce_button_separator" id="tinymce-separator-<?= $i * $j ?>">
                                |                                
                                <input type="hidden" name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>
                        <?php elseif (in_array($button, $tinymce_text_buttons) || in_array($button, $custom_addon_buttons)): ?>
                            <li class="tinymce_button_dropdown" id="tinymce-button-<?= $button ?>">
                                <?= $button; ?> <?php if (!in_array($button, $custom_addon_buttons)): ?> <i class="fa fa-caret-down"></i> <?php endif ?>
                                <input type="hidden"  name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>                   
                        <?php else: ?>
                            <?php
                            $is_addon_button = !in_array($button, $system_buttons);
                            $icon = !$is_addon_button ? "mce-ico mce-i-{$button}" : 'fa fa-puzzle-piece'
                            ?>
                            <li class="tinymce_button" id="tinymce-button-<?= $button ?>">
                                <i class="<?= $icon ?>" title="<?= $button; ?>"></i> <?= $is_addon_button ? $button : '' ?>
                                <input type="hidden" name="array_toolbar<?= $i; ?>[]" value="<?= $button ?>" />
                            </li>                        
                        <?php endif ?>
                        <?php $j++ ?>
                    <?php endforeach ?>
                    <!-- end show the buttons -->
                <?php endif ?>
            </ul>
        <?php endfor ?>                 
        <h3><?= ___('Unused buttons') ?></h3>
        <ul id="toolbar_unused" class="tinymce-unused-buttons button-target">
            <!-- now show the buttons -->
            <?php foreach ($unused_buttons as $button): ?>
                <?php if ($button == '|'): ?>
                    <li class="tinymce_button_separator" id="tinymce_unused_separator" data-clone="1">
                        |                                
                        <input type="hidden" name="array_unused_buttons[]" value="<?= $button ?>" />
                    </li>
                <?php elseif (in_array($button, $tinymce_text_buttons)): ?>
                    <li class="tinymce_button_dropdown" id="tinymce-button-<?= $button ?>">
                        <?= $button; ?> <i class="fa fa-caret-down"></i>
                        <input type="hidden"  name="array_unused_buttons[]" value="<?= $button ?>" />
                    </li>                   
                <?php else: ?>
                    <li class="tinymce_button" id="tinymce-button-<?= $button ?>">
                        <i class="mce-ico mce-i-<?= $button ?>" title="<?= $button; ?>"></i> <?= $button ?>
                        <input type="hidden" name="array_unused_buttons[]" value="<?= $button ?>" />
                    </li>                        
                <?php endif ?>
            <?php endforeach ?>
            <!-- end show the buttons -->
        </ul> 

        <!-- end toolbar config -->
        <h3><?= ___('Advanced appearance options') ?></h3>
        <p><?= ___('You can leave these values blank') ?></p>
        <schlix-config:checkbox config-key="bool_config_autoresize_on_init" label="<?= ___('Auto resize on init') ?>" config-default-value="1" />            

        <schlix-config:checkbox config-key="bool_config_image_advtab" label="<?= ___('Add advanced tab to the image dialog') ?>" config-default-value="1" />
        <schlix-config:checkbox config-key="bool_config_image_caption" label="<?= ___('Enable adding image caption') ?>" config-default-value="0" />                    


        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Min Size') ?></span>
                    <schlix-config:textbox config-key="str_config_min_width" style="width:100px" />
                    x                            
                    <schlix-config:textbox config-key="str_config_min_height" style="width:100px" />
                </div>

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Max Size') ?></span>
                    <schlix-config:textbox config-key="str_config_max_width" style="width:100px" />
                    x                            
                    <schlix-config:textbox config-key="str_config_max_height" style="width:100px" />
                </div>


                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Editor Size') ?></span>
                    <schlix-config:textbox config-key="str_config_width" style="width:100px" config-default-value="100%" />
                    x                            
                    <schlix-config:textbox config-key="str_config_height" style="width:100px" />
                </div>

                <div class="form-inline">
                    <span class="editor_size_label"><?= ___('Auto Resize Height') ?></span>
                    <schlix-config:textbox config-key="str_config_autoresize_min_height" style="width:100px" config-default-value="400" label="<?= ___('Min. height') ?>" />
                    <schlix-config:textbox config-key="str_config_autoresize_max_height" style="width:100px" config-default-value="800" label="<?= ___('Max. height') ?>" />

                </div>

                <schlix-config:textbox config-key="str_config_body_id" label="<?= ___('Custom editor body CSS ID') ?>" placeholder="<?= ___('e.g.') ?> my_id ~ <?= ___('specify an id for the body of each editor instance') ?>" />
                <schlix-config:textbox config-key="str_config_body_class" label="<?= ___('Custom editor body CSS class') ?>" placeholder="<?= ___('e.g.') ?> my-custom-class ~ <?= ___('specify a class for the body of each editor instance.') ?>" />

                <schlix-config:textbox config-key="str_config_visual_anchor_class" label="<?= ___('Custom CSS class to be added to anchors with names') ?>" placeholder="<?= ___('e.g.') ?> my-custom-class ~ <?= ___('class to be added to anchors') ?>" />
                <schlix-config:textbox config-key="str_config_visual_table_class" label="<?= ___('Custom CSS class to be added to tables no border') ?>" placeholder="<?= ___('e.g.') ?> my-custom-class ~ <?= ___('class to be added to borderless table') ?>" />
                <?php if ($possible_css_files): ?>
                    <schlix-config:dropdownlist  config-key="str_config_importcss_file_filter" label="<?= ___('Select the CSS file for importcss plugin') ?>" config-default-value="<?= $possible_css_files[0] ?>" >
                        <?php foreach ($possible_css_files as $css_file): ?>
                            <schlix-config:option value="<?= $css_file ?>"><?= ___h($css_file) ?></schlix-config:option>                
                        <?php endforeach ?>
                    </schlix-config:dropdownlist> 
                <?php endif ?>
                <schlix-config:checkbox config-key="bool_config_importcss_append" label="<?= ___('Append imported CSS styles instead of replacing the default (recommended)') ?>" config-default-value="1" />

                <schlix-config:textarea config-key="str_config_importcss_groups" class="monospaced" label="<?= ___('Custom CSS Grouping for importcss plugin)') ?>" placeholder="<?= ___('This can be an array or a function') ?>" config-default-value="[ {title: 'Image styles', filter: /^(img)\./},
                                        {title: 'Heading styles', filter: /^(h1|h2|h3|h4|h5|h6)\./},
                                        {title: 'Table styles', filter: /^(table|td|tr)\./},
                                        {title: 'List styles', filter: /^(ul|li)\./},
                                        {title: 'Block styles', filter: /^(div|p)\./},
                                        {title: 'Link styles', filter: /^(a)\./},
                                        {title: 'Generic styles'} ]"  />

                <hr />
                <schlix-config:textarea config-key="str_config_content_style" class="monospaced" label="<?= ___('Custom CSS content style') ?>" placeholder="div {margin: 10px; border: 5px solid red; padding: 3px}"  />
                <p><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to set custom CSS styles as a string that will be injected into the editor\'s iframe. These styles are useful for previewing content as it will appear outside the editor. Since these styles are not saved with the content, it is important that they match the styles in the location that the content will appear.'), 'https://www.tinymce.com/docs/configure/content-appearance/#content_style') ?></p> 


            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:textbox config-key="str_config_block_formats" class="monospaced" label="<?= ___('List of formats to be displayed under formatselect dropdown') ?>" placeholder="Paragraph=p;Heading 1=h1;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Preformatted=pre" />
                <schlix-config:textarea config-key="str_config_font_formats" class="monospaced" label="<?= ___('List of fonts to be displayed under fontselect dropdown') ?>" placeholder="Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats" />
                <schlix-config:textbox config-key="str_config_fontsize_formats" label="<?= ___('List of font sizes displayed in the font size select box') ?>" placeholder="8pt 10pt 12pt 14pt 18pt 24pt 36pt" />
                <schlix-config:textarea config-key="str_config_formats" class="monospaced" label="<?= ___('Formats (object)') ?>" placeholder="{alignleft: {selector : p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img, classes : left},...}" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> enables you to override and add custom formats to the editor.'), 'https://www.tinymce.com/docs/configure/content-formatting/#formats') ?></em>             
                <schlix-config:textarea config-key="str_config_removeformat" class="monospaced" label="<?= ___('Remove formats (array)') ?>" placeholder="[alignleft: {selector : p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img, classes : left},...]" />
                <schlix-config:textbox config-key="str_config_indentation" label="<?= ___('Indentation') ?>" placeholder="<?= ___('e.g.') ?> 30px ~ <?= ___('Indentation level for indent/outdent buttons in the UI. This defaults to 30px but can be any value.') ?>" />
                <h3><?= ___('Style Formats') ?></h3>
                <schlix-config:textarea config-key="str_config_style_formats" class="monospaced" label="<?= ___('Style formats (array)') ?>" placeholder="[alignleft: {selector : p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img, classes : left},...]" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> add more advanced style formats for text and other elements to the editor. The value of this option will be rendered as styles in the Formats dropdown'), 'https://www.tinymce.com/docs/configure/content-formatting/#style_formats') ?></em> 
                <schlix-config:checkbox config-key="bool_config_style_formats_autohide" label="<?= ___('Auto hide styles that do not match the current context.') ?>" config-default-value="0" />            
                <schlix-config:checkbox config-key="bool_config_style_formats_merge" label="<?= ___('Merge style formats instead of replacing them.') ?>" config-default-value="0" />


                <!-- end col content -->                
            </x-ui:column>            

        </x-ui:row>



    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_content_filtering" fonticon="fas fa-filter" label="<?= ___('Content Filtering') ?>"> 

        <!-- row -->
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:radiogroup  config-key="str_config_schema" label="<?= ___('Schema') ?>" config-default-value="html5" >
                    <schlix-config:option value="html5">HTML5 (<?= ___('preferred') ?>)</schlix-config:option>
                    <schlix-config:option value="html5-strict">HTML5-Strict</schlix-config:option>
                    <schlix-config:option value="html4">HTML4</schlix-config:option>
                </schlix-config:radiogroup> 

                <schlix-config:radiogroup  config-key="str_config_element_format" label="<?= ___('Format') ?>" config-default-value="html" >
                    <schlix-config:option value="html">HTML</schlix-config:option>
                    <schlix-config:option value="xhtml">XHTML (<?= ___('the schema should also be set to HTML5-Strict') ?>)</schlix-config:option>
                </schlix-config:radiogroup> 
                <schlix-config:radiogroup  config-key="str_config_encoding" label="<?= ___('Encoding') ?>" config-default-value="" >
                    <schlix-config:option value=""><?= ___('None') ?> (<?= ___('preferred') ?>)</schlix-config:option>
                    <schlix-config:option value="xml">XML</schlix-config:option>
                </schlix-config:radiogroup> 
                <em><?= sprintf(___('This option allows you to get XML escaped content out of TinyMCE. By setting this option to xml, posted content will be converted to an XML string escaping characters such as %s. This option is disabled by default.'), ___h('<, >, ", &')) ?></em>

                <schlix-config:radiogroup  config-key="str_config_entity_encoding" label="<?= ___('Entity Encoding') ?>" config-default-value="named" >
                    <schlix-config:option value="named"><?= ___('Named Entities (preferred)') ?></schlix-config:option>
                    <schlix-config:option value="numeric"><?= ___('Numeric entities') ?></schlix-config:option>
                    <schlix-config:option value="raw"><?= ___('All characters will be stored in non-entity form except these XML default entities') ?></schlix-config:option>
                </schlix-config:radiogroup> 

                <schlix-config:textbox config-key="str_config_entities" label="<?= ___('Comma separated list of entity names that is used instead of characters.') ?>" placeholder="<?= ___('e.g.') ?> 160,nbsp,162,cent,8364,euro,163,pound." />

                <!-- end col content -->
            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->

                <schlix-config:checkbox config-key="bool_config_image_dimensions" label="<?= ___('Enable custom image dimension (uncheck this box for responsive theme)') ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_remove_trailing_brs" label="<?= ___('Remove trailing br tags at the end of block elements') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_fix_list_elements" label="<?= ___('List elements (ul, ol) should be converted to valid XHTML') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_force_hex_style_colors" label="<?= ___('Force the color format to use hexadecimal instead of RGB strings.') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_allow_conditional_comments" label="<?= ___('Parse and keep conditional HTML comments') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_allow_html_in_named_anchor" label="<?= ___('Parse and keep HTML within named anchor tags') ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_allow_unsafe_link_target" label="<?= ___('Disable adding noopener noreferrer for links opening in new window') ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_convert_fonts_to_spans" label="<?= ___('Convert all font elements to span elements') ?>" config-default-value="1" />
                <?php /*
                  <schlix-config:checkbox config-key="bool_forced_root_block" label="<?= ___('Force the root block.') ?>" config-default-value="p" placeholder="<?= ___('Should be just p. If you set this option to empty it will never produce p tags on enter, or, automatically it will instead produce br elements and Shift+Enter will produce a p.') ?>" /> */ ?>

                <h4><?= ___('Advanced Editing Options') ?></h4>
                <schlix-config:checkbox config-key="bool_config_br_in_pre" label="<?= sprintf(___('Line break in %s tag - if you disable this, use Shift+Enter instead of Enter in %s tag'), ___h('<pre>'), ___h('<pre>')) ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_end_container_on_empty_block" label="<?= ___('Split the current container block element if the enter key is pressed inside an empty inner block element (preferred)') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_nowrap" label='<?= sprintf(___('Make the editable area behave like a %s tag'), ___h('<pre>')) ?>' config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_object_resizing" label="<?= ___('Always enable resizing handles on images, tables or media objects') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_typeahead_urls" label="<?= ___('Enable the type ahead url field') ?>" config-default-value="1" />

                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>

        <!-- row -->
        <h3><?= ___('Advanced element and style options') ?></h3>
        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:textbox config-key="str_config_extended_valid_elements" label="<?= ___('Extended valid elements (important - only change as necessary)') ?>" config-default-value="strike,span[class|style|id],i[class],div[class],div,div[id|class|style],script[language|type|src]" placeholder="<?= ___('e.g.') ?> strike,span[class|style|id],i[class],div[class],div,div[id|class|style],script[language|type|src]" />

                <schlix-config:textbox config-key="str_config_custom_elements" label="<?= ___('Specify non-HTML elements for the editor.') ?>" placeholder="<?= ___('e.g.') ?> mycustomblock,~mycustominline ~ <?= ___('You can prefix the element names with a ~ if you want the element to behave as a span element and not a div element') ?>" />


                <schlix-config:textbox config-key="str_config_valid_elements" label="<?= ___('Limit valid elements to') ?>" placeholder="<?= ___('e.g.') ?> a[href|target=_blank],strong/b,div[align],br" />
                <schlix-config:textbox config-key="str_config_invalid_elements" label="<?= ___('Comma separated list of elements that will be removed.') ?>" placeholder="<?= ___('e.g.') ?> strong,em" />            
                <schlix-config:textbox config-key="str_config_valid_children" label="<?= ___('Limit valid children to') ?>" placeholder="<?= ___('e.g.') ?> +body[style],-body[div],p[strong|a|#text]" />            
                <schlix-config:textarea config-key="str_config_protect" class="monospaced" label="<?= ___('Protect the following code from cleanup (regex accepted)') ?>" />
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> allows you to control what contents should be protected from editing while it gets passed into the editor'), 'https://www.tinymce.com/docs/configure/content-filtering/#protect') ?></em> 

                <!-- end col content -->
            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:textbox config-key="str_config_valid_classes" label="<?= ___('Limit valid CSS classes to') ?>" placeholder="<?= ___('e.g.') ?> class1 class2 class3" />            
                <schlix-config:textarea config-key="str_config_valid_styles" class="monospaced" label="<?= ___('Limit valid CSS styles to (object)') ?>" />            
                <em><?= sprintf(___('<a href="%s" target="_blank">This option</a> enables you specify the available styles for each element'), 'https://www.tinymce.com/docs/configure/content-filtering/#valid_styles') ?></em> 
                <schlix-config:textbox config-key="str_config_invalid_styles" label="<?= ___('Space separated list of invalid CSS styles.') ?>" placeholder="<?= ___('e.g.') ?> color font-size" />
                <schlix-config:checkbox config-key="bool_config_keep_styles" label="<?= ___("Keep the editor's current text style when a user presses enter/return") ?>" config-default-value="1" />

                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>

        <h3><?= ___('Fullpage Plugin Options') ?></h3>
        <p><?= ___('You must enable the fullpage plugin from the Extensions tab') ?></p>
        <p><?= ___('This plugin allows user to edit certain document properties such as title, keywords, and description. This is done via a dialog box which appears after pressing a control added to the toolbar. If the code plugin is enabled fullpage exposes HEAD, BODY and various meta tags in source code view. The plugin also adds a Document properties menu under the File menu and button to the toolbar.') ?></p>

        <x-ui:row>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->

                <schlix-config:dropdownlist  config-key="str_config_fullpage_default_doctype" label="<?= ___('Default document type') ?>" >
                    <schlix-config:option value=""><?= ___('Default DocType') ?></schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html>') ?>">HTML5 (<?= ___('preferred') ?>)</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> ') ?>">HTML 4.01 Strict</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> ') ?>">HTML 4.01 Transitional</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd"> ') ?>">HTML 4.01 Frameset</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"> ') ?>">XHTML 1.1</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> ') ?>">XHTML 1.0 Strict</schlix-config:option>
                    <schlix-config:option value="<?= ___h('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ') ?>">XHTML 1.0 Transitional</schlix-config:option>
                </schlix-config:dropdownlist> 

                <schlix-config:textbox config-key="str_config_fullpage_default_encoding" label="<?= ___('Default Encoding') ?>" config-default-value="UTF-8" placeholder="<?= ___('e.g.') ?> utf-8, utf-16, iso-8859-1, iso-2022-jp" />
                <schlix-config:checkbox config-key="bool_config_fullpage_default_xml_pi" label="<?= ___('Add XML declaration') ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_fullpage_hide_in_source_view" label="<?= ___('Hide the non body content from source view') ?>" config-default-value="0" />
                <!-- end col content -->
            </x-ui:column>
        </x-ui:row>
        <!-- end tab content -->
    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_scripts" fonticon="fas fa-code" label="<?= ___('Custom Scripts') ?>"> 

        <p><?= ___('The following is generated script from the previously saved configuration values') ?></p>
        <pre class="config">var __tinymce4_config = {<?= ___h($tinymce4->getUncachedConfigurationScript()); ?>,
// <?= ___('You can insert additional configuration options here (optional)') ?>
            <schlix-config:textarea config-key="str_additional_config" />
}</pre>
        <hr />
        <h4><?= ___('Alternative configuration script') ?></h4>
        <p><?= ___('Replace the entire configuration script above with your own (caution!)') ?></p>
        <strong>var __tinymce4_config = { //</strong>
        <schlix-config:textarea config-key="str_replacement_config"   style="min-height:400px" />
        <strong>}</strong>
    </x-ui:schlix-tab>


</x-ui:schlix-tab-container>    
    <schlix-config:checkbox config-key="reset_to_default" label="<?= ___('Reset to default settings') ?>"  />
    <x-ui:row id="alert-reset-option" style="display:none">
        <x-ui:column md="6" class="alert alert-warning">
            <schlix-config:dropdownlist  config-key="reset_to_default_profile" label="<?= ___('Reset the configuration to the following profile') ?>" config-default-value="<?= $possible_css_files[0] ?>" >
                <schlix-config:option value=""><?= ___('Please select') ?></schlix-config:option>
                <schlix-config:option value="full"><?= ___('Full') ?></schlix-config:option>
                <schlix-config:option value="simple"><?= ___('Simple') ?></schlix-config:option>
                <schlix-config:option value="simple-nomediamanager"><?= ___('Simple - No Media') ?></schlix-config:option>
            </schlix-config:dropdownlist> 
        </x-ui:column>
    </x-ui:row>  
