<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */


/**********************************************************************
 * Custom header image needs to be placed in the THEME template file
 * if the template has 1 or more sidebar (2 or 3 column)
 * Otherwise the header image will not be displayed properly.
 * To do this, you will need to specify 2 global variables inside your
 * APP template file: $_custom_header_image and $_custom_header_title.
 * The name is arbitrary but must be the same declaration
 *
 * In this example, the blog will be set to using the regular template
 * if it's displayed on the main page, but on subsequent page it will
 * switch to 2 column (two-column-right-sidebar.template.php)
 * because on its MENU item, the inner pages subtemplate is set to
 * two-column-right-sidebar.template.php.
 *
 * You can change this behaviour if you prefer to use a single column
 * template
 **********************************************************************/

// this will retrieve the custom header image
$header_img = \App\Core_MediaHeader::getDefaultCustomHeader($this);
$field_cid = $this->getFieldCategoryID();
$field_id = $this->getFieldID();
$str_mainpage_title = $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
$str_mainpage_text = $this->getConfig('str_mainpage_text');

// number of columns - on first page, it's 3, for subsequent pages, it's 2
$max_number_of_column = $pg > 1 ? 2 : 3;
$column_size = 12 / $max_number_of_column;
// OPTIONAL - feel free to uncomment
// $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');

global $_custom_header_image, $_custom_header_title, $_blog_first_page;
$_custom_header_image = $header_img;
$_custom_header_title = $this->getConfig('str_mainpage_title');
?>
<div class="app-page-main grid-mode app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
<?php if ($pg <= 1): ?>
    <?php $_blog_first_page = true; ?>
    <!-- Page Title with custom background image -->
    <?php if ($header_img): ?>
    <div class="media-header-full-width " style="background-image: url('<?= $header_img ?>');">
        <div class="media-header-title container d-flex h-100">
            <div class="row align-self-center w-100">
                <div class="col-8 mx-auto">
                    <div class="text-center">
                        <h1 class="item title" itemprop="name"><?= ___h($str_mainpage_title) ?></h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <h1><?= ___h($str_mainpage_title) ?></h1>
    <?php endif ?>
    <!-- End Page Title -->
    <?php endif ?>


    <?php if ($pg < 2) : ?>
        <?= $str_mainpage_text ?>
    <?php endif ?>

    <?php if ($items): ?>
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~ child items ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <?php $col_pos = 0; ?>
        <div class="container-fluid">
            <div class="main items row">
                <?php foreach ($items as $child_item): ?>
                    <?php if ($child_item['status'] > 0): ?>
                        <?php if ($col_pos % $max_number_of_column == 0): ?>
                        </div>
                        <div class="main items row">
                        <?php endif ?>
                        <section class="child-item col-md-<?= $column_size ?>" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>" >
                            <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                            <?php
                            $child_item_id = $child_item[$field_id];
                            $this->processDataOutputWithMacro($child_item, 'viewMainPageItem', array('main_meta_options' => $main_meta_options));
                            $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                            $child_item_title = ___h($child_item['title']);
                            $child_item_title_text = ($child_item != null) && ($main_meta_options['display_child_item_read_more_link'] == false || $main_meta_options['display_link_title'] == true) ?
                                    \__HTML::A($child_item_title, $link) : $child_item_title;
                            $image_size = $main_meta_options['image_display_size'] ? 'image_medium' : 'image_small';

                            $secondary_headline = $this->getArticleExcerptFromObjectArray($child_item, 'summary_secondary_headline', 'summary', 255);

                            $continue_reading = ' <i class="fa fa-arrow-circle-right"></i> ' . ___('Continue Reading');
                            $intro_img_src = $this->getBlogImage($image_size, $child_item['summary_intro_image']);
                            ?>
                            <div class="row no-gutters border rounded overflow-hidden flex-md-row mb-4 shadow-sm h-md-250 position-relative">
                                <?php if ($main_meta_options['display_item_summary_intro_image'] && $intro_img_src): ?>
                                    <div class="intro-image col-auto d-lg-block mb-0 mt-0">
                                        <figure class="mb-0">
                                                <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $intro_img_src ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>"></a>
                                                    <?php if ($main_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                                                <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                                            <?php endif ?>
                                        </figure>
                                    </div>
                                <?php endif ?>

                                <div class="col p-2 d-flex flex-column position-static">
                                    <?php if ($child_item_title_text): ?>
                                        <h2 class="item title mb-2 mt-0"><?= $child_item_title_text; ?></h2>
                                    <?php endif ?>
                                    <div class="mb-1 text-muted">
                                        <!-- move it to below summary -->
                                        <!-- Macro - Pre -->
                                        <?php if ($child_item['macro_processed_text_before_article']): ?>
                                            <div class="meta before-article">
                                                <?= $child_item['macro_processed_text_before_article'] ?>
                                            </div>
                                        <?php endif ?>
                                        <!-- End Macro - Pre -->

                                    </div>
                                    <div class="card-text mb-auto">
                                        <?php if ($main_meta_options['display_item_summary']): ?>
                                            <div class="secondary-headline">
                                                <?= $secondary_headline ?>
                                            </div>
                                        <?php endif; ?>


                                    </div>

                                    <?= __HTML::A($continue_reading, $link, ['class' => 'stretched-link']) ?>
                                </div>
                            </div>
                            <?php /*
                              <div class="row">
                              <div class="col-sm-12">
                              <?php if ($child_item_title_text): ?>
                              <h2 class="item title"><?= $child_item_title_text; ?></h2>
                              <?php endif ?>

                              <!-- intro image -->
                              <?php if ($main_meta_options['display_item_summary_intro_image'] && is_file($this->getDataFileFullPath($image_size, $child_item['summary_intro_image']))): ?>
                              <div class="intro-image">
                              <figure>
                              <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $this->getDataFileURLPath($image_size, $child_item['summary_intro_image']) ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>)"></a>
                              <?php if ($main_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                              <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                              <?php endif ?>
                              </figure>
                              </div>
                              <?php endif ?>
                              <!-- end intro image -->
                              <?php if ($main_meta_options['display_item_summary']): ?>
                              <div class="secondary-headline">
                              <?=  $secondary_headline ?>
                              </div>
                              <?php endif; ?>
                              </div>
                              </div> */ ?>

                            <!-- Macro - Post -->
                            <?php if (isset($child_item['macro_processed_text_after_article'])): ?>
                                <div class="meta after-article">
                                    <?= $child_item['macro_processed_text_after_article'] ?>
                                </div>
                            <?php endif ?>
                            <!-- End Macro - Post -->
                            <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                        </section>
                        <?php $col_pos++; ?>
                    <?php endif ?>
                <?php endforeach ?>
            </div>
        </div>
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~ end child items ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <?php endif; ?>

    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg, $pagination['total'], "action=main"); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div>
