<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.

The view templates inside the apps and blocks  folder in this theme provide  you with ample amount of customization.
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

global $TagManager;
global $HTMLHeader;

// display intro image
$url_intro_image = $intro_image; // $this->getBlogImage('image_large', $intro_image);
$url_default_header_img = \App\Core_MediaHeader::getDefaultCustomHeader($this);
$url_image = $intro_image && is_file($file_intro_image) ? $url_intro_image : $url_default_header_img;

global $_custom_header_image, $_custom_header_title, $_custom_header_extra_class;
$_custom_header_image = $url_intro_image;
$_custom_header_title = ___h($item['title']);
$_custom_header_extra_class = 'media-header-blog-item';
/**********************************************************************
 * Custom header image needs to be placed in the THEME template file
 * if the template has 1 or more sidebar (2 or 3 column)
 * Otherwise the header image will not be displayed properly.
 * To do this, you will need to specify 2 global variables inside your
 * APP template file: $_custom_header_image and $_custom_header_title.
 * The name is arbitrary but must be the same declaration
 * 
 * In this example, the blog will be set to using the regular template
 * if it's displayed on the main page, but on subsequent page it will
 * switch to 2 column (two-column-right-sidebar.template.php)
 * because on its MENU item, the inner pages subtemplate is set to 
 * two-column-right-sidebar.template.php.
 * 
 * You can change this behaviour if you prefer to use a single column
 * template
 **********************************************************************/ 
$use_single_template = false;
?>

<div class="app-page-item app-<?= $this->app_name; ?>" itemscope="1" itemtype="http://schema.org/BlogPosting">
    <?= $item['macro_processed_text_outside_article_top'] ?>
    <article class="item" id="app-<?= $this->app_name; ?>-item-<?= $item[$this->field_id]; ?>">
        <!-- Page Title -->
        <?php if ($use_single_template): ?>
        <div class="media-header-full-width" style="background-image: url('<?= $header_img ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="headline"><?= ___h($item['title']); ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
         
        <?php endif  ?>
        <!-- End Page Title -->
        <?php if ($item_meta_options['display_description_secondary_headline'] && $secondary_headline): ?>
            <div class="secondary-headline">
                <?= $secondary_headline ?>
            </div>
        <?php endif ?>

        <!-- Macro - Pre -->
        <?php if ($item['macro_processed_text_before_article']): ?>        
            <div class="meta before-article">        
            <?= $item['macro_processed_text_before_article'] ?>            
            </div>
        <?php endif ?>
        <!-- End Macro - Pre -->
        
         <?= $theme_sidebar_output ?>
        <!-- content -->
        <div class="text" itemprop="articleBody">
            <?php if (!$item_meta_options['hide_item_summary_in_detail_view']): ?>
                <?= $item['summary'] ?>
            <?php endif ?>
            <?= $item['description'] ?>
        </div>
        <!-- end content -->
        <!-- category info -->
        
        <?php $categories = $this->getItemCategoriesByItemID($item['id'],'*', 'status > 0') ?>
        <?php if ($categories): ?>                
                <div class="article-item-categories row">        
                    <div class="col-12">        
                        <?= ___c($categories) > 1 ? ___('Categories') : ___('Category') ?>:
                        <?php foreach ($categories as $category): ?>
                        <span class="article-item-category"><a href="<?= $this->createFriendlyURL("action=viewcategory&cid={$category['cid']}") ?>" ><i class="fa fa-bookmark"></i>&nbsp;<?= ___h($category['title']) ?></a></span>
                        <?php endforeach ?>
                    </div>
                </div>
            
        <?php endif ?>
        <!-- end category info -->
        <!-- tag info -->
        <?php if ($item['tags']): ?>            
        
            <?php $tags = explode(',', $item['tags']) ?>
            <?php if ($tags): ?>
                <div class="article-item-tags row">        
                    <div class="col-12">
                        <?= ___c($tags) > 1 ? ___('Tags') : ___('Tag') ?>:
                        <?php foreach ($tags as $tag): ?>
                        <?php $sanitized_tag = urlencode(trim($tag)); ?>
                        <span class="article-item-tag"><a href="<?= $TagManager->createFriendlyURL("action=viewtag&tag={$sanitized_tag}") ?>" ><i class="fa fa-tag"></i> <?= ___h(trim($tag)) ?></a></span>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>
        
        <?php endif ?>
        <!-- end tag info -->
        
        <!-- macro -->
        <?php if ($item['macro_processed_text_after_article']): ?>
            <div class="meta after-article">
                <?= $item['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
    </article>
    <?= $item['macro_processed_text_outside_article_bottom'] ?>
</div>