<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');

$captchaurl = \App\Core_Captcha::getURL();
$location = array('city'=>'addressLocality','province'=>'addressRegion','postal'=>'postalCode','country'=>'addressCountry');
global $HTMLHeader;
$HTMLHeader->JAVASCRIPT_SCHLIX_UI();
$this->CSS('contacts.css');
$this->JAVASCRIPT('contacts.js');

$place_str =  '';
$place_no_html_str = '';
foreach ($location as $element => $element_type)
{
    if ($item[$element])
    {
        $place[] = \__HTML::SPAN(___h($item[$element]), array('itemprop'=>$element_type));
        $place_no_html[] = $item[$element];
    }
}
if ($place)
{
    $place_str = implode(', ', $place);
}
if ($item['display_map'])
{
    //$google_map_api_key = $this->getConfig('str_google_maps_api_key');
    $item_title =  addcslashes(___h($item['title']), '"\\/');
    if ($item['street']) array_unshift($place_no_html , $item['street']);
    if (___c($place_no_html) > 0) // is the address complete? otherwise don't display the map without street address
    {
        $place_no_html_str = implode(', ', $place_no_html);
        $item_complete_address = addcslashes(___h($place_no_html_str), '"\\/');
        $item_zoom = ($item['map_zoom'] > 0) ? intval($item['map_zoom']) : 10;
        //$HTMLHeader->JAVASCRIPT_EXTERNAL('https://maps.googleapis.com/maps/api/js?sensor=false&key='.$google_map_api_key);
        // as of 2019
        //$HTMLHeader->CSS_EXTERNAL('https://map.schlix.website/1/leaflet.css','all');
        //$HTMLHeader->JAVASCRIPT_EXTERNAL('https://map.schlix.website/1/leaflet.js');
        // as of 2023
        $this->CSS('leaflet/leaflet.css');
        $this->JAVASCRIPT('leaflet/leaflet.js');
    }
}
$schema_org_type = (!empty($item['schema_org_type'])) ? ___h($item['schema_org_type']) : 'ContactPoint';
if ($item['display_map'])
{
    $div_left_css = 'col-12 col-sm-12 col-md-6 col-lg-6';
    $div_right_css = 'col-12 col-sm-12 col-md-6 col-lg-6';    
} else
{
    $div_left_css = 'col-11 col-sm-11 col-md-11 col-lg-11';
    $div_right_css = 'col-1 col-sm-1 col-md-1 col-lg-1';
}

// this will retrieve the custom header image
$header_img = \App\Core_MediaHeader::getCustomHeaderByGUID($this, $item['guid']);
/* This template is an example where the custom header is used as a map display 
  */
?>

<?php if ($item['display_map']): ?>
<script type="text/javascript">
    var canvas_map_title = "<?= ___h($item_title) ?>";
    var canvas_map_address = "<?= ___h($item_complete_address) ?>";
    var canvas_map_zoom = <?= strval(intval($item_zoom)) ?>;
</script>    
<?php endif ?>    
<div class="app-page-item app-<?= $this->app_name; ?> contactform" id="app-<?= $this->app_name; ?>-item-<?= $item[$this->field_id]; ?>" itemscope="1" itemtype="http://schema.org/<?= $schema_org_type; ?>">
        
        <!-- Page Title with map -->
        <div class="media-header-full-width" <?php if (!$item['display_map']): ?> style="background-image: url('<?= $header_img ?>');" <?php endif; ?>>
            <?php if ($item['display_map']): ?>     
            <div class="contacts_info_map" id="contact_map_canvas"></div>
            <meta itemprop="latitude" content="<?= $item['latitude']; ?>" id="latitude" />
            <meta itemprop="longitude" content="<?= $item['longitude']; ?>" id="longitude" />            
            <?php else: ?>
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="name"><?= ___h($item['title']); ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
            <?php endif ?>
            
            
        </div>
        <!-- End Page Title -->
        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>
        <!-- end breadcrumb -->
    
    
        <!-- Macro - Pre -->
        <?php if ($item['macro_processed_text_before_article']): ?>        
            <div class="meta before-article">        
            <?= $item['macro_processed_text_before_article'] ?>            
            </div>
        <?php endif ?>
        <!-- End Macro - Pre -->

        <div class="row">

            
            <!-- col -->
            <div class="col-md-5">
                <!-- contact info -->
                <h1 class="contacts title" itemprop="name"><?= ___h($item['title']); ?></h1>
                <?php if ($item['contact_person']): ?>
                <div class="contacts_info_label contact_person">
                    <i class="fa fa-user"></i> 
                    <?= ___h($item['contact_person']); ?>
                </div>
                <?php endif; ?>
                <?php if ($item['pobox'] || $item['branch'] || $item['street'] || $place_str): ?>
                <div itemprop="address" itemscope="1" itemtype="http://schema.org/PostalAddress">
                    <?php if ($item['branch']): ?>
                    <div class="contacts_info_label contact_buildingbranch">
                        <i class="fa fa-building"></i> 
                        <?= ___h($item['branch']); ?>
                    </div>
                    <?php endif; ?>
                    <?php if ($item['pobox']): ?>
                    <div class="contacts_info_label contact_pobox">
                        <i class="far fa-envelope"></i> 
                        <span itemprop=" postOfficeBoxNumber"><?= ___h($item['pobox']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if ($item['street']): ?>
                    <div class="contacts_info_label contact_street">
                        <i class="fa fa-road"></i> 
                        <span itemprop="streetAddress"><?= ___h($item['street']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if ($place_str): ?>
                    <div class="contacts_info_label contact_place">
                        <i class="fa fa-globe"></i> 
                        <?= $place_str; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php if ($item['tollfree']): ?>
                <div class="contacts_info_label contact_tollfree">
                    <i class="fa fa-phone-square"></i> 
                    <span itemprop="telephone"><?= ___h($item['tollfree']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($item['phone']): ?>
                <div class="contacts_info_label contact_phone">
                    <i class="fa fa-phone"></i> 
                    <span itemprop="telephone"><?= ___h($item['phone']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($item['fax']): ?>
                <div class="contacts_info_label contact_fax">
                    <i class="fa fa-fax"></i> 
                    <span itemprop="faxNumber"><?= ___h($item['fax']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($item['mobile']): ?>
                <div class="contacts_info_label contact_mobile">
                    <i class="fas fa-mobile-alt-phone"></i> 
                    <span itemprop="telephone"><?= ___h($item['mobile']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($item['email'] && $item['display_email']): ?>
                <div class="contacts_info_label contact_email">
                    <i class="fa fa-envelope"></i>
                    <?= ___h($item['email']); ?>
                </div>
                <?php endif; ?>
                
                
                <?php /**** EXAMPLE: You may delete this code, it's just an example *****/ 
                // if you know the custom field variable name, simple use something like
                // $item['xcf_sample_field_name']
                  ?>                
                <?php $custom_fields = $this->getItemCustomFields(); ?>
                <?php foreach ($custom_fields as $cf): ?>
                <?php $field_name = 'xcf_'.$cf['field_name']; $field_label = $cf['field_label'] ?>
                <div class="contacts_info_label custom_field">
                    <i class="fa fa-file"></i>
                    <?= ___h($item[$field_name]); ?>
                </div>                
                <?php endforeach ?>
                <?php /**** EXAMPLE ENDS *****/ ?>
                                
                
                <!-- Map -->
                <?php if ($item['additional_info']): ?>
                <div class="contacts_info_additional_description">
                    <?php  echo $item['additional_info']; ?>
                </div>
                <?php endif; ?>
                

                <!-- end contact info -->
            </div>
            <!-- col -->
            <div class="col-md-7">
                <!-- contact -->
                <?php $this->viewContactFormByID($item['id']); ?>
                <!-- end contact -->                
            </div>    
            
        </div>    
        
        <?php if ($item['macro_processed_text_after_article']): ?>
            <div class="meta after-article">
                <?= $item['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        
</div>
 <?php if (!$this->getConfig('bool_disable_contact_form')): ?>
<hr />
 <?php endif; ?>
