<?php

// Include config file
require_once "../db/config.php";
 
// Define variables and initialize with empty values
$new_password = $confirm_password = "";
$new_password_err = $confirm_password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Validate new password
    if(empty(trim($_POST["new_password"]))){
        $_SESSION['error'] = "Please enter the new password.";     
    } elseif(strlen(trim($_POST["new_password"])) < 6){
        $_SESSION['error'] = "Password must have atleast 6 characters.";
    } else{
        $new_password = trim($_POST["new_password"]);
    }
    
    // Validate confirm password
    if(empty(trim($_POST["confirm_password"]))){
        $_SESSION['error'] = "Please confirm the password.";
    } else{
        $confirm_password = trim($_POST["confirm_password"]);
        if(empty($new_password_err) && ($new_password != $confirm_password)){
            $_SESSION['error'] = "Password did not match.";
        }
    }
        
    // Check input errors before updating the database
    if(empty($new_password_err) && empty($confirm_password_err)){
        // Prepare an update statement
        $sql = "UPDATE users SET password = ? WHERE id = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "si", $param_password, $param_id);
            
            // Set parameters
            $param_password = password_hash($new_password, PASSWORD_DEFAULT);
            $param_id = $_SESSION["id"];
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){

                $_SESSION['success'] = 'Password updated successfully.';

            } else{

                $_SESSION['error'] = "Oops! Something went wrong. Please try again later!";

            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Close connection
    mysqli_close($link);
}
?>
 
 
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reset Password</title>

    <style type="text/css">
        body{ font: 14px sans-serif; }
        .wrapper{ width: 350px; padding: 20px; }
    </style>
</head>
<body>
    

<!--Start Reset Pop Up-->

    <div id="reset" class="overlay overlay_modal" align="center">
  
    <div class="overlay-content reset">

    <div class="parallax-scene parallax-scene-3 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
        </div>

        <div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
            <div class="icon icon-2 float-bob-y"></div>
        </div>
  

    <h5>Reset Your Password</h5>

    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post"> 

         <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group <?php echo (!empty($new_password_err)) ? 'has-error' : ''; ?>" align="center">
          
          <input type="password" name="new_password" id="new_password" class="form-control" value="<?php echo $new_password; ?>" placeholder="New Password">

            <span class="help-block"><?php echo $new_password_err; ?></span>
        
        </div>


        <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group <?php echo (!empty($confirm_password_err)) ? 'has-error' : ''; ?>" align="center">
          
          <input type="password" name="confirm_password" id="confirm_password" class="form-control" value="<?php echo $confirm_password; ?>" placeholder="Confirm Password">

            <span class="help-block"><?php echo $confirm_password_err; ?></span>
        
        </div>

            <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">
                <button type="submit">Submit</button>
            </div>
        </form>
   
   <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">

  <button class="close-btn" onclick="closeReset()">Cancel</button>

  </div>

  </div>
</div>

<script type="text/javascript">

function openReset() {
  document.getElementById("reset").style.display = "block";
}

function closeReset() {
  document.getElementById("reset").style.display = "none";
} 

</script>

</body>
</html>