<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>About | Scoris International Junior School Uganda (SIJSU) &copy;</title>

<!-- Stylesheets -->
<link href="../css/style.css" rel="stylesheet">
<link href="../css/responsive.css" rel="stylesheet">
<link rel="icon" href="../images/logo/ico4.png" type="image/x-icon">

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">

    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="../search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required="">
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header style-two">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="header-info pull-left">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-mobile"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                        </ul>
                    </div>
                    <div class="outer-content pull-right">
                        <div class="login-box">
                            <i class="fas fa-user"></i>
                            <a href="../soon">Log in or Register</a>
                        </div>
                        <ul class="clearfix">
                            <li class="header-flyout-searchbar">
                                <i class="fa fa-search"></i>
                            </li>
                            <li><a href="../soon"><i class="fas fa-shopping-cart"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="inner-container">
                    <div class="nav-outer">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                               <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li><a href="../">Home</a></li>
                                        <li class="current dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="../about">About Us</a></li>
                                                <li><a href="../uniforms">About Uniforms</a></li>
                                                <li><a href="../faqs">Faq Page</a></li>
                                                <li><a href="../testimonials">Testimonials</a></li>
                                            </ul>
                                        </li> 
                                        <li class="dropdown"><a href="#">Classes</a>
                                            <ul>
                                                <li><a href="../class">Our Classes</a></li>
                                                <li><a href="../activities">Our Activities</a></li></li>
                                            </ul>
                                        </li> 
                                        <li class="logo-box">
                                            <figure class="logo"><a href="../"><img src="../images/logo/ico4.png" alt="Scoris International"></a></figure>
                                        </li>
                                        <li class="dropdown"><a href="#">Pages</a>
                                            <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="../blog">Blog</a></li>                              
                                        <li><a href="../contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href="../"><img src="../images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                <li><a href="../">Home</a></li>
                                <li class="current dropdown"><a href="#">About</a>
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../uniforms">About Uniforms</a></li>
                                        <li><a href="../faqs">Faq Page</a></li>
                                        <li><a href="../testimonials">Testimonials</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Classes</a>
                                    <ul>
                                        <li><a href="../class">Our Classes</a></li>
                                        <li><a href="../activities">Our Activities</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Pages</a>
                                    <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a href="../blog">Blog</a>
                                </li>                              
                                <li><a href="../contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


    <!--Page Title-->
    <section class="page-title centred" style="background-image: url(../images/stock/bg/2.png);background-attachment: fixed;">
        <div class="container">
            <div class="content-box">
                <h1>About Us</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="../">Home</a></li>
                    <li>About</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->


    <!-- about-section -->
    <section class="about-section style-two">
        <div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
            <div class="icon icon-3"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                    <div class="content-box">
                        <div class="sec-title style-two">
                            <h5>About Us</h5>
                            <h1>Welcome To Scoris</h1>
                        </div>
                        <div class="bold-text">Scoris International Junior School is a privately owned International School offering Cambridge International Curriculum and fully registered by the Centre for International Academic Exchange.</div> <br>
                        <div class="text">
                            <p>We offer an integrated approach towards learning all about helping every child reach their full potential. Leading provider in early childhood development foundation. <br> <br>
                            Putting quality education within reach of every child is our sole purpose and delivering an international learning experience in a clear, safe and child friendly environment is our every day.</p>
                        </div>
                        <div class="btn-box"><a href="../contact" class="theme-btn">Contact us</a></div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                    <div class="image-box wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <figure class="image image-1"><img src="../images/stock/about-hero/8.png" alt=""></figure>
                        <figure class="image image-2"><img src="../images/stock/about-hero/9.png" alt=""></figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-section end -->


    <!-- classes-section -->
    <section class="classes-section about style-two sec-pad">
        <div class="parallax-scene parallax-scene-1 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
        </div>
        <div class="container">
            <div class="sec-title centred">
                <h5>Our Pillars of Education</h5>
                <h1>That Define Who We Are</h1>
            </div>
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-12 block-column">
                    <div class="inner-block wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <figure class="image-box"><img src="../images/stock/objectives/9.png" alt=""></figure>
                        <div class="lower-content" align="center">
                            
                            <h3>Eager to Learn</h3>
                            <div class="price">Open minded curiosity fuels a love for learning.</div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-12 block-column">
                    <div class="inner-block wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <figure class="image-box"><img src="../images/stock/objectives/6.png" alt=""></figure>
                        <div class="lower-content" align="center">
                            
                            <h3>One Team</h3>
                            <div class="price">We put our team's interest ahead of our own.</div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-12 block-column">
                    <div class="inner-block wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <figure class="image-box"><img src="../images/stock/objectives/7.png" alt=""></figure>
                        <div class="lower-content" align="center">
                            
                            <h3>Respect</h3>
                            <div class="price">Setting ambitious goals and aiming to exceed expectations.</div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-12 block-column">
                    <div class="inner-block wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <figure class="image-box"><img src="../images/stock/objectives/11.png" alt=""></figure>
                        <div class="lower-content" align="center">
                            
                            <h3>Excellence</h3>
                            <div class="price">Aiming for the best we can at everything we do.</div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- classes-section end -->


    

    <!-- testimonial-video -->
    <section class="testimonial-video">
        <div class="anim-icon">
            <div class="icon icon-1 float-bob-y"></div>
        </div>
        <div class="outer-container clearfix">
            <div class="testimonial-column">
                <div class="testimonial-content">
                    <div class="sec-title style-two">
                        <h5>Why Choose Us?</h5>
                        <p>A community school, rich in tradition and dedication to excellence. Our dear ones are working towards academic, artistic and athletic/sport achievements and our dedicated teachers challenge them to do their best everyday opportunities.</p>
                    </div>
                    <div class="inner-content">
                        <div class="client-testimonial-carousel owl-carousel owl-theme">
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Vision</span></div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">A center of excellence preparing all learners for global success.</div>
                                </div>
                            </div>
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Mission</div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">Inspiring young minds to explore, learn and lead internationally.</div>
                                </div>
                            </div>
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Core Values</div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">Our pillars of Education, that define who we are. "Play, Learn, Grow, Explore".</div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <!--Client Thumbs Carousel-->
                        <div class="client-thumb-outer">
                            <div class="client-thumbs-carousel owl-carousel owl-theme">
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="../images/icons/ico/1.png" alt=""></figure>
                                </div>
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="../images/icons/ico/2.png" alt=""></figure>
                                </div>
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="../images/icons/ico/3.png" alt=""></figure>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="video-column">
                <div class="video-inner" style="background-image: url(../images/stock/about-core/1.png);">
                    <a href="../images/stock/video/2.mp4" class="overlay-link lightbox-image" data-caption=""><i class="flaticon-play-button"></i></a>
                </div>    
            </div>
        </div>
    </section>
    <!-- testimonial-video end -->


    <!-- fact-counter -->
    <section class="fact-counter">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-two-users"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="2500" data-stop="50">0</span>
                        </div>
                        <div class="text">Teachers & Staff</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-calendar"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="125">0</span>
                        </div>
                        <div class="text">Total Sessions</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-boy"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="150">0</span>
                        </div>
                        <div class="text">Students +</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-flask"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="80">0</span>
                        </div>
                        <div class="text">Events & Activities</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- fact-counter end -->


    <!-- activities-section -->
    <section class="activities-section style-two">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                    <div class="image-box clearfix">
                        <figure class="image"><img src="../images/stock/long/7.png" alt=""></figure>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                    <div class="content-box">
                        <div class="title-box">
                            <div class="sec-title style-two">
                                <h5>Our Focus</h5>
                                <h1>At Scoris International Junior School</h1>
                            </div>
                            <div class="text">Our focus is providing an academic environment with the highest student achievement possible. In an engaging and safe learning environment, Children and teachers alike must become master learners, problem solvers and world communicators in order to be effective and successful.</div>
                        </div>
                        <div class="inner-box">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInLeft" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-teddy-bear"></i></div>
                                        <h3>Play</h3>
                                        <div class="text">Improves the cognitive, physical, social, and emotional well-being of children</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInRight" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-abc-block"></i></div>
                                        <h3>Learn</h3>
                                        <div class="text">Observe, listen, experiment and asking questions.</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInLeft" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-championship"></i></div>
                                        <h3>Grow</h3>
                                        <div class="text">Respond, cuddle, relax, play & talk to nourish a child’s growing brain.</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInRight" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-playground"></i></div>
                                        <h3>Explore</h3>
                                        <div class="text">An active learning approach that gives the learner a sense that anything is possible.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- activities-section end -->


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris international Junior school, every learner is cherished daily. With the Cambridge curriculum and a holistic approach, we inspire both academic excellence and personal growth, ensuring each child feels valued and empowered to thrive.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../contact">Contact Us</a></li>
                                        <li><a href="../class">Classes</a></li>
                                        <li><a href="../activities">Activities</a></li>
                                        <li><a href="../events">Events</a></li>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-mobile"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" method="post" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#">Scoris International Junior School</a>. All Rights Reserved</div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="../images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="https://instagram.com/ScorisJuniors"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassistinc.com/" target="_blank"><strong>Custom Assist Inc.</strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="../js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>


<!-- jequery plugins -->
<script src="../js/jquery.js"></script>
<script src="../js/popper.min.js"></script>
<script src="../js/bootstrap.min.js"></script>

<script src="../js/owl.js"></script>
<script src="../js/wow.js"></script>
<script src="../js/validation.js"></script>
<script src="../js/jquery.fancybox.js"></script>
<script src="../js/appear.js"></script>
<script src="../js/parallax.min.js"></script>

<!-- map script -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="../js/gmaps.js"></script>
<script src="../js/map-helper.js"></script>

<!-- main-js -->
<script src="../js/script.js"></script>

</body><!-- End of .page_wrapper -->
</html>
