
<?php
// Initialize the session
session_start();
 
// Check if the user is already logged in, if yes then redirect him to welcome page
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
  header("location: profile");
  exit;
}

// Include config file
require_once "db/config.php";
 
// Define variables and initialize with empty values
$email = $password = "";
$email_err = $password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Check if email is empty
    if(empty(trim($_POST["email"]))){
        $email_err = "Please enter email.";
    } else{
        $email = trim($_POST["email"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){
        $password_err = "Please enter your password.";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate credentials
    if(empty($email_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT id, fname, lname, email, phone, status, address, occupation, company, image, profile, user_id, password FROM users WHERE email = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_email);
            
            // Set parameters
            $param_email = $email;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if email exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $id, $fname, $lname, $email, $phone, $status, $address, $occupation, $company, $image, $profile, $user_id, $hashed_password);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            // Password is correct, so start a new session
                            session_start();
                            
                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["fname"] = $fname;
                            $_SESSION["lname"] = $lname;
                            $_SESSION["email"] = $email;
                            $_SESSION["phone"] = $phone;
                            $_SESSION["status"] = $status;
                            $_SESSION["address"] = $address;
                            $_SESSION["occupation"] = $occupation;
                            $_SESSION["company"] = $company;
                            $_SESSION["image"] = $image;
                            $_SESSION["profile"] = $profile;
                            $_SESSION["user_id"] = $user_id; 
                            $_SESSION["password"] = $password;                      
                            
                            // Redirect user to welcome page
                            header("location: profile");
                        } else{
                            // Display an error message if password is not valid
                            $password_err = "The password you entered was not valid.";
                        }
                    }
                } else{
                    // Display an error message if email doesn't exist
                    $email_err = "No account found with that email.";
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Close connection
    mysqli_close($link);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Login | SIJSU &copy;</title>

<!-- Stylesheets -->
<link href="../css/style.css" rel="stylesheet">
<link href="../css/responsive.css" rel="stylesheet">
<link rel="icon" href="../images/logo/ico4.png" type="image/x-icon">

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">


    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="../search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required="">
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header style-two">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="header-info pull-left">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-phone"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                        </ul>
                    </div>
                    <div class="outer-content pull-right">
                        <div class="login-box">
                            <i class="fas fa-user"></i>
                            <a href="../soon">Log in or Register</a>
                        </div>
                        <ul class="clearfix">
                            <li class="header-flyout-searchbar">
                                <i class="fa fa-search"></i>
                            </li>
                            <li><a href="../soon"><i class="fas fa-shopping-cart"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="inner-container">
                    <div class="nav-outer">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                                <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li><a href="../">Home</a></li>
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="../about">About Us</a></li>
                                                <li><a href="../uniforms">About Uniforms</a></li>
                                                <li><a href="../faqs">Faq Page</a></li>
                                                <li><a href="../testimonials">Testimonials</a></li>
                                            </ul>
                                        </li> 
                                        <li class="dropdown"><a href="#">Classes</a>
                                            <ul>
                                                <li><a href="../class">Our Classes</a></li>
                                                <li><a href="../activities">Our Activities</a></li></li>
                                            </ul>
                                        </li> 
                                        <li class="logo-box">
                                            <figure class="logo"><a href="../"><img src="../images/logo/ico4.png" alt="Scoris International"></a></figure>
                                        </li>
                                        <li class="dropdown"><a href="#">Pages</a>
                                            <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="../blog">Blog</a></li>                              
                                        <li class=""><a href="../contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href="../"><img src="../images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                <li><a href="../">Home</a></li>
                                <li class="dropdown"><a href="#">About</a>
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../uniforms">About Uniforms</a></li>
                                        <li><a href="../faqs">Faq Page</a></li>
                                        <li><a href="../testimonials">Testimonials</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Classes</a>
                                    <ul>
                                        <li><a href="../class">Our Classes</a></li>
                                        <li><a href="../activities">Our Activities</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Pages</a>
                                    <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a href="../blog">Blog</a>
                                </li>                              
                                <li class=""><a href="../contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


    <!--Page Title-->
    <section class="page-title centred" style="background-image: url(../images/img/1/IMG_9041.webp);background-attachment: fixed;">
        <div class="container">
            <div class="content-box">
                <h1>Login</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="register">Register</a></li>
                    <li>Login</li>
                </ul>

                
            
            </div>
        </div>
    </section>
    <!--End Page Title-->



    <!-- contact-form-section -->
    <section class="contact-form-section sec-pad">
        <div class="container">
            <div class="sec-title centred">
                <h5>Account</h5>
                <h1>LOGIN</h1>
            </div>
            <div class="row">
                <div class="col-lg-8 col-md-12 col-sm-12 offset-lg-2 form-column">
                    <div class="contact-form">
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" id="contact-form" class="default-form"> 
                            <div class="row">
                                <div class="col-lg-6 col-md-12 col-sm-12 form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                                    <input type="email" name="email" placeholder="Your Email" required>
                                    <span class="help-block"><?php echo $email_err; ?></span>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-12 form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                                    <input  type="password" name="password" id="password" placeholder="Password" required>
                                    <span class="help-block"><?php echo $password_err; ?></span>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn centred">
                                    <button type="submit" class="theme-btn" name="login">Login</button> <br> <br>
                                <p>Don't have an account, <a href="register" style="color: #2b3c6b;text-decoration: underline;">Register Here</a></p> <br>

                                <p><a href="forgot" style="color: #2b3c6b;">Forgot Password</a></p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-form-section end -->



<?php include('forgot/index.php') ?>

    <!-- contact-info-section -->
    <section class="contact-info-section sec-pad centred">
        <div class="container">
            <div class="sec-title">
                <h5>Contact</h5>
                <h1>Get In Touch</h1>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-address"></i></div>
                            <h3>Our Location</h3>
                            <div class="text">Makindye Division: Kansanga, Kiwafu Road<br>Opposite Rwizi Arch Hotel</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-vintage-hand-phone"></i></div>
                            <h3>Phone Number</h3>
                            <div class="text">
                                <a href="tel:+256393256880">+256 393 256880</a> <br> <a href="tel:+256700110828">+256 700 110828</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-mail"></i></div>
                            <h3>Email Address</h3>
                            <div class="text">
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a><br />
                                <a href="mailto:help@scorisinternationaljunior.com">help@scorisinternationaljunior.com</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-info-section end -->



    <!-- google-map-section -->
    <section class="google-map-section">
        <div class="map-column">
            <div class="google-map-area">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.7676178281804!2d32.608857199999996!3d0.2888525999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbd431f92a227%3A0x57b490184adaf84b!2sScoris%20International%20Junior%20School!5e0!3m2!1sen!2sug!4v1667001802887!5m2!1sen!2sug" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </section>
    <!-- google-map-section end -->


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris International Junior School our focus is providing an academic environment with the highest student achievement possible. In an engaging and safe learning environment, Children and teachers alike must become master learners, problem solvers and world communicators in order to be effective and successful</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../contact">Contact Us</a></li>
                                        <li><a href="../class">Classes</a></li>
                                        <li><a href="../activities">Activities</a></li>
                                        <li><a href="../events">Events</a></li>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../faqs">FAQs</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-phone"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:academics@scorisinternationaljunior.com">academics@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" method="post" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#">Scoris International Junior School</a>. All Rights Reserved</div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="../images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="https://instagram.com/ScorisJuniors"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassistinc.com/" target="_blank"><strong>Custom Assist Inc.</strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="../js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "../contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>



<!-- jequery plugins -->
<script src="../js/jquery.js"></script>
<script src="../js/popper.min.js"></script>
<script src="../js/bootstrap.min.js"></script>

<script src="../js/owl.js"></script>
<script src="../js/wow.js"></script>
<script src="../js/validation.js"></script>
<script src="../js/jquery.fancybox.js"></script>
<script src="../js/appear.js"></script>
<script src="../js/parallax.min.js"></script>
<script src="../js/isotope.js"></script>
<script src="../js/jquery-ui.js"></script>  
<script src="../js/jquery.bootstrap-touchspin.js"></script> 

<!-- map script -->
<script src="../https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="../js/gmaps.js"></script>
<script src="../js/map-helper.js"></script>

<!-- main-js -->
<script src="../js/script.js"></script>

</body><!-- End of .page_wrapper -->
</html>
